/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: st_sql.c,v 1.17.2.4 2004/05/06 10:35:06 jura Exp $ */

#include "netams.h"

//////////////////////////////////////////////////////////////////////////
void *stOpenSql(Service *s,unsigned type){

	if(!s) {
		aLog(D_WARN, "NULL storage in OpenSql\n");
		return NULL;
	}

        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	void *fd;

	switch (cfg->type) {
#ifdef USE_MYSQL
		case MY_SQL:
			fd=my_stOpenSql(s,type);
			break;
#endif
#ifdef USE_POSTGRES
		case POSTGRES:
			fd=pg_stOpenSql(s,type);
			break;
#endif
		case UNKNOWN:
		default:
			aLog(D_ERR, "SQL feature is not compiled in!\n");
			fd=NULL;
			break;
	}
	return fd;
}
//////////////////////////////////////////////////////////////////////////
void stCloseSql(Service *s , void *fd){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        my_stCloseSql(s,fd);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        pg_stCloseSql(s,fd);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_WARN, "SQL feature is not compiled in!\n");
                        break;
        }
}
//////////////////////////////////////////////////////////////////////////
unsigned stSaveSql(Service *s, Message *msg){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	unsigned ret=0;

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        ret=my_stSaveSql(s,msg);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        ret=pg_stSaveSql(s,msg);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "SQL feature is not compiled in!\n");
                        break;
        }
	return ret;
}
//////////////////////////////////////////////////////////////////////////
unsigned stLoadSql(Service *s, Message *msg){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	unsigned ret=0;

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        ret=my_stLoadSql(s,msg);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        ret=pg_stLoadSql(s,msg);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "SQL feature is not compiled in!\n");
                        break;
        }
return ret;
}
//////////////////////////////////////////////////////////////////////////
unsigned stStatSql(Service *s, Message *msg){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	unsigned ret=0;

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        ret=my_stStatSql(s,msg);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        ret=pg_stStatSql(s,msg);
                        break;
#endif
                case UNKNOWN:
                default:
			aLog(D_WARN, "This feature available only for SQL!\n");
                        break;
        }
return ret;
}
//////////////////////////////////////////////////////////////////////////
void stMonitorToSql(Monitor_cfg *smcfg, time_t t, unsigned msec, NetUnit *u, struct ip *ip, unsigned long len){
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)smcfg->st->cfg;

 	switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        my_stMonitorToSql(smcfg,t,msec,u,ip,len);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        pg_stMonitorToSql(smcfg,t,msec,u,ip,len);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "SQL feature is not compiled in!\n");
                        break;
        }
}
//////////////////////////////////////////////////////////////////////////
void stLgObtainDbData(Login_cfg *slcfg, NetUnit *u){
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)slcfg->st->cfg;
	
	switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL: 
			my_stLgObtainDbData(slcfg,u);
			break;
#endif
#ifdef USE_POSTGRES
		case POSTGRES:
			pg_stLgObtainDbData(slcfg,u);
			break;
#endif
		case UNKNOWN:
		default:
			aLog(D_ERR, "login service requires MySQL or Postgres storage [%d], exiting\n", cfg->type);
			break;
	}
}
//////////////////////////////////////////////////////////////////////////
void stLgSetCfg(Login_cfg *slcfg, NetUnit *u) {
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)slcfg->st->cfg;
	void *fd;

	if(!(fd=stOpenSql(slcfg->st,ST_CONN_LOGIN))) {
		aLog(D_WARN,"stLgSetCfg: can't acquire database from storage:%u\n",slcfg->st->instance);
		return;
	}
	
        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        my_stLgSetCfg(u,fd);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        pg_stLgSetCfg(u,fd);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "login service requires MySQL or Postgres storage [%d], exiting\n", cfg->type);
                        break;
        }
	stCloseSql(slcfg->st,fd);
}
//////////////////////////////////////////////////////////////////////////
void stQuObtainDbData(Quota_cfg *sqcfg, NetUnit *u){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)sqcfg->st->cfg;

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        my_stQuObtainDbData(sqcfg,u);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        pg_stQuObtainDbData(sqcfg,u);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "quota service requires MySQL or Postgres storage [%d], exiting\n", cfg->type);
                        break;
        }
}
//////////////////////////////////////////////////////////////////////////
void stQuSetCfg(Quota_cfg *sqcfg, NetUnit *u) {
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)sqcfg->st->cfg;
	void *fd;

	if(!(fd=stOpenSql(sqcfg->st,ST_CONN_LOGIN))) {
                aLog(D_WARN,"stLgSetCfg: can't acquire database from storage:%u\n",sqcfg->st->instance);
                return;
        }

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        my_stQuSetCfg(u,fd);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        pg_stQuSetCfg(u,fd);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "login service requires MySQL or Postgres storage [%d], exiting\n", cfg->type);
                        break;
        }
	stCloseSql(sqcfg->st,fd);
}
//////////////////////////////////////////////////////////////////////////

