/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: st_sql_mysql.c,v 1.20.2.21 2004/08/17 06:13:25 jura Exp $ */

#ifdef USE_MYSQL

#include "netams.h"

//////////////////////////////////////////////////////////////////////////
void *my_stOpenSql(Service *s, unsigned int type){

	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	char *st_conn=NULL;
	MYSQL_RES *res;
	MYSQL* fd=NULL;
	char *my_host, *my_user, *my_pass, *my_dbname, *my_socket;
	u_short my_port;
	char buffer[255]; 

 	if(!(fd=mysql_init(fd))) { 
		aLog(D_WARN, "mysql init failed	\n");
		return NULL;
	}
	
        if (cfg->hostname) my_host=cfg->hostname; else my_host="localhost";
        if (cfg->username) my_user=cfg->username; else my_user="root";
        if (cfg->password) my_pass=cfg->password; else my_pass="";
        if (cfg->dbname) my_dbname=cfg->dbname; else my_dbname="netams";
        if (cfg->port) my_port=cfg->port; else my_port=3306;
        if (cfg->socket) my_socket=cfg->socket; else my_socket=NULL;
	
	if (!mysql_real_connect(fd, my_host, my_user, my_pass, my_dbname, my_port, my_socket, CLIENT_LOCAL_FILES)) {
		if (!mysql_real_connect(fd, my_host, my_user, my_pass, NULL, my_port, my_socket, CLIENT_LOCAL_FILES)) {
			aLog(D_WARN, "mysql connect failed: %s, continuing closed\n", mysql_error(fd));
			return NULL;
		}
	
		res=mysql_list_dbs(fd, my_dbname); 

		if (!res) {
			aLog(D_WARN, "mysql list dbs failed: %s\n", mysql_error(fd)); 
			return NULL;
		}

		if (!mysql_num_rows(res)) { //hmmm, there are no netams database there... creating it...
			snprintf(buffer, 254, "CREATE DATABASE %s", my_dbname);
			if (mysql_query(fd, buffer)) aLog(D_ERR, "mysql create db failed: %s\n", mysql_error(fd));
			aLog(D_WARN, "mysql database [%s] created\n", my_dbname);
		}
		mysql_free_result(res);

		if (mysql_select_db(fd, my_dbname)) aLog(D_WARN, "mysql select netams/raw failed: %s\n", mysql_error(fd));
	}

	switch(type) {
		case ST_CONN_RAW:
			st_conn="RAW";
			res=mysql_list_tables(fd, "raw");
			if (!res) {
                		aLog(D_WARN, "mysql list tables failed: %s\n", mysql_error(fd));
                		return NULL;
        		}
			if (!mysql_num_rows(res)) {// there is no raw table ... creating it ...
				// old workaround included as default
				if (mysql_query(fd, "CREATE TABLE raw (unit_oid int(10) unsigned NOT NULL default '0',policy_oid int(10) unsigned NOT NULL default '0',t_from int(10) unsigned default NULL,t_to int(10) unsigned default NULL,bytes_in bigint(20) unsigned default NULL,bytes_out bigint(20) unsigned default NULL,id bigint(20) unsigned NOT NULL auto_increment,hostname varchar(32) default NULL,PRIMARY KEY  (id),KEY unit_oid (unit_oid),KEY policy_oid (policy_oid))")) aLog(D_WARN, "mysql create raw failed: %s\n", mysql_error(fd));
				else aLog(D_INFO, "mysql table 'raw' created\n");
			}
			mysql_free_result(res);
			break;
		case ST_CONN_SUMMARY:	
			st_conn="SUMMARY";
		 	res=mysql_list_tables(fd, "summary");
			if (!res) {
                                aLog(D_WARN, "mysql list tables failed: %s\n", mysql_error(fd));
                                return NULL;
                        }
                       	if (!mysql_num_rows(res)) {// there is no summary table ... creating it ...
				if (mysql_query(fd, "CREATE TABLE summary (prefix ENUM('T','M','W','D','H') NOT NULL, unit_oid INT UNSIGNED NOT NULL, policy_oid INT UNSIGNED NOT NULL, t_from INT UNSIGNED NOT NULL, bytes_in BIGINT UNSIGNED, bytes_out BIGINT UNSIGNED, KEY (unit_oid), KEY (policy_oid), KEY (t_from), PRIMARY KEY(prefix, unit_oid, policy_oid, t_from))")) aLog(D_WARN, "mysql create summary failed: %s\n", mysql_error(fd));
				else aLog(D_INFO, "mysql table 'summary' created\n");
			}
			mysql_free_result(res);
			break;
		case ST_CONN_MONITOR:
			st_conn="MONITOR";
			res=mysql_list_tables(fd, "monitor");
			if (!res) {
                                aLog(D_WARN, "mysql list tables failed: %s\n", mysql_error(fd));
                                return NULL;
                        }
			if (!mysql_num_rows(res)) { // there is no monitor table ... creating it ...
				if (mysql_query(fd, "CREATE TABLE monitor (time TIMESTAMP NOT NULL , msec INT UNSIGNED, name VARCHAR(32), unit_oid INT UNSIGNED, proto TINYINT UNSIGNED, src INT UNSIGNED NOT NULL, srcport SMALLINT UNSIGNED, dst INT UNSIGNED NOT NULL, dstport SMALLINT UNSIGNED, len BIGINT UNSIGNED, KEY(time), KEY(unit_oid));\0")) aLog(D_WARN, "mysql create monitor failed: %s\n", mysql_error(fd));
				else aLog(D_INFO, "mysql table 'monitor' created\n");
			}
			mysql_free_result(res);
			break;
		case ST_CONN_LOGIN:
			st_conn="LOGIN";
			res=mysql_list_tables(fd, "login");
			if (!res) {
                                aLog(D_WARN, "mysql list tables failed: %s\n", mysql_error(fd));
                                return NULL;
                        }
			if (!mysql_num_rows(res)) { // there is no login table ... creating it ...
				if (mysql_query(fd, "CREATE TABLE login (unit_oid INT UNSIGNED PRIMARY KEY NOT NULL, password VARCHAR(32), inact INT UNSIGNED, abs INT UNSIGNED, last_changed INT UNSIGNED, last_opened_time INT UNSIGNED, ip INT UNSIGNED, mac VARCHAR(18), def_state INT, curr_state INT, strict INT);")) aLog(D_WARN, "mysql create login failed: %s\n", mysql_error(fd));
				else aLog(D_INFO, "mysql table 'login' created\n");
			}
			mysql_free_result(res);
			break;
		case ST_CONN_QUOTA:
			st_conn="QUOTA";
			res=mysql_list_tables(fd, "quota");
			if (!res) {
                                aLog(D_WARN, "mysql list tables failed: %s\n", mysql_error(fd));
                                return NULL;
                        }
			if (!mysql_num_rows(res)) { // there is no quota table ... creating it ...
				if (mysql_query(fd, "CREATE TABLE quota (unit_oid INT UNSIGNED PRIMARY KEY NOT NULL,policy_oid INT UNSIGNED NOT NULL,syspolicy_oid INT UNSIGNED,soft_treshold INT UNSIGNED,active INT UNSIGNED,blocked INT UNSIGNED,notified INT UNSIGNED,last_blocked_time INT UNSIGNED,notify_soft_oid INT UNSIGNED,notify_hard_oid INT UNSIGNED,notify_return_oid INT UNSIGNED,notify_soft_self INT UNSIGNED,notify_hard_self INT UNSIGNED,notify_return_self INT UNSIGNED,h_in BIGINT UNSIGNED NULL,h_out BIGINT UNSIGNED NULL,h_sum BIGINT UNSIGNED NULL,d_in BIGINT UNSIGNED NULL,d_out BIGINT UNSIGNED NULL,d_sum BIGINT UNSIGNED NULL,w_in BIGINT UNSIGNED NULL,w_out BIGINT UNSIGNED NULL,w_sum BIGINT UNSIGNED NULL,m_in BIGINT UNSIGNED NULL,m_out BIGINT UNSIGNED NULL,m_sum BIGINT UNSIGNED NULL,t_in BIGINT UNSIGNED NULL,t_out BIGINT UNSIGNED NULL,t_sum BIGINT UNSIGNED NULL)")) aLog(D_WARN, "mysql create quota failed: %s\n", mysql_error(fd));
				else aLog(D_INFO, "mysql table 'quota' created\n");
			}
			mysql_free_result(res);
			break;
		default:
			break;
	} 
	aDebug(DEBUG_STORAGE, "MySQL DB:%u opened [%s] for %s\n", s->instance, my_dbname, st_conn);
	return (void*)fd;
}

//////////////////////////////////////////////////////////////////////////
void my_stCloseSql(Service *s,void *conn){

	mysql_close((MYSQL*)conn);
	aDebug(DEBUG_STORAGE, "MySQL DB:%u closed\n", s->instance);

}

//////////////////////////////////////////////////////////////////////////
unsigned my_stSaveSql(Service *s, Message *msg){

	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	char *query=cfg->query;;
	int i;
	NetUnit *u;

	switch (msg->prefix){
		case 'F':
			if(!cfg->fd1) {
                                cfg->fd1=stOpenSql(s,ST_CONN_RAW);
                                if(!cfg->fd1) {
					return 0;
				}
                        }
			if(!(u=Units.getUnitById(msg->netunit))) return 1; 
			snprintf(query, 254, "INSERT DELAYED INTO raw VALUES (%u, %u, %u, %u, %qu, %qu, 0, '%s')", msg->netunit, msg->ap, msg->data.from, msg->data.to, msg->data.in, msg->data.out, u->name?u->name:"<\?\?>");
			if(mysql_query((MYSQL*)cfg->fd1, query)) {
				aLog(D_WARN, "MySQL error: %s\n", mysql_error((MYSQL*)cfg->fd1));
				return 0;
			}
			i=mysql_affected_rows((MYSQL*)cfg->fd1);
			// aDebug(DEBUG_STORAGE, "%u %s\n", i, query); 
			aDebug(DEBUG_STORAGE, "SQL->HDD/raw(F) query %u bytes, affected: %u\n", strlen(query), i);
			break;

		case 'T':
		case 'M':
		case 'W':
		case 'D':
		case 'H':
			if(!cfg->fd2) {
                                cfg->fd2=stOpenSql(s,ST_CONN_SUMMARY);
                                if(!cfg->fd2) {
                                        return 0;
                                }
                        }
			snprintf(query, 254, "UPDATE summary SET bytes_in=%qu, bytes_out=%qu WHERE (prefix='%c' AND unit_oid=%u AND policy_oid=%u AND t_from=%u)", msg->data.in, msg->data.out, msg->prefix, msg->netunit, msg->ap, msg->data.from);
			if(mysql_query((MYSQL*)cfg->fd2, query)) {
				aLog(D_WARN, "MySQL error: %s\n", mysql_error((MYSQL*)cfg->fd2));
				return 0;
			}
			i=mysql_affected_rows((MYSQL*)cfg->fd2);
			if (i==0) { // update failed! 
				snprintf(query, 254, "INSERT INTO summary VALUES ('%c', %u, %u, %u, %qu, %qu)", msg->prefix, msg->netunit, msg->ap, msg->data.from, msg->data.in, msg->data.out); 
				if(mysql_query((MYSQL*)cfg->fd2, query)) {
					aLog(D_WARN, "MySQL error: %s\n", mysql_error((MYSQL*)cfg->fd2));
					return 0;
				}
				i=mysql_affected_rows((MYSQL*)cfg->fd2); 
				// aDebug(DEBUG_STORAGE, "%u %s\n", i, query); 
			} 
			aDebug(DEBUG_STORAGE, "SQL->HDD/summary(%c) query %u bytes, affected: %u\n", msg->prefix, strlen(query), i);
			break;
		}
return 1;
}
//////////////////////////////////////////////////////////////////////////
unsigned my_stLoadSql(Service *s, Message *msg){

	msg->id=s->instance;
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	char *query=cfg->query;
	MYSQL_RES *res;
	MYSQL_ROW row;

	pstat *cps;
	MYSQL *m;
	
	if (msg->pdata)  // assuming type is READ, fill this unit policy data field on policy apply (startup)
		switch (msg->prefix){
			case 'T': cps=&(msg->pdata->t); break;
			case 'M': cps=&(msg->pdata->m); break;
			case 'W': cps=&(msg->pdata->w); break;
			case 'D': cps=&(msg->pdata->d); break;
			case 'H': cps=&(msg->pdata->h); break;
			case 'F': cps=&(msg->pdata->flow); break;
			}
	else cps=&(msg->data);	// pdata is NULL, reading a raw data while program is running

	if (msg->prefix=='F') {
			if(!cfg->fd1) {
                                cfg->fd1=stOpenSql(s,ST_CONN_RAW);
                                if(!cfg->fd1) {
                                        return 0;
                                }
                        }
			snprintf(query, 254, "SELECT bytes_in, bytes_out FROM raw WHERE unit_oid=%u AND policy_oid=%u AND t_from=%u AND t_to=%u", msg->netunit, msg->ap, cps->from, cps->to);
			m=(MYSQL*)cfg->fd1;
		} else if (msg->prefix=='T') {
			if(!cfg->fd2) {
                                cfg->fd2=stOpenSql(s,ST_CONN_SUMMARY);
                                if(!cfg->fd2) {
                                        return 0;
                                }
                        }
			snprintf(query, 254, "SELECT bytes_in, bytes_out, t_from FROM summary WHERE prefix='T' AND unit_oid=%u AND policy_oid=%u", msg->netunit, msg->ap);
			m=(MYSQL*)cfg->fd2;
		} else {
			if(!cfg->fd2) {
                                cfg->fd2=stOpenSql(s,ST_CONN_SUMMARY);
                                if(!cfg->fd2) {
                                        return 0;
                                }
                        }
			snprintf(query, 254, "SELECT bytes_in, bytes_out FROM summary WHERE prefix='%c' AND unit_oid=%u AND policy_oid=%u AND t_from=%u", msg->prefix, msg->netunit, msg->ap, cps->from);
			m=(MYSQL*)cfg->fd2;
		}

	if(mysql_query(m, query)) {
		aLog(D_WARN, "MySQL error: %s\n", mysql_error(m));
		return 0;
	}
	res=mysql_store_result(m); 
	if (res) {
		row=mysql_fetch_row(res);
		if (row) { 
			sscanf(row[0], "%qu", &cps->in); 
			sscanf(row[1], "%qu", &cps->out);
			if (msg->prefix=='T') sscanf(row[2], "%lu", &cps->from);
			}
		mysql_free_result(res);
		}
	aDebug(DEBUG_STORAGE, "SQL<-HDD/%c query %u bytes, fr=%lu in=%qu out=%qu\n", msg->prefix, strlen(query), cps->from, cps->in, cps->out);
	return 1;
}

//////////////////////////////////////////////////////////////////////////
unsigned my_stStatSql(Service *s, Message *msg){
	msg->id=s->instance;
	MYSQL *m;

	if(!(m=(MYSQL*)stOpenSql(s,ST_CONN_SUMMARY))) return 0;

	policy_data *pd;
	NetUnit *u;
	int i;

	u=Units.getUnitById(msg->netunit);
	if (!u) return 1;

	msg->stat->num_policies=u->ap.num_policies;

	switch (msg->prefix){
		case 'D':
			msg->stat->num_points=24;
			break;
		case 'W':
			msg->stat->num_points=24*7;
			break;
		case 'M':
			msg->stat->num_points=24*31;
			break;
		default:
			return 1;
	}

	msg->stat->in =(unsigned long long*)aMalloc((sizeof (unsigned long long))*msg->stat->num_points*msg->stat->num_policies);
	msg->stat->out=(unsigned long long*)aMalloc((sizeof (unsigned long long))*msg->stat->num_points*msg->stat->num_policies);
				
	for (pd=u->ap.root, i=0; pd!=NULL; pd=pd->next, i++) {
		if(!my_stStatSql_p(msg->stat, msg->prefix, m, i, msg->netunit, pd->policy->id, msg->stat->num_points)) {
			stCloseSql(s,m);
			return 0;
		}
	}
	stCloseSql(s,m);
	return 1;
}
//////////////////////////////////////////////////////////////////////////
unsigned my_stStatSql_p(stat_data *s, char prefix, MYSQL *m, int i, oid u, oid p, unsigned points){
	char query[255];
	MYSQL_RES *res;
	MYSQL_ROW row;
	pstat tmp;
	unsigned j;
	unsigned a;

	a=time(NULL)-points*60*60;

	for (j=0; j<points; j++) {
		s->in[i*points+j]=0;
		s->out[i*points+j]=0;
	}

	snprintf(query, 254, "SELECT DISTINCT t_from, bytes_in, bytes_out FROM summary WHERE prefix='H' AND unit_oid=%u AND policy_oid=%u AND t_from>=%u", u, p, a);

	if(mysql_query(m, query)) {
		aLog(D_WARN, "MySQL error: %s\n", mysql_error(m));
		return 0;
	}
	res=mysql_store_result(m); 
	if (res) {
		while ((row=mysql_fetch_row(res))) {
			sscanf(row[0], "%lu", &tmp.from); 
			sscanf(row[1], "%qu", &tmp.in);
			sscanf(row[2], "%qu", &tmp.out);
			j=(unsigned)((tmp.from-a)/3600);
			if(j>=points) continue; //this should't be
//			printf("j=%u ", j);
			s->in[i*points+j]=tmp.in;
			s->out[i*points+j]=tmp.out;
		}
		mysql_free_result(res);
	}
	aDebug(DEBUG_STORAGE, "SQL<-HDD/%c pd=%u query STAT %u bytes\n%s\n", prefix, i, strlen(query), query);

	return 1;
}
//////////////////////////////////////////////////////////////////////////
void my_stMonitorToSql(Monitor_cfg *cfg, time_t t, unsigned msec, NetUnit *u, struct ip *ip, unsigned long len){

	char *query=cfg->query;
	int i;
	struct tcphdr *th;
	th=(struct tcphdr *)((unsigned char *)ip + ip->ip_hl*4);

	snprintf(query, 254, "INSERT DELAYED INTO monitor VALUES (FROM_UNIXTIME(%u), %u, '%s', %u, %u, %u, %u, %u, %u, %lu)", t, msec, u->name?u->name:"<\?\?>", u->id, ip->ip_p, ntohl(ip->ip_src.s_addr), ntohs(th->th_sport), ntohl(ip->ip_dst.s_addr), ntohs(th->th_dport), len);
	if(mysql_query((MYSQL*)cfg->fd, query)) {
		aLog(D_WARN, "MySQL error: %s\n", mysql_error((MYSQL*)cfg->fd));
		return;
	}
	i=mysql_affected_rows((MYSQL*)cfg->fd);
//	aDebug(DEBUG_STORAGE, "%u %s\n", i, query); 
	aDebug(DEBUG_STORAGE, "SQL->HDD/monitor query %u bytes, affected: %u\n", strlen(query), i);
}
//////////////////////////////////////////////////////////////////////////
void my_stLgObtainDbData(Login_cfg *cfg, NetUnit *u){
	char *buffer=cfg->query;
	
	snprintf(buffer, 255, "SELECT * from login where unit_oid=%u", u->id);
	if (mysql_query((MYSQL*)cfg->fd, buffer)) { 
		aLog(D_WARN, "mysql select login failed: %s\n", mysql_error((MYSQL*)cfg->fd)); 
		return; 
	}
	
	MYSQL_RES *res;
        MYSQL_ROW row;
	
	res=mysql_store_result((MYSQL*)cfg->fd);
	if (res) {
		row=mysql_fetch_row(res);
		if (row) {
                	if (!u->logindata) u->logindata = (sLoginData*)aMalloc(sizeof(sLoginData));
                        aFree(u->logindata->password); u->logindata->password=set_string(row[1]);
                        sscanf(row[2], "%lu", &u->logindata->inact);
                        sscanf(row[3], "%lu", &u->logindata->abs);
                        sscanf(row[5], "%lu", &u->logindata->opened);
                        sscanf(row[6], "%u", &u->logindata->ip_from.s_addr);
                        memcpy(&u->logindata->mac_from, ether_aton(row[7]), sizeof (struct ether_addr));
                        sscanf(row[8], "%u", &u->logindata->d_state);
                        sscanf(row[9], "%u", &u->logindata->c_state);
                        sscanf(row[10], "%u", &u->logindata->strict);

                        aDebug(DEBUG_LOGIN, "Unit: %06X inact %lu abs %lu def:%u curr:%u st:%u\n", u->id, u->logindata->inact, u->logindata->abs, u->logindata->d_state, u->logindata->c_state, u->logindata->strict);
		} else aDebug(DEBUG_LOGIN, "Unit: %06X login entry was not found\n", u->id);
                mysql_free_result(res);
     	} else aDebug(DEBUG_LOGIN, "Unit: %06X login table access problem\n", u->id);

}
//////////////////////////////////////////////////////////////////////////
void my_stLgSetCfg(NetUnit *u, void *fd) {
        char buffer[256];

	snprintf(buffer, 255, "REPLACE INTO login values(%u,'%s',%u,%u,%u,%u,%u,'%s',%u,%u,%u);", u->id, u->logindata->password?u->logindata->password:"", u->logindata->inact, u->logindata->abs, time(NULL), u->logindata->opened, u->logindata->ip_from.s_addr, ether_ntoa(&u->logindata->mac_from), u->logindata->d_state, u->logindata->c_state, u->logindata->strict);
	
	if (mysql_query((MYSQL*)fd, buffer)) { 
		aLog(D_WARN, "mysql replace [%s] login failed: %s\n", buffer, mysql_error((MYSQL*)fd)); 
	}
}	
//////////////////////////////////////////////////////////////////////////
void my_stQuObtainDbData(Quota_cfg *cfg, NetUnit *u){
        char *buffer=cfg->query;
	sQuotaData *q;

	snprintf(buffer, 255, "SELECT * from quota where unit_oid=%u", u->id);
        aDebug(DEBUG_QUOTA, "sQuObtainDbData query: '%s'\n", buffer);
        if (mysql_query((MYSQL*)cfg->fd, buffer)) { 
		aLog(D_WARN, "mysql select quota failed: %s\n", mysql_error((MYSQL*)cfg->fd)); 
		return; 
	}

        MYSQL_RES *res;
        MYSQL_ROW row;

        res=mysql_store_result((MYSQL*)cfg->fd);
        if (res) {
        	row=mysql_fetch_row(res);
                if (row) {
                	if (!u->quotadata) u->quotadata = (sQuotaData*)aMalloc(sizeof(sQuotaData));
                       	q=u->quotadata;
                        oid id; 
			sscanf(row[1], "%u", &id); q->policy=PolicyL.getPolicyById(id);
                        sscanf(row[3], "%u", &q->soft_treshold);
                        sscanf(row[4], "%u", &q->active);
                        sscanf(row[5], "%u", &q->blocked);
                        sscanf(row[6], "%u", &q->notified);
                        sscanf(row[7], "%lu", &q->blocked_time);

                        sscanf(row[8], "%u", &q->nso);
                        sscanf(row[9], "%u", &q->nho);
                        sscanf(row[10], "%u", &q->nro);

                        sscanf(row[11], "%u", &q->nss);
                        sscanf(row[12], "%u", &q->nhs);
                        sscanf(row[13], "%u", &q->nrs);

                        sscanf(row[14], "%qu", &q->h.in);
                        sscanf(row[15], "%qu", &q->h.out);
                        sscanf(row[16], "%qu", &q->h.sum);

                        sscanf(row[17], "%qu", &q->d.in);
                        sscanf(row[18], "%qu", &q->d.out);
                        sscanf(row[19], "%qu", &q->d.sum);

                        sscanf(row[20], "%qu", &q->w.in);
                        sscanf(row[21], "%qu", &q->w.out);
                        sscanf(row[22], "%qu", &q->w.sum);

                        sscanf(row[23], "%qu", &q->m.in);
                        sscanf(row[24], "%qu", &q->m.out);
                        sscanf(row[25], "%qu", &q->m.sum);

                        sscanf(row[26], "%qu", &q->t.in);
                        sscanf(row[27], "%qu", &q->t.out);
                        sscanf(row[28], "%qu", &q->t.sum);

			aDebug(DEBUG_QUOTA, "Unit: %06X soft %u act %u blo %u notif %u\n", u->id, q->soft_treshold, q->active, q->blocked, q->notified);
           	} else aDebug(DEBUG_QUOTA, "Unit: %06X quota entry was not found\n", u->id);
                mysql_free_result(res);
      	} else aDebug(DEBUG_QUOTA, "Unit: %06X quota table access problem\n", u->id);

}
//////////////////////////////////////////////////////////////////////////
void my_stQuSetCfg(NetUnit *u, void *fd) {
	char buffer[256];
	sQuotaData *q;

	q=u->quotadata;
	snprintf(buffer, 512, "REPLACE INTO quota values(%u,%u,0,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu);", u->id, q->policy->id,/*syspolicy,*/q->soft_treshold, q->active, q->blocked, q->notified, q->blocked_time, q->nso, q->nho, q->nro, q->nss, q->nhs, q->nrs, q->h.in,q->h.out,q->h.sum, q->d.in,q->d.out,q->d.sum, q->w.in,q->w.out,q->w.sum, q->m.in,q->m.out,q->m.sum, q->t.in,q->t.out,q->t.sum);
	
        aDebug(DEBUG_QUOTA, "sQuSetCfg query: '%s'\n", buffer);
        if (mysql_query((MYSQL*)fd, buffer)) { 
		aLog(D_WARN, "mysql replace [%s] quota failed: %s\n", buffer, mysql_error((MYSQL*)fd));
	}
}
#endif
//////////////////////////////////////////////////////////////////////////

