#!/usr/bin/perl 
#
# netams_graph.cgi
#
# This script make a dynamic PNG image with graph of traffic activity for 
# a given unit for a given period of time. All policies are listed, both IN and OUT
# direction. You should have lucon.ttf font in this directory in order to
# have text labels visible.
#
# No responsibility for this script is given!
# (c) 2002, Anton Vinokurov <anton@inorg.chem.msu.ru>
#-----------------------------------------------------------------------------
# $Id: netams_graph.cgi,v 1.2 2003/02/26 13:22:26 jura Exp $


use GD;
use CGI;
use POSIX;
require "netams_api.pl";

$cgi=new CGI;
#print $cgi->header(-type=>'text/plain',-expires=>'now');
print $cgi->header(-type=>'image/png',-expires=>'now');

$unit=$cgi->param("unit");
$policy=$cgi->param("policy");
$prefix=$cgi->param("prefix");
$nolegend=$cgi->param("nolegend");

if ($prefix eq "") { $prefix="W"; }

netams_login("localhost", 20001, "anton", "aaa");
netams_send("show stat unit $unit $prefix to now 20");

$result=netams_readline();
@result=split(/\n/, $result);
undef $result;
shift @result;
$r=shift @result;
($r_unit, $r_oid, $r_from, $r_to, $r_points)=split(/ /, $r);
$policies=shift @result;
@policies=split(/ /, $policies);
netams_logout();

#print "unit $r_unit ($r_oid) ";
#foreach $p (@policies) { print "$p "; $pl{$p}}
#print "\n".@result."\n";

if ($prefix eq "W") { $points=24*7; }
elsif ($prefix eq "M") { $points=24*31; }

# load data to hashes
for ($i=0; $i<$points; $i++) {
	$r=shift @result;
	@rd=split(/ /, $r);

	$j=0;
	foreach $p (@policies) { 
		$in=$rd[$j];
		$out=$rd[$j+1];
		$j+=2;
		if (($policy eq "") or ($policy eq $p)) {
			push @{$pl{$p.'in'}}, $in;
			push @{$pl{$p.'out'}}, $out;
			}
		}

	}

if ($policy ne "") { undef @policies; @policies=($policy); }
	
# find a maximum value
foreach $p (@policies) { 
	$ppi=$p."in";
	$ppo=$p."out";
	for ($i=0; $i<$points; $i++) {
		if (@{$pl{$p.'in'}}[$i]>$max{$ppi}) { $max{$ppi}=@{$pl{$p.'in'}}[$i]; }
		if (@{$pl{$p.'out'}}[$i]>$max{$ppo}) { $max{$ppo}=@{$pl{$p.'out'}}[$i]; }
		}
	
#	print "$p in max: ".$max{$ppi}."\n";
#	print "$p out max: ".$max{$ppo}."\n";
	}
# find a cumulative maximum
foreach $p (@policies) { 
	$ppi=$p."in";
	$ppo=$p."out";
	if ($max{$ppi}>$c_maxin) { $c_maxin=$max{$ppi}; }
	if ($max{$ppo}>$c_maxout) { $c_maxout=$max{$ppo}; }
	}
#print "c_maxin=$c_maxin, c_maxout=$c_maxout\n";

# normalize to maximum
foreach $p (@policies) { 
	for ($i=0; $i<$points; $i++) {
		@{$pl{$p.'in'}}[$i] = sprintf "%.2f", (100 * @{$pl{$p.'in'}}[$i] / ($c_maxin+1));
#		print "$i ";
#		print @{$pl{$p.'in'}}[$i];
#		print " ";
		@{$pl{$p.'out'}}[$i] = sprintf "%.2f", (100 * @{$pl{$p.'out'}}[$i] / ($c_maxout+1));
#		print @{$pl{$p.'out'}}[$i];
#		print "\n";
		}
	}

# here is the place for image creation

$x=500, $y=400;
if ($nolegend eq "") { $im = new GD::Image($x, $y+25); }
else { $im = new GD::Image($x, $y); }

$gray = $im->colorAllocate(220,220,220);
$darkgray = $im->colorAllocate(127,127,127);
$white = $im->colorAllocate(255,255,255);
$black = $im->colorAllocate(0,0,0);
$red = $im->colorAllocate(255,0,0);
@colors=(
	$im->colorAllocate(0,127,0),
	$im->colorAllocate(0,0,220),
	$im->colorAllocate(127,0,0),
	$im->colorAllocate(220,220,0),
	$im->colorAllocate(0,220,220),
	$im->colorAllocate(220,0,220),
	$im->colorAllocate(80,220,0),
	$im->colorAllocate(0,80,220),
	$im->colorAllocate(220,0,80),
	$im->colorAllocate(0,80,0),
	$im->colorAllocate(0,0,80),
	$im->colorAllocate(80,0,0),
	);


$idx=0;
$xpos=50;

# font search
$fontname="lucon.ttf";
$fontpath=substr($ENV{"SCRIPT_FILENAME"}, 0, rindex($ENV{"SCRIPT_FILENAME"}, "/"))."/".$fontname;

# basic rectangle
$im->rectangle(0,0,$x-1,$y-1, $black);
$im->filledRectangle(50, 3, $x-4, ($y-2)/2-15, $white);
$im->rectangle(49, 2, $x-3, ($y-2)/2-14, $darkgray);
$im->filledRectangle(50, ($y-2)/2+15, $x-4, $y-4, $white);
$im->rectangle(49, ($y-2)/2+16, $x-3, $y-3, $darkgray);

# should we draw a legend?
if ($nolegend eq "") { 
	$im->filledRectangle(0,$y,$x-1,$y-1+25, $gray);
	$im->rectangle(0,$y-1,$x-1,$y-1+25, $black);
	} 

foreach $p (@policies) { 
	
	$poly1=new GD::Polygon;
	$poly2=new GD::Polygon;
	
	$poly1->addPt(0, 100); 
	$poly2->addPt(0, 0); 

	for ($i=0; $i<$points; $i++) {
		$poly1->addPt($i, 100 - @{$pl{$p.'in'}}[$i]); 
		$poly2->addPt($i, @{$pl{$p.'out'}}[$i]); 
		}
	
	$poly1->addPt($points-1, 100); 
	$poly2->addPt($points-1, 0); 

	$poly1->map(0,0,$points-1,100, 50, 4, $x-4, $y/2-16);
	$poly2->map(0,0,$points-1,100, 50, $y/2+16, $x-4, $y-4);
	$im->filledPolygon($poly1, $colors[$idx]);
	$im->filledPolygon($poly2, $colors[$idx]);
	undef $poly1;
	undef $poly2;

	if ($nolegend eq "") { 
		$im->filledRectangle($xpos, $y+3, $xpos+20, $y+20, $colors[$idx]);
		$im->rectangle($xpos, $y+3, $xpos+20, $y+20, $black);
		@bounds=$im->stringTTF($colors[11], $fontpath, 8, 0, $xpos+25, $y+16, $p);
		$xpos=$xpos+40+$bounds[2]-$bounds[0];

		$idx++;
		}
	}
# final labels
$im->stringTTF($black, $fontpath, 10, 0, 10, ($y-2)/2-15, " in:");
$im->stringTTF($black, $fontpath, 10, 0, 10, ($y-2)/2+25, "out:");
$im->line(0,($y-2)/2-12,$x-1,($y-2)/2-12, $colors[11]);
$im->line(0,($y-2)/2+14,$x-1,($y-2)/2+14, $colors[11]);

# draw a vertical ticks
if ($prefix eq "W") {
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$day_beg=POSIX::mktime(0,0,0,$mday,$mon,$year,0,0,$isdst);

	$time_end=time();
	$time_beg = $time_end-60*60*24*7;
	$scale = 60*60*24*7 / ($x-54);
	for ($d=0; $d<7; $d++) {
		$d_b=$day_beg-$d*60*60*24;
		$pos=50+($d_b-$time_beg)/$scale;
		$im->line($pos,($y-2)/2-16,$pos,($y-2)/2-10, $black);
		$im->dashedLine($pos,3,$pos,($y-2)/2-17, $gray);
		$im->line($pos,($y-2)/2+12,$pos,($y-2)/2+18, $black);
		$im->dashedLine($pos,($y-2)/2+19,$pos,$y-3, $gray);
		$dayname=substr(localtime($d_b), 0, 3);
		$im->stringTTF($darkgray, $fontpath, 10, 0, $pos+5, ($y-2)/2+5, $dayname);
		}
	}
elsif ($prefix eq "M"){
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$mon_beg=POSIX::mktime(0,0,0,$mday,$mon,$year,0,0,$isdst);

	$time_end=time();
	$time_beg = $time_end-60*60*24*31;
	$scale = 60*60*24*31 / ($x-54);
	for ($d=0; $d<31; $d+=2) {
		$d_b=$mon_beg-$d*60*60*24;
		$pos=50+($d_b-$time_beg)/$scale;
		$im->line($pos,($y-2)/2-16,$pos,($y-2)/2-10, $black);
		$im->dashedLine($pos,3,$pos,($y-2)/2-17, $gray);
		$im->line($pos,($y-2)/2+12,$pos,($y-2)/2+18, $black);
		$im->dashedLine($pos,($y-2)/2+19,$pos,$y-3, $gray);
		$dayname=POSIX::strftime("%d", localtime($d_b));
		$im->stringTTF($darkgray, $fontpath, 10, 0, $pos+5, ($y-2)/2+5, $dayname);
		}
	}


# draw a horizontal ticks
if ($c_maxin > 1024*1024*1024) { $c_maxin_p="Gbytes"; $c_maxin=$c_maxin/(1024*1024*1024); }
elsif ($c_maxin > 1024*1024) { $c_maxin_p="Mbytes"; $c_maxin=$c_maxin/(1024*1024); }
elsif ($c_maxin > 1024) { $c_maxin_p="Kbytes"; $c_maxin=$c_maxin/1024; }
else { $c_maxin_p="Bytes"; }
$im->stringTTF($black, $fontpath, 10, 3.14159/2, 12, $y/4+20, $c_maxin_p);

if ($c_maxout > 1024*1024*1024) { $c_maxout_p="Gbytes"; $c_maxout=$c_maxout/(1024*1024*1024); }
elsif ($c_maxout > 1024*1024) { $c_maxout_p="Mbytes"; $c_maxout=$c_maxout/(1024*1024); }
elsif ($c_maxout > 1024) { $c_maxout_p="Kbytes"; $c_maxout=$c_maxout/1024; }
else { $c_maxout_p="Bytes"; }
$im->stringTTF($black, $fontpath, 10, 3.14159/2, 12, 3*$y/4+30, $c_maxout_p);

for ($i=0; $i<6; $i++){
	$res_in=sprintf "%3.f", $i*$c_maxin/6;
	$res_out=sprintf "%3.f", $i*$c_maxout/6;
	$im->line(48,2+($i/5)*(($y-2)/2-16),52,2+($i/5)*(($y-2)/2-16), $black);
	$im->line(48,$y/2+15+($i/5)*(($y-2)/2-17),52,$y/2+15+($i/5)*(($y-2)/2-17), $black);

	if ($i>0) {
		$im->stringTTF($black, $fontpath, 8, 0, 25, 2+((5-$i)/5)*(($y-2)/2-16)+8, $res_in);
		$im->stringTTF($black, $fontpath, 8, 0, 25, $y/2+15+($i/5)*(($y-2)/2-17), $res_out);
		}
	}		 

if ($c_maxout<$c_maxin) {
	$im->line(49, (1-$c_maxout/($c_maxin+1))*($y/2-17)+2, 49, ($y-2)/2-14, $red);
	} else {
	$im->line(49, ($y-2)/2+16+($c_maxin/($c_maxout+1))*($y/2-18), 49, ($y-2)/2+16, $red);
	}


binmode STDOUT;
print $im->png;





