/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: common.h,v 1.12.2.2 2004/05/06 10:35:02 jura Exp $ */

/////////////////////////////////////////////////////////////////////////////////////////
// Memory management //////////////////////////////////////////////////////////////////// 
void *aMalloc(size_t size, int critical=1); 
void aFree(void *ptr);
quad_t aGetBytesAllocated();
unsigned aGetTimesAllocated();
unsigned aGetTimesFreed();
unsigned aGetTimesFreedNull();

//////////////////////////////////////////////////////////////////////////////////////////
// Logging Management ///////////////////////////////////////////////////////////////////
void aParse(Connection *conn, char const *fmt, ...);
void aLog(unsigned level, char const *fmt, ...);

#define	D_EMERG	    0x0000  /* for program start/stop records*/
#define	D_ALERT	    0x0001  /* for threads start/stop, db open/close ? */
#define	D_CRIT	    0x0002  /* die without data save */
#define	D_ERR	    0x0003  /* errors, program will be closed with save */
#define	D_WARN	    0x0004  /* warnings, should be logged */
#define	D_NOTICE    0x0005  /* */
#define	D_INFO	    0x0006  /* informational messages for daily run*/
#define	D_DEBUG	    0x0007  /* all debugging info is on */
#define	D_DEFAULT_DEBUG	    D_INFO


//////////////////////////////////////////////////////////////////////////////////////////

typedef unsigned oid;
oid newOid(unsigned id);

//////////////////////////////////////////////////////////////////////////////////////////
// Debugging management
typedef quad_t Debug;
void aDebug(Debug d, char const *fmt, ...);
void aDebugInit();
int aDebugAdd(Debug &d, char *str);
int aDebugRm(Debug &d, char *str);
int aDebugIsSet(Debug d, unsigned u);

extern char *debug_list[64]; 

#define DEBUG_NONE		0
#define	DEBUG_COMMAND	1
#define DEBUG_PARSE		2
#define DEBUG_SLEEP		3
#define DEBUG_SERVER	4
#define DEBUG_PROC_MUX 	5
#define DEBUG_DS_IP 	6
#define DEBUG_STORAGE 	7
#define DEBUG_ALERT 	8
#define DEBUG_SCHED		9
#define DEBUG_NF		10
#define DEBUG_HTML		11
#define DEBUG_MONITOR		12
#define DEBUG_LOGIN		13
#define DEBUG_QUOTA		14
#define DEBUG_IPTREE		15
#define DEBUG_FLOW		16
#define DEBUG_ALL		63

//////////////////////////////////////////////////////////////////////////////////////////
struct time_counters {
	time_t ht;
	time_t dt;
	time_t wt;
	time_t mt;
};

void PrepareTimeCounters(struct time_counters *tc);
void FillTimeCounters(policy_data *np,struct time_counters *tc);
time_t aGetActual(char prefix);
//////////////////////////////////////////////////////////////////////////////////////////
void cHelp(Connection *conn, int no_flag, char *str);
void aShowVersion (FILE*);
char* binary(unsigned long num);
void print_to_string(char **string, char const *fmt, ...);
char *set_string(char *string);
void cExec(char *cmd, char **buffer);
//////////////////////////////////////////////////////////////////////////////////////////
int cNewOid(Connection *c, char *type);
unsigned cShowPerf(Connection *conn, char *param[32]);
//////////////////////////////////////////////////////////////////////////////////////////
