/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: connections.c,v 1.10.2.2 2004/05/06 10:35:02 jura Exp $ */

#include "netams.h"

//////////////////////////////////////////////////////////////////////////////////////////
Connection::Connection(char *n, int fd){
	name=set_string(n);
	conn_id=0;

	if (fd==CONN_FD_VIRT) {
		stream_r=NULL;
		#ifdef LINUX
		cookie_io_functions_t fhooks;
		fhooks.write=&conn_write;
		stream_w=fopencookie(this, "w", fhooks);
		#else // FreeBSD
		stream_w=fwopen(this, conn_write);
		#endif
		if (!stream_w) aLog(D_ERR, "%s\n", strerror(errno));
		setlinebuf(stream_w);
		stream_r=NULL;
		}

	else if (fd==1) {
		stream_r=stdin;
		stream_w=stdout;
		if (!stream_r || !stream_w) aLog(D_ERR, "%s\n", strerror(errno));
		}

	else {
		stream_r=fdopen(fd, "r");
		stream_w=fdopen(dup(fd), "w");
		if (!stream_r || !stream_w) aLog(D_ERR, "%s\n", strerror(errno));
		}

	next=NULL;
	user=NULL;
	buffer=NULL;
	aDebugAdd(debug, "none");
	
	addr=(struct sockaddr_in*)aMalloc(sizeof(struct sockaddr_in));
	inet_aton("0.0.0.0", &(addr->sin_addr));

	socket=fd;
	service=NULL;
	permissions=UPERM_NONE;

	t_connected=t_lastcmd=time(NULL);
	}

Connection::~Connection(){
//	aDebug(DEBUG_PARSE, "deleting conn: %s, fd=%d bufferL=%d\n", name, socket, buffer?strlen(buffer):0);
	Flush();
	aFree(name);
	aFree(addr);
	if (buffer) aFree(buffer);
//	return;

	if (socket!=CONN_FD_VIRT) {
		fclose(stream_w);
		fclose(stream_r);
		shutdown(socket, SHUT_RDWR);
		close(socket);
		}
	}

#ifdef LINUX
ssize_t conn_write(void *conn, const char *buf, unsigned int i) {
#else 
int conn_write(void *conn, const char *buf, int i) {
#endif

	int j1, j2;

//	aDebug(DEBUG_PARSE, "printing to conn %s, buffer %p, %d bytes\n", ((Connection*)conn)->name, ((Connection*)conn)->buffer, i);

	if (((Connection*)conn)->buffer) {
		j1=strlen(((Connection*)conn)->buffer);
		j2=j1+strlen(buf)+1;
		char *c = (char*)aMalloc(j2);
		memcpy(c, ((Connection*)conn)->buffer, j1);
		memcpy(c+j1, buf, i);
		c[j2]='\0';
		aFree(((Connection*)conn)->buffer);
		((Connection*)conn)->buffer=c;
		}
	else {
		((Connection*)conn)->buffer=(char*)aMalloc(i+1);
		memcpy(((Connection*)conn)->buffer, buf, i);
		}

	return 0;
	}

void Connection::Flush(){
	if (socket!=CONN_FD_VIRT) {
		fflush(stream_w);
		}
	}

//////////////////////////////////////////////////////////////////////////////////////////
// Connections management
ConnectionsList::ConnectionsList(){
	root=last=NULL;
	num_connections=0;
	last_conn_id=0;
	unknown_service=UNKNOWN_REFERENCE;
	lock=(pthread_mutex_t*)aMalloc(sizeof (pthread_mutex_t));
	pthread_mutex_init(lock, NULL);
	}

ConnectionsList::~ConnectionsList(){
	pthread_mutex_destroy(lock);
	aFree(lock);
	}

Connection *ConnectionsList::getConnection(unsigned conn_id){
	pthread_mutex_lock(lock);
	Connection *t;
	for (t=root; t!=NULL; t=t->next) {
		if (t->conn_id==conn_id) {
			pthread_mutex_unlock(lock);
			return t;
			}
		}
	pthread_mutex_unlock(lock);
	return NULL;
	}

void ConnectionsList::Insert(Connection *t){
	pthread_mutex_lock(lock);
	Connection *d;
	for(d=root; d!=NULL; d=d->next)
		if (d==t) { 
			pthread_mutex_unlock(lock);
			return;
			}
	if (root==NULL) root=t;
	else last->next=t;
	last=t; 
	num_connections++;
	last_conn_id++;
	t->conn_id=last_conn_id;
	pthread_mutex_unlock(lock);
	}

void ConnectionsList::Delete(Connection *t){
	pthread_mutex_lock(lock);
	Connection *d, *p;
	for(d=root; d!=NULL; d=d->next)	{
		if (d==t) {
			if (t==root && t==last ) root=last=NULL;
			else if (t==root) root=t->next;
			else if (t==last) { last=p; last->next=NULL; }
			else p->next=t->next;

			delete t;
			num_connections--;
			t=NULL;
			break;
			}
		p=d; 
	 	}
	pthread_mutex_unlock(lock);
	return;
	}
	
void ConnectionsList::Delete(unsigned conn_id){
	for(Connection *d=root; d!=NULL; d=d->next) if (d->conn_id==conn_id) Delete(d); 
	}	

void ConnectionsList::listConnections(Connection *watcher){
	pthread_mutex_lock(lock);
	Connection *t;
	time_t idle;
	unsigned long days, hours, mins, secs;

	fprintf(watcher->stream_w, "%10s | %6s | %8s | %10s | %18s | %10s\n", "NAME", "ID", "IDLE", "CONNECTED", "ADDR", "PERMIT");
	for(t=root; t!=NULL; t=t->next){

		fprintf(watcher->stream_w, "%10s | %06d | ", t->name, t->conn_id);

		idle = time(NULL) - t->t_lastcmd;
		days=idle/(60*60*24);
		hours=(idle-days*60*60*24)/(60*60);
		mins=(idle-(days*60*60*24)-(hours*60*60))/60;
		secs=idle-(days*60*60*24)-(hours*60*60)-mins*60;
		if (days>0) fprintf(watcher->stream_w, "%4ldd%2ldh", days, hours);
		else if (hours>0) fprintf(watcher->stream_w, "%4ldh%2ldm", hours, mins);
		else if (mins>0) fprintf(watcher->stream_w, "%4ldm%2lds", mins, secs);
	  	else fprintf(watcher->stream_w, "%7lds", secs);

		fprintf(watcher->stream_w, " | ");

		idle = time(NULL) - t->t_connected;
		days=idle/(60*60*24);
		hours=(idle-days*60*60*24)/(60*60);
		mins=(idle-(days*60*60*24)-(hours*60*60))/60;
		secs=idle-(days*60*60*24)-(hours*60*60)-mins*60;
		if (days>0) fprintf(watcher->stream_w, "  %4ldd%2ldh", days, hours);
		else if (hours>0) fprintf(watcher->stream_w, "  %4ldh%2ldm", hours, mins);
		else if (mins>0) fprintf(watcher->stream_w, "  %4ldm%2lds", mins, secs);
	  	else fprintf(watcher->stream_w, "  %7lds", secs);

		fprintf(watcher->stream_w, " | %18s | %10s\n", inet_ntoa(t->addr->sin_addr), permissions_list[t->permissions]);
		}
	pthread_mutex_unlock(lock);
	}

char *ConnectionsList::getConnectionByThr(pthread_t t){
	pthread_mutex_lock(lock);
	Connection *d;
	for(d=root; d!=NULL; d=d->next)
		if (pthread_equal(t, d->t_id)) {
			pthread_mutex_unlock(lock);
			return d->name;
			}
	pthread_mutex_unlock(lock);
	return unknown_service;
	}

//////////////////////////////////////////////////////////////////////////////////////////
void cShowConnections(Connection *conn){
	if (!conn->stream_w) return;
	Connections.listConnections(conn);
	}



