/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: ds_netflow.c,v 1.8.2.2 2004/05/06 10:35:02 jura Exp $ */

#include "netams.h"
#include "netflow.h"

//////////////////////////////////////////////////////////////////////////
struct vip {
        struct ip iph;
        struct tcphdr tch;
        };
//////////////////////////////////////////////////////////////////////////
unsigned sDS_AcctNetFlow(Service *s, struct ip *ip, struct timeval *tv) {

	ServiceDS_cfg *cfg=(ServiceDS_cfg*)s->cfg;
	struct vip v_ip; // we will treat this flow record as a virtual IP packet

	IPStat5Msg *msg = (IPStat5Msg*)ip;
	IPFlow5Stat *rec;
	Flow5StatHdr *hdr = &msg->header;
	hdr->version = ntohs(hdr->version);

	if (hdr->version==FLOW_VERSION_5) {
		hdr->count         = ntohs(hdr->count);
		hdr->SysUptime     = ntohl(hdr->SysUptime);
		hdr->unix_secs     = ntohl(hdr->unix_secs);
		hdr->unix_nsecs    = ntohl(hdr->unix_nsecs);
		hdr->flow_sequence = ntohl(hdr->flow_sequence);

//		aDebug(DEBUG_NF, " cfg seq %lu, fl seq %lu, %d records:\n", cfg->seq_id, hdr->flow_sequence, hdr->count);

		if (!cfg->seq_id) cfg->seq_id=hdr->flow_sequence;
		if (cfg->seq_id!=hdr->flow_sequence) { 
			if (hdr->flow_sequence> V5FLOWS_PER_PAK) aLog(D_WARN, "NF:%d awaited seq %lu, received %lu from %02X (%d flows are lost)\n", cfg->id, cfg->seq_id, hdr->flow_sequence, hdr->engine_id, hdr->flow_sequence-cfg->seq_id);
			cfg->seq_id=hdr->flow_sequence; // restoring back
		}

		cfg->seq_id+=hdr->count;

		aDebug(DEBUG_NF, " NetFlow v%d:%02X packet ds:%d seq %lu/%lu with %d records:\n", hdr->version, hdr->engine_id, cfg->id, hdr->flow_sequence, cfg->seq_id, hdr->count);

		for (int i = 0; i < hdr->count; i++) {
			rec = &msg->records[i];
			
			bzero((void*)&v_ip, sizeof(v_ip));
			
			v_ip.iph.ip_hl=ip->ip_hl;
			v_ip.iph.ip_len=0;   //no metter
			v_ip.iph.ip_p=rec->prot;
			memcpy(&v_ip.iph.ip_src, &rec->srcaddr, sizeof(struct in_addr)); 
			memcpy(&v_ip.iph.ip_dst, &rec->dstaddr, sizeof(struct in_addr)); 

    			v_ip.tch.th_sport = rec->srcport;
	    		v_ip.tch.th_dport = rec->dstport;

#ifdef DEBUG
			char *b1, buf_1[32], *b2, buf_2[32]; // for debugging
			b1=inet_ntoa(v_ip.iph.ip_src); strncpy(buf_1, b1, strlen(b1)+1);
			b2=inet_ntoa(v_ip.iph.ip_dst); strncpy(buf_2, b2, strlen(b2)+1);
			aDebug(DEBUG_NF, " IP src:%s,dst:%s,l:%ld,p:%d,sp:%u,dp:%u\n", buf_1, buf_2, ntohl(rec->dOctets), (v_ip.iph.ip_p), ntohs(v_ip.tch.th_sport), ntohs(v_ip.tch.th_dport));
#endif
			sDS_AcctIp(s, (struct ip*)&v_ip, tv, ntohl(rec->dOctets), 1);

    		}
	
	}
	
	else aDebug(DEBUG_NF, " NetFlow v%d packet unsupported\n", hdr->version);

	return 0;
}
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

