/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***
*************************************************************************/
/* $Id: flowmodule.h,v 1.2.2.1 2004/05/06 10:35:02 jura Exp $ */


#ifndef _NETINET_IN_H_
#include <netinet/in.h>
#endif
/////////////////////////////////////////////////////////////////////////////////////
void dsFlowModule(Service *s);
void dsFlowModuleAdd(Service *s);
void dsFlowModuleRemove(Service *s);
/////////////////////////////////////////////////////////////////////////////////////
enum action { A_DROP=1, A_PASS=0, A_PASS_LOCAL=2 };
enum fm_msg_type { EMPTY, CONFIG, REQ_FLOW, ACK_FLOW, SEND_FLOW };

typedef struct qos_policy {
	unsigned set_high_priority;
	};

typedef struct fm_ipheader {
	u_char ip_p;					 
	u_char ip_tos;
	struct in_addr ip_src,ip_dst;
	u_char tcp_flags;
	u_short s_port, d_port;
	u_short len;
	};

// REQ_FLOW
typedef struct fm_req_flow { 
	fm_ipheader header;
	u_short hash;
	char iface[10];
	};

// ACK_FLOW
typedef struct fm_ack_flow { 
	fm_ipheader header;
	u_short hash;
	char iface[10];
	action act;
	time_t timeout;
	qos_policy qp;
	};

// SEND_FLOW
typedef struct fm_send_flow { 
	fm_ipheader header;
	u_short hash;
	char iface[10];
	time_t t_from;
	time_t t_to;
	unsigned long packets;
	unsigned long long bytes;
	};

typedef struct fm_message {
	unsigned	version;
	fm_msg_type	type;	
	union {
		fm_req_flow req_flow;
		fm_ack_flow ack_flow;
		fm_send_flow send_flow;
		};
	};

/////////////////////////////////////////////////////////////////////////////////////



