/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: iptree.c,v 1.14.2.1 2004/05/06 10:35:02 jura Exp $ */

#include "netams.h"

/////////////////////////////////////////////////////////////////////////////////////////////
IPTree::IPTree() {
	nodes=1;
	dlink=0;
	unodes=0;
	root=(IPTree_node*)aMalloc(sizeof(IPTree_node));
	rwlock=(pthread_rwlock_t*)aMalloc(sizeof (pthread_rwlock_t));
	pthread_rwlock_init(rwlock, NULL);
}
/////////////////////////////////////////////////////////////////////////////////////////////
IPTree::~IPTree() {
	freetree(root);
	aFree(root);
	pthread_rwlock_destroy(rwlock);
        aFree(rwlock);
}
/////////////////////////////////////////////////////////////////////////////////////////////
void IPTree::FreeTree(IPTree_node *node) {
        pthread_rwlock_wrlock(rwlock);
	freetree(node);
        pthread_rwlock_unlock(rwlock);
}
/////////////////////////////////////////////////////////////////////////////////////////////
void IPTree::freetree(IPTree_node *node) {
	if(node->next) {
		for(unsigned i=0;i<256;i++) 
			if(node->next[i]) freetree(node->next[i]);
		aFree(node->next);
                node->next=NULL;
                dlink--;
	}
	dsUlist *tmp,*dsu;
	dsu=(dsUlist*)(node->ptr);
	while(dsu) {
		tmp=dsu;
		dsu=dsu->next;
		aFree(tmp);
		unodes--;
	}
	if(node != root) {
		aFree(node); //we alloc root in constructor so we'll delete it in descructor
		nodes--;
	}
} 
/////////////////////////////////////////////////////////////////////////////////////////////
unsigned short IPTree::cleanup(IPTree_node *node) {
	unsigned short active=0;
	if(node->next) {
        	for(unsigned i=0;i<256;i++)
                	if(node->next[i]) 
				if(cleanup(node->next[i])) active++;
				else node->next[i]=NULL;

        	if(!active) { 
                	aFree(node->next);
                	node->next=NULL;
                	dlink--;
        	} else return 1;	
	}

	if(node->ptr) return 1;

        if(node != root) {
                aFree(node); //we alloc root in constructor so we'll delete it in destructor
                nodes--;
        }
	return 0;
}
/////////////////////////////////////////////////////////////////////////////////////////////
void IPTree::addr2tree(unsigned long addr,unsigned mask,NetUnit *u,unsigned flag) {
	IPTree_node *node=root;
        IPTree_node *tmp;
        unsigned num;
        int range;

	if(!addr && mask==32) return;

	pthread_rwlock_wrlock(rwlock);
        
	if(mask==0) {
		add2node(root,u,flag);
		pthread_rwlock_unlock(rwlock);
		return;
	}
	
//	struct in_addr ia;
//	ia.s_addr=addr;
//	aLog(D_INFO,"IPTree: working with %s /%u action=%u(1-add,0-remove)\n",inet_ntoa(ia),mask,flag);

        for (unsigned i=0;i<4;i++) {
                num=(addr&0x000000FF);
		addr=addr>>8;
//		aLog(D_INFO,"num[%u]=%u\n",i,num);
                range=8*(i+1)-mask;
                if(range<8 && range>=0){
			unsigned nnum=num;
			if(!node->next){
				if(!flag) break;
                                node->next=(IPTree_node**)aMalloc(256*sizeof(IPTree_node*));
                        	bzero(node->next,256*sizeof(IPTree_node*));
				dlink++;
			}

                         do {
                                if(!node->next[num] && flag) {
                                        tmp=(IPTree_node*)aMalloc(sizeof(IPTree_node));
                                        bzero(tmp,sizeof(IPTree_node));
                                        node->next[num]=tmp;
					tmp->up=node;
					nodes++;
                                } 
				add2node(node->next[num],u,flag);
				num++;
                        } while(num<nnum+(unsigned)(1<<range));
                        break;
                }
			
		if(!node->next){
				if(!flag) break;
                                node->next=(IPTree_node**)aMalloc(256*sizeof(IPTree_node*));
                                bzero(node->next,256*sizeof(IPTree_node*));
				dlink++;
                }

		if(!node->next[num]) {
			if(!flag) break; 
			tmp=(IPTree_node*)aMalloc(sizeof(IPTree_node));
                        bzero(tmp,sizeof(IPTree_node));
                        node->next[num]=tmp;
			tmp->up=node;
			nodes++;
                }
                node=node->next[num];
	}
	if(!flag) cleanup(root);
	
	pthread_rwlock_unlock(rwlock);
}

void IPTree::add2node(IPTree_node *node,NetUnit *u,unsigned flag) {//1-add 0-remove
	if(!node) return; //just in case

	dsUlist *dsu=(dsUlist*)(node->ptr);
       	for(;dsu!=NULL;dsu=dsu->next) 
		if(dsu->u==u) break;

	if(flag) {//add
		if(dsu) return; // we do not want to add same unit
       	 	dsUlist *newdsu=(dsUlist*)aMalloc(sizeof(dsUlist));
                bzero(newdsu,sizeof(dsUlist));
                newdsu->u=u;
		unodes++;
		dsu=(dsUlist*)(node->ptr);
                if(dsu) {
               	 	dsu->prev=newdsu;
               		newdsu->next=dsu;
                } 
               	node->ptr=(void*)newdsu;
      	} else {//remove
		if(!dsu) return; //nothing to remove
		if(dsu==(dsUlist*)(node->ptr)) {
			node->ptr=(void*)dsu->next;
                } else 
                	dsu->prev->next=dsu->next;
                if(dsu->next) dsu->next->prev=dsu->prev;
                aFree(dsu);
		unodes--;
         }
}
/////////////////////////////////////////////////////////////////////
dsUlist* IPTree::checktree(struct ip *packet) {
        unsigned num;
        IPTree_node *node=root;
	dsUlist *dsu;
	//if there is 0/0 network it will be included thus
	// otherwise ==NULL 
	dsUlist *start=(dsUlist*)(root->ptr); 
	unsigned long src,dst;
	unsigned i;

	if(start) start->mf=MATCH_BOTH; // it's true for 0/0
	
	src=packet->ip_src.s_addr;
	dst=packet->ip_dst.s_addr;
//	aLog(D_INFO,"src=%s %s\n",inet_ntoa(packet->ip_src),binary(src));
//	aLog(D_INFO,"dst=%s %s\n",inet_ntoa(packet->ip_dst),binary(dst));

//	showtree(root,0,0);
	
	//check for dst first
        for ( i=0;i<4;i++) {
		num=(dst&0x000000FF);
		dst=dst>>8;
//                aLog(D_INFO,"num[%u]=%u\n",i,num);
                if(!node->next || !node->next[num]) break;
                node=node->next[num];
                if(node->ptr) {
			dsu=(dsUlist*)(node->ptr);
			dsu->mf=MATCH_DST;
			dsu->link=start;
			start=dsu;
//			aLog(D_INFO,"MATCH_DST\n");
		}
        }
// i'll put comments here 
// there is trick in creating units list here and later when we using it in sDS_Acct_Ip	:
// first cycle creates list of units lists 
// second - continues it for dst packet addr and if some units already matched in this list 
// rematch it as MATCH_BOTH, but !!! there is some networks that actually matches one unit net, 
// but represented with number of subnets with full mask (8,16,24,32)
// in this case one unit will be represented in this list 2 times: once as MATCH_SRC and another MATCH_DST
// but it will be prefect checked(but 2 times), cause when we check ip for forward we actually call to packet and unit
// and then it will be counted(but 2 times) - if we look inside function that counts it 
// we found that function actually check for match flag only to summ numbers so it will be ok 
// to call this functions 2 times - once for MATCH_DST and another or MATCH_SRC
// so only problem - we performs 1 extra check cycle for such units type
	node=root;
	//check for src
	for ( i=0;i<4;i++) {
		num=(src&0x000000FF);
		src=src>>8;
//                aLog(D_INFO,"num[%u]=%u\n",i,num);
                if(!node->next || !node->next[num]) break;
                node=node->next[num];
                if(node->ptr) {
			dsu=(dsUlist*)(node->ptr);
			if(dsu->mf) 
				dsu->mf=MATCH_BOTH;
			else {
				dsu->mf=MATCH_SRC;
				dsu->link=start;
                       		start=dsu;
			}
//			aLog(D_INFO,"MATCH_SRC\n");
                }
        }
	return start;
}
/////////////////////////////////////////////////////////////////////
void IPTree::showtree(IPTree_node *node,unsigned long addr,unsigned depth) {
        unsigned i;

        if(node->ptr) {
                struct in_addr ia;
                ia.s_addr=addr;
                aLog(D_INFO,"%s /%u\n", inet_ntoa(ia), 8*depth);
        } else {
		if(node->next)
                	for(i=0;i<256;i++)
                        	if(node->next[i])  showtree(node->next[i],addr+(i<<(8*depth)),depth+1);
        }
}
/////////////////////////////////////////////////////////////////////////////////////////////
// definitions for PrefixTree
/////////////////////////////////////////////////////////////////////////////////////////////
PrefixTree::PrefixTree() {
	nodes=1;
	dlink=0;
        root=(IPTree_node*)aMalloc(sizeof(IPTree_node));
}
/////////////////////////////////////////////////////////////////////////////////////////////
PrefixTree::~PrefixTree() {
        freetree(root);
	aFree(root);
}
/////////////////////////////////////////////////////////////////////////////////////////////
void PrefixTree::freetree(IPTree_node *node) {
        if(node->next) {
		for(unsigned i=0;i<256;i++)
                	if(node->next[i]) freetree(node->next[i]);
		aFree(node->next);
		node->next=NULL;
		dlink--;
	}
	if(node !=root) {
		aFree(node);
		nodes--;
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////
void PrefixTree::prefix2tree(prefix *p) {
        IPTree_node *tmp;
	IPTree_node *node=root;
        unsigned num;
        int range;
        unsigned mask=p->mask;
        unsigned long addr=p->network;

        if(mask <0 && mask > 32) return;
        if(mask==0) {node->ptr=(void*)p;return;}

        for (unsigned i=0;i<4;i++) {
                if(node->ptr) return;
                num=(addr&0x000000FF);
		addr=addr>>8;
                range=8*(i+1)-mask;
                if(range<8 && range>=0){
			unsigned nnum=num;
			if(!node->next){
                                node->next=(IPTree_node**)aMalloc(256*sizeof(IPTree_node*));
                 	       	bzero(node->next,256*sizeof(IPTree_node*));
				dlink++;
                        }
             
                        do {
                                if(!node->next[num]) {
                                        tmp=(IPTree_node*)aMalloc(sizeof(IPTree_node));
                                        bzero(tmp,sizeof(IPTree_node));
                                        node->next[num]=tmp;
					nodes++;
                                } else {
					if(node->next[num]->next)	{
						for(unsigned j=0;j<256;j++) 
							if(node->next[num]->next[j]) freetree(node->next[num]->next[j]);
						aFree(node->next[num]->next);
						node->next[num]->next=NULL;
						dlink--;
					}
				}
                                node->next[num]->ptr=(void*)p;
				num++;
                        } while(num<nnum+(1<<range)); 
                        break;
                }
                
		if(!node->next){
                        node->next=(IPTree_node**)aMalloc(256*sizeof(IPTree_node*));
                        bzero(node->next,256*sizeof(IPTree_node*));
			dlink++;
                }

		if(!node->next[num]) {
                        tmp=(IPTree_node*)aMalloc(sizeof(IPTree_node));
                        bzero(tmp,sizeof(IPTree_node));
                        node->next[num]=tmp;
			nodes++;
                }
                node=node->next[num];
        }
}
/////////////////////////////////////////////////////////////////////////////////////////////
unsigned PrefixTree::checktree(unsigned long addr) { 
        unsigned num;
	IPTree_node *node=root;

	if(node->ptr) {
        	((prefix*)(node->ptr))->match++;
               	return 1;
        }

        for (unsigned i=0;i<4;i++) {
		num=(addr&0x000000FF);
		addr=addr>>8;
                if(!node->next || !node->next[num]) break;
                node=node->next[num];

                if(node->ptr) {
                        ((prefix*)(node->ptr))->match++;
                        return 1;
                }
        }
        return 0;
}
/////////////////////////////////////////////////////////////////////////////////////////////
		
			


		
