/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: iptree.h,v 1.7.2.1 2004/05/06 10:35:03 jura Exp $ */

typedef struct IPTree_node {
	IPTree_node *up;
	IPTree_node **next;
	void *ptr;
} IPTree_node;
/////////////////////////////////////////////////////////////////////////////////////
class IPTree {
	public:
		unsigned long nodes; //number of IPTree_node allocated
		unsigned long dlink; //number of *IPTree_node[256] allocated;
		unsigned long unodes; //number of dsUlist allocated
		IPTree_node *root;
		pthread_rwlock_t *rwlock;

		IPTree();
		~IPTree();
		void FreeTree(IPTree_node *node); //this organize locks
		void freetree(IPTree_node *node); //this makes recursion and real free
		unsigned short cleanup(IPTree_node *node);
		void add2node(IPTree_node *node,NetUnit *u,unsigned flag);
		void addr2tree(unsigned long addr,unsigned mask,NetUnit *u,unsigned flag);
		dsUlist *checktree(struct ip *ipc);
		void showtree(IPTree_node *node,unsigned long addr,unsigned depth);
};
/////////////////////////////////////////////////////////////////////////////////////
class PrefixTree {
        public:
		unsigned long nodes; //number of IPTree_node allocated
		unsigned long dlink; //number of *IPTree_node[256] allocated;
                IPTree_node *root;
		// we do not need lock here cause it's worked in PrefixFile class and locked here
                PrefixTree();
                ~PrefixTree();
                void freetree(IPTree_node *node); //this makes recursion and real free
                void prefix2tree(prefix *p);
                unsigned checktree(unsigned long addr);
};
/////////////////////////////////////////////////////////////////////////////////////

		
