/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: main.c,v 1.17.2.3 2004/05/06 10:35:03 jura Exp $ */

#include "netams.h"

ConnectionsList Connections;
ServicesList Services;
UsersList Users;
ScheduleList Sched;
Connection *cInternal;
Service *sMain;
Service *sSched;
User *uInternal;
int global_return_code=0;

int flag_nodaemon=0, flag_log=0, flag_quiet=0;
FILE *LOGFILE;
FILE *DEVNULL;
FILE *configfile;
char *config_file_name=NULL;
struct timeval program_start;

int main(int argc, char **argv){
int op;
char *buffer;

aPermissionsInit();
aDebugInit();
aSysPolicyInit();
 
uInternal=new User("<internal>", 1);  uInternal->permissions=UPERM_ALL;
Users.Insert(uInternal);

cInternal=new Connection("<internal>", 1); cInternal->permissions=UPERM_ALL;
cInternal->user=uInternal;
Connections.Insert(cInternal);
aDebugAdd(cInternal->debug, "none");
gettimeofday(&program_start, NULL);

sMain=new Service("main", 0);
Services.Insert(sMain);
pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
sMain->t_id=cInternal->t_id=pthread_self();

while((op=getopt(argc, argv, "qdlf:")) != EOF){
	switch(op){
		case 'q': 
			flag_quiet = 1;
			break;
		case 'd': 
			flag_nodaemon = 1;
			break;
		case 'l': 
			flag_log = 1;
			break;
		case 'f': 
			config_file_name=set_string(optarg);
			break;
		default: break;
		}
	}

if (flag_log) {
	LOGFILE = fopen(path_to_log, "at");
	if (LOGFILE==NULL) { fprintf(stderr, "LOGFILE %s opening: %s\n", path_to_log, strerror(errno)); exit(-1); }
	setvbuf(LOGFILE, NULL, _IOLBF, 0);
	}

DEVNULL = fopen("/dev/null", "wt");
if (DEVNULL==NULL) {
	aLog(D_CRIT, "main/devnull opening: %s\n", strerror(errno));
	exit(-1);
	}

if (!flag_quiet) aShowVersion(stdout);
if (flag_log) aShowVersion(LOGFILE);

if (config_file_name==NULL)
	config_file_name=set_string((char*)path_to_config);

configfile = fopen(config_file_name, "rt");
if (configfile==NULL) {
	aLog(D_CRIT, "main/configfile opening: %s\n", strerror(errno));
	exit(-1);
	}

if (!flag_nodaemon) { aLog(D_INFO, "Becoming a daemon...\n"); daemon(0, 1); chdir(_PATH_VARTMP); }
else aLog(D_INFO, "Stay in debug mode...\n");
// handling signals
signal(SIGINT, (sig_t)termination);

sSched=new Service("scheduler", 0);
Services.Insert(sSched);
sSched->Start("scheduler");

// here is the place for config file parse

buffer=(char *)aMalloc(4*1024+1); 
while (!feof(configfile)){
	fgets(buffer, 4*1024, configfile);
	aCommand(cInternal, buffer);
	bzero(buffer, 4*1024);
	}  
fclose(configfile);
aFree(buffer);

sMain->setSleep();
sMain->Sleep(1000); //we must sleep to be sure all services read they configuration
Services.StartAll(sMain);
if (!flag_quiet) printf("%s is now operational, %s\n", aaa_fw_software_name, timeU2T(time(NULL), NULL));
sMain->Sleep();

// the last actual action
;

/////////////////////////////////////////////////////////////
// exit point
if (!flag_quiet) printf("Shutdown signal received at %s\n", timeU2T(time(NULL), NULL));

Services.ShutdownAll(sMain);
//Services.getService("server", 0)->Shutdown();
//sMain->Sleep(1000);

if (!flag_quiet) printf("%s exiting at %s\n", aaa_fw_software_name, timeU2T(time(NULL), NULL));
aLog(D_INFO, "%s exiting with code %d\n", aaa_fw_software_name, global_return_code);

aLog(D_INFO, "memory usage summary:\ntotal allocated: %qu (%u times), freed %u times (%u null)\n", aGetBytesAllocated(), aGetTimesAllocated(), aGetTimesFreed(), aGetTimesFreedNull());
aLog(D_INFO, "units locking summary:\ntries: %lu, failed: %lu, ratio: %3.2f\n", Units.tries_lock, Units.tries_lock_failed,  !Units.tries_lock?0:100*(float)((double)Units.tries_lock_failed/(double)Units.tries_lock));
if (flag_log) fclose(LOGFILE);

aFree(config_file_name);
if( global_return_code == PARSE_RELOAD ) 
	if (-1==execvp(argv[0],argv)) perror("reload failed");

return global_return_code;					  
}
/////////////////////////////////////////////////////////////
