/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: net_units.h,v 1.17.2.3 2004/05/06 10:35:03 jura Exp $ */

#define NETUNIT_TYPES_NUM	6

enum netunit_type { NETUNIT_UNKNOWN=0, NETUNIT_USER=1, NETUNIT_HOST=2, NETUNIT_CLUSTER=3, NETUNIT_NET=4, NETUNIT_GROUP=5 };
extern char *netunit_type_name[NETUNIT_TYPES_NUM];

typedef struct DSList{
	unsigned id;
	DSList *prev;
	DSList *next;
	} DSList;

void DSListAdd(NetUnit *u, int *i, Connection *conn, char *param[32], int no_flag);
/////////////////////////////////////////////////////////////////////////////////////
class NetUnit {
	public:
		oid id;
		char *name;
		char *email;
		netunit_type type;
		NetUnit *next;
		NetUnit *parent;
		PdList ap;
		PdList fp;
		struct DSList *dsl_root;
		void *monitor;
		sLoginData *logindata;
		sQuotaData *quotadata;
		unsigned nlp; // no-local-pass flag

		char *sys_policy_name; 
		SysPolicy sys_policy; 
		oid sys_policy_perm;
		int changed;
		
		time_t open;
		time_t timeout;
		time_t inact;

		NetUnit(netunit_type t);
		~NetUnit();
		void setName(char *n);
		int setDSList(unsigned ds_id);
		int clearDSList(unsigned ds_id=0);
		struct DSList *getDSList();
		int checkDSList(unsigned ds_id); 
		match Check(void *s);
		void unit2tree(IPTree *iptree,unsigned flag); // flag=1 add 0 -remove
		void NetUnit::unit2trees(unsigned flag); //add unit to all correspondign trees
};

/////////////////////////////////////////////////////////////////////////////////////
class NetUnit_host: public NetUnit {
	public:
		struct in_addr ip;
		NetUnit_host *next;
		NetUnit_host();
		match Check(struct ip *ipc);
		void unit2tree(IPTree *iptree,unsigned flag);
};

class NetUnit_cluster: public NetUnit {
	private:
		unsigned references;
		pthread_mutex_t *lock;
	public:
		NetUnit_host *root;
		NetUnit_host *last;
		NetUnit_cluster();
		~NetUnit_cluster();
		void Add(struct in_addr ip);
		void Remove(struct in_addr ip);
		match Check(struct ip *ipc);
		void unit2tree(IPTree *iptree,unsigned flag);
		friend unsigned cShowUnits(Connection *conn);
		friend void sHtmlAction(Html_cfg *cfg);
		friend void sProcessorListCfg(Service *s, FILE *f);
	};

class NetUnit_net: public NetUnit {
	public:
		struct in_addr ip;
		struct in_addr mask;
		NetUnit_net();
		match Check(struct ip *ipc);
		void unit2tree(IPTree *iptree,unsigned flag);
	};

class NetUnit_group: public NetUnit {
	private:
		unsigned references;
	public:
		NetUnit_group();
		match Check(struct ip *ipc);
	};

class NetUnit_user: public NetUnit {
        public:
                struct in_addr ip;
		char *password;
		char *real_name;
                NetUnit_user *next;
                NetUnit_user();
                match Check(struct ip *ipc);
		void unit2tree(IPTree *iptree,unsigned flag);
        };

/////////////////////////////////////////////////////////////////////////////////////
class NetUnitsList {
	public:
		NetUnit *root;
		NetUnit *last;
		unsigned num_units;
		pthread_rwlock_t *rwlock;
		unsigned long tries_lock;
		unsigned long tries_lock_failed;

		NetUnitsList();
		~NetUnitsList();
		void Insert(NetUnit *unit);
		void Delete(NetUnit *unit);
		void Delete(oid id);
		NetUnit *getUnit(char *name);
		NetUnit *getUnitById(oid id);
		void DeletePolicyElsewhere(Policy *p);
		friend unsigned cShowUnits(Connection *conn);
		unsigned setMon(void *value, oid id, char *name);
		void showMon(FILE *out, void *to, unsigned action); //action: 1-for show, 0- for config
		void listPasswordsHtml(Connection *conn);
		};

// this using in quotactl service as unit representation
typedef struct qUlist {
        NetUnit *u;
        qUlist *prev;
        qUlist *next;
	unsigned q_soft,q_viol;
        } qUlist;
// this using un datasource service as unit representation
typedef struct dsUlist {
	NetUnit *u;
	dsUlist *prev;
	dsUlist *next;
	
	dsUlist *link; //this used to organize matched units in list
	match mf;
} dsUlist;

/////////////////////////////////////////////////////////////////////////////////////
int cUnit(Connection *conn, char *param[], int no_flag);
unsigned cShowUnits(Connection *conn, char *param[]);
unsigned cShowUnitsList(Connection *conn, int isfull, char *p1, char *p2);
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////




