/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: parse.c,v 1.22.2.5 2004/05/06 10:35:04 jura Exp $ */

#include "netams.h"

char *empty=" ";
char *empty_="";

//////////////////////////////////////////////////////////////////////////////////////////
// Configuration parse /////////////////////////////////////////////////////////////////// 

unsigned aCommand(Connection *conn, char *cmd_orig){
	char *param[32];
	int no_flag;
	
	char *a, *b;
	int i, j, return_state=PARSE_OK;
	char *cmd;
	
	if (cmd_orig[0]==10 || cmd_orig[0]=='\0') { 
		if(conn->service) {
        		if(conn!= cInternal && !conn->service->Wakeup()) {
               			aLog(D_INFO, "waking up %s:%u service\n", conn->service->getName(), conn->service->instance);
                	}
			conn->service=NULL;
		}
		return return_state; 
	} 
	if (cmd_orig[0]=='#' || cmd_orig[0]=='!') return return_state; 

	cmd=set_string(cmd_orig);

	no_flag=0;

	// now we will parse the input string for 'no' modifier and param[] array
	a=strstr(cmd, "\n"); if (a!=NULL) *a='\0';	
	a=strstr(cmd, "\r"); if (a!=NULL) *a='\0';
	b=cmd;

	if (conn->service) aDebug(DEBUG_COMMAND, "(%s)/%s:%u->%s\n", conn->getName(), conn->service->getName(), conn->service->instance, cmd);
	else aDebug(DEBUG_COMMAND, "(%s)->%s\n", conn->getName(), cmd);

	conn->t_lastcmd=time(NULL);

	for (i=0; i<32; i++) param[i]=empty;
	i=0;
	while (NULL!=(a=strchr(b, ' '))) {
		if (b[0]=='"'){ 
			a=strchr(++b, '"');  
			if (a==NULL) { 
				aParse(conn, "Unterminated quotation, %s\n", b); 
				goto EXIT; 
			} 
		}
		if (b[0]=='\''){ 
			a=strchr(++b, '\'');  
			if (a==NULL) { 
				aParse(conn, "Unterminated quotation, %s\n", b); 
				goto EXIT; 
			} 
		}
		j=(a-b);
		if (strncasecmp(b, "no ", 3)==0 && i==0) { no_flag=1; 	while (a[1]==' ') a++; 	b=a+1; continue;  }
		param[i]=(char *)aMalloc(j+1); bzero(param[i], j+1); param[i+1]=empty;
		strncpy(param[i], b, j);
		while (a[1]==' ') a++;
		b=a+1;
		if (++i==29) break;
	}

	if (b[0]=='"'){ 
		a=strchr(++b, '"'); 
		a[0]=0; 
		if (a==NULL) { 
			aParse(conn, "Unterminated quotation, %s\n", b); 
			goto EXIT;
		} 
	}
	if (b[0]=='\''){ 
		a=strchr(++b, '\''); 
		a[0]=0; 
		if (a==NULL) { 
			aParse(conn, "Unterminated quotation, %s\n", b); 
			goto EXIT;
		} 
	}
	if (b[0]!='\0') { 
		param[i]=set_string(b);
		param[i+1]=empty; 
	}

//	for (int k=0; k<32; k++) if (param[k]!=empty) aDebug("parse", conn, "[%d]=%s\n", k, param[k]); 
	
	// ok here param[0] switch clause
	if (!strcasecmp(param[0], "exit")) { 
			if (conn->service) {
				if(!conn->service->Wakeup()) {
					aLog(D_INFO, "waking up %s:%u service\n", conn->service->getName(), conn->service->instance);
				}
				conn->service=NULL;
			} else return_state=PARSE_EXIT;
	} else if (conn->service) {
		conn->service->ProcessCfg(param, conn, no_flag);
	} else {
		if (!strcasecmp(param[0], "?")) cHelp(conn, no_flag, "?");
		else if	(!strcasecmp(param[0], "save")) cSave(conn);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "config")) {
			if (!strcasecmp(param[2], "?")) cHelp(conn, no_flag, "show config");
			else cShowConfig(NULL, conn);
			}
		else if (!strcasecmp(param[0], "show") && (!strcasecmp(param[1], "connections") || !strcasecmp(param[1], "conn")) ) cShowConnections(conn);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "users")) cShowUsers(conn);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "schedule")) cShowScheduleList(conn);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "units")) cShowUnits(conn, param);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "processor")) cShowProcessor(conn);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "alerter")) cShowAlerter(conn);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "quotactl")) cShowQuotactl(conn, param);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "quota")) cShowQuota(conn, param);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "version")) cShowVersion(conn);
		else if (!strcasecmp(param[0], "show") && (!strcasecmp(param[1], "timeout") || !strcasecmp(param[1], "timeouts"))) cShowTimeouts(conn);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "list"))  {
			if (!strcasecmp(param[2], "full" )) cShowUnitsList(conn, 1, param[3], param[4]); 
			else if (!strcasecmp(param[2], "?")) cHelp(conn, no_flag, "show list");
			else cShowUnitsList(conn, 0, param[2], param[3]); }
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "policy")) cShowPolicy(conn);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "stat")) cShowStat(conn, param);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "login")) cShowLogin(conn, param);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "perf")) cShowPerf(conn, param);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "?")) cHelp(conn, no_flag, "show");
		else if (!strcasecmp(param[0], "service")) cService(conn, param, no_flag);
		else if (!strcasecmp(param[0], "debug")) cDebug(conn, param, no_flag);
		else if (!strcasecmp(param[0], "user")) return_state=cUser(conn, param, no_flag);
		else if (!strcasecmp(param[0], "show") && !strcasecmp(param[1], "monitor")) cShowMonitor(conn);
		else if (!strcasecmp(param[0], "schedule")) return_state=cTask(conn, param, no_flag);
		else if (!strcasecmp(param[0], "data")) return_state=sProcessorData(conn, param);
		else if (!strcasecmp(param[0], "read")) return_state=sProcessorRead(conn, param);
		else if (!strcasecmp(param[0], "send")) cSend(conn, param);
		else if (!strcasecmp(param[0], "html")) cHtml(conn, param, no_flag);
		else if (!strcasecmp(param[0], "auth")) sWLProcessCfg(param, conn, no_flag); // dirty hack here
		else if (!strcasecmp(param[0], "oid")) if (!strcmp(param[1], "?")) cHelp(conn, no_flag, "oid"); else cNewOid(conn, param[1]);
  		else if (!strcasecmp(param[0], "kill")) if (!aCheckPerm(conn, UPERM_SYSACTION)) { aParse(conn, "%s will be killed without database save and NOT restarted\n", aaa_fw_software_name); return_state=PARSE_KILL; } else aParse(conn, "no permissions to do it!\n");
		else if (!strcasecmp(param[0], "reload")) if (!aCheckPerm(conn, UPERM_SYSACTION)) { aParse(conn, "%s will be re-loaded again with database save\n", aaa_fw_software_name); return_state=PARSE_RELOAD; } else aParse(conn, "no permissions to do it!\n");
		else if (!strcasecmp(param[0], "shutdown")) if (!aCheckPerm(conn, UPERM_SYSACTION)) { aParse(conn, "%s will be shutted down with database save and NOT restarted\n", aaa_fw_software_name); return_state=PARSE_SHUTDOWN; } else aParse(conn, "no permissions to do it!\n");

		else if (!strcasecmp(param[0], "mode")) { if (!strcasecmp(param[1], "human")) { conn->user->mode=USER_HUMAN; aParse(conn, "switching to human mode\n"); }
			else if (!strcasecmp(param[1], "data-source")) { conn->user->mode=USER_DATASOURCE; aDebugRm(conn->debug, "all"); aParse(conn, "switching to data-source mode\n"); }
			else if (!strcasecmp(param[1], "storage")) { conn->user->mode=USER_STORAGE; aDebugRm(conn->debug, "all"); aParse(conn, "switching to storage mode\n"); }
			else if (!strcasecmp(param[1], "?")) cHelp(conn, no_flag, "mode");
			else aParse(conn, "unknown user mode: %s\n", param[1]);
			}

		else if (!strcasecmp(param[0], "auth")) sWLProcessCfg(param, conn, no_flag);
		else if (!strcasecmp(param[0], "rotate")) cRotate(conn,param);
		else aParse(conn, "Unknown command: %s\n", param[0]);
 		}
EXIT:
	// free temp cmd copy and out
	aFree(cmd);
	for (i=0; i<32; i++) if (param[i]!=empty) aFree(param[i]);
	return return_state;
	}

/////////////////////////////////////////////////////////////////////////////////////////////
void cService(Connection *conn, char *param[32], int no_flag){
	Service *s;
	unsigned instance;
	
	if (!strcasecmp(param[1], "?")) { cHelp(conn, no_flag, "service"); return; }

	instance = atoi(param[2]);
	if(instance !=0 && !(strcasecmp(param[1],"processor")) ) {   
                 instance=0;   
                 aParse(conn,"Service %s might be only one. Using %s:%u instead\n",param[1],param[1],instance);   
         }   
  

	s=Services.getService(param[1], instance);
	if (s) { 
		if(no_flag) {
			Services.Delete(s);
                	s->Shutdown();
			delete s;
                	return;
		} else {
			conn->service=s;
			aParse(conn, "switching to service %s:%u for configuring\n", s->name, s->instance);
		}
	} else {
		if(no_flag) {
			aParse(conn, "service %s not exist\n", param[1]);
			return;
		}
		s=new Service(param[1], instance);
		s->Start(param);
		if(s->cfg) {
			aParse(conn,"creating service %s:%u\n",s->name,s->instance);
			aLog(D_INFO, "service %s:%u initialized\n", param[1], instance);
			Services.Insert(s);
			conn->service=s;
		} else  {
			aParse(conn, "service %s undefined\n", param[1]);
			delete s;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////
// here is general command processing
// valid list is: save, exit, reload, shutdown, kill, debug, show connections, show config *

void cSave(Connection *conn){
	if (aCheckPerm(conn, UPERM_SYSACTION)) return;
	FILE *c;
	c=fopen(config_file_name, "wt");
	if (c==NULL) aLog(D_INFO, "config write failed: %s\n", strerror(errno));
	cShowConfig(c, NULL);
	fclose(c);
	}

void cShowConfig(FILE *f, Connection *conn){
	FILE *out;
	if (f) out=f; else if (conn) out=conn->stream_w; else out=stderr;

	// first we will output service-independent lines
	time_t t=time(NULL);
	fprintf(out, "#%s version %d.%d(%d", aaa_fw_software_name, aaa_fw_major_version, aaa_fw_minor_version, aaa_fw_build_version);
	if (aaa_fw_build_version_local) fprintf(out, ".%d", aaa_fw_build_version_local);
	fprintf(out, ") compiled by %s\n", aaa_fw_build_person);
	fprintf(out, "#configuration built %s#begin\n", ctime(&t));
	fprintf(out, "#global variables configuration\n");

	fprintf(out, "debug ");
	if (aDebugIsSet(cInternal->debug, DEBUG_NONE)) fprintf(out, "none\n");
	else if (aDebugIsSet(cInternal->debug, DEBUG_ALL)) fprintf(out, "all\n");
	else { 
		for (int i=1; i<63; i++) if (aDebugIsSet(cInternal->debug, i)) fprintf(out, "%s ", debug_list[i]);
		fprintf(out, "\n");
		}

 	Users.listUsersCfg(out);
	Sched.listTasksCfg(out);
	// then check if various services are registered and call config lines output for each of them
	fprintf(out, "\n#services configuration\n");

	fprintf(out, "\n");
	Services.listCfg(out);

	// end of output
	fprintf(out, "\n#end\n");
	}

void cDebug(Connection *conn, char *param[32], int no_flag){
	int internal=0, i=1;
	
	if (!strcasecmp(param[1], "?")) { cHelp(conn, no_flag, "debug"); return; }
	
	while (strcmp(param[i], empty) && !internal) {
		if (!strcmp(param[i+1], "internal")) internal=1; else internal=0;
		if (!no_flag) {
			if (aDebugAdd(conn->debug, param[i])) {
				aDebugAdd(cInternal->debug, param[i]);
				aParse(conn, "debugging on %s is turned on\n", param[i]);
				}
			else aParse(conn, "cannot debug on %s\n", param[i]);
			}
		else {
			if (aDebugRm(conn->debug, param[i])) {
				aDebugRm(cInternal->debug, param[i]);
				aParse(conn, "debugging on %s is turned off\n", param[i]);
				}
			else aParse(conn, "cannot un-debug on %s\n", param[i]);
			}
		i++;
		}
   }	

void cRotate(Connection *conn, char *param[32]) {
	
	if (!strcasecmp(param[1], "?")) { cHelp(conn, 0, "rotate"); return; }
	if (!strcasecmp(param[1], "monitor")) {
		unsigned instance=atoi(param[2]);
		Service *s=Services.getService("monitor", instance);
		if(!s) {aParse(conn, "Service monitor:%u not exist.\n",instance); return;}
		Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;
		if(cfg->to!=MON_FILE) {aParse(conn,"Service monitor:%u not monitoring to file\n",instance); return;}
		
		aParse(conn, "Rotating monitor file %s for service %s:%u\n", cfg->name,s->name,s->instance);
		aLog(D_INFO, "Rotating monitor file %s for service %s:%u\n", cfg->name,s->name,s->instance);
		cfg->to=MON_NONE;
		fclose((FILE*)cfg->fd);
		char filename[64],mytime[32];
		time_t t;
		time(&t);
		strftime(mytime,32,"%Y-%m-%d_%H:%M",localtime(&t));
	 	sprintf(filename,"%s.%s",cfg->name,mytime);	
		rename(cfg->name,filename);
		cfg->fd=(void*)fopen(cfg->name, "at");
		cfg->to=MON_FILE;
		}
	else if (!strcasecmp(param[1], "log")) {
		if(!flag_log) {aParse(conn,"There is no log file"); return;}
		aParse(conn, "Rotating log file %s\n",path_to_log);
		aLog(D_INFO, "Rotating log file %s\n",path_to_log);

		flag_log=0;
		fclose(LOGFILE);
		char filename[64],mytime[32];
               	time_t t;
               	time(&t);
               	strftime(mytime,32,"%Y-%m-%d_%H:%M",localtime(&t));
               	sprintf(filename,"%s.%s",path_to_log,mytime);
               	rename(path_to_log,filename);
               	LOGFILE=fopen(path_to_log, "at");
		flag_log=1;
		}
	else 
		aParse(conn, "Can't rotate service %s\n",param[1]);
}
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

