/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: policy.h,v 1.12.2.1 2004/05/06 10:35:04 jura Exp $ */

enum policy_type { POLICY_ACCT=20, POLICY_FW };
typedef struct prefixes;

/////////////////////////////////////////////////////////////////////////////////////
#ifndef IP_FW_MAX_PORTS
#define IP_FW_MAX_PORTS	10
#endif

enum policy_target_type { PT_UNKNOWN=0, PT_IP_TRAFFIC=1, PT_NETFLOW_TRAFFIC, PT_LIBPCAP_TRAFFIC, PT_FM_TRAFFIC, PT_MAIL_STAT, PT_CACHE_EFF, PT_LOGIN_LOG };
enum policy_check_type { PC_UNKNOWN=0, PC_IP=1, PC_UNIT, PC_FILE };

typedef struct policy_target {
	policy_target_type	target_type;
	policy_check_type	check_type;
	
	// check_type == PC_IP
	u_short proto;	// as in /etc/protocols
    struct in_addr src, dst;			/* Source and destination IP addr */
    struct in_addr src_mask, dst_mask;	/* Mask for src and dest IP addr */
	u_short src_ports[IP_FW_MAX_PORTS];
	u_short dst_ports[IP_FW_MAX_PORTS];
	u_char ip_tos;
	u_short icmp_type;

	// check_type == PC_UNIT
	oid 	unit_id;	
	char 	*unit_name;

	// check_type == PC_FILE
	PrefixFile *file;

	} policy_target;
	 
/////////////////////////////////////////////////////////////////////////////////////
class Policy {
	public:
		oid id;
		char *name;
		char *target_string;
		policy_target target; // ip, mail, squid, login, etc...
		policy_type type; // acct, fw, (quota, bandwidth, ...)

		Policy *next;

		Policy(policy_type t);
		~Policy();
		void setName(char *n);
		unsigned setTarget(char **tgt, int *i);
		char *getTarget(char *buf);
		unsigned short Check(struct ip *ip,match mf);
		};

/////////////////////////////////////////////////////////////////////////////////////
class PolicyList {
	public:
		Policy *root;
		Policy *last;
		unsigned num_policies;
		pthread_rwlock_t *rwlock;

		PolicyList();
		~PolicyList();
		void Insert(Policy *p);
		void Delete(Policy *p);
		void Delete(oid id);
		void DeleteAll();
		Policy *getPolicy(char *name);
		Policy *getPolicyById(oid id);
		friend unsigned cShowPolicy(Connection *conn);
		};

/////////////////////////////////////////////////////////////////////////////////////
unsigned cPolicy(Connection *conn, char *param[], int no_flag);
unsigned cShowPolicy(Connection *conn);

/////////////////////////////////////////////////////////////////////////////////////
typedef struct pstat {
	unsigned long long in;
	unsigned long long out;
	time_t from;
	time_t to;
	} pstat;

typedef struct policy_data {
	Policy *policy;
	time_t timestamp;
	long long check;
	long long match;
	pstat flow;
	pstat h,d,w,m,t;
	policy_data *next;
	unsigned inv;
	unsigned brk; // serach break flag
	} policy_data;

/////////////////////////////////////////////////////////////////////////////////////
class PdList {
	public:
		policy_data *root;
		policy_data *last;
		pthread_mutex_t *lock;
		unsigned num_policies;

		PdList();
		~PdList();
		policy_data *Add(Policy *p, unsigned inv=0, unsigned brk=0, unsigned place=0);
		void Delete(Policy *p);
		void List(Connection *conn);
		void ListForCfg(FILE *f);
		void SetForUnit(policy_type pt, NetUnit *u);
		policy_data *Get(Policy *p);
		time_t LastUsed();
		void ClearLastUsed();
		};

/////////////////////////////////////////////////////////////////////////////////////
void PolicyDataUpdate(match m, policy_target_type type, policy_data *p, unsigned long len, struct timeval *tv);
void PolicyAdd(NetUnit *u, int *i, policy_type p, Connection *conn, char *param[32], int no_flag);

/////////////////////////////////////////////////////////////////////////////////////
enum SysPolicy {SP_NONE=0, SP_ALLOW, SP_DENY_NONE, SP_DENY_MONEY, SP_DENY_QUOTA, SP_DENY_MACVIOL,
	SP_DENY_AUTH, SP_ALLOW_AUTH, SP_LOC_NONE, SP_LOC_MONEY, SP_LOC_QUOTA, SP_LOC_MACVIOL,
	SP_LOC_AUTH, SP_LX_NONE, SP_LX_MONEY, SP_LX_QUOTA, SP_LX_MACVIOL, SP_LX_AUTH};

extern char *SysPolicy_name[32];
void aSysPolicyInit();
void SetSysPolicy(char *p, NetUnit *u, Connection *conn);
char *ShowSysPolicy(char *buf, SysPolicy p, oid perm, char *name);

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////




