/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: s_html.c,v 1.20.2.7 2004/06/01 22:09:22 anton Exp $ */

#include "netams.h"

Connection *sHOpenFile(Html_cfg *cfg, char *name);
int sHSafeMkdir(char *temp);
void sHPrintHeader(Connection *conn, char *title, char *back, char *logopath=NULL);
void sPrintFooter(Connection *conn, char *back);
const char mon_name[][12]={ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" }; 
int sHisindex(char *root, int yr, int mon, int day, int hour);
void sHPrintUnits(FILE *f); 
void sHPrintUnitsRoot(FILE *f, NetUnit *p);
void sHPrintUnitsTree(FILE *f, NetUnit *p);
void sHPrintUnitST(FILE *f, NetUnit *p);
void sHPrintTHeader(FILE *f);

//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlInit(Service *s){
	s->cfg = (Html_cfg*)aMalloc(sizeof(Html_cfg));
	Html_cfg *cfg=(Html_cfg*)s->cfg;

	cfg->path=NULL;
	cfg->lang=HTML_LANG_EN;
	cfg->run_period=NULL;
	cfg->is_distributed=0;
	cfg->cpages=CPAGES_ALL;
	cfg->url=NULL;
	cfg->is_htaccess=0;
		
	pthread_create(&(s->t_id), NULL, &sHtml, s);
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlProcessCfg(char *param[32], Connection *conn, unsigned no_flag){
	Html_cfg *cfg=(Html_cfg*)conn->service->cfg;

	if (!strcasecmp(param[0], "path")) {
		cfg->path=set_string(param[1]);
		aParse(conn, "html path is set to %s\n", cfg->path);
	}
	else if (!strcasecmp(param[0], "url")) {
		cfg->url=set_string(param[1]);
		aParse(conn, "URL path is set to %s\n", cfg->url);
	}
	else if (!strcasecmp(param[0], "run")) {
		cfg->run_period=set_string(param[1]);
		aParse(conn, "html run period is set to %s\n", cfg->run_period);
		if (!strcasecmp(param[1], "distributed")) {
			cfg->is_distributed=1;
			aParse(conn, "html service will run in distributed mode\n");
		}
	}
	else if (!strcasecmp(param[0], "language")) {
		if (!strcasecmp(param[1], "en")) {
			cfg->lang=HTML_LANG_EN;
			aParse(conn, "html output language is ENGLISH\n");
		}
		else if (!strcasecmp(param[1], "ru")) {
			cfg->lang=HTML_LANG_RU;
			aParse(conn, "html output language is RUSSIAN\n");
		}
		else aParse(conn, "html output language %s unsupported\n", param[1]);
	}		
	else if (!strcasecmp(param[0], "htaccess")) {
		if (!strcasecmp(param[1], "yes") || strtol(param[1], NULL, 10)==1) {
			aParse(conn, "html service will manage Apache .htaccess and .htpasswd files\n");
			cfg->is_htaccess=1;
		}
		else {
			aParse(conn, "html service will NOT manage Apache .htaccess and .htpasswd files\n");
			cfg->is_htaccess=0;
		}
	}
	else if (!strcasecmp(param[0], "client-pages")) {
		if (!strcasecmp(param[1], "all")) {
			cfg->cpages=CPAGES_ALL;
			aParse(conn, "html client pages creator: all pages\n");
		}
		else if (!strcasecmp(param[1], "groups")) {
			cfg->cpages=CPAGES_GROUPS;
			aParse(conn, "html client pages creator: only group units\n");
		}
		else if (!strcasecmp(param[1], "none")) {
			cfg->cpages=CPAGES_NONE;
			aParse(conn, "html client pages creator: none created\n");
		}
		else aParse(conn, "html client-pages command %s unsupported\n", param[1]);
	}		
	else aParse(conn, "unknown html service command: %s\n", param[0]);

}
//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlListCfg(Service *s, FILE *f){
	Html_cfg *cfg=(Html_cfg*)s->cfg;
	fprintf(f, "service html %d\n", s->instance);
	if (cfg->path) fprintf(f, "path %s\n", cfg->path);
	if (cfg->lang==HTML_LANG_EN) fprintf(f, "language en\n");
	else if (cfg->lang==HTML_LANG_RU) fprintf(f, "language ru\n");
	if (cfg->run_period) fprintf(f, "run %s\n", cfg->run_period);
	if (cfg->url) fprintf(f, "url %s\n", cfg->url);
	if (cfg->is_htaccess) fprintf(f, "htaccess yes\n");

	if (cfg->cpages==CPAGES_ALL) fprintf(f, "client-pages all\n");
	else if (cfg->cpages==CPAGES_GROUPS) fprintf(f, "client-pages groups\n");
	else if (cfg->cpages==CPAGES_NONE) fprintf(f, "client-pages none\n");

	fprintf(f, "\n");
	}

//////////////////////////////////////////////////////////////////////////////////////////
void *sHtml(void *ss){
	Service *s=(Service*)ss;

	aLog(D_INFO, "service html:%u thread started (%p)\n", s->instance, s->cfg);
	pthread_cleanup_push(sHtmlCancel, s);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
	s->t_id=pthread_self();

	Html_cfg *cfg=(Html_cfg*)s->cfg;
	s->Sleep();

	// here we should put scheduler task setup code
	if (!cfg->run_period) aLog(D_WARN, "cannot set up scheduler task because no run period defined\n");
	else if (cfg->is_distributed) { 
		aLog(D_DEBUG, "distributing html service...\n");
		while (1) { sleep(guess_load(1)); sHtmlAction(cfg); } 
		//never reach this
		goto FINISH; // suck but I cannot call pthread_cleanup_pop once more - it is just an ugly macro :((
		}
	else {
		char *buffer=(char*)aMalloc(256);
		snprintf(buffer, 256, "schedule oid 08FFFF action \"html\" time %s-", cfg->run_period);
		// snprintf(buffer, 256, "schedule action \"html\" time %s invisible", cfg->run_period);
		aCommand(cInternal, buffer);
		aFree(buffer);
		}
		
	// here we should put path checking and directories creation

	while(1) {
		s->Sleep(); // we will wait for external wakeup signal from scheduler initiated call
		// actual action
		aLog(D_INFO, "html pages creation...\n");
		sHtmlAction(cfg);
		}

FINISH:
	pthread_cleanup_pop(0);
	return NULL;
	}

//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlCancel(void *v){
	Service *s=(Service*)v;
	aLog(D_INFO, "cancelling service html:%u\n", s->instance);
	// free memory and close file descriptor(s)
}

//////////////////////////////////////////////////////////////////////////////////////////
void cHtml(Connection *conn, char *param[32], int no_flag){
	// regardless of command parameters, wake up the html service
	Service *s=NULL;
        while((s=Services.getServiceByName("html",s))) {
		if (s) aDebug(DEBUG_HTML, "waking up html service: %s\n", s->Wakeup()?"WAS_UP":"WAS_DOWN");
		else aDebug(DEBUG_HTML, "html command while no html service	running\n");
	}
}

//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlAction(Html_cfg *cfg){
	if (!cfg->path) { aLog(D_INFO, "cannot create pages because no html dir is set!\n"); return; }
	Connection *conn;
	NetUnit *u;
	int changed_pw=0;

	char *param[32]; for (int i=0; i<32; i++) param[i]=empty;
	struct stat sb;
	bzero(&sb, sizeof (struct stat));

	//=================================================================================	
	// first, calculate current year, month, day and hour
	char path[256]; bzero(path, 255);
	time_t current=time(NULL);
	struct tm tm;
	localtime_r(&current, &tm);

	//=================================================================================	
	// create index file
	snprintf(path, 255, "/%04d/%02d/%02d/%02d/index.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	conn=sHOpenFile(cfg, path); if (!conn) return;
	sHPrintHeader(conn, "Runtime information page", "../../../../index.html");
	
	fprintf(conn->stream_w, "<h3>Time period-derived statistics for %02d %s</h3>\n \
		<div style=\"margin-left : 5%%;\"> \n", tm.tm_mday, mon_name[tm.tm_mon]);

		// years table
		fprintf(conn->stream_w, "<table border=1 cellpadding=3 cellspacing=0> \n");
		for (int yr=2000; yr<=tm.tm_year+1900; yr++) {
			if (sHisindex(cfg->path, yr, 0, 0, 0)) { 
				fprintf(conn->stream_w, "<tr><td bgcolor=silver><b>%d</b></td>\n", yr);
				for (int mon=1; mon<=12; mon++) {
					if (sHisindex(cfg->path, yr, mon, 0, 0)) 
						fprintf(conn->stream_w, "<td><a href=\"../../../../%04d/%02d/index.html\">%s</a></td>", yr, mon, mon_name[mon-1]);
					else 
						fprintf(conn->stream_w, "<td>%s</td>", mon_name[mon-1]);
					}
				fprintf(conn->stream_w, "</tr>\n");
				}
			}
		fprintf(conn->stream_w, "</table>\n");
				
		// days table
		fprintf(conn->stream_w, "<b>This month:</b><br>\n");
		for (int day=1; day<=31; day++){
			if (sHisindex(cfg->path, tm.tm_year+1900, tm.tm_mon+1, day, 0)) 
				fprintf(conn->stream_w, "<a href=\"../../%02d/index.html\">%d</a> ", day, day);
			else 
				fprintf(conn->stream_w, "%d ", day);
			}
		fprintf(conn->stream_w, "<br>\n");

		// hours table

		fprintf(conn->stream_w, "<b>This day:</b><br>\n");
		for (int hour=0; hour<=11; hour++){
			if (sHisindex(cfg->path, tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, hour+1)) 
				fprintf(conn->stream_w, "<a href=\"../%02d/time.html\">%02d-%02d</a> ", hour, hour, hour+1);
			else 
				fprintf(conn->stream_w, "%02d-%02d ", hour, hour+1);
			}
		fprintf(conn->stream_w, "<br>\n");

		for (int hour=12; hour<=23; hour++){
			if (sHisindex(cfg->path, tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, hour+1)) 
				fprintf(conn->stream_w, "<a href=\"../%02d/time.html\">%02d-%02d</a> ", hour, hour, hour+1);
			else 
				fprintf(conn->stream_w, "%02d-%02d ", hour, hour+1);
			}
		fprintf(conn->stream_w, "<br></div>\n");

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	fprintf(conn->stream_w, "<h3>Objects statistics</h3>\n \
		<div style=\"margin-left : 5%%;\"> \n");

	if (cfg->cpages==CPAGES_ALL || cfg->cpages==CPAGES_GROUPS) {
		fprintf(conn->stream_w, "<b>Groups:</b><br>\n");
		for (u=Units.root; u!=NULL; u=u->next) if (u->type==NETUNIT_GROUP && u->name) {
			fprintf(conn->stream_w, "<a href=\"../../../../clients/%s/index.html\">%s</a>\n", u->name, u->name);
			}
		}
	
	if (cfg->cpages==CPAGES_ALL) {
		fprintf(conn->stream_w, "<br><b>Units:</b><br>\n");
		for (u=Units.root; u!=NULL; u=u->next) if (u->type!=NETUNIT_GROUP && u->name) {
			fprintf(conn->stream_w, "<a href=\"../../../../clients/%s/index.html\">%s</a>\n", u->name, u->name);
			}
		}
		
	fprintf(conn->stream_w, "<br><br></div>\n");


	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	fprintf(conn->stream_w, "<h3>Software statistics</h3>\n \
		<div style=\"margin-left : 5%%;\"> \n\
		Output of <a href=\"software-version.html\">show version</a><br> \n\
		Current <a href=\"software-quota.html\">quota state</a><br> \n\
		Current <a href=\"software-login.html\">logins state</a><br> \n\
		Current <a href=\"software-config.html\">configuration</a><br> </div>\n");
	sPrintFooter(conn, NULL);
	delete conn;

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create SW version
	snprintf(path, 255, "/%04d/%02d/%02d/%02d/software-version.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	conn=sHOpenFile(cfg, path); if (!conn) return;
	sHPrintHeader(conn, "Software version", "index.html");
	fprintf(conn->stream_w, "<pre>\n");
	cShowVersion(conn); 
	fprintf(conn->stream_w, "</pre>\n");
	sPrintFooter(conn, "index.html");
	delete conn;

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create Quota state
	snprintf(path, 255, "/%04d/%02d/%02d/%02d/software-quota.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	conn=sHOpenFile(cfg, path); if (!conn) return;
	sHPrintHeader(conn, "Quota control state", "index.html");
	fprintf(conn->stream_w, "<pre>\n");
	cShowQuota(conn, param); 
	fprintf(conn->stream_w, "</pre>\n");
	sPrintFooter(conn, "index.html");
	delete conn;

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create Quota state
	snprintf(path, 255, "/%04d/%02d/%02d/%02d/software-login.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	conn=sHOpenFile(cfg, path); if (!conn) return;
	sHPrintHeader(conn, "Login control state", "index.html");
	fprintf(conn->stream_w, "<pre>\n");
	cShowLogin(conn, param); 
	fprintf(conn->stream_w, "</pre>\n");
	sPrintFooter(conn, "index.html");
	delete conn;

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create SW log
	snprintf(path, 255, "/%04d/%02d/%02d/%02d/software-config.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	conn=sHOpenFile(cfg, path); if (!conn) return;
	sHPrintHeader(conn, "Running configuration", "index.html");
	fprintf(conn->stream_w, "<pre>\n");
	cShowConfig(NULL, conn); 
	fprintf(conn->stream_w, "</pre>\n");
	sPrintFooter(conn, "index.html");
	delete conn;

	//=================================================================================	
	// if this is the end of hour, generate hourly report
	snprintf(path, 255, "/%04d/%02d/%02d/%02d/time.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	conn=sHOpenFile(cfg, path); if (!conn) return;
	snprintf(path, 255, "Traffic information from %02d.%02d.%04d %02d:00 to %02d.%02d.%04d %02d:00", tm.tm_mday, tm.tm_mon+1, tm.tm_year+1900, tm.tm_hour, tm.tm_mday, tm.tm_mon+1, tm.tm_year+1900, tm.tm_hour+1);
	sHPrintHeader(conn, path, "index.html");
	fprintf(conn->stream_w, "<div style=\"margin-left : 5%%; align: right;\">\n");
	sHPrintUnits(conn->stream_w); 
	fprintf(conn->stream_w, "</div> \n");
	sPrintFooter(conn, "index.html");
	delete conn;

	// if this is the end of day, generate daily report
	// ...omitted...

	// if this is the end of month, generate monthly report
	// ...omitted...
	
	//=================================================================================	
	// create a master index file at path root, pointing to the current file
	snprintf(path, 255, "/index.html");
	conn=sHOpenFile(cfg, path); if (!conn) return;
	fprintf(conn->stream_w, "<html><HEAD><META http-equiv=\"Pragma\" content=\"no-cache\"><META http-equiv=\"Expires\" content=\"-1\"><META http-equiv=\"Cache-Control\" content=\"no-cache\"></HEAD><body><h1>Redirecting to current index...</h1><script> \
		document.location.href=\"%04d/%02d/%02d/%02d/index.html\" \
		</script></body></html>\n", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	delete conn;

	//=================================================================================	
	// generate day index redirect page
	snprintf(path, 255, "/%04d/%02d/%02d/index.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday);
	conn=sHOpenFile(cfg, path); if (!conn) return;
	fprintf(conn->stream_w, "<html><HEAD><META http-equiv=\"Pragma\" content=\"no-cache\"><META http-equiv=\"Expires\" content=\"-1\"><META http-equiv=\"Cache-Control\" content=\"no-cache\"></HEAD><body><h1>Redirecting to this day index...</h1><script> \
		document.location.href=\"%02d/index.html\" \
		</script></body></html>\n", tm.tm_hour);
	delete conn;

	//=================================================================================	
	// generate month index page
	snprintf(path, 255, "/%04d/%02d/index.html", tm.tm_year+1900, tm.tm_mon+1);
	conn=sHOpenFile(cfg, path); if (!conn) return;
	sHPrintHeader(conn, "Runtime information page", "../../index.html", "../..");
	
	fprintf(conn->stream_w, "<h3>Index pages for month: %s</h3>\n <div style=\"margin-left : 5%%;\"> \n", mon_name[tm.tm_mon]);

		// years table
		fprintf(conn->stream_w, "<table border=1 cellpadding=3 cellspacing=0> \n");
		for (int yr=2000; yr<=tm.tm_year+1900; yr++) {
			if (sHisindex(cfg->path, yr, 0, 0, 0)) { 
				fprintf(conn->stream_w, "<tr><td bgcolor=silver><b>%d</b></td>\n", yr);
				for (int mon=1; mon<=12; mon++) {
					if (sHisindex(cfg->path, yr, mon, 0, 0)) 
						fprintf(conn->stream_w, "<td><a href=\"../../%04d/%02d/index.html\">%s</a></td>", yr, mon, mon_name[mon-1]);
					else 
						fprintf(conn->stream_w, "<td>%s</td>", mon_name[mon-1]);
					}
				fprintf(conn->stream_w, "</tr>\n");
				}
			}
		fprintf(conn->stream_w, "</table>\n");
				
		// days table
		fprintf(conn->stream_w, "<b>By day:</b><br>\n");
		for (int day=1; day<=31; day++){
			if (sHisindex(cfg->path, tm.tm_year+1900, tm.tm_mon+1, day, 0)) 
				fprintf(conn->stream_w, "<a href=\"%02d/index.html\">%d</a> ", day, day);
			else 
				fprintf(conn->stream_w, "%d ", day);
			}
	fprintf(conn->stream_w, "<br></div><br>\n");
	sPrintFooter(conn, "../../index.html");
	delete conn;

	guess_load(2);

#ifdef GENERATE_CHILD_HTML
	//=================================================================================	
	// generate per-client pages
	if (cfg->cpages!=CPAGES_NONE) for (u=Units.root; u!=NULL; u=u->next) if (u->name) {

		if (cfg->cpages==CPAGES_ALL || (cfg->cpages==CPAGES_GROUPS && u->type==NETUNIT_GROUP)) {	 // CPAGES_CHECK

		snprintf(path, 255, "/clients/%s/%04d/%02d/index-day-%02d.html", u->name, tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday);
		conn=sHOpenFile(cfg, path); if (!conn) return;
		sHPrintHeader(conn, "Traffic information for selected unit", "../../index.html");
		
		switch (u->type) {
			case NETUNIT_HOST: {
				NetUnit_host *h;
				h = (NetUnit_host*)u;
				fprintf(conn->stream_w, "HOST: <b>%s</b><br>OID: <b>%06X</b><br> IP: <b>%-12s</b><br>\n", h->name, h->id, inet_ntoa(h->ip));
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			case NETUNIT_USER: {
				NetUnit_user *h;
				h = (NetUnit_user*)u;
				fprintf(conn->stream_w, "USER: <b>%s</b><br>OID: <b>%06X</b><br> IP: <b>%-12s</b><br>\n", h->name, h->id, inet_ntoa(h->ip));
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			case NETUNIT_CLUSTER: { 
				NetUnit_cluster *h;
				NetUnit_host *t;
				h = (NetUnit_cluster*)u;
				fprintf(conn->stream_w, "CLUSTER: <b>%s</b><br>OID: <b>%06X</b><br>IPs:<b>\n", h->name, h->id);
				for (t=h->root; t!=NULL; t=t->next)	fprintf(conn->stream_w, "%s ", inet_ntoa(t->ip));
				fprintf(conn->stream_w, "</b><br>\n");
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			case NETUNIT_GROUP: {
				NetUnit_group *h;
				NetUnit *t; 
				h = (NetUnit_group*)u;
				fprintf(conn->stream_w, "GROUP: <b>%s</b><br>OID: <b>%06X</b><br>Subs: <b>", h->name, h->id);
				for (t=Units.root; t!=NULL; t=t->next)	if (t->parent==u && t->name) { 
					if (cfg->cpages==CPAGES_ALL) fprintf(conn->stream_w, "<a href=\"../../../%s/index.html\">%s</a> ", t->name, t->name);
					else fprintf(conn->stream_w, "%s ", t->name);
					}
				fprintf(conn->stream_w, "</b><br>\n");
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			case NETUNIT_NET: {
				NetUnit_net *h;
				h = (NetUnit_net*)u;
				fprintf(conn->stream_w, "NET: <b>%s</b><br>OID: <b>%06X</b><br>NETWORK: <b>%s</b>\n", h->name, h->id, inet_ntoa(h->ip));
				fprintf(conn->stream_w, " NET_MASK: <b>%s</b><br>\n", inet_ntoa(h->mask));
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			default: 
				fprintf(conn->stream_w, "<UNKNOWN><br> OID: <b>%06X</b>\n", u->id);
				break;
			}

		snprintf(path, 255, "%s/clients/%s", cfg->path, u->name);
		//++++++++++++++++++++++++++++++++++++++++++
		// year/month table (client)
		fprintf(conn->stream_w, "<br><b>Calendar:</b><br><table border=1 cellpadding=3 cellspacing=0> \n");
		for (int yr=2000; yr<=tm.tm_year+1900; yr++) {
			if (sHisindex(path, yr, 0, 0, 0)) { 
				fprintf(conn->stream_w, "<tr><td bgcolor=silver><b>%d</b></td>\n", yr);
				for (int mon=1; mon<=12; mon++) {
					if (sHisindex(path, yr, mon, 0, 0)) 
						fprintf(conn->stream_w, "<td><a href=\"../../%04d/%02d/index.html\">%s</a></td>", yr, mon, mon_name[mon-1]);
					else 
						fprintf(conn->stream_w, "<td>%s</td>", mon_name[mon-1]);
					}
				fprintf(conn->stream_w, "</tr>\n");
				}
			}
		fprintf(conn->stream_w, "</table>\n");
				
		// days table (client)
		fprintf(conn->stream_w, "<b>This month:</b><br>\n");
		for (int day=1; day<=31; day++){
			if (sHisindex(cfg->path, tm.tm_year+1900, tm.tm_mon+1, day, 0)) 
				fprintf(conn->stream_w, "<a href=\"index-day-%02d.html\">%d</a> ", day, day);
			else 
				fprintf(conn->stream_w, "%d ", day);
			}
		fprintf(conn->stream_w, "<br>\n");
		//+++++++++++++++++++++++++++++++++++++++++
		
		fprintf(conn->stream_w, "<h3>Generalized statistics for %s, actual for creation time ONLY!</h3>\n <div style=\"margin-left : 5%%;\"> \n", u->name);

        if (u->type!=NETUNIT_GROUP) sHPrintTHeader(conn->stream_w);
		sHPrintUnitsTree(conn->stream_w, u);
        if (u->type!=NETUNIT_GROUP) fprintf(conn->stream_w, "</table><br>\n");   

		fprintf(conn->stream_w, "</div><br>");

		sPrintFooter(conn, "../../index.html");
		delete conn;

		// create a master index file at client root, pointing to the current file
		snprintf(path, 255, "/clients/%s/index.html", u->name);
		conn=sHOpenFile(cfg, path); if (!conn) return;
		fprintf(conn->stream_w, "<html><HEAD><META http-equiv=\"Pragma\" content=\"no-cache\"><META http-equiv=\"Expires\" content=\"-1\"><META http-equiv=\"Cache-Control\" content=\"no-cache\"></HEAD><body><h1>Redirecting to current index...</h1><script> \
			document.location.href=\"%04d/%02d/index-day-%02d.html\" \
			</script></body></html>\n", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday);
		delete conn;

		// generate month index page
		snprintf(path, 255, "/clients/%s/%04d/%02d/index.html", u->name, tm.tm_year+1900, tm.tm_mon+1);
		conn=sHOpenFile(cfg, path); if (!conn) return;
		sHPrintHeader(conn, "Runtime information page", "../../index.html");
		
		fprintf(conn->stream_w, "<h3>Index pages for month: %s</h3>\n <div style=\"margin-left : 5%%;\"> \n", mon_name[tm.tm_mon]);

			// days table
			fprintf(conn->stream_w, "<b>By day:</b><br>\n");
			for (int day=1; day<=31; day++){
				snprintf(path, 255, "%s/clients/%s/%04d/%02d/index-day-%02d.html", cfg->path, u->name, tm.tm_year+1900, tm.tm_mon+1, day);
				if (!stat(path, &sb))
					fprintf(conn->stream_w, "<a href=\"index-day-%02d.html\">%d</a> ", day, day);
				else 
					fprintf(conn->stream_w, "%d ", day);
				}

		fprintf(conn->stream_w, "<br></div><br>\n");
		sPrintFooter(conn, "../../index.html");
		delete conn;

		} // CPAGES_CHECK
		guess_load(2);

		if (cfg->is_htaccess && u->changed) {
			NetUnit_user *us;
			if (u->type==NETUNIT_USER) {
				us = (NetUnit_user*)u;
				if (us->password) {
					snprintf(path, 255, "/clients/%s/.htaccess", u->name);
					conn=sHOpenFile(cfg, path); if (!conn) return;
					fprintf(conn->stream_w, "AuthName \"NeTAMS User Login\"\n Require user");
					Users.listUsersHtml(conn);
					fprintf(conn->stream_w, " %s\n<Files *.gif>\nRequire valid-user\nSatisfy Any\n</Files>\nAuthType Basic\nAuthUserFile %s/.htpasswd\n\n", u->name, cfg->path);
					delete conn;			
					u->changed=0;
					}
				}
			}

		} // 'for' loop, all clients

#endif

	//=================================================================================	
	// if htaccess==1 AND UserList changed flag is set, generate new .htaccess and .htpasswd
	if (cfg->is_htaccess) {
		if (Users.changed_user) {
			conn=sHOpenFile(cfg, "/.htaccess"); if (!conn) return;
			fprintf(conn->stream_w, "AuthName \"NeTAMS Administrators Only\"\n Require user");
			Users.listUsersHtml(conn);
			fprintf(conn->stream_w, "\n<Files *.gif>\nRequire valid-user\nSatisfy Any\n</Files>\nAuthType Basic\nAuthUserFile %s/.htpasswd\n\n", cfg->path);
			delete conn;			
			Users.changed_user=0;
			}
		}
		
		if (Users.changed_pw || changed_pw) {
			conn=sHOpenFile(cfg, "/.htpasswd"); if (!conn) return;
			Users.listPasswordsHtml(conn);
			Units.listPasswordsHtml(conn);
			delete conn;			
		}
	//=================================================================================	

}
//////////////////////////////////////////////////////////////////////////////////////////
Connection *sHOpenFile(Html_cfg *cfg, char *name){
	char *fullpath=NULL;
	char *c, *temp;
	int f;
	Connection *conn;

	print_to_string(&fullpath, "%s%s", cfg->path, name);
	
	c=fullpath;	temp=(char*)aMalloc(strlen(c));
	while (c!=NULL) {
		strncpy(temp, fullpath, (c-fullpath)+1);
		if (sHSafeMkdir(temp)) return NULL;
		c=strchr(c+1, '/');
	}

	f=open(fullpath, O_RDWR|O_CREAT|O_TRUNC, 0644);
	aDebug(DEBUG_HTML, "%s : %s\n", fullpath, (f+1)?"ok":"fail");
	aFree(fullpath); aFree(temp);
	conn = new Connection("htmlSave", f);
	return conn;
}

//////////////////////////////////////////////////////////////////////////////////////////
int sHSafeMkdir(char *temp){
	struct stat sb;
	bzero(&sb, sizeof (struct stat));
	
	// printf("html_safe_mkdir: %s\n", temp);
	int i=stat(temp, &sb);
	if (!(sb.st_mode & S_IFDIR) || i) { 
		aDebug(DEBUG_HTML, "make directory %s\n", temp); 
		i=mkdir(temp, 0711);
		if (i) { aLog(D_INFO, "failed to create %s, please check permissions and config!\n", temp); return -1; }
		}
	return 0;
	}

//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintHeader(Connection *conn, char *title, char *back, char *logopath){

	fprintf(conn->stream_w, "<html><head><title>NeTAMS</title><HEAD><META http-equiv=\"Pragma\" content=\"no-cache\"><META http-equiv=\"Expires\" content=\"-1\"><META http-equiv=\"Cache-Control\" content=\"no-cache\"></HEAD> \n\
		<body bgcolor=white marginheight=0 leftmargin=0 topmargin=0 marginwidth=0> \n\
		<table width=100%% align=left border=0 cellpadding=5 cellspacing=0> \n\
		<tr bgcolor='white' align=left><td width=359> \n\
		<A href=\"http://www.netams.com/index.html\"> \n\
		<img src=\"%s/images/logo-small.gif\" width=359 height=49 border=0></a></td> \n\
		<td valign=middle align=left width=80%%> This is automatically built \n\
		<a href=\"http://www.netams.com/index.html\"><b>NeTAMS</b></a> \n\
		report<br> <b>Software version:</b>", logopath?logopath:"../../../..");
	fprintf(conn->stream_w, "%d.%d(%d", aaa_fw_major_version, aaa_fw_minor_version, aaa_fw_build_version);
	if (aaa_fw_build_version_local) fprintf(conn->stream_w, ".%d", aaa_fw_build_version_local);
	fprintf(conn->stream_w, ")<br>\n");
		
	char buff[32];
	fprintf(conn->stream_w, "<b>Creation time:</b> %s<br> </td></tr> <tr bgcolor='#ccccff'><td colspan=2> \n\
		<h3>%s", timeU2T(time(NULL), buff), title);
	if (back) fprintf(conn->stream_w, "<font face=monospace size=-1><b> [<a href=\"%s\"> <- back</a> ]</b></font>", back);
	fprintf(conn->stream_w, "</h3></td></tr><tr><td colspan=2>\n");
	}
//////////////////////////////////////////////////////////////////////////////////////////
void sPrintFooter(Connection *conn, char *back){
	fprintf(conn->stream_w, "</td></tr>\n");
	if (back) fprintf(conn->stream_w, "<tr bgcolor='#ccccff'><td colspan=2><font face=monospace size=-1><b>[<a href=\"%s\"> <- back</a> ]</b></font></td></tr>", back);
	fprintf(conn->stream_w, "</table>\n</body></html> \n");
	}

//////////////////////////////////////////////////////////////////////////////////////////
int sHisindex(char *root, int yr, int mon, int day, int hour){
	struct stat sb;
	bzero(&sb, sizeof (struct stat));
	char tmp[256]; bzero(tmp, 255);
	
	if (mon && day && hour) snprintf(tmp, 255, "%s/%04d/%02d/%02d/%02d/index.html", root, yr, mon, day, hour-1);
	else if (mon && day) snprintf(tmp, 255, "%s/%04d/%02d/%02d", root, yr, mon, day);	
	else if (mon) snprintf(tmp, 255, "%s/%04d/%02d", root, yr, mon);	
	else snprintf(tmp, 255, "%s/%04d", root, yr);	

	int i=stat(tmp, &sb);
	//printf("check %s: %d\n", tmp, i);
	if (!i) return 1; else return 0;
	}
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintUnits(FILE *f){

	Units.tries_lock++;
	int err=pthread_rwlock_tryrdlock(Units.rwlock); 
	if (err==EBUSY) { Units.tries_lock_failed++; pthread_rwlock_rdlock(Units.rwlock); }

	sHPrintUnitsRoot(f, NULL);

	if (err!=EDEADLK) pthread_rwlock_unlock(Units.rwlock);

	} 
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintUnitsRoot(FILE *f, NetUnit *p){
	NetUnit *u;

	for (u=Units.root; u!=NULL; u=u->next)	
	    if (u->parent==p)
			if (u->type==NETUNIT_GROUP) {
				sHPrintUnitsTree(f, u);
                }

    sHPrintTHeader(f);
	for (u=Units.root; u!=NULL; u=u->next)
	    if (u->parent==p)
			if (u->type!=NETUNIT_GROUP) {
				sHPrintUnitsTree(f, u);
				}
    fprintf(f, "</table><br>\n");   

    }
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintUnitsTree(FILE *f, NetUnit *u){
	
	if (u->type==NETUNIT_GROUP) {
        sHPrintTHeader(f);
        fprintf(f, "<tr bgcolor='#000000'><td colspan=11 height=2> </td></tr><tr bgcolor='#ffffcc'><td colspan=11>GROUP: <b>%s</b> <font size=-1>oid %06X</font>", u->name?u->name:"", u->id);
        fprintf(f, "</td></tr>\n");
        sHPrintUnitST(f, u);
        fprintf(f, "<tr bgcolor='#ccffcc'><td colspan=11 align=right>\n");

        sHPrintUnitsRoot(f, u);
        
        fprintf(f, "</td></tr>\n");
        fprintf(f, "</table><br>\n");
        } 
    else { 
    	fprintf(f, "<tr bgcolor='#ffffcc'><td colspan=11><A href=\"../../../../admintool.cgi?oid=%06X\"><img src=\"../../../../images/admintool-logo.gif\" width=20 height=20 border=1 align=absmiddle></a> ", u->id);

		if (u->type==NETUNIT_HOST) fprintf(f, "HOST");
		else if (u->type==NETUNIT_USER) fprintf(f, "USER");
		else if (u->type==NETUNIT_NET) fprintf(f, "NET");
		else fprintf(f, "CLUSTER");
		fprintf(f, " <b>%s</b> <font size=-1>oid %06X</font>", u->name?u->name:"", u->id);

		if (u->type==NETUNIT_HOST) fprintf(f, " IP: <i>%-12s</i>", inet_ntoa(((NetUnit_host*)u)->ip));
		else if (u->type==NETUNIT_USER) fprintf(f, " IP: <i>%-12s</i>", inet_ntoa(((NetUnit_user*)u)->ip));
		else if (u->type==NETUNIT_NET) { 
			fprintf(f, " IP: <i>%-12s</i>", inet_ntoa(((NetUnit_net*)u)->ip));
			fprintf(f, " MASK: <i>%-12s</i>", inet_ntoa(((NetUnit_net*)u)->mask));
			}
		fprintf(f, "</td></tr>\n\n");
        sHPrintUnitST(f, u);
		}

/*	for (u=Units.root; u!=NULL; u=u->next)
		if (u==p)
			if (u->type==NETUNIT_GROUP) {
                sHPrintTHeader(f);
    			fprintf(f, "<tr bgcolor='#000000'><td colspan=11 height=2> </td></tr><tr bgcolor='#ffffcc'><td colspan=11>GROUP: <b>%s</b> <font size=-1>oid %06X</font>", u->name?u->name:"", u->id);
				if (p) fprintf(f, " parent %s", p->name?p->name:"");
				fprintf(f, "</td></tr>\n");
                sHPrintUnitST(f, u);
				fprintf(f, "<tr bgcolor='#ccffcc'><td colspan=11>\n");
				if (u->parent==p) sHPrintUnitsTree(f, u);
				fprintf(f, "</td></tr>\n");
               	fprintf(f, "</table><br>\n");
				}

    sHPrintTHeader(f);
	for (u=Units.root; u!=NULL; u=u->next)
		if (p==u)
			if (u->type!=NETUNIT_GROUP) {
				if (u->type==NETUNIT_HOST) fprintf(f, "<tr bgcolor='#ffffcc'><td colspan=11>HOST");
				else if (u->type==NETUNIT_NET) fprintf(f, "<tr bgcolor='#ffffcc'><td colspan=11>NET");
				else fprintf(f, "<tr><td colspan=11 bgcolor='#ffffcc'>CLUSTER");
				fprintf(f, " <b>%s</b> <font size=-1>oid %06X</font>", u->name?u->name:"", u->id);
				if (p) fprintf(f, " parent %s", p->name?p->name:"");
				fprintf(f, "</td></tr>\n\n");
                sHPrintUnitST(f, u);
				}
    fprintf(f, "</table><br>\n");           */

	}

//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintUnitST(FILE *f, NetUnit *u){
	policy_data *cpd;
	static char b2qt[10][32];
	for	(cpd=u->ap.root; cpd!=NULL; cpd=cpd->next) {
		fprintf(f, "<tr align=right><td valign=middle bgcolor='#ffffaa'>%s</td>\n", cpd->policy->name?cpd->policy->name:"<\?\?>");
		fprintf(f, "<td>%10s</td><td>%10s</td>", bytesQ2T(cpd->h.in, b2qt[0]), bytesQ2T(cpd->h.out, b2qt[1]));
		fprintf(f, "<td>%10s</td><td>%10s</td>", bytesQ2T(cpd->d.in, b2qt[2]), bytesQ2T(cpd->d.out, b2qt[3]));
		fprintf(f, "<td>%10s</td><td>%10s</td>", bytesQ2T(cpd->w.in, b2qt[4]), bytesQ2T(cpd->w.out, b2qt[5]));
		fprintf(f, "<td>%10s</td><td>%10s</td>", bytesQ2T(cpd->m.in, b2qt[6]), bytesQ2T(cpd->m.out, b2qt[7]));
		fprintf(f, "<td>%10s</td><td>%10s</td></tr>\n", bytesQ2T(cpd->t.in, b2qt[8]), bytesQ2T(cpd->t.out, b2qt[9]));
		} 

    }
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintTHeader(FILE *f){

	fprintf(f, "<table cellpadding=3 cellspacing=0 border=1 width=95%% bgcolor=white>\n");
	fprintf(f, "<tr bgcolor=navy align=center><td rowspan=2 valign=middle><font face=monospace size=-1 color=yellow>acct-policy</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>HOUR</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>DAY</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>WEEK</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>MONTH</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>TOTAL</font></td> \
		</tr><tr bgcolor=black align=center> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		</tr>\n");
    }
//////////////////////////////////////////////////////////////////////////////////////////
int guess_load(int x) { // 1 between generations, 2 between each unit, 
if (x==1) return 1000*60*5;
else return 1000*5;
}   

