/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: s_quotactl.c,v 1.20.2.6 2004/06/21 09:52:36 jura Exp $ */

#include "netams.h"

Quotactl_cfg QuotactlCfg;

//////////////////////////////////////////////////////////////////////////
void sQuotactlInit(Service *s){
	s->cfg = (Quotactl_cfg*)aMalloc(sizeof(Quotactl_cfg));
	
	Quotactl_cfg *cfg=(Quotactl_cfg*)s->cfg;
	cfg->root=NULL;
	cfg->delay=QUOTACTL_DELAY; 

	cfg->soft_reach=cfg->hard_reach=cfg->reset_back=NULL;
	cfg->user_soft_reach=cfg->user_hard_reach=cfg->user_reset_back=0;

	cfg->rwlock=(pthread_rwlock_t*)aMalloc(sizeof (pthread_rwlock_t));
	pthread_rwlock_init(cfg->rwlock, NULL);

	pthread_create(&(s->t_id), NULL, &sQuotactl, s);

	return;
	}

//////////////////////////////////////////////////////////////////////////
void sQuotactlProcessCfg(char *param[32], Connection *conn, unsigned no_flag){
	Quotactl_cfg *cfg=(Quotactl_cfg*)conn->service->cfg;
	Qdef *q=NULL;
	Qdef *qq=NULL;

	pthread_rwlock_wrlock(cfg->rwlock);
	
	if (!strcasecmp(param[0], "quota") && param[1]!=empty) {
		for (Qdef *quotas=cfg->root; quotas!=NULL; quotas=quotas->next) {
			qq=quotas;
			if (quotas->name && strcasecmp(param[1], quotas->name)==0) q=quotas;
		}

		if (q && no_flag) { 
			if(q==cfg->root) cfg->root=q->next;
			else q->prev->next=q->next;
			if(q->next) q->next->prev=q->prev;
			for(qUlist *ql=q->root;ql!=NULL;ql=ql->next) {
				NetUnit *u=ql->u;
		        	if (u && u->sys_policy==q->sys_policy) {
                                	u->sys_policy=SP_NONE;
                                        u->sys_policy_name=SysPolicy_name[SP_NONE];
                                        u->sys_policy_perm=0;
					aParse(conn, "unit %06X (%s) unbinded from quota %s\n", u->id, u->name?u->name:"<>", q->name);
                                }
				aFree(ql);
			}
			aParse(conn, "quota %s deleted\n", q->name);
			aFree(q->name);
			aFree(q); 
			pthread_rwlock_unlock(cfg->rwlock);
			return;
		}	

		if (!q) {

			if (no_flag) { 
				aParse(conn, "quota %s not defined\n", param[1]);
				pthread_rwlock_unlock(cfg->rwlock);
				return;
			}	

			q=(Qdef*) aMalloc(sizeof(Qdef));
			bzero(q,sizeof(Qdef)); //clear stats    
			q->name=set_string(param[1]);
			if (!cfg->root) cfg->root=q; else qq->next=q;
			q->prev=qq;
			q->next=NULL;
			q->root=NULL;
			aParse(conn, "quota %s created\n", q->name);
		}

		int i=2;
		while (param[i]!=empty) {

	 		if (strcasecmp(param[i], "policy")==0) {
	 			Policy *pol=PolicyL.getPolicy(param[i+1]);
				if (pol) {
					q->policy=pol;
					aParse(conn, "quota %s policy %s (%06X) is set\n", q->name, pol->name?pol->name:"<>", pol->id);
				}
				else aParse(conn, "quota %s policy %s is undefined\n", q->name, param[i+1]);
 			}
			else if (strcasecmp(param[i], "set")==0) {
				NetUnit *u = new NetUnit(NETUNIT_UNKNOWN);
				u->id=0xFFFFFF;
				SetSysPolicy(param[i+1], u, conn);
				q->sys_policy=u->sys_policy;
				q->sys_policy_name=u->sys_policy_name;
				q->sys_policy_perm=u->sys_policy_perm;
				
				if (q->sys_policy_perm) aParse(conn, "quota %s set: sys-LOCAL%s%s, allowed OID %06X\n", q->name, q->sys_policy_name[0]?"-":"", q->sys_policy_name, q->sys_policy_perm);
				else aParse(conn, "quota %s set: %s\n", q->name, q->sys_policy_name);

				delete u;
			}
			else if (strcasecmp(param[i], "hour")==0) sQuotactlGetValue(&i, param, &(q->h));
			else if (strcasecmp(param[i], "day")==0) sQuotactlGetValue(&i, param, &(q->d));
			else if (strcasecmp(param[i], "week")==0) sQuotactlGetValue(&i, param, &(q->w));
			else if (strcasecmp(param[i], "month")==0) sQuotactlGetValue(&i, param, &(q->m));
			else if (strcasecmp(param[i], "total")==0) sQuotactlGetValue(&i, param, &(q->t));

			i+=2;
		} // while
	} //quota
	else if (!strcasecmp(param[0], "bind") && !strcasecmp(param[1], "quota") && !strcasecmp(param[3], "to")) {
		for (Qdef *quotas=cfg->root; quotas!=NULL; quotas=quotas->next) {
			if (quotas->name && strcasecmp(param[2], quotas->name)==0) q=quotas;
		}
		if (!q) { aParse(conn, "bind to undefined quota\n"); pthread_rwlock_unlock(cfg->rwlock); return; }
		int i=4;
		NetUnit *u; oid id;
		while (param[i]!=empty) {
			qUlist *ql,*qu,*qql;
			id=strtol(param[i], NULL, 16);
			u=Units.getUnitById(id);
			if (!u) u=Units.getUnit(param[i]);
			if (u) {
				for (ql=q->root; ql!=NULL; ql=ql->next) {
					if (!no_flag && ql->u==u) {
						aParse(conn, "unit %06X (%s) is already binded with quota %s\n", u->id, u->name?u->name:"<>", q->name);
						goto AGAIN;
					}
				}
				for (ql=q->root; ql!=NULL; ql=ql->next) {
					if (no_flag) {
						if (ql->u==u) {
							if(q->root == ql) q->root=ql->next; else ql->prev->next=ql->next;
							if(ql->next) ql->next->prev=ql->prev;
                                			if (u && u->sys_policy==q->sys_policy) {
                                        			u->sys_policy=SP_NONE;
                                        			u->sys_policy_name=SysPolicy_name[SP_NONE];
                                        			u->sys_policy_perm=0;
                                			}
							aFree(ql);
							aParse(conn, "unit %06X (%s) unbinded from quota %s\n", u->id, u->name?u->name:"<>", q->name);
							goto AGAIN;
							}
						}
					qql=ql;
				}
				qu=(qUlist*)aMalloc(sizeof(qUlist));
				qu->u=u;
				qu->next=NULL;
				if(!q->root) q->root=qu; else qql->next=qu;
				qu->prev=qql;
				qu->q_soft=qu->q_viol=0;
				aParse(conn, "unit %06X (%s) binded with quota %s\n", u->id, u->name?u->name:"<>", q->name);
			}
			else aParse(conn, "unit %06X unknown, cannot bind\n", id);
AGAIN:		i++;
		}		
	}
	else if (!strcasecmp(param[0], "alert")) {
		User *x;
		int j;

		if (!strcasecmp(param[1], "soft-reach")) {
			if (!strcasecmp(param[2], "<user>")) { j=3;	cfg->user_soft_reach=1; }
			else j=2; 
			
			x=Users.getUser(param[j]);
			if (!x) x=Users.getUserById(strtol(param[j], NULL, 16));
			if (!x && param[j]!=empty) aParse(conn, "user %s unknown\n", param[j]);
			else if (x) cfg->soft_reach=x;
		}
		else if (!strcasecmp(param[1], "hard-reach")) {
			if (!strcasecmp(param[2], "<user>")) { j=3;	cfg->user_hard_reach=1; }
			else j=2; 
			
			x=Users.getUser(param[j]);
			if (!x) x=Users.getUserById(strtol(param[j], NULL, 16));
			if (!x && param[j]!=empty) aParse(conn, "user %s unknown\n", param[j]);
			else if (x) cfg->hard_reach=x;
		}
		else if (!strcasecmp(param[1], "reset-back")) {
			if (!strcasecmp(param[2], "<user>")) { j=3;	cfg->user_reset_back=1; }
			else j=2; 
			
			x=Users.getUser(param[j]);
			if (!x) x=Users.getUserById(strtol(param[j], NULL, 16));
			if (!x && param[j]!=empty) aParse(conn, "user %s unknown\n", param[j]);
			else if (x) cfg->reset_back=x;
		}
		else aParse(conn, "quotactl alert parameter unknown: %s\n", param[1]);
	}
	else if (!strcasecmp(param[0], "lookup-delay")) {
		unsigned delay=atoi(param[1]);
		if(delay>1 && delay <24*60*60) {
			cfg->delay=delay*1000;
			aParse(conn, "quotas will be checked every %u seconds\n",delay);
		} 
		else aParse(conn, "lookup delay value invalid\n");
	}
	else aParse(conn, "unknown quotactl command: %s\n", param[0]);
	
	pthread_rwlock_unlock(cfg->rwlock);
	return;
}
//////////////////////////////////////////////////////////////////////////
void sQuotactlListCfg(Service *s, FILE *f){
	Quotactl_cfg *cfg=(Quotactl_cfg*)s->cfg;
	char buf[32];
	Qdef *q;

	if (!cfg->rwlock) return;

	pthread_rwlock_rdlock(cfg->rwlock);
	fprintf(f, "service quotactl %d\n", s->instance);
	if(cfg->delay!=QUOTACTL_DELAY) fprintf(f, "lookup-delay %d\n", cfg->delay/1000);
	for (q=cfg->root; q!=NULL; q=q->next) {
		if (q->name) {
			fprintf(f, "quota %s policy %s ", q->name, (q->policy && q->policy->name)?q->policy->name:"<>");

			if (q->sys_policy!=SP_NONE) { 
				if (q->sys_policy_perm) fprintf(f, "set sys-%06X%s%s ", q->sys_policy_perm, q->sys_policy_name[0]?"-":"", q->sys_policy_name);
				else fprintf(f, "set %s ", q->sys_policy_name);
				}

			if (q->h.in || q->h.out || q->h.softin || q->h.softout || q->h.sum || q->h.softsum) {
				fprintf(f, "hour ");
				if (q->h.softin) fprintf(f, "%s soft-in ", bytesQ2T(q->h.softin, buf));
				if (q->h.softout) fprintf(f, "%s soft-out ", bytesQ2T(q->h.softout, buf));
				if (q->h.softsum) fprintf(f, "%s soft-sum ", bytesQ2T(q->h.softsum, buf));
				if (q->h.in) fprintf(f, "%s in ", bytesQ2T(q->h.in, buf));
				if (q->h.out) fprintf(f, "%s out ", bytesQ2T(q->h.out, buf));
				if (q->h.sum) fprintf(f, "%s sum ", bytesQ2T(q->h.sum, buf));
				}
		 
			if (q->d.in || q->d.out || q->d.softin || q->d.softout || q->d.sum || q->d.softsum) {
				fprintf(f, "day ");
				if (q->d.softin) fprintf(f, "%s soft-in ", bytesQ2T(q->d.softin, buf));
				if (q->d.softout) fprintf(f, "%s soft-out ", bytesQ2T(q->d.softout, buf));
				if (q->d.softsum) fprintf(f, "%s soft-sum ", bytesQ2T(q->d.softsum, buf));
				if (q->d.in) fprintf(f, "%s in ", bytesQ2T(q->d.in, buf));
				if (q->d.out) fprintf(f, "%s out ", bytesQ2T(q->d.out, buf));
				if (q->d.sum) fprintf(f, "%s sum ", bytesQ2T(q->d.sum, buf));
				}

			if (q->w.in || q->w.out || q->w.softin || q->w.softout || q->w.sum || q->w.softsum) {
				fprintf(f, "week ");
				if (q->w.softin) fprintf(f, "%s soft-in ", bytesQ2T(q->w.softin, buf));
				if (q->w.softout) fprintf(f, "%s soft-out ", bytesQ2T(q->w.softout, buf));
				if (q->w.softsum) fprintf(f, "%s soft-sum ", bytesQ2T(q->w.softsum, buf));
				if (q->w.in) fprintf(f, "%s in ", bytesQ2T(q->w.in, buf));
				if (q->w.out) fprintf(f, "%s out ", bytesQ2T(q->w.out, buf));
				if (q->w.sum) fprintf(f, "%s sum ", bytesQ2T(q->w.sum, buf));
				}

			if (q->m.in || q->m.out || q->m.softin || q->m.softout || q->m.sum || q->m.softsum) {
				fprintf(f, "month ");
				if (q->m.softin) fprintf(f, "%s soft-in ", bytesQ2T(q->m.softin, buf));
				if (q->m.softout) fprintf(f, "%s soft-out ", bytesQ2T(q->m.softout, buf));
				if (q->m.softsum) fprintf(f, "%s soft-sum ", bytesQ2T(q->m.softsum, buf));
				if (q->m.in) fprintf(f, "%s in ", bytesQ2T(q->m.in, buf));
				if (q->m.out) fprintf(f, "%s out ", bytesQ2T(q->m.out, buf));
				if (q->m.sum) fprintf(f, "%s sum ", bytesQ2T(q->m.sum, buf));
				}
		
				if (q->t.in || q->t.out || q->t.softin || q->t.softout || q->t.sum || q->t.softsum) {
				fprintf(f, "total ");
				if (q->t.softin) fprintf(f, "%s soft-in ", bytesQ2T(q->t.softin, buf));
				if (q->t.softout) fprintf(f, "%s soft-out ", bytesQ2T(q->t.softout, buf));
				if (q->t.softsum) fprintf(f, "%s soft-sum ", bytesQ2T(q->t.softsum, buf));
				if (q->t.in) fprintf(f, "%s in ", bytesQ2T(q->t.in, buf));
				if (q->t.out) fprintf(f, "%s out ", bytesQ2T(q->t.out, buf));
				if (q->t.sum) fprintf(f, "%s sum ", bytesQ2T(q->t.sum, buf));
				}
			fprintf(f, "\n");
			
			if (q->root) {
				fprintf(f, "bind quota %s to ", q->name);
				for (qUlist *ql=q->root;ql!=NULL;ql=ql->next) 
						if (ql->u) fprintf(f, "%06X ", ql->u->id);
					else {
						if(q->root == ql) q->root=ql->next; else ql->prev->next=ql->next;
                                                 if(ql->next) ql->next->prev=ql->prev;
					}
				fprintf(f, "\n");
				}
			}

		}

	if (cfg->user_soft_reach || cfg->soft_reach) {
		fprintf(f, "alert soft-reach ");
		if (cfg->user_soft_reach) fprintf(f, "<user> ");
		if (cfg->soft_reach) { if (cfg->soft_reach->name) fprintf(f, "%s", cfg->soft_reach->name); else fprintf(f, "%06X", cfg->soft_reach->id); }
		fprintf(f, "\n");
		}

	if (cfg->user_hard_reach || cfg->hard_reach) {
		fprintf(f, "alert hard-reach ");
		if (cfg->user_hard_reach) fprintf(f, "<user> ");
		if (cfg->hard_reach) { if (cfg->hard_reach->name) fprintf(f, "%s", cfg->hard_reach->name); else fprintf(f, "%06X", cfg->hard_reach->id); }
		fprintf(f, "\n");
		}

	if (cfg->user_reset_back || cfg->reset_back) {
		fprintf(f, "alert reset-back ");
		if (cfg->user_reset_back) fprintf(f, "<user> ");
		if (cfg->reset_back) { if (cfg->reset_back->name) fprintf(f, "%s", cfg->reset_back->name); else fprintf(f, "%06X", cfg->reset_back->id); }
		fprintf(f, "\n");
		}

	fprintf(f, "\n");
	pthread_rwlock_unlock(cfg->rwlock);
	return;
	}

//////////////////////////////////////////////////////////////////////////
void cShowQuotactl(Connection *conn, char *param[32]){
	char buf[32], buf2[32];
	Qdef *q;
	NetUnit *u;
	policy_data *pd;
 	Service *s=NULL;
	char *r_qname=NULL; oid r_id=0;

	for(unsigned i=2;param[i]!=empty;) {
		if (!strcasecmp("name", param[i])) {
		 	if (param[i+1]!=empty) r_qname=param[i+1];
			i+=2;
		} 
		else if (!strcasecmp("oid", param[i])) {
		 	if (param[i+1]!=empty) {
				if((u=Units.getUnit(param[i+1]))) r_id=u->id;
				else r_id=strtol(param[i+1], NULL, 16);
			}
			i+=2;
		} else i++;
	}
        
	while((s=Services.getServiceByName("quotactl",s))) {
		Quotactl_cfg *cfg=(Quotactl_cfg*)s->cfg;
		if (!cfg->rwlock) return;
		fprintf(conn->stream_w,"service quotactl %u\n",s->instance);
		
		int err=pthread_rwlock_tryrdlock(cfg->rwlock);
		if(err == EBUSY) pthread_rwlock_rdlock(cfg->rwlock);
		
		for (q=cfg->root; q!=NULL; q=q->next) 
		if (q->name) if ((r_qname && !strcasecmp(q->name, r_qname)) || r_qname==NULL)
			{
			fprintf(conn->stream_w, "QUOTA: %s\tpolicy %s\t", q->name, (q->policy && q->policy->name)?q->policy->name:"<>");

			ShowSysPolicy(buf, q->sys_policy,q->sys_policy_perm, q->sys_policy_name);    
			fprintf(conn->stream_w, "set %s\n", buf);

			for (qUlist *ql=q->root;ql!=NULL;ql=ql->next) { 
				if (ql->u) {
					if (r_id==0 || (r_id!=0 && r_id==ql->u->id) ) {
						u=ql->u;

						ShowSysPolicy(buf, u->sys_policy, u->sys_policy_perm, u->sys_policy_name);    
						pd=u->ap.Get(q->policy);
						fprintf(conn->stream_w, " UNIT %06X\t(%s)\tSYST: %s\tACCT is %spresent\n", u->id, u->name?u->name:"<>", buf, pd?"":"NOT ");
						if (!pd) continue;

						if (q->h.softin)  	fprintf(conn->stream_w, "  HOUR   in: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->h.in, buf), bytesQ2T(q->h.softin, buf2), 100.0*(double)pd->h.in/q->h.softin, pd->h.in>=q->h.softin?'-':'+');
						if (q->h.in)  		fprintf(conn->stream_w, "  HOUR   in: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->h.in, buf), bytesQ2T(q->h.in, buf2), 100.0*(double)pd->h.in/q->h.in, pd->h.in>=q->h.in?'-':'+');
						if (q->h.softout) 	fprintf(conn->stream_w, "  HOUR  out: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->h.out, buf), bytesQ2T(q->h.softout, buf2), 100.0*(double)pd->h.out/q->h.softout, pd->h.out>=q->h.softout?'-':'+');
						if (q->h.out) 		fprintf(conn->stream_w, "  HOUR  out: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->h.out, buf), bytesQ2T(q->h.out, buf2), 100.0*(double)pd->h.out/q->h.out, pd->h.out>=q->h.out?'-':'+');
						if (q->h.softsum) 	fprintf(conn->stream_w, "  HOUR  sum: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->h.in+pd->h.out, buf), bytesQ2T(q->h.softsum, buf2), 100.0*(double)(pd->h.in+pd->h.out)/q->h.softsum, (pd->h.in+pd->h.out)>=q->h.softsum?'-':'+');
						if (q->h.sum) 		fprintf(conn->stream_w, "  HOUR  sum: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->h.in+pd->h.out, buf), bytesQ2T(q->h.sum, buf2), 100.0*(double)(pd->h.in+pd->h.out)/q->h.sum, (pd->h.in+pd->h.out)>=q->h.sum?'-':'+');

						if (q->d.softin)  		fprintf(conn->stream_w, "  DAY    in: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->d.in, buf), bytesQ2T(q->d.softin, buf2), 100.0*(double)pd->d.in/q->d.softin, pd->d.in>=q->d.softin?'-':'+');
						if (q->d.in)  		fprintf(conn->stream_w, "  DAY    in: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->d.in, buf), bytesQ2T(q->d.in, buf2), 100.0*(double)pd->d.in/q->d.in, pd->d.in>=q->d.in?'-':'+');
						if (q->d.softout) 		fprintf(conn->stream_w, "  DAY   out: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->d.out, buf), bytesQ2T(q->d.softout, buf2), 100.0*(double)pd->d.out/q->d.softout, pd->d.out>=q->d.softout?'-':'+');
						if (q->d.out) 		fprintf(conn->stream_w, "  DAY   out: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->d.out, buf), bytesQ2T(q->d.out, buf2), 100.0*(double)pd->d.out/q->d.out, pd->d.out>=q->d.out?'-':'+');
						if (q->d.softsum) 		fprintf(conn->stream_w, "  DAY   sum: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->d.in+pd->d.out, buf), bytesQ2T(q->d.softsum, buf2), 100.0*(double)(pd->d.in+pd->d.out)/q->d.softsum, (pd->d.in+pd->d.out)>=q->d.softsum?'-':'+');
						if (q->d.sum) 		fprintf(conn->stream_w, "  DAY   sum: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->d.in+pd->d.out, buf), bytesQ2T(q->d.sum, buf2), 100.0*(double)(pd->d.in+pd->d.out)/q->d.sum, (pd->d.in+pd->d.out)>=q->d.sum?'-':'+');

						if (q->w.softin)  		fprintf(conn->stream_w, "  WEEK   in: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->w.in, buf), bytesQ2T(q->w.softin, buf2), 100.0*(double)pd->w.in/q->w.softin, pd->w.in>=q->w.softin?'-':'+');
						if (q->w.in)  		fprintf(conn->stream_w, "  WEEK   in: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->w.in, buf), bytesQ2T(q->w.in, buf2), 100.0*(double)pd->w.in/q->w.in, pd->w.in>=q->w.in?'-':'+');
						if (q->w.softout) 		fprintf(conn->stream_w, "  WEEK  out: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->w.out, buf), bytesQ2T(q->w.softout, buf2), 100.0*(double)pd->w.out/q->w.softout, pd->w.out>=q->w.softout?'-':'+');
						if (q->w.out) 		fprintf(conn->stream_w, "  WEEK  out: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->w.out, buf), bytesQ2T(q->w.out, buf2), 100.0*(double)pd->w.out/q->w.out, pd->w.out>=q->w.out?'-':'+');
						if (q->w.softsum) 		fprintf(conn->stream_w, "  WEEK  sum: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->w.in+pd->w.out, buf), bytesQ2T(q->w.softsum, buf2), 100.0*(double)(pd->w.in+pd->w.out)/q->w.softsum, (pd->w.in+pd->w.out)>=q->w.softsum?'-':'+');
						if (q->w.sum) 		fprintf(conn->stream_w, "  WEEK  sum: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->w.in+pd->w.out, buf), bytesQ2T(q->w.sum, buf2), 100.0*(double)(pd->w.in+pd->w.out)/q->w.sum, (pd->w.in+pd->w.out)>=q->w.sum?'-':'+');

						if (q->m.softin)  		fprintf(conn->stream_w, "  MONTH  in: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->m.in, buf), bytesQ2T(q->m.softin, buf2), 100.0*(double)pd->m.in/q->m.softin, pd->m.in>=q->m.softin?'-':'+');
						if (q->m.in)  		fprintf(conn->stream_w, "  MONTH  in: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->m.in, buf), bytesQ2T(q->m.in, buf2), 100.0*(double)pd->m.in/q->m.in, pd->m.in>=q->m.in?'-':'+');
						if (q->m.softout) 		fprintf(conn->stream_w, "  MONTH out: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->m.out, buf), bytesQ2T(q->m.softout, buf2), 100.0*(double)pd->m.out/q->m.softout, pd->m.out>=q->m.softout?'-':'+');
						if (q->m.out) 		fprintf(conn->stream_w, "  MONTH out: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->m.out, buf), bytesQ2T(q->m.out, buf2), 100.0*(double)pd->m.out/q->m.out, pd->m.out>=q->m.out?'-':'+');
						if (q->m.softsum) 		fprintf(conn->stream_w, "  MONTH sum: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->m.in+pd->m.out, buf), bytesQ2T(q->m.softsum, buf2), 100.0*(double)(pd->m.in+pd->m.out)/q->m.softsum, (pd->m.in+pd->m.out)>=q->m.softsum?'-':'+');
						if (q->m.sum) 		fprintf(conn->stream_w, "  MONTH sum: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->m.in+pd->m.out, buf), bytesQ2T(q->m.sum, buf2), 100.0*(double)(pd->m.in+pd->m.out)/q->m.sum, (pd->m.in+pd->m.out)>=q->m.sum?'-':'+');

						if (q->t.softin)  		fprintf(conn->stream_w, "  TOTAL  in: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->t.in, buf), bytesQ2T(q->t.softin, buf2), 100.0*(double)pd->t.in/q->t.softin, pd->t.in>=q->t.softin?'-':'+');
						if (q->t.in)  		fprintf(conn->stream_w, "  TOTAL  in: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->t.in, buf), bytesQ2T(q->t.in, buf2), 100.0*(double)pd->t.in/q->t.in, pd->t.in>=q->t.in?'-':'+');
						if (q->t.softout) 		fprintf(conn->stream_w, "  TOTAL out: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->t.out, buf), bytesQ2T(q->t.softout, buf2), 100.0*(double)pd->t.out/q->t.softout, pd->t.out>=q->t.softout?'-':'+');
						if (q->t.out) 		fprintf(conn->stream_w, "  TOTAL out: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->t.out, buf), bytesQ2T(q->t.out, buf2), 100.0*(double)pd->t.out/q->t.out, pd->t.out>=q->t.out?'-':'+');
						if (q->t.softsum) 		fprintf(conn->stream_w, "  TOTAL sum: %s, softquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->t.in+pd->t.out, buf), bytesQ2T(q->t.softsum, buf2), 100.0*(double)(pd->t.in+pd->t.out)/q->t.softsum, (pd->t.in+pd->t.out)>=q->t.softsum?'-':'+');
						if (q->t.sum) 		fprintf(conn->stream_w, "  TOTAL sum: %s, hardquota %s ratio %.2f%% -> [%c]\n", bytesQ2T(pd->t.in+pd->t.out, buf), bytesQ2T(q->t.sum, buf2), 100.0*(double)(pd->t.in+pd->t.out)/q->t.sum, (pd->t.in+pd->t.out)>=q->t.sum?'-':'+');
						}

				} else {
                                	if(q->root == ql) q->root=ql->next; else ql->prev->next=ql->next;
                                        if(ql->next) ql->next->prev=ql->prev; 
                                       }
			}
			fprintf(conn->stream_w, "\n");
		}
	if (err!=EDEADLK) pthread_rwlock_unlock(cfg->rwlock);
	}
	return;
}

//////////////////////////////////////////////////////////////////////////
void *sQuotactl(void *ss){
	Service *s=(Service*)ss;
	Quotactl_cfg *cfg=(Quotactl_cfg*)s->cfg;
	Qdef *q;
	NetUnit *u;
	policy_data *pd;
	unsigned q_viol, q_soft;

	aLog(D_INFO, "service quotactl:%u thread started (%p)\n", s->instance, s->cfg);
	pthread_cleanup_push(sQuotactlCancel, s);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
	s->t_id=pthread_self();

	// now we should sleep before starting service
	s->Sleep();

	aLog(D_DEBUG, "service quotactl:%u checking every %d seconds\n", s->instance, cfg->delay/1000);
	while (1) {
		pthread_rwlock_wrlock(cfg->rwlock);
	
		for (q=cfg->root; q!=NULL; q=q->next)
		if (q->name) {
			for (qUlist *ql=q->root;ql!=NULL;ql=ql->next) { 
				if (ql->u) {
					q_viol=q_soft=0;
					u=ql->u;

					pd=u->ap.Get(q->policy);
					if (!pd) continue;

					if (q->h.in) if (pd->h.in>=q->h.in) q_viol=1;
					if (q->h.out) if (pd->h.out>=q->h.out) q_viol=1;
					if (q->h.sum) if ((pd->h.in+pd->h.out)>=q->h.sum) q_viol=1;
					if (q->h.softin) if (pd->h.in>=q->h.softin) q_soft=1;
					if (q->h.softout) if (pd->h.out>=q->h.softout) q_soft=1;
					if (q->h.softsum) if ((pd->h.in+pd->h.out)>=q->h.softsum) q_soft=1;

					if (q->d.in) if (pd->d.in>=q->d.in) q_viol=1;
					if (q->d.out) if (pd->d.out>=q->d.out) q_viol=1;
					if (q->d.sum) if ((pd->d.in+pd->d.out)>=q->d.sum) q_viol=1;
					if (q->d.softin) if (pd->d.in>=q->d.softin) q_soft=1;
					if (q->d.softout) if (pd->d.out>=q->d.softout) q_soft=1;
					if (q->d.softsum) if ((pd->d.in+pd->d.out)>=q->d.softsum) q_soft=1;
					
					if (q->w.in) if (pd->w.in>=q->w.in) q_viol=1;
					if (q->w.out) if (pd->w.out>=q->w.out) q_viol=1;
					if (q->w.sum) if ((pd->w.in+pd->w.out)>=q->w.sum) q_viol=1;
					if (q->w.softin) if (pd->w.in>=q->w.softin) q_soft=1;
					if (q->w.softout) if (pd->w.out>=q->w.softout) q_soft=1;
					if (q->w.softsum) if ((pd->w.in+pd->w.out)>=q->w.softsum) q_soft=1;
					
					if (q->m.in) if (pd->m.in>=q->m.in) q_viol=1;
					if (q->m.out) if (pd->m.out>=q->m.out) q_viol=1;
					if (q->m.sum) if ((pd->m.in+pd->m.out)>=q->m.sum) q_viol=1;
					if (q->m.softin) if (pd->m.in>=q->m.softin) q_soft=1;
					if (q->m.softout) if (pd->m.out>=q->m.softout) q_soft=1;
					if (q->m.softsum) if ((pd->m.in+pd->m.out)>=q->m.softsum) q_soft=1;
					
					if (q->t.in) if (pd->t.in>=q->t.in) q_viol=1;
					if (q->t.out) if (pd->t.out>=q->t.out) q_viol=1;
					if (q->t.sum) if ((pd->t.in+pd->t.out)>=q->t.sum) q_viol=1;
					if (q->t.softin) if (pd->t.in>=q->t.softin) q_soft=1;
					if (q->t.softout) if (pd->t.out>=q->t.softout) q_soft=1;
					if (q->t.softsum) if ((pd->t.in+pd->t.out)>=q->t.softsum) q_soft=1;

					if (!q_viol && u->sys_policy==q->sys_policy) {
						u->sys_policy=SP_NONE;
						u->sys_policy_name=SysPolicy_name[SP_NONE];
						u->sys_policy_perm=0;
						aLog(D_WARN, "unit %06X (%s) quota %s reset back\n", u->id, u->name?u->name:"<>", q->name);
						sQuotaSendAlert(s, u, q, 0);
						ql->q_soft=ql->q_viol=0;
						cAccessScriptCall(PASS, u, "QUOTA RESET");
						}
					if (q_viol && u->sys_policy!=q->sys_policy) {
						u->sys_policy=q->sys_policy;
						u->sys_policy_name=q->sys_policy_name;
						u->sys_policy_perm=q->sys_policy_perm;
						aLog(D_WARN, "unit %06X (%s) violated quota %s\n", u->id, u->name?u->name:"<>", q->name);
						sQuotaSendAlert(s, u, q, 1);
						ql->q_viol=q_viol;
						cAccessScriptCall(DROP, u, "QUOTA VIOLATE");
						}
					if (q_soft && u->sys_policy!=q->sys_policy && !ql->q_soft) {
						aLog(D_WARN, "unit %06X (%s) reached soft quota %s\n", u->id, u->name?u->name:"<>", q->name);
						sQuotaSendAlert(s, u, q, 2);
						ql->q_soft=q_soft;
						}
					if (!q_soft && ql->q_soft) {
						aLog(D_WARN, "unit %06X (%s) soft quota %s reset back\n", u->id, u->name?u->name:"<>", q->name);
						ql->q_soft=0;
						}

		   		} else {
                                   	if(q->root == ql) q->root=ql->next; else ql->prev->next=ql->next;
                                   	if(ql->next) ql->next->prev=ql->prev;
                                       }
				}
			}
		pthread_rwlock_unlock(cfg->rwlock);
		s->Sleep(cfg->delay); // quotas will be checked every cfg->delay/1000 seconds
		}

	pthread_cleanup_pop(0);
	return NULL;
	}

//////////////////////////////////////////////////////////////////////////
void sQuotactlCancel(void *v){
	Service *s = (Service*)v;
	Quotactl_cfg *cfg=(Quotactl_cfg*)s->cfg;
	
	aLog(D_INFO, "cancelling service quotactl:%u\n", s->instance);

	pthread_rwlock_wrlock(cfg->rwlock);
	pthread_rwlock_rdlock(Units.rwlock);

	for (Qdef *q=cfg->root; q!=NULL;) {
		for(qUlist *ql=q->root;ql!=NULL;) {
                	NetUnit *u=ql->u;
                        if (u && u->sys_policy==q->sys_policy) {
                        	u->sys_policy=SP_NONE;
                                u->sys_policy_name=SysPolicy_name[SP_NONE];
                                u->sys_policy_perm=0;
			}
			qUlist *ptr=ql;
			ptr=ql;
			ql=ql->next;
			aFree(ptr);
		}
		Qdef *qd=q;
		q=q->next;
		aFree(qd->name);
		aFree(qd);
	}
	pthread_rwlock_unlock(Units.rwlock);
	pthread_rwlock_unlock(cfg->rwlock);
	pthread_rwlock_destroy(cfg->rwlock);
	aFree(cfg->rwlock);
	aFree(s->cfg);
}
//////////////////////////////////////////////////////////////////////////
void sQuotaSendAlert(Service *s,NetUnit *u, Qdef *q, int dir){	 // dir=1:violates; =0:back; =2:soft_quota_reached
	if(!u->email) return; //nowhere to send
	Quotactl_cfg *cfg=(Quotactl_cfg*)s->cfg;
	Service *ss=NULL;
        if(!(ss=Services.getServiceByName("alerter",ss))) return;

	ServiceAlerter_cfg *alerter=(ServiceAlerter_cfg*)ss->cfg;

	if (!alerter->queue) return; // alerter service is no running

	Message *msg;
	alert *al;

	msg = new Message();
	msg->type=ALERT;
	al=(alert*)aMalloc(sizeof(alert));
	
	msg->al=al;
	al->sent=time(NULL);
	al->expired=al->sent+60*60; // one hour expire
	al->report_id=0x06101; 
	al->tries=0; 
	al->alert_id=alerter->queue->total_items+1; //here

 	char *subject, *message, *buffer;
	subject=message=NULL; 
	buffer=(char*)aMalloc(255);
	timeU2T(time(NULL), buffer);

	print_to_string(&message, "This is automatically generated report by %s, version %d.%d(%d)\nTime: %s\n\n", aaa_fw_software_name, aaa_fw_major_version, aaa_fw_minor_version, aaa_fw_build_version, buffer);
	
	//we do not need lock here because we locked it in sQuotactl already

	switch (dir) {	
		case 0:
			if (cfg->reset_back) al->user_id[0]=cfg->reset_back->id; else al->user_id[0]=0;
			if (cfg->user_reset_back)  al->unit_id[0]=u->id; 
			print_to_string(&subject, "Quotactl: unit %s quota RETURN", u->name?u->name:"<>", q->name);
			print_to_string(&message, "NeTAMS Quotactl service have detected quota RETURN for unit %s (%06X), quota %s\n", u->name?u->name:"<>", u->id, q->name);
			break;
		case 1:
			if (cfg->hard_reach) al->user_id[0]=cfg->hard_reach->id; else al->user_id[0]=0;
			if (cfg->user_hard_reach)  al->unit_id[0]=u->id; 
			print_to_string(&subject, "Quotactl: unit %s quota VIOLATION", u->name?u->name:"<>", q->name);
			print_to_string(&message, "NeTAMS Quotactl service have detected quota HARD REACH for unit %s (%06X), quota %s\n", u->name?u->name:"<>", u->id, q->name);
			break;
		case 2:
			if (cfg->soft_reach) al->user_id[0]=cfg->soft_reach->id; else al->user_id[0]=0;
			if (cfg->user_soft_reach)  al->unit_id[0]=u->id; 
			print_to_string(&subject, "Quotactl: unit %s quota SOFT REACH", u->name?u->name:"<>", q->name);
			print_to_string(&message, "NeTAMS Quotactl service have detected quota SOFT REACH for unit %s (%06X), quota %s\n", u->name?u->name:"<>", u->id, q->name);
			break;
	}	

	print_to_string(&message, "\n################################");
	print_to_string(&message, "\nCurrent quotactl status follows:\n\n");
	snprintf(buffer, 254, "show quota name %s oid %06X", q->name, u->id);
	cExec(buffer, &message);

	print_to_string(&message, "\n####################################");
	print_to_string(&message, "\nCurrent user traffic status follows:\n\n");
	snprintf(buffer, 245, "show list full oid %06X", u->id);
	cExec(buffer, &message);
	
	al->data=NULL;
	print_to_string(&al->data, "%s\n%s\n", subject, message);
	aFree(subject);	aFree(message);	aFree(buffer);

	al->alert_id=(unsigned)alerter->queue->Push(msg);
	alerter->self->Wakeup();
	aDebug(DEBUG_ALERT, "alert (quota) %u complete, data is %d bytes\n", al->alert_id, strlen(al->data));
}
//////////////////////////////////////////////////////////////////////////
void sQuotactlGetValue(int *i, char *param[], qstat *q){

	int j=*i+1;
	unsigned long long data;
	while (1) {
		bytesT2Q(&data, param[j]);

		if (strcasecmp(param[j+1], "in")==0) q->in=data;
		else if (strcasecmp(param[j+1], "out")==0) q->out=data;
		else if (strcasecmp(param[j+1], "sum")==0) q->sum=data;
		else if (strcasecmp(param[j+1], "soft-in")==0) q->softin=data;
		else if (strcasecmp(param[j+1], "soft-out")==0) q->softout=data;
		else if (strcasecmp(param[j+1], "soft-sum")==0) q->softsum=data;
		else break;

		j+=2;
		}
	*i=j-2;

}
//////////////////////////////////////////////////////////////////////////

