/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: services.h,v 1.7.2.1 2004/05/06 10:35:06 jura Exp $ */

//////////////////////////////////////////////////////////////////////////
class Service {
	public:
		char *getName();
		Service(char *param1, unsigned i=1);
		~Service();
		void Shutdown();
		void setTID();
		Service *next;
		void *cfg;
		pthread_t t_id;
		char *name;
		unsigned instance;
		int Wakeup();
		int Sleep(unsigned msec=0);
		void setSleep() { sleep_state=1; }
		int isSleep() { return sleep_state; }
		void Start(char *param[32]);
		void Start(char *param);
		void ProcessCfg(char *param[32], Connection *conn, unsigned no_flag);
		void listCfg(FILE *f);
		void listInfo(FILE *f);
		void showPerf(FILE *f, int isheader=0);

	private:
		pthread_mutex_t *sleep_mutex;
		pthread_cond_t *sleep_cond;
		unsigned sleep_state;
		};

//////////////////////////////////////////////////////////////////////////
class ServicesList {
	private:
		Service *root;
		Service *last;
		unsigned num_services;
		pthread_rwlock_t *rwlock;
		unsigned long tries_lock;
                unsigned long tries_lock_failed;
		char *unknown_service;
	public:
		ServicesList();
		~ServicesList();
		void Insert(Service *s);
		void Delete(char *param1, unsigned i);
		void Delete(Service *s);
		Service *getService(char *param1, unsigned i);
		Service *getServiceByName( char *param1, Service *s);
		unsigned getServices() { return num_services; }
		char *getServiceByThr(pthread_t t);
		void StartAll(Service *except=NULL);
		void ShutdownAll(Service *except);
		void listCfg(FILE *f);
		void listInfo(FILE *f);
		void showPerf(FILE *f, int isheader=0);
		};

//////////////////////////////////////////////////////////////////////////
void cService(Connection *conn, char *param[32], int no_flag);
