/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: st_sql_postgres.c,v 1.20.2.12 2004/05/06 10:35:07 jura Exp $ */

#ifdef USE_POSTGRES

#include "netams.h"

//////////////////////////////////////////////////////////////////////////
void *pg_stOpenSql(Service *s, unsigned int type){

	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
//	FILE *debug;
	PGresult  *res;
	PGconn *conn=NULL;
	char *st_conn=NULL;

	char *pg_host, *pg_user, *pg_pass, *pg_dbname;
	char buffer[255]; 
        
	if (!cfg->hostname) pg_host="localhost"; else pg_host=cfg->hostname;
        if (!cfg->username) pg_user="root"; else pg_user=cfg->username;
        if (!cfg->password) pg_pass=""; else pg_pass=cfg->password;
        if (!cfg->dbname) pg_dbname="netams"; else pg_dbname=cfg->dbname;

	
	conn = PQsetdbLogin(pg_host,NULL,NULL,NULL,pg_dbname,pg_user,pg_pass);
	if (PQstatus(conn) == CONNECTION_BAD) {
		PQfinish(conn);
		conn = PQsetdbLogin(pg_host,NULL,NULL,NULL,"template1",pg_user,pg_pass);
		if (PQstatus(conn) == CONNECTION_BAD) {	
             		aLog(D_WARN, "postgres connect failed: %s, continuing closed\n",  PQerrorMessage(conn));
			return NULL;
		}
		res = PQexec(conn,"SET autocommit TO 'on'"); 
		PQclear(res);

		sprintf(buffer,"SELECT * FROM pg_database WHERE datname='%s'",pg_dbname);
		res = PQexec(conn, buffer);
        	if (PQresultStatus(res) != PGRES_TUPLES_OK) {
			aLog(D_WARN, "postgres list dbs failed: %s\n", PQerrorMessage(conn));
			return NULL;
		}
		if(!PQntuples(res)) { //hmmm, there are no netams database there... creating it...
			PQclear(res);
			snprintf(buffer, 254, "CREATE DATABASE %s", pg_dbname);
			res = PQexec(conn, buffer);
			if (PQresultStatus(res) != PGRES_COMMAND_OK) {
				aLog(D_WARN, "postgres create db failed: %s\n",PQerrorMessage(conn));
				return NULL;
			}
			PQclear(res);
			PQfinish(conn);

			conn = PQsetdbLogin(pg_host,NULL,NULL,NULL,pg_dbname,pg_user,pg_pass);
			if (PQstatus(conn) == CONNECTION_BAD) {
                        	aLog(D_WARN, "postgres connect failed: %s, continuing closed\n",  PQerrorMessage(conn));
                        	return NULL;
                	}
		}
	}
	
	res=PQexec(conn,"BEGIN");PQclear(res);

	switch(type) {
		case ST_CONN_RAW:
			st_conn="RAW";
			res = PQexec(conn, "SELECT * FROM pg_tables WHERE tablename='raw'");
			if(!PQntuples(res)) { //hmmm, there are no 'raw' table there... creating it...
				PQclear(res);
				res = PQexec(conn,"CREATE TABLE raw (unit_oid INT NOT NULL, policy_oid INT NOT NULL, t_from INT , t_to INT , bytes_in BIGINT , bytes_out BIGINT ,id BIGSERIAL PRIMARY KEY, hostname VARCHAR(32) NULL)");
				if (PQresultStatus(res) != PGRES_COMMAND_OK) {
 					aLog(D_WARN, "postgres create table 'raw' failed: %s\n", PQerrorMessage(conn));
					return NULL;
				}
				PQclear(res);
				res = PQexec(conn,"CREATE INDEX raw_unit_oid_idx ON raw(unit_oid)"); PQclear(res);
                        	res = PQexec(conn,"CREATE INDEX raw_policy_oid_idx ON raw(policy_oid)"); 
				aLog(D_INFO, "postgres table 'raw' created\n");
			}
			PQclear(res);
			break;
		case ST_CONN_SUMMARY:
                        st_conn="SUMMARY";
			res = PQexec(conn, "SELECT * FROM pg_tables WHERE tablename='summary'");
                        if(!PQntuples(res)) { //hmmm, there are no 'summary' table there... creating it...
                                PQclear(res);
				res = PQexec(conn,"CREATE TABLE summary (prefix CHAR(1) NOT NULL, unit_oid INT NOT NULL, policy_oid INT NOT NULL, t_from INT NOT NULL, bytes_in BIGINT, bytes_out BIGINT)");
				if (PQresultStatus(res) != PGRES_COMMAND_OK) {	
					aLog(D_WARN, "postgres create table 'summary' failed: %s\n", PQerrorMessage(conn));
					return NULL;
				}
				PQclear(res);
                        	res = PQexec(conn,"CREATE INDEX summary_unit_oid_idx ON summary(unit_oid)"); PQclear(res);
                        	res = PQexec(conn,"CREATE INDEX summary_policy_oid_idx ON summary(policy_oid)");PQclear(res); 
                        	res = PQexec(conn,"CREATE INDEX summary_t_from_idx ON summary(t_from)"); 
				aLog(D_INFO, "postgres table 'summary' created\n");
			}
			PQclear(res);
			break;
		case ST_CONN_MONITOR:
                        st_conn="MONITOR";
			res = PQexec(conn, "SELECT * FROM pg_tables WHERE tablename='monitor'");
                        if(!PQntuples(res)) { //hmmm, there are no 'monitor' table there... creating it...
                                PQclear(res);
				res = PQexec(conn,"CREATE TABLE monitor (time INT NOT NULL , msec SMALLINT , name VARCHAR(32), unit_oid INT , proto SMALLINT , src BIGINT NOT NULL, srcport INT , dst BIGINT NOT NULL, dstport INT , len INT)");
				if (PQresultStatus(res) != PGRES_COMMAND_OK) { 
					aLog(D_WARN, "postgres create table 'monitor' failed: %s\n", PQerrorMessage(conn));
					return NULL;
				}	
				PQclear(res);
				res = PQexec(conn,"CREATE INDEX monitor_time_idx ON monitor(time)"); PQclear(res);
				res = PQexec(conn,"CREATE INDEX monitor_unit_oid_idx ON monitor(unit_oid)"); 
				aLog(D_INFO, "postgres table 'monitor' created\n");
			}
			PQclear(res);
			break;
		case ST_CONN_LOGIN:
                        st_conn="LOGIN";
			res = PQexec(conn, "SELECT * FROM pg_tables WHERE tablename='login'");
			if(!PQntuples(res)) { //hmmm, there are no 'login' table there... creating it...
                                PQclear(res);
				res = PQexec(conn,"CREATE TABLE login (unit_oid INT NOT NULL, password VARCHAR(32), inact INT, abs INT , last_changed INT , last_opened_time INT , last_opened_ip BIGINT , last_opened_mac VARCHAR(18), def_state INT, curr_state INT, strict INT)");
				if (PQresultStatus(res) != PGRES_COMMAND_OK) {
                                        aLog(D_WARN, "postgres create table 'login' failed: %s\n", PQerrorMessage(conn));
                                        return NULL;
                                }
				PQclear(res);
				res = PQexec(conn,"CREATE INDEX login_unit_oid_idx ON login(unit_oid)"); 
				aLog(D_INFO, "postgres table 'login' created\n");
			}
			PQclear(res);
			break;
		case ST_CONN_QUOTA:
                        st_conn="QUOTA";
			res = PQexec(conn, "SELECT * FROM pg_tables WHERE tablename='quota'");
                        if(!PQntuples(res)) { //hmmm, there are no 'quota' table there... creating it...
                                PQclear(res);
				res = PQexec(conn,"CREATE TABLE quota (unit_oid INT NOT NULL,policy_oid INT NOT NULL, syspolicy_oid INT, soft_treshold INT, active INT, blocked INT, notified INT, last_blocked_time INT, notify_soft_oid INT, notify_hard_oid INT, notify_return_oid INT, notify_soft_self INT, notify_hard_self INT, notify_return_self INT, h_in BIGINT NULL, h_out BIGINT NULL, h_sum BIGINT NULL, d_in BIGINT NULL, d_out BIGINT NULL, d_sum BIGINT NULL, w_in BIGINT NULL, w_out BIGINT NULL, w_sum BIGINT NULL, m_in BIGINT NULL, m_out BIGINT NULL, m_sum BIGINT NULL, t_in BIGINT NULL, t_out BIGINT NULL, t_sum BIGINT NULL)");
				if (PQresultStatus(res) != PGRES_COMMAND_OK) {
					aLog(D_WARN, "postgres create table 'quota' failed: %s\n", PQerrorMessage(conn));
                                        return NULL;
                                }
                                PQclear(res);
                                res = PQexec(conn,"CREATE INDEX quota_unit_oid_idx ON quota(unit_oid)");
                                aLog(D_INFO, "postgres table 'quota' created\n");
                        }
                        PQclear(res);
			break;
		default:
			break;
	}

//	debug = fopen("/tmp/trace.out","a"); 
//     PQtrace(conn, debug);  

	aDebug(DEBUG_STORAGE, "POSTGRESQL DB:%d opened [%s] for %s\n", s->instance, pg_dbname, st_conn);
	
	res=PQexec(conn,"COMMIT");PQclear(res);
	res=PQexec(conn,"BEGIN");PQclear(res);
	
	return (void*)conn;
}

//////////////////////////////////////////////////////////////////////////
void pg_stCloseSql(Service *s,void *conn){

	PGresult *res;

	if(PQstatus((PGconn*)conn) == CONNECTION_OK) {
		res=PQexec((PGconn*)conn,"END");
		PQclear(res);
	}
	PQfinish((PGconn*)conn);
	
	aDebug(DEBUG_STORAGE, "POSTGRESQL DB:%d closed\n", s->instance);
}

//////////////////////////////////////////////////////////////////////////
unsigned pg_stSaveSql(Service *s, Message *msg){

	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	
	PGresult  *res;
        PGconn *conn;

	char *query=cfg->query;
	char *i;
	NetUnit *u;

	switch (msg->prefix){
		case 'F':
			if(!cfg->fd1) {
                                cfg->fd1=stOpenSql(s,ST_CONN_RAW);
                                if(!cfg->fd1) {
                                        return 0;
                                }
                        }
			conn=(PGconn*)cfg->fd1;

			u=Units.getUnitById(msg->netunit);
			snprintf(query, 254, "INSERT INTO raw VALUES (%d, %d, %ld, %ld, %qu, %qu,nextval('raw_id_seq') , '%s')", msg->netunit, msg->ap, (unsigned long)msg->data.from, (unsigned long)msg->data.to, msg->data.in, msg->data.out, u->name?u->name:"<\?\?>");
			
			res = PQexec(conn,query);
			if (PQresultStatus(res) != PGRES_COMMAND_OK ) {PQclear(res); return 0;}
			i=PQcmdTuples(res);
			aDebug(DEBUG_STORAGE, "SQL->HDD/raw(F) query %d bytes, affected: %s\n", strlen(query), i);
			PQclear(res);
			break;

		case 'T':
		case 'M':
		case 'W':
		case 'D':
		case 'H':
			if(!cfg->fd2) {
                                cfg->fd2=stOpenSql(s,ST_CONN_SUMMARY);
                                if(!cfg->fd2) {
                                        return 0;
                                }
                        }
			conn=(PGconn*)cfg->fd2;
			snprintf(query, 254, "UPDATE summary SET bytes_in=%qu, bytes_out=%qu WHERE (prefix='%c' AND unit_oid=%d AND policy_oid=%d AND t_from=%ld)", msg->data.in, msg->data.out, msg->prefix, msg->netunit, msg->ap, (unsigned long)msg->data.from);
			res = PQexec(conn,query); 
			if (PQresultStatus(res) != PGRES_COMMAND_OK ) {PQclear(res); return 0;}
                        i=PQcmdTuples(res);
			aDebug(DEBUG_STORAGE, "SQL->HDD/summary(%c) query %d bytes, affected: %s\n", msg->prefix, strlen(query), i);	
			// aDebug(DEBUG_STORAGE, "%d %s\n", i, query); 
			if (!strcmp(i,"0")) { // update failed!
				PQclear(res);
				snprintf(query, 254, "INSERT INTO summary VALUES ('%c', %d, %d, %ld, %qu, %qu)", msg->prefix, msg->netunit, msg->ap, (unsigned long)msg->data.from, msg->data.in, msg->data.out);
				res = PQexec(conn,query);
				if (PQresultStatus(res) != PGRES_COMMAND_OK ) {PQclear(res); return 0;}
				i=PQcmdTuples(res);
				aDebug(DEBUG_STORAGE, "SQL->HDD/summary(%c) query %d bytes, affected: %s\n", msg->prefix, strlen(query), i);
			}
			PQclear(res);
			break;
		}
return 1;
}
//////////////////////////////////////////////////////////////////////////
unsigned pg_stLoadSql(Service *s, Message *msg){
	msg->id=s->instance;
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	PGresult  *res;
        PGconn *conn;
	
	char *query=cfg->query;
	
	pstat *cps;
	
	if (msg->pdata)  // assuming type is READ, fill this unit policy data field on policy apply (startup)
		switch (msg->prefix){
			case 'T': cps=&(msg->pdata->t); break;
			case 'M': cps=&(msg->pdata->m); break;
			case 'W': cps=&(msg->pdata->w); break;
			case 'D': cps=&(msg->pdata->d); break;
			case 'H': cps=&(msg->pdata->h); break;
			case 'F': cps=&(msg->pdata->flow); break;
			}
	else cps=&(msg->data);	// pdata is NULL, reading a raw data while program is running

	if (msg->prefix=='F') {
			if(!cfg->fd1) {
                                cfg->fd1=stOpenSql(s,ST_CONN_RAW);
                                if(!cfg->fd1) {
                                        return 0;
                                }
                        }
			conn = (PGconn*)cfg->fd1;
			snprintf(query, 254, "SELECT bytes_in, bytes_out FROM raw WHERE unit_oid=%d AND policy_oid=%d AND t_from=%ld AND t_to=%ld", msg->netunit, msg->ap, (unsigned long)cps->from, (unsigned long)cps->to);
		} else if (msg->prefix=='T') {
			if(!cfg->fd2) {
                                cfg->fd2=stOpenSql(s,ST_CONN_SUMMARY);
                                if(!cfg->fd2) {
                                        return 0;
                                }
                        }
                        conn=(PGconn*)cfg->fd2;
			snprintf(query, 254, "SELECT bytes_in, bytes_out, t_from FROM summary WHERE prefix='T' AND unit_oid=%d AND policy_oid=%d", msg->netunit, msg->ap);
		} else {
			if(!cfg->fd2) {
                                cfg->fd2=stOpenSql(s,ST_CONN_SUMMARY);
                                if(!cfg->fd2) {
                                        return 0;
                                }
                        }
                        conn=(PGconn*)cfg->fd2;
			snprintf(query, 254, "SELECT bytes_in, bytes_out FROM summary WHERE prefix='%c' AND unit_oid=%d AND policy_oid=%d AND t_from=%ld", msg->prefix, msg->netunit, msg->ap, (unsigned long)cps->from);
		}
	
	res=PQexec(conn,query);
	if(PQresultStatus(res) == PGRES_TUPLES_OK) {
		if(PQntuples(res)) {		
			sscanf(PQgetvalue(res,0,0), "%qu", &cps->in); 
			sscanf(PQgetvalue(res,0,1), "%qu", &cps->out);
			if (msg->prefix=='T') sscanf(PQgetvalue(res,0,2), "%ld", &cps->from);
		}
	} else {PQclear(res); return 0;}
	PQclear(res);
	aDebug(DEBUG_STORAGE, "SQL<-HDD/%c query %d bytes, fr=%ld in=%qu out=%qu\n", msg->prefix, strlen(query), cps->from, cps->in, cps->out);
	return 1;
}

//////////////////////////////////////////////////////////////////////////
unsigned pg_stStatSql(Service *s, Message *msg){
	msg->id=s->instance;

	PGconn *conn;
	if(!(conn=(PGconn*)stOpenSql(s,ST_CONN_SUMMARY))) return 0;

	policy_data *pd;
	NetUnit *u;
	int i;

	u=Units.getUnitById(msg->netunit);
	if (!u) return 1;

	msg->stat->num_policies=u->ap.num_policies;

	switch (msg->prefix){
		case 'D':
                        msg->stat->num_points=24;
                        break;
		case 'W':
			msg->stat->num_points=24*7;
			break;
		case 'M':
			msg->stat->num_points=24*31;
			break;
		default:
			return 1;
	}
	
	msg->stat->in =(unsigned long long*)aMalloc((sizeof (unsigned long long))*msg->stat->num_points*msg->stat->num_policies);
	msg->stat->out=(unsigned long long*)aMalloc((sizeof (unsigned long long))*msg->stat->num_points*msg->stat->num_policies);
	for (pd=u->ap.root, i=0; pd!=NULL; pd=pd->next, i++) {
		if(!pg_stStatSql_p(msg->stat, msg->prefix, conn, i, msg->netunit, pd->policy->id, msg->stat->num_points)) {
			stCloseSql(s,conn);
			return 0;
		}
	}
	stCloseSql(s,conn);
	return 1;
}
//////////////////////////////////////////////////////////////////////////
unsigned pg_stStatSql_p(stat_data *s, char prefix, PGconn *conn, int i, oid u, oid p, unsigned points){
	char query[255];
	PGresult *res;
	
	int row;	
	
	pstat tmp;
	unsigned j;
	unsigned long a;

	a=time(NULL)-points*60*60;

	for (j=0; j<points; j++) {
		s->in[i*points+j]=0;
		s->out[i*points+j]=0;
	}

	snprintf(query, 254, "SELECT DISTINCT t_from, bytes_in, bytes_out FROM summary WHERE prefix='H' AND unit_oid=%u AND policy_oid=%u AND t_from>%u)", u, p, a);

	res=PQexec(conn, query);
        if(PQresultStatus(res) == PGRES_TUPLES_OK) {
                for(row=0;row < PQntuples(res); row++) {
                        sscanf(PQgetvalue(res,row,0), "%lu", &tmp.from);
                        sscanf(PQgetvalue(res,row,1), "%qu", &tmp.in);
                        sscanf(PQgetvalue(res,row,2), "%qu", &tmp.out);
			j=(unsigned)((tmp.from-a)/3600);
			if(j>=points) continue; //this should't be
//                      printf("j=%u ", j);
                        s->in[i*points+j]=tmp.in;
                        s->out[i*points+j]=tmp.out;
		}
        } else {PQclear(res); return 0;}
        PQclear(res);
	aDebug(DEBUG_STORAGE, "SQL<-HDD/%c pd=%d query STAT %d bytes\n%s\n", prefix, i, strlen(query), query);
	return 1;
}
//////////////////////////////////////////////////////////////////////////
void pg_stMonitorToSql(Monitor_cfg *cfg, time_t t, unsigned msec, NetUnit *u, struct ip *ip, unsigned long len){
	
	PGconn *conn=(PGconn*)cfg->fd;
	PGresult *res;
	char *query=cfg->query;
	char *i;
	struct tcphdr *th;
	
	th=(struct tcphdr *)((unsigned char *)ip + ip->ip_hl*4);

	snprintf(query, 254, "INSERT INTO monitor VALUES (%ld, %u, '%s', %u, %u, %lu, %u, %lu, %u, %lu)", (unsigned long)t, msec, u->name?u->name:"<\?\?>", u->id, ip->ip_p, (unsigned long)ntohl(ip->ip_src.s_addr), ntohs(th->th_sport), (unsigned long)ntohl(ip->ip_dst.s_addr), ntohs(th->th_dport), len);
	res = PQexec(conn,query);
	i=PQcmdTuples(res);
	aDebug(DEBUG_STORAGE, "SQL->HDD/monitor query %d bytes, affected: %s\n", strlen(query), i);
        PQclear(res);

        if(cfg->commit==100) {
                res=PQexec(conn,"COMMIT");PQclear(res);
                res=PQexec(conn,"BEGIN");PQclear(res);
                cfg->commit=0;
        }
        cfg->commit++;
}
//////////////////////////////////////////////////////////////////////////
void pg_stLgObtainDbData(Login_cfg *cfg, NetUnit *u){
        char *query=cfg->query;
	PGresult  *res;
        PGconn *conn=(PGconn*)cfg->fd;

        snprintf(query, 255, "SELECT * from login where unit_oid=%d", u->id);
	res=PQexec(conn,query);
	if(PQresultStatus(res) != PGRES_TUPLES_OK) {
                aLog(D_WARN, "postgres select login failed: %s\n", PQerrorMessage(conn));
                return;
        }

        if(PQntuples(res)) {
               	if (!u->logindata) u->logindata = (sLoginData*)aMalloc(sizeof(sLoginData));
                aFree(u->logindata->password); 
		u->logindata->password=set_string(PQgetvalue(res,0,1));
                sscanf(PQgetvalue(res,0,2), "%ld", &u->logindata->inact);
                sscanf(PQgetvalue(res,0,3), "%ld", &u->logindata->abs);
                sscanf(PQgetvalue(res,0,5), "%ld", &u->logindata->opened);
                sscanf(PQgetvalue(res,0,6), "%d", &u->logindata->ip_from.s_addr);
                memcpy(&u->logindata->mac_from, ether_aton(PQgetvalue(res,0,7)), sizeof (struct ether_addr));
                sscanf(PQgetvalue(res,0,8), "%d", &u->logindata->d_state);
                sscanf(PQgetvalue(res,0,9), "%d", &u->logindata->c_state);
                sscanf(PQgetvalue(res,0,10), "%d", &u->logindata->strict);

               	aDebug(DEBUG_LOGIN, "Unit: %06X inact %ld abs %ld def:%d curr:%d st:%d\n", u->id, u->logindata->inact, u->logindata->abs, u->logindata->d_state, u->logindata->c_state, u->logindata->strict);
        } else aDebug(DEBUG_LOGIN, "Unit: %06X login entry was not found\n", u->id);
	PQclear(res);
}
//////////////////////////////////////////////////////////////////////////
void pg_stLgSetCfg(NetUnit *u, void *fd) {
        char query[256];
	PGresult  *res;
        PGconn *conn=(PGconn*)fd;

        snprintf(query, 255, "UPDATE login SET password='%s',inact=%u abs=%u,last_changed=%u, last_opened_time=%u,last_opened_ip=%u, last_opened_mac='%s',def_state=%d,curr_state=%d,strict=%d WHERE unit_oid=%d;", u->logindata->password?u->logindata->password:"", u->logindata->inact, u->logindata->abs, time(NULL), u->logindata->opened, u->logindata->ip_from.s_addr, ether_ntoa(&u->logindata->mac_from), u->logindata->d_state, u->logindata->c_state, u->logindata->strict, u->id);

        res=PQexec(conn,query);
	char *i=PQcmdTuples(res);
	aDebug(DEBUG_STORAGE, "SQL->HDD/login(UPDATE) query %d bytes, affected: %s\n", strlen(query), i);

	if (!strcmp(i,"0")) { // update failed!
        	PQclear(res);
		snprintf(query, 255, "INSERT INTO login VALUES(%d,'%s',%ld,%ld,%ld,%ld,%d,'%s',%d,%d,%d);", u->id, u->logindata->password?u->logindata->password:"", (unsigned long)u->logindata->inact, (unsigned long)u->logindata->abs, (unsigned long)time(NULL), (unsigned long)u->logindata->opened, u->logindata->ip_from.s_addr, ether_ntoa(&u->logindata->mac_from), u->logindata->d_state, u->logindata->c_state, u->logindata->strict);
		res = PQexec(conn,query);
                if (PQresultStatus(res) != PGRES_COMMAND_OK ) {PQclear(res); return ;}
		i=PQcmdTuples(res);
                aDebug(DEBUG_STORAGE, "SQL->HDD/login(INSERT) query %d bytes, affected: %s\n", strlen(query), i);
	}
	PQclear(res);
}
//////////////////////////////////////////////////////////////////////////
void pg_stQuObtainDbData(Quota_cfg *cfg, NetUnit *u){
        char *query=cfg->query;
        sQuotaData *q;
        PGresult  *res;
        PGconn *conn=(PGconn*)cfg->fd;

        snprintf(query, 255, "SELECT * from quota where unit_oid=%d", u->id);
        aDebug(DEBUG_QUOTA, "sQuObtainDbData query: '%s'\n", query);
        
	res=PQexec(conn,query);
        if(PQresultStatus(res) != PGRES_TUPLES_OK) {
                aLog(D_WARN, "postgres select quota failed: %s\n", PQerrorMessage(conn));
                return;
        }

       if(PQntuples(res)) {
                if (!u->quotadata) u->quotadata = (sQuotaData*)aMalloc(sizeof(sQuotaData));
                q=u->quotadata;
                oid id;
                sscanf(PQgetvalue(res,0,1), "%d", &id); q->policy=PolicyL.getPolicyById(id);
                sscanf(PQgetvalue(res,0,3), "%d", &q->soft_treshold);
                sscanf(PQgetvalue(res,0,4), "%d", &q->active);
                sscanf(PQgetvalue(res,0,5), "%d", &q->blocked);
                sscanf(PQgetvalue(res,0,6), "%d", &q->notified);
                sscanf(PQgetvalue(res,0,7), "%ld", &q->blocked_time);

                sscanf(PQgetvalue(res,0,8), "%d", &q->nso);
                sscanf(PQgetvalue(res,0,9), "%d", &q->nho);
                sscanf(PQgetvalue(res,0,10), "%d", &q->nro);

                sscanf(PQgetvalue(res,0,11), "%d", &q->nss);
                sscanf(PQgetvalue(res,0,12), "%d", &q->nhs);
                sscanf(PQgetvalue(res,0,13), "%d", &q->nrs);

                sscanf(PQgetvalue(res,0,14), "%qu", &q->h.in);
                sscanf(PQgetvalue(res,0,15), "%qu", &q->h.out);
                sscanf(PQgetvalue(res,0,16), "%qu", &q->h.sum);

                sscanf(PQgetvalue(res,0,17), "%qu", &q->d.in);
                sscanf(PQgetvalue(res,0,18), "%qu", &q->d.out);
                sscanf(PQgetvalue(res,0,19), "%qu", &q->d.sum);

                sscanf(PQgetvalue(res,0,20), "%qu", &q->w.in);
                sscanf(PQgetvalue(res,0,21), "%qu", &q->w.out);
                sscanf(PQgetvalue(res,0,22), "%qu", &q->w.sum);

                sscanf(PQgetvalue(res,0,23), "%qu", &q->m.in);
                sscanf(PQgetvalue(res,0,24), "%qu", &q->m.out);
                sscanf(PQgetvalue(res,0,25), "%qu", &q->m.sum);

                sscanf(PQgetvalue(res,0,26), "%qu", &q->t.in);
                sscanf(PQgetvalue(res,0,27), "%qu", &q->t.out);
                sscanf(PQgetvalue(res,0,28), "%qu", &q->t.sum);

                aDebug(DEBUG_QUOTA, "Unit: %06X soft %d act %d blo %d notif %d\n", u->id, q->soft_treshold, q->active,q->blocked, q->notified);
	} else aDebug(DEBUG_QUOTA, "Unit: %06X quota entry was not found\n", u->id);
	PQclear(res);
}
//////////////////////////////////////////////////////////////////////////
void pg_stQuSetCfg(NetUnit *u, void *fd) {
        char query[256];
        sQuotaData *q;
	PGresult  *res;
        PGconn *conn=(PGconn*)fd;

        q=u->quotadata;
        snprintf(query, 512, "UPDATE quota SET policy_oid=%d,syspolicy_oid=0,soft_treshold=%d,active=%d,blocked=%d,notified=%d,last_blocked_time=%d,notify_soft_oid=%d,notify_hard_oid=%d,notify_return_oid=%d,notify_soft_self=%d,notify_hard_self=%d,notify_return_self=%d,h_in=%qu,h_out=%qu,h_sum=%qu,d_in=%qu,d_out=%qu,d_sum=%qu,w_in=%qu,w_out=%qu,w_sum=%qu,m_in=%qu,m_out=%qu,m_sum=%qu,t_in=%qu,t_out=%qu,t_sum=%qu WHERE unit_oid=%d ;", q->policy->id,/*syspolicy,*/q->soft_treshold, q->active, q->blocked, q->notified, q->blocked_time, q->nso, q->nho, q->nro, q->nss, q->nhs, q->nrs, q->h.in,q->h.out,q->h.sum, q->d.in,q->d.out,q->d.sum, q->w.in,q->w.out,q->w.sum, q->m.in,q->m.out,q->m.sum, q->t.in,q->t.out,q->t.sum,u->id);

      	res=PQexec(conn,query);
        char *i=PQcmdTuples(res);
        aDebug(DEBUG_STORAGE, "SQL->HDD/quotA(UPDATE) query %d bytes, affected: %s\n", strlen(query), i);
        aDebug(DEBUG_QUOTA, "sQuSetCfg query: '%s'\n", query);
        if (!strcmp(i,"0")) { // update failed!
        	PQclear(res);
		snprintf(query, 512, "INSERT INTO quota values(%d,%d,0,%d,%d,%d,%d,%ld,%d,%d,%d,%d,%d,%d,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu,%qu);", u->id, q->policy->id,/*syspolicy,*/q->soft_treshold, q->active, q->blocked, q->notified, (unsigned long)q->blocked_time, q->nso, q->nho, q->nro, q->nss, q->nhs, q->nrs, q->h.in,q->h.out,q->h.sum, q->d.in,q->d.out,q->d.sum, q->w.in,q->w.out,q->w.sum, q->m.in,q->m.out,q->m.sum, q->t.in,q->t.out,q->t.sum);
		res = PQexec(conn,query);
                if (PQresultStatus(res) != PGRES_COMMAND_OK ) {PQclear(res); return ;}
                i=PQcmdTuples(res);
                aDebug(DEBUG_STORAGE, "SQL->HDD/quota(INSERT) query %d bytes, affected: %s\n", strlen(query), i);
        }
	PQclear(res);
}
//////////////////////////////////////////////////////////////////////////
#endif
//////////////////////////////////////////////////////////////////////////
