/*************************************************************************
***     Authentication, authorization, accounting + firewalling package
***     (c) 1998-2003 Anton Vinokurov <anton@netams.com>
***		(c) 2003 NeTAMS Development Team
***		All rights reserved. See 'Copying' file included in distribution
***		For latest version and more info, visit this project web page
***		located at http://www.netams.com
***		 					
*************************************************************************/
/* $Id: users.h,v 1.6.2.1 2004/05/06 10:35:07 jura Exp $ */

// user modes definition
enum user_mode { USER_HUMAN, USER_DATASOURCE, USER_STORAGE };

//////////////////////////////////////////////////////////////////////////
class User {
	public:
		char *real_name;
		char *name;
		char *email;
		char *password;
		char *crypted;
		unsigned permissions;
		int hidden;
		oid id;
		User(char *name, int hidden=0);
		~User();
		User *next;
		user_mode mode;

		void setName(char *s);
		void setRealName(char *s);
		void setEmail(char *s);
		void setPassword(char *s);
		void setCrypted(char *s);
		void setPermissions(char *s);
		unsigned getPermissions();
		};

//////////////////////////////////////////////////////////////////////////
class UsersList {
	private:
		User *root;
		User *last;
		unsigned num_users;
		pthread_mutex_t *lock;
	public:
		int changed_pw;
		int changed_user;
		UsersList();
		~UsersList();
		void Insert(User *s);
		void Delete(char *name);
		void Delete(User *s);
		User *getUser(char *name);
		User *getUserById(oid id);
		void listUsers(Connection *conn);
		void listUsersCfg(FILE *f);
		void listUsersHtml(Connection *conn);
		void listPasswordsHtml(Connection *conn);
		unsigned getUsers() { return num_users; }
		};

//////////////////////////////////////////////////////////////////////////
unsigned cUser(Connection *conn, char *param[], int no_flag);
unsigned cShowUsers(Connection *conn);
