#!/bin/sh
# $Id: versions.sh,v 1.5.2.1 2004/05/06 12:23:43 jura Exp $ 

build_hostname=`hostname -s`
current_v=`cat versions_build.dat`
next_v=$current_v
next_v_l=0;

if [ $build_hostname != "srv" -a $build_hostname != "notebook" -a $build_hostname != "test" ]; then
	if [ -r versions_build_local.dat ]; then
		current_v_l=`cat versions_build_local.dat`
	else
		current_v_l=0;
	fi
	next_v_l=$((1+$current_v_l))
	echo $next_v_l > versions_build_local.dat

else
	next_v=$((1+$current_v))
	next_v_l=0;
	rm -rf versions_build_local.dat 
	echo $next_v > versions_build.dat
fi
	


build_date=`date`
build_person=`whoami`@`hostname -s`

echo "const unsigned int aaa_fw_build_version=$next_v;" > versions_build.c
echo "const unsigned int aaa_fw_build_version_local=$next_v_l;" >> versions_build.c
echo "const char aaa_fw_build_time[]=\"$build_date\";" >> versions_build.c
echo "const char aaa_fw_build_person[]=\"$build_person\";" >> versions_build.c
if [ "$1" != "" ]; then
	echo "const char path_to_config[]=\"$1\";" >> versions_build.c
	else 
	echo "const char path_to_config[]=\"/usr/local/etc/netams.cfg\";" >> versions_build.c
fi
if [ "$2" != "" ]; then
	echo "const char path_to_log[]=\"$2\";" >> versions_build.c
	else 
	echo "const char path_to_log[]=\"/var/log/netams.log\";" >> versions_build.c
fi
echo "linking for version $next_v.$next_v_l"
rm -rf versions_build.o
cc -c versions_build.c
