geometry = ngsolve/pde_tutorial/beam.geo
mesh = ngsolve/pde_tutorial/beam.vol

define constant heapsize = 100000000

define coefficient e
1e11,

define coefficient nu
0.2,

define coefficient penalty
1e30, 0, 0, 

define coefficient coef_force_z
0, 5e7, 0,

define fespace v -order=3 -dim=3
define gridfunction u -fespace=v -nested
define gridfunction ulin -fespace=v -nested

define fespace vstress -h1ho -order=2 -dim=6
define gridfunction stress -fespace=vstress

define bilinearform alin -fespace=v -symmetric
elasticity e nu
robin penalty -comp=1
robin penalty -comp=2
robin penalty -comp=3

define bilinearform a -fespace=v -symmetric
nonlinmech e nu
robin penalty -comp=1
robin penalty -comp=2
robin penalty -comp=3

define linearform f -fespace=v
neumann coef_force_z -comp=3

define preconditioner c -type=direct -bilinearform=alin

numproc bvp np1lin -bilinearform=alin -linearform=f -gridfunction=ulin -preconditioner=c 
numproc nonlinelast np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=100

numproc drawflux np2 -bilinearform=a -solution=u -label=elstre