#ifndef FILE_EVCOARSE
#define FILE_EVCOARSE

/*********************************************************************/
/* File:   evcoarse.hh                                               */
/* Author: Joachim Schoeberl                                         */
/* Date:   5. Nov. 2000                                             */
/*********************************************************************/

/** 
   Coarse Grid preconditioner finding a few EV
*/

class EVCoarseGrid : public BaseMatrix
{
  ///
  const Smoother & smoother;
  ///
  ARRAY<ngla::BaseVector*> vecs;
  ///
  ngla::BaseMatrix * invlocmat;
public:
  ///
  EVCoarseGrid (const ngla::BaseMatrix & mat, const Smoother & sm,
		const ARRAY<ngla::BaseVector*> & coarsevecs,
		int maxv, double maxits);
  
  ///
  virtual void Mult (const ngla::BaseVector & x, ngla::BaseVector & y) const;

  ///
  virtual ngla::BaseVector * CreateVector () const
  { return smoother.CreateVector(1); }
  
  ///
  const ARRAY<ngla::BaseVector*> & GetVectors () const
    { return vecs; }
};

#endif
