Ng_Vis_Set parameters



set viscnt 0
proc snapshottimer { } {
    after 2000 { snapshottimer }

    global viscnt
    set viscnt [expr $viscnt+1]
    set s1 0000$viscnt
#    puts $s1
    set cnt [string range $s1 [expr [string length $s1]-4] end]
    set filename "p$cnt.jpg"
#    puts "cnt = $cnt"
#    puts "filename = $filename"
#    .ndraw Ng_SnapShot pictures/$filename
}
snapshottimer



proc redrawtimer { } {
    global visoptions.autoredraw
    global visoptions.autoredrawtime

    set delay [expr int(${visoptions.autoredrawtime}*1000)]
    if { ${visoptions.autoredraw} == 1 } { redraw; }
    after $delay { redrawtimer } 
}
redrawtimer


set perstarttime [clock clicks -millisecond]
proc redrawperiodic { } {
    global visoptions.redrawperiodic
    global perstarttime
    set curtime [clock clicks -millisecond]
#    puts "redraw periodic, time = $curtime"
    Ng_Vis_Set time [expr ($curtime - $perstarttime) / 5]
    redraw
    if { ${visoptions.redrawperiodic} == 1 } { after 100 { redrawperiodic } };

}

proc visual_dialog { } {

    set w .visoptions_dlg

    if {[winfo exists .visoptions_dlg] == 1} {
	wm withdraw $w
	wm deiconify $w
	focus $w
    } {

	toplevel $w

	checkbutton $w.imaginary -text "Imaginary Part" \
	    -variable visoptions.imaginary \
	    -command { Ng_Vis_Set parameters; redraw }

	checkbutton $w.usetexture -text "Use Textures" \
	    -variable visoptions.usetexture \
	    -command { Ng_Vis_Set parameters; redraw }
	
	checkbutton $w.invcolor -text "Inverse Color" \
	    -variable visoptions.invcolor \
	    -command { Ng_Vis_Set parameters; redraw }
	
	checkbutton $w.redrawperiodic -text "Animate periodic" \
	    -variable visoptions.redrawperiodic \
	    -command { 
		redrawperiodic
		Ng_Vis_Set parameters; 
		redraw 
	    }
	

	frame $w.fieldlines  -relief groove -borderwidth 3
	checkbutton $w.fieldlines.enable -text "Field-lines" \
	    -variable visoptions.drawfieldlines \
	    -command { 
		# set visoptions.redrawperiodic ${visoptions.drawfieldlines}
		# redrawperiodic
		# redrawperiodic # sonst 
		Ng_Vis_Set parameters; 
		redraw 
	    }
	tixControl $w.fieldlines.num -label "Num: " -integer true \
	    -variable visoptions.numfieldlines \
	    -command { Ng_Vis_Set parameters; redraw } \
	    -options {
		entry.width 6
		label.width 12
		label.anchor e
	    }	

	checkbutton $w.fieldlines.randomstart -text "Random start" \
	    -variable visoptions.fieldlinesrandomstart \
	    -command { Ng_Vis_Set parameters; redraw}

	checkbutton $w.logscale -text "Log Scale" \
	    -variable visoptions.logscale \
	    -command { Ng_Vis_Set parameters; redraw }
	
	checkbutton $w.lineartexture -text "Use Linear Texture" \
	    -variable visoptions.lineartexture \
	    -command { Ng_Vis_Set parameters; redraw }
	
	scale $w.numcols -orient horizontal -length 100 -from 0 -to 50 \
	    -resolution 1   \
	    -variable  visoptions.numtexturecols \
	    -command { Ng_Vis_Set parameters; redraw }

	checkbutton $w.showclipsolution -text "Draw Clipping Plane Solution" \
	    -variable visoptions.showclipsolution \
	    -command { Ng_Vis_Set parameters; redraw }

	checkbutton $w.showsurfsolution -text "Draw Surface Solution" \
	    -variable visoptions.showsurfacesolution \
	    -command { Ng_Vis_Set parameters; redraw }



	frame $w.grid -relief groove -borderwidth 3
	# change to: max gridsize 200
	scale $w.grid.size -orient horizontal -length 100 -from 1 -to 200 \
	    -label "Grid" \
	    -resolution 1    \
	    -variable  visoptions.gridsize \
	    -command { Ng_Vis_Set parameters; redraw }

	# x- and y- offset
	scale $w.grid.xoffset -orient horizontal -length 80 -from 0 -to 1 \
	    -label "x-Offset" \
	    -resolution 0.05    \
	    -variable  visoptions.xoffset \
	    -command { Ng_Vis_Set parameters; redraw }

	scale $w.grid.yoffset -orient horizontal -length 80 -from 0 -to 1 \
	    -label "y-Offset" \
	    -resolution 0.05    \
	    -variable  visoptions.yoffset \
	    -command { Ng_Vis_Set parameters; redraw }


	# pack $w.showclipsolution 
	pack $w.showsurfsolution
	pack $w.grid -fill x -ipady 3
	pack $w.grid.size $w.grid.xoffset $w.grid.yoffset -side left -expand yes



	#	pack $w.lineartexture $w.numcols 



	frame $w.deform -relief groove -borderwidth 3
	checkbutton $w.deform.cb -text "Deformation" \
	    -variable visoptions.deformation \
	    -command { Ng_Vis_Set parameters; redraw }

	tixControl $w.deform.sc1 -label "Scale: " -integer false \
	    -variable visoptions.scaledeform1 \
	    -command { Ng_Vis_Set parameters; redraw } \
	    -options {
		entry.width 6
		label.width 7
		label.anchor e
	    }	

	scale $w.deform.sc2 -orient horizontal -length 100 -from 0 -to 1 \
	    -resolution 0.01    \
	    -variable  visoptions.scaledeform2 \
	    -command { Ng_Vis_Set parameters; redraw }

	pack $w.deform -fill x -ipady 2
	pack $w.deform.cb $w.deform.sc1 $w.deform.sc2 -side left -expand yes
	

	frame $w.as -relief groove -borderwidth 3
	checkbutton $w.as.autoscale -text "Autoscale" \
	    -variable visoptions.autoscale \
	    -command { Ng_Vis_Set parameters; redraw }

	tixControl $w.as.minval -label "Min-value: " -integer false \
	    -variable visoptions.mminval \
	    -command { Ng_Vis_Set parameters; redraw } \
	    -options {
		entry.width 6
		label.width 12
		label.anchor e
	    }	
	tixControl $w.as.maxval -label "Max-value: " -integer false \
	    -variable visoptions.mmaxval \
	    -command { Ng_Vis_Set parameters; redraw } \
	    -options {
		entry.width 6
		label.width 12
		label.anchor e
	    }	

	pack $w.as -fill x -ipady 3
	pack $w.as.autoscale $w.as.minval $w.as.maxval -side left

	checkbutton $w.lintexture -text "Linear Texture" \
	    -variable visoptions.lineartexture \
	    -command { Ng_Vis_Set parameters; redraw }
	pack $w.lintexture




	frame $w.iso -relief groove -borderwidth 3
	checkbutton $w.iso.isolines -text "Iso-lines" \
	    -variable visoptions.isolines \
	    -command { Ng_Vis_Set parameters; redraw }

	scale $w.iso.numiso -orient horizontal -length 100 -from 2 -to 50 \
	    -label "" \
	    -resolution 1    \
	    -variable  visoptions.numiso \
	    -command { Ng_Vis_Set parameters; redraw }

	pack $w.iso -fill x -ipady 3
	pack $w.iso.isolines $w.iso.numiso -side left


	scale $w.iso.subdiv -orient horizontal -length 100 -from 0 -to 5 \
	    -label "subdivision" \
	    -resolution 1    \
	    -variable  visoptions.subdivisions \
	    -command { Ng_Vis_Set parameters; redraw }
# ; Ng_SetNextTimeStamp
	pack $w.iso.subdiv $w.iso.numiso -side left


#	scale $w.iso.zpos -orient horizontal -length 100 -from 0 -to 1 \
#	    -label "z-position" \
#	    -resolution 0.01 \
#	    -variable visoptions.zposition \
#	    -command {
#		catch {NGS_Set zpos ${visoptions.zposition};}
#		redraw }
#	pack $w.iso.zpos -side right



	frame $w.redraw -relief groove -borderwidth 3
	checkbutton $w.redraw.auto -text "Auto-redraw" \
	    -variable visoptions.autoredraw 

	tixControl $w.redraw.val -label " after (sec) " -integer false \
	    -variable visoptions.autoredrawtime \
	    -options {
		entry.width 6
		label.width 0
		label.anchor w
	    }	

	pack $w.redraw -fill x -ipady 3
	pack $w.redraw.auto  $w.redraw.val -side left

	
	tixControl $w.redraw.simtime -label " Simulation Time (1e-6 s)" -integer false \
	    -variable visoptions.simulationtime \
	    -command { 
		Ng_Vis_Set time ${visoptions.simulationtime}; 
		catch {NGS_Set time ${visoptions.simulationtime};}
		redraw } \
	    -options {
		entry.width 6
		label.width 0
		label.anchor w
	    }	
	pack $w.redraw.simtime -side left
	



	tixOptionMenu $w.clipsol -label "Clipping Plane Sol: " \
	    -options {
		label.width  18
		label.anchor e
		menubutton.width 12
	    }

	set none 1
	$w.clipsol add command none -label None
	$w.clipsol add command scal -label "Scalar Function"
	$w.clipsol add command vec -label "Vector Function"

	$w.clipsol configure -variable visoptions.clipsolution
	$w.clipsol configure -command { Ng_Vis_Set parameters; redraw }

	pack $w.clipsol



	tixOptionMenu $w.scalfun -label "Scalar Function: " \
	    -options {
		label.width  18
		label.anchor e
		menubutton.width 12
	    }

	tixOptionMenu $w.vecfun -label "Vector Function: " \
	    -options {
		label.width  18
		label.anchor e
		menubutton.width 12
	    }


	$w.scalfun add command none -label None
	for { set i 1 } { $i <= [Ng_Vis_Field getnfieldnames] } { incr i } {
	    set fname [Ng_Vis_Field getfieldname $i]
	    set fcomp [Ng_Vis_Field getfieldcomponents $i]
	    if { $fcomp == 1 } {
		$w.scalfun add command $fname.1 -label $fname
	    } {
		for { set j 1 } { $j <= $fcomp } { incr j } {
		    $w.scalfun add command $fname.$j -label "$fname ($j)"
		}
		$w.scalfun add command $fname.0 -label "func ($fname)"
	    }
	}

	$w.vecfun add command none -label None 
	for { set i 1 } { $i <= [Ng_Vis_Field getnfieldnames] } { incr i } {
	    set fname [Ng_Vis_Field getfieldname $i]
	    set fcomp [Ng_Vis_Field getfieldcomponents $i]
	    set iscomplex [Ng_Vis_Field iscomplex $i]
	    set sdim [Ng_Vis_Field getdimension]
	    if { $iscomplex == 1 } { set fcomp [expr $fcomp / 2] }
	    if { ($fcomp == $sdim) || ($fcomp == 3) } {
		$w.vecfun add command $fname -label $fname
	    } 
	}

	$w.scalfun configure -variable visoptions.scalfunction
	$w.scalfun configure -command { Ng_Vis_Set parameters; redraw }
	$w.vecfun configure -variable visoptions.vecfunction
	$w.vecfun configure -command { Ng_Vis_Set parameters; redraw }


	# puts "sclfunction = ${visoptions.scalfunction}"


	tixOptionMenu $w.evaluate -label "Evaluate: " \
	    -options {
		label.width  18
		label.anchor e
		menubutton.width 12
	    }	
	$w.evaluate add command abs -label "|.|"
	$w.evaluate add command abstens -label "|tensor|"
	$w.evaluate add command mises -label "Mises"
	$w.evaluate add command main  -label "Main"
	$w.evaluate configure -variable visoptions.evaluate
	$w.evaluate configure -command { 
	    Ng_Vis_Set parameters; 
	    redraw 
	}

	pack $w.scalfun $w.vecfun $w.evaluate

	tixControl $w.multidimcomp -label "multidim-component: " -integer true \
	    -variable visoptions.multidimcomponent -min 0 \
	    -command { Ng_Vis_Set parameters; redraw } \
	    -options {
		entry.width 6
		label.width 18
		label.anchor e
	    }	


	pack $w.multidimcomp

	pack $w.imaginary $w.logscale $w.usetexture $w.invcolor $w.redrawperiodic
	pack $w.fieldlines 
	pack $w.fieldlines.enable $w.fieldlines.num $w.fieldlines.randomstart -side left


	




	frame $w.bu
	pack $w.bu  -pady 5

	button $w.bu.showsol -text "Show Solution" -command { 
	    set selectvisual solution
	    Ng_SetVisParameters
	    redraw
	}
	button $w.bu.clipping -text "Clipping" -command { 
	    clippingdialog; 
	}
	button $w.bu.done -text "Close" -command { 
	    destroy .visoptions_dlg
	}

	pack $w.bu.showsol $w.bu.clipping $w.bu.done -side left -expand yes

	wm withdraw $w
	wm geom $w +100+100
	wm deiconify $w
	wm title $w "Visualization"

    }
}
