#!/usr/local/bin/perl
#
# nhppf 2.0 fontmap generator
#
# $Id: mkpsfontmap.pl,v 2.4 1998/10/20 11:08:30 junker Exp $
#
# first improved, 97/5/26
# for nh2ps, 97/6/22
#
#   for HLaTeX-0.95/0.96
#   by Choi Jun Ho(junker@jazz.snu.ac.kr)
#      Narae, SNU.
#
# Todo:
#  - generate perl matrix of fontmap
#  - it has two components:
#     font index:
#      A-J: KSC5601 Composed Hangul(2350 char)
#      01-03: Hangul Johab(no fonts in HLaTeX-0.95 mode)
#      04-07: KSC5601 Symbol(no fonts in HLaTeX-0.95 mode)
#      10-29: KSC5601 Hanja(A-T in HLaTeX-0.95 mode)
#
#  - maintain compatibility for both HLaTeXs, 0.95 and 0.96(and also 0.961)
#  - output is two perl array indexed(0-32767)
#  - in real, use character index(0xa1a1-0xfefe) into this array
#  - @PSFontName, @PSFontIndex

# initialize arrays
@PSFontName=();
@PSFontIndex=();

# total array size
#  0xa1-0xfe * 0xa1-0xfe = 94 * 94 = 8836
#
for($i=0; $i<94*94; $i++){
  $PSFontName[$i]="0";
  $PSFontIndex[$i]=0;
}

# fill it

# 1. KSC5601 Hangul
for($ch1=0xb0; $ch1<=0xc8; $ch1++){
  for($ch2=0xa1; $ch2<=0xfe; $ch2++){
    $addr=($ch1*256+$ch2) & 0x7fff;
    $pos=($ch1-0xb0)*94+($ch2-0xa1);
    $fn=65+$pos/256;
    $loc=$pos%256;
    #$PSFontName[$addr]=chr($fn);
    #$PSFontIndex[$addr]=$loc;
    $PSFontName[&getaddr($addr)]=chr($fn);
    $PSFontIndex[&getaddr($addr)]=$loc;
    #printf("addr %d, pos %d, fn %s, loc %d\n", $addr, $pos, chr($fn), $loc);
  }
}

# 2. KSC5601 Hanja
for($ch1=0xca; $ch1<=0xfd; $ch1++){
  for($ch2=0xa1; $ch2<=0xfe; $ch2++){
    $addr=($ch1*256+$ch2) & 0x7fff;
    $pos=($ch1-0xca)*94+($ch2-0xa1);
    $fn=$pos/256+10;
    $loc=$pos%256;
    $PSFontName[&getaddr($addr)]=(sprintf("%02d", $fn));
    $PSFontIndex[&getaddr($addr)]=$loc;
    #printf("addr %d, pos %d, fn %02d, loc %d\n", $addr, $pos, $fn, $loc);
  }
}

# 3. Symbols
# Symbol-04
# hangul jamo
&fillsymbol(0xa4a1, 0xa4d3, "04", 0);
# won sign(?)
&fillsymbol(0xa3dc, 0xa3dc, "04", 0x33);
# hangul jamo, ancient hangul jamo
&fillsymbol(0xa4d5, 0xa4fe, "04", 0x34);
# circle chars
&fillsymbol(0xa8b1, 0xa8f5, "04", 0x5e);
# parenthese chars
&fillsymbol(0xa9b1, 0xa9f5, "04", 0xa3);

# Symbol-05
# punctuations
&fillsymbol(0xa1a2, 0xa1fe, "05", 0);
# graphical symbols
&fillsymbol(0xa2a1, 0xa2e5, "05", 0x5d);
# punctuations
&fillsymbol(0xa7a1, 0xa7ef, "05", 0xa2);

# Symbol-06
# line symbols
&fillsymbol(0xa6a1, 0xa6e4, "06", 0);
# fractions
&fillsymbol(0xa8f6, 0xa8fe, "06", 0x44);
# sub/superscripts
&fillsymbol(0xa9f6, 0xa9fe, "06", 0x4d);
# hirakana
&fillsymbol(0xaaa1, 0xaaf3, "06", 0x56);
# katakana
&fillsymbol(0xaba1, 0xabf6, "06", 0xa9);

# Symbol-07
# wide-chars(ascii equivalent)
&fillsymbol(0xa3a1, 0xa3db, "07", 0);
# wide-chars(ascii equivalent)
&fillsymbol(0xa3dd, 0xa3fe, "07", 0x3b);
# greek numbers(lower case)
&fillsymbol(0xa5a1, 0xa5aa, "07", 0x5d);
# greek numbers(upper case)
&fillsymbol(0xa5b0, 0xa5b9, "07", 0x67);
# greek alphabet(upper case)
&fillsymbol(0xa5c1, 0xa5d8, "07", 0x71);
# greek alphabet(lower case)
&fillsymbol(0xa5e1, 0xa5f8, "07", 0x89);
# other languages
&fillsymbol(0xa8a1, 0xa8af, "07", 0xa1);
# other languages(2)
&fillsymbol(0xa9a1, 0xa9b0, "07", 0xae);
# russian(upper case)
&fillsymbol(0xaca1, 0xacc1, "07", 0xbe);
# russian(lower case)
&fillsymbol(0xacd1, 0xacf1, "07", 0xdf);


# print out array

# prologue
print "/*\n";
print " * nh2ps 2.1\n";
print " *\n";
print " * A Korean version of a2ps 4.3 using PostScript font of HLaTeX\n";
print " *\n";
print " * No Copyright, 22 Jun 1997, Choi Jun Ho <junker\@jazz.snu.ac.kr>\n";
print " * \n";
print " * Thanks to author of HLaTeX-0.97 for supplying Hangul fonts\n";
print " * #ifdef HFONT -- #endif HFONT is where I changed, if there is no compile\n";
print " * option '-DHFONT', it will generate a complete a2ps without hangul support\n";
print " *\n";
print " */\n\n";
print "#ifdef HFONT\n";

# array
print "char* PSFontName[] = {\n\t";
for($i=0; $i<94*94; $i++)
{
  printf("\"%s\", ",$PSFontName[$i]);
  if ($i%10==9){
      print "\n\t";
    }
}

print "};\n";

print "int PSFontIndex[] = {\n\t";
for($i=0; $i<94*94; $i++)
{
  printf("%2d, ",$PSFontIndex[$i]);
  if ($i%10==9){
      print "\n\t";
    }
}

print "};\n";

# epilogue
print "\n#endif\n";

# subroutines
sub fillsymbol
{
  $addr=$_[0] & 0x7fff;
  $addrend=$_[1] & 0x7fff;
  $fn=$_[2];
  $fidx=$_[3];
  #print "fillsymbol(addr $idx, addrend $addrend, fn $fn, idx $idx)\n";
  
  for($idx=$addr; $idx<=$addrend; $idx++){
    $PSFontName[&getaddr($idx)]=$fn;
    $PSFontIndex[&getaddr($idx)]=$fidx+($idx-$addr);
    #print "addr $idx, fn $fn, idx $idx\n";
  }
}

sub getaddr
{
    local($ch1, $ch2);

    $ch1=($_[0]/256 | 0x80);
    $ch2=($_[0]%256 | 0x80);
    
    return ($ch1-0xa1)*94+($ch2-0xa1);
}


