/*
 *   $Id: rfc2231.c,v 1.4 2002/04/29 12:53:59 oli Exp $
 *   Made with rfc2231.c from the mutt 1.2.5 dist as reference
 *   Copyright (C) 1999-2000 Thomas Roessler <roessler@guug.de>
 *   Copyright (C) 2002 Olafur Osvaldsson
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include        <stdio.h>
#include        <ctype.h>
#include        <string.h>
#include        <stdlib.h>

#if defined(DEBUG) && defined(DMALLOC)
#include <dmalloc.h>
#endif				/* DEBUG */

static          const char rcsid[] = "$Id: rfc2231.c,v 1.4 2002/04/29 12:53:59 oli Exp $";

int             Index_hex[128] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
    -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

#define hexval(c) Index_hex[(unsigned int)(c)]

#define strfcpy(A,B,C) strncpy(A,B,C), *(A+(C)-1)=0


char           *
rfc2231_get_charset(char *value, char *charset, size_t chslen)
{
    char           *t, *u;

    if (!(t = strchr(value, '\''))) {
	charset[0] = '\0';
	return value;
    }

    *t = '\0';
    strfcpy(charset, value, chslen);

    if ((u = strchr(t + 1, '\'')))
	return u + 1;
    else
	return t + 1;
}

void
rfc2231_decode(char *dest, char *src)
{
    char           *d;

    for (d = dest; *src; src++) {
	if (*src == '%' && isxdigit(*(src + 1)) && isxdigit(*(src + 2))) {
	    *d++ = (hexval(*(src + 1)) << 4) | (hexval(*(src + 2)));
	    src += 2;
	}
	else {
	    *d++ = *src;
	}
    }

    *d = '\0';
}
