#!/bin/sh
#  $Id: check-noattach.sh,v 1.2 2002/02/13 10:28:18 oli Exp $
#  Copyright (C) 2002 Olafur Osvaldsson
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#
# This script should work to check if your noattach milter is running
# and restart it if it has crashed
#
# I run it every 5 minutes
#
# !!! Remember to change the paths if you have changed the install paths !!!
#

progname="noattach"
rundir="/tmp"
pidfile="/var/run/noattach.pid"
program="/usr/local/etc/rc.d/noattach.sh start"

########## you probably don't need to change anything below here ##########

cd $rundir
if test -r $pidfile; then
  # there is a pid file -- is it current?
  pid=`cat $pidfile`
  if `kill -CHLD $pid >/dev/null 2>&1`; then
    # it's still going
    # back out quietly
    exit 0
  fi
  echo ""
  echo "Stale pid file (erasing it)"
  rm -f $pidfile
fi
echo ""
echo "Couldn't find $progname running.  Reloading it..."
echo ""
$program
exit 0

