/*
 * regstr.c -- regular expression compare
 *
 * Copyright (c) 1995,1996 by nir@mxa.meshnet.or.jp
 *
 * This file is part of npc.cgi source tree.
 * npc.cgi is free software; you can redistribute it and/or modify it
 * for any purpose.
 *
 * @(#)$Id: regstr.c,v 2.2 1997/11/05 12:34:47 nir Rel $
 */

/*
 * $Log: regstr.c,v $
 * Revision 2.2  1997/11/05 12:34:47  nir
 * Add Copyright, Id and Log.
 *
 */

#include "npc.h"
#include "regexp.h"

void regerror(char *msg) {
	error_out("Regular Expression Error: \"%s\"", msg);
}

BOOLEAN reg_strcmp(char *exp, char *str) {
	regexp *prog;

	if ((exp == NULL) || (*exp == EOS) || (str == NULL))
		return(NO);
	if ((prog = regcomp(exp)) == NULL)
		return(NO);
	return(regexec(prog, str));
}

