/*
 * charfont.c -- default characters pixel
 *
 * Copyright (c) 1995-1997 by nir@mxa.meshnet.or.jp
 *
 * This file is part of npc.cgi source tree.
 * npc.cgi is free software; you can redistribute it and/or modify it
 * for any purpose.
 *
 * @(#)$Id: charfont.c,v 2.5 1997/12/11 14:00:49 nir Rel $
 */

/*
 * $Log: charfont.c,v $
 * Revision 2.5  1997/12/11 14:00:49  nir
 * Add left, top and disposal_method elements to struct IMAGE.
 *
 * Revision 2.4  1997/11/10 16:19:05  nir
 * Modify error_out() message.
 *
 * Revision 2.3  1997/11/05 11:26:26  nir
 * Add Copyright, Id and Log.
 * Move WIDTHLIMITS definition to npc.h.
 *
 */

#include "npc.h"

#define CHARACTER_CODE_SIZE 3
#define CHARACTER_COLOR 8
#define CHARACTER_X     7
#define CHARACTER_Y    11

INTERN unsigned char character_color_table[CHARACTER_COLOR][3] = {
	{  0,   0,   0},
	{ 24,  24,  24},
	{ 90,  90,  90},
	{132, 132, 132},
	{165, 165, 165},
	{206, 206, 206},
	{239, 239, 239},
	{255, 255, 255}
};

INTERN unsigned char character_pixel[CHARACTER_Y * 6][CHARACTER_X * 16] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 3, 6, 2, 0, 0, 0, 3, 3, 4, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 6, 2, 0, 0, 0, 0, 0, 1, 5, 2, 0, 0, 2, 5, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 5, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 2, 0, 0, 0, 2, 7, 4, 7, 3, 0, 0, 0, 7, 7, 7, 1, 0, 0, 1, 5, 7, 7, 3, 0, 0, 4, 7, 7, 3, 0, 0, 0, 0, 2, 3, 1, 0, 0, 0, 0, 2, 7, 2, 0, 0, 0, 0, 0, 6, 7, 1, 0, 0, 1, 7, 7, 0, 0, 0, 0, 0, 1, 4, 1, 0, 0, 0, 0, 1, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 4, 0, 0, 0, 1, 7, 3, 7, 2, 0, 0, 0, 7, 7, 7, 1, 0, 0, 6, 7, 5, 7, 7, 0, 0, 7, 6, 6, 7, 0, 0, 0, 5, 7, 7, 7, 0, 0, 0, 0, 1, 7, 1, 0, 0, 0, 0, 2, 7, 4, 0, 0, 0, 0, 3, 7, 3, 0, 0, 0, 2, 3, 7, 3, 3, 0, 0, 0, 2, 7, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 2, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 3, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 5, 7, 7, 7, 5, 0, 0, 7, 7, 3, 2, 2, 0, 0, 4, 7, 7, 6, 4, 0, 0, 6, 7, 3, 3, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 6, 7, 1, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 5, 7, 7, 7, 6, 0, 1, 1, 3, 7, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 7, 7, 2, 0, 0, 2, 7, 7, 7, 3, 0, 0, 2, 6, 7, 7, 2, 0, 0, 4, 7, 6, 2, 6, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 7, 7, 7, 1, 0, 3, 7, 7, 7, 7, 7, 3, 0, 0, 0, 0, 0, 0, 0, 1, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 3, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 7, 7, 5, 0, 0, 5, 2, 2, 7, 7, 0, 0, 4, 6, 7, 7, 3, 0, 2, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 1, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 1, 6, 2, 7, 2, 0, 1, 2, 4, 7, 4, 2, 1, 0, 0, 0, 1, 1, 0, 0, 1, 7, 7, 7, 7, 7, 1, 0, 0, 1, 2, 1, 0, 0, 0, 0, 7, 7, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 7, 7, 1, 0, 0, 7, 7, 5, 7, 7, 0, 0, 0, 5, 7, 5, 7, 0, 3, 7, 5, 7, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 3, 0, 0, 0, 0, 2, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 2, 0, 0, 0, 0, 3, 7, 6, 0, 0, 0, 1, 2, 2, 2, 1, 0, 0, 0, 6, 7, 5, 0, 0, 0, 2, 7, 4, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 7, 7, 7, 0, 0, 0, 3, 6, 7, 6, 2, 0, 0, 0, 2, 7, 7, 5, 0, 0, 7, 7, 7, 7, 7, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 6, 7, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 5, 1, 0, 0, 0, 0, 5, 7, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 5, 0, 0, 0, 7, 7, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 3, 3, 0, 0, 0, 0, 3, 7, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 2, 0, 0, 2, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 4, 3, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 2, 2, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 3, 2, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0},
	{0, 2, 7, 7, 7, 3, 0, 0, 3, 7, 7, 5, 0, 0, 0, 5, 7, 7, 7, 4, 0, 0, 5, 7, 7, 7, 2, 0, 0, 0, 1, 7, 7, 1, 0, 0, 7, 7, 7, 7, 7, 0, 0, 0, 5, 7, 7, 7, 0, 1, 7, 7, 7, 7, 4, 0, 0, 4, 7, 7, 7, 4, 0, 0, 4, 7, 7, 7, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 2, 0, 0, 0, 0, 0, 0, 0, 2, 4, 1, 0, 0, 0, 0, 0, 4, 7, 7, 7, 2, 0},
	{0, 7, 7, 3, 7, 7, 0, 0, 3, 5, 7, 5, 0, 0, 0, 7, 6, 2, 7, 7, 0, 0, 4, 4, 2, 7, 6, 0, 0, 0, 5, 7, 7, 1, 0, 0, 7, 7, 4, 4, 2, 0, 0, 5, 7, 4, 0, 0, 0, 2, 7, 4, 5, 7, 3, 0, 0, 7, 7, 0, 7, 7, 0, 1, 7, 7, 0, 7, 7, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 5, 7, 7, 3, 0, 2, 2, 2, 2, 2, 0, 2, 7, 7, 5, 1, 0, 0, 0, 6, 7, 3, 7, 6, 0},
	{1, 7, 6, 0, 5, 7, 2, 0, 0, 1, 7, 5, 0, 0, 0, 1, 0, 2, 7, 7, 0, 0, 0, 2, 7, 7, 3, 0, 0, 2, 7, 5, 7, 1, 0, 0, 7, 7, 7, 7, 2, 0, 0, 7, 7, 7, 6, 2, 0, 0, 0, 0, 5, 7, 1, 0, 0, 7, 7, 4, 7, 7, 0, 1, 7, 7, 0, 7, 7, 1, 0, 0, 6, 7, 5, 0, 0, 0, 0, 5, 7, 5, 0, 0, 1, 5, 7, 7, 6, 1, 0, 4, 7, 7, 7, 7, 7, 4, 0, 1, 5, 7, 7, 6, 2, 0, 1, 0, 3, 7, 6, 0},
	{2, 7, 5, 0, 5, 7, 3, 0, 0, 1, 7, 5, 0, 0, 0, 0, 1, 7, 7, 3, 0, 0, 0, 3, 7, 7, 3, 0, 0, 7, 7, 4, 7, 3, 0, 0, 6, 7, 5, 7, 7, 0, 1, 7, 7, 7, 7, 7, 0, 0, 0, 0, 7, 7, 0, 0, 0, 3, 7, 7, 7, 4, 0, 0, 7, 7, 7, 7, 7, 1, 0, 0, 5, 7, 5, 0, 0, 0, 0, 5, 7, 5, 0, 0, 4, 7, 7, 3, 0, 0, 0, 2, 6, 6, 6, 6, 6, 2, 0, 0, 0, 3, 7, 7, 6, 0, 0, 5, 7, 7, 1, 0},
	{1, 7, 7, 0, 6, 7, 2, 0, 0, 1, 7, 5, 0, 0, 0, 1, 7, 7, 2, 1, 0, 0, 0, 0, 0, 7, 7, 0, 1, 7, 7, 7, 7, 7, 1, 0, 0, 0, 0, 7, 7, 1, 1, 7, 7, 0, 7, 7, 1, 0, 0, 2, 7, 4, 0, 0, 0, 7, 7, 0, 7, 7, 1, 0, 1, 4, 5, 7, 7, 0, 0, 0, 1, 3, 1, 0, 0, 0, 0, 1, 3, 2, 0, 0, 0, 3, 7, 7, 7, 3, 0, 4, 7, 7, 7, 7, 7, 3, 0, 3, 7, 7, 7, 4, 1, 0, 0, 5, 6, 0, 0, 0},
	{0, 7, 7, 6, 7, 7, 0, 0, 4, 7, 7, 7, 5, 0, 1, 7, 7, 7, 7, 7, 0, 1, 7, 7, 5, 7, 6, 0, 0, 1, 4, 7, 7, 5, 0, 1, 7, 6, 5, 7, 7, 0, 0, 7, 7, 4, 7, 7, 0, 0, 0, 6, 7, 2, 0, 0, 0, 7, 7, 3, 7, 7, 1, 0, 2, 3, 7, 7, 3, 0, 0, 0, 7, 7, 6, 0, 0, 0, 0, 3, 7, 5, 0, 0, 0, 0, 0, 3, 7, 7, 3, 0, 1, 1, 1, 1, 1, 0, 3, 7, 7, 3, 0, 0, 0, 0, 0, 7, 7, 2, 0, 0},
	{0, 1, 7, 7, 7, 2, 0, 0, 5, 7, 7, 7, 7, 0, 1, 7, 7, 7, 7, 6, 0, 0, 6, 7, 7, 7, 1, 0, 0, 0, 5, 7, 7, 7, 0, 1, 7, 7, 7, 7, 2, 0, 0, 2, 7, 7, 7, 2, 0, 0, 0, 7, 7, 0, 0, 0, 0, 2, 7, 7, 7, 3, 0, 0, 7, 7, 7, 3, 0, 0, 0, 0, 4, 7, 4, 0, 0, 0, 0, 7, 7, 2, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 7, 7, 1, 0, 0},
	{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 5, 7, 6, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0},
	{0, 5, 7, 5, 7, 5, 0, 0, 7, 7, 7, 4, 0, 0, 3, 7, 7, 7, 7, 3, 0, 0, 2, 7, 7, 7, 7, 2, 3, 7, 7, 7, 6, 2, 0, 4, 7, 7, 7, 7, 7, 2, 3, 7, 7, 7, 7, 7, 2, 0, 2, 7, 7, 7, 7, 1, 3, 7, 7, 5, 7, 7, 3, 0, 6, 7, 7, 7, 6, 0, 0, 0, 4, 7, 7, 7, 4, 3, 7, 7, 4, 7, 7, 3, 3, 7, 7, 7, 1, 0, 0, 6, 7, 4, 0, 3, 7, 5, 4, 7, 5, 2, 7, 7, 5, 0, 2, 7, 7, 7, 2, 0},
	{0, 7, 5, 2, 7, 7, 0, 0, 5, 7, 7, 7, 0, 0, 3, 7, 7, 6, 7, 7, 1, 0, 7, 7, 5, 7, 7, 3, 2, 7, 7, 7, 7, 7, 0, 3, 7, 7, 6, 7, 7, 3, 2, 7, 7, 6, 7, 7, 4, 1, 7, 7, 5, 7, 7, 2, 2, 7, 7, 3, 7, 7, 2, 0, 5, 7, 7, 7, 4, 0, 0, 0, 3, 7, 7, 7, 3, 2, 7, 7, 4, 7, 7, 2, 2, 7, 7, 7, 1, 0, 0, 5, 7, 7, 0, 7, 7, 5, 3, 7, 7, 4, 7, 7, 5, 1, 7, 7, 5, 7, 7, 1},
	{1, 7, 7, 7, 7, 7, 0, 0, 3, 7, 5, 7, 3, 0, 0, 7, 7, 3, 7, 7, 0, 4, 7, 4, 0, 1, 7, 2, 0, 7, 7, 0, 4, 7, 4, 0, 7, 7, 3, 6, 5, 2, 0, 7, 7, 3, 5, 5, 2, 5, 7, 3, 0, 1, 7, 1, 0, 7, 7, 4, 7, 7, 0, 0, 0, 2, 7, 4, 0, 0, 0, 0, 0, 1, 7, 7, 0, 0, 7, 7, 7, 7, 0, 0, 0, 5, 7, 1, 0, 0, 0, 3, 7, 7, 4, 7, 7, 2, 0, 7, 7, 7, 4, 7, 1, 5, 7, 3, 0, 4, 7, 5},
	{1, 7, 7, 7, 7, 7, 0, 0, 7, 7, 5, 7, 6, 0, 0, 7, 7, 7, 7, 7, 1, 5, 7, 3, 0, 0, 0, 0, 0, 7, 7, 0, 3, 7, 5, 0, 7, 7, 7, 7, 0, 0, 0, 7, 7, 7, 7, 0, 0, 6, 7, 1, 4, 7, 7, 5, 0, 7, 7, 7, 7, 7, 0, 0, 0, 2, 7, 4, 0, 0, 1, 4, 0, 1, 7, 7, 0, 0, 7, 7, 7, 7, 0, 0, 0, 5, 7, 1, 0, 2, 2, 3, 7, 6, 7, 7, 7, 3, 0, 7, 7, 7, 7, 7, 1, 6, 7, 2, 0, 2, 7, 5},
	{1, 7, 6, 7, 7, 7, 0, 1, 7, 7, 7, 7, 7, 1, 0, 7, 7, 0, 3, 7, 5, 3, 7, 5, 0, 0, 2, 1, 0, 7, 7, 0, 5, 7, 3, 0, 7, 7, 3, 4, 7, 2, 0, 7, 7, 3, 3, 0, 0, 5, 7, 4, 3, 7, 7, 5, 0, 7, 7, 0, 7, 7, 0, 0, 0, 2, 7, 4, 0, 0, 3, 7, 1, 2, 7, 7, 0, 0, 7, 7, 5, 7, 4, 0, 0, 5, 7, 1, 0, 7, 6, 3, 7, 3, 7, 5, 7, 4, 0, 7, 5, 6, 7, 7, 1, 4, 7, 4, 0, 4, 7, 4},
	{0, 7, 7, 2, 1, 1, 0, 7, 7, 7, 1, 7, 7, 6, 3, 7, 7, 7, 7, 7, 4, 0, 7, 7, 7, 7, 7, 3, 2, 7, 7, 7, 7, 7, 0, 3, 7, 7, 7, 7, 7, 3, 2, 7, 7, 3, 0, 0, 0, 1, 7, 7, 6, 7, 7, 1, 3, 7, 7, 4, 7, 7, 3, 0, 6, 7, 7, 7, 6, 0, 3, 7, 7, 7, 7, 5, 0, 3, 7, 7, 2, 7, 7, 3, 3, 7, 7, 7, 7, 7, 7, 7, 7, 6, 0, 5, 7, 7, 4, 7, 7, 3, 7, 7, 2, 0, 7, 7, 7, 7, 7, 1},
	{0, 1, 7, 7, 7, 2, 0, 5, 7, 5, 1, 6, 7, 5, 3, 7, 7, 7, 7, 4, 0, 0, 1, 6, 7, 7, 4, 0, 2, 7, 7, 7, 5, 1, 0, 3, 7, 7, 7, 7, 6, 1, 2, 7, 7, 3, 0, 0, 0, 0, 2, 6, 7, 7, 5, 0, 2, 7, 6, 4, 6, 7, 3, 0, 5, 7, 6, 7, 5, 0, 1, 5, 7, 7, 5, 1, 0, 3, 7, 7, 2, 2, 7, 3, 3, 7, 6, 7, 7, 7, 3, 5, 7, 5, 0, 4, 7, 5, 3, 7, 7, 2, 4, 7, 1, 0, 2, 7, 7, 6, 2, 0},
	{0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 3, 7, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{1, 7, 7, 7, 7, 5, 0, 0, 4, 7, 7, 7, 4, 0, 3, 7, 7, 7, 7, 5, 0, 0, 4, 7, 7, 7, 7, 0, 3, 7, 7, 7, 7, 7, 4, 5, 7, 7, 2, 7, 7, 6, 6, 7, 7, 2, 7, 7, 7, 7, 7, 7, 0, 6, 7, 7, 3, 7, 7, 5, 7, 7, 2, 3, 7, 7, 5, 7, 7, 3, 0, 7, 7, 7, 7, 7, 0, 0, 0, 5, 7, 7, 0, 0, 0, 3, 7, 3, 0, 0, 0, 0, 2, 7, 7, 4, 0, 0, 0, 2, 7, 7, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 7, 7, 5, 7, 7, 3, 2, 7, 7, 3, 7, 7, 2, 1, 7, 7, 4, 7, 7, 2, 1, 7, 7, 1, 7, 7, 0, 5, 7, 6, 7, 6, 7, 5, 3, 7, 7, 0, 6, 7, 3, 4, 7, 7, 0, 6, 7, 4, 5, 7, 5, 4, 4, 7, 5, 1, 7, 7, 5, 7, 7, 1, 2, 7, 7, 3, 7, 7, 1, 1, 7, 7, 7, 7, 7, 0, 0, 0, 7, 7, 1, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 2, 7, 5, 0, 0, 0, 5, 4, 0, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 6, 7, 1, 5, 7, 4, 6, 7, 2, 0, 2, 7, 6, 0, 7, 7, 3, 7, 7, 2, 1, 7, 7, 7, 4, 2, 0, 5, 7, 3, 7, 3, 7, 5, 0, 7, 7, 0, 5, 7, 1, 0, 7, 7, 0, 7, 7, 0, 2, 7, 5, 7, 5, 7, 2, 0, 0, 7, 7, 7, 0, 0, 0, 3, 7, 7, 7, 2, 0, 1, 6, 3, 7, 7, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 4, 7, 2, 0, 0, 0, 0, 1, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 5, 7, 7, 7, 7, 0, 7, 7, 1, 0, 2, 7, 6, 0, 7, 7, 7, 7, 4, 0, 0, 3, 7, 7, 7, 7, 0, 0, 0, 3, 7, 4, 0, 0, 1, 7, 7, 0, 5, 7, 1, 0, 5, 7, 3, 7, 6, 0, 1, 7, 7, 7, 7, 7, 1, 0, 0, 5, 7, 6, 0, 0, 0, 0, 5, 7, 6, 0, 0, 0, 0, 7, 7, 3, 3, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 1, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 6, 7, 3, 2, 0, 0, 4, 7, 5, 0, 4, 7, 4, 0, 7, 7, 3, 7, 7, 0, 2, 7, 2, 0, 7, 7, 2, 0, 0, 3, 7, 4, 0, 0, 1, 7, 7, 0, 5, 7, 1, 0, 2, 7, 7, 7, 2, 0, 1, 7, 7, 2, 7, 7, 1, 0, 3, 7, 6, 7, 4, 0, 0, 0, 2, 7, 4, 0, 0, 0, 5, 7, 3, 6, 7, 1, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 4, 7, 2, 0, 0, 0, 1, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{1, 7, 7, 7, 1, 0, 0, 1, 7, 7, 7, 7, 7, 0, 3, 7, 7, 3, 6, 7, 7, 3, 7, 7, 7, 7, 7, 1, 0, 6, 7, 7, 7, 7, 0, 0, 7, 7, 7, 7, 7, 0, 0, 0, 7, 7, 7, 0, 0, 0, 7, 7, 0, 7, 7, 0, 3, 7, 7, 5, 7, 7, 4, 0, 5, 7, 7, 7, 5, 0, 1, 7, 7, 7, 7, 7, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 1, 7, 6, 0, 0, 0, 1, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{1, 4, 5, 5, 1, 0, 0, 0, 2, 7, 7, 7, 3, 2, 2, 5, 5, 2, 0, 4, 4, 1, 5, 6, 7, 5, 2, 0, 0, 3, 5, 5, 5, 3, 0, 0, 1, 5, 7, 5, 2, 0, 0, 0, 2, 5, 2, 0, 0, 0, 3, 3, 0, 3, 3, 0, 2, 5, 5, 2, 5, 5, 2, 0, 3, 5, 5, 5, 3, 0, 1, 4, 5, 5, 5, 3, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 0, 5, 7, 0, 0, 0, 1, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 7, 7, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 7, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 3, 3, 3, 3, 3},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 7, 7},
	{0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1},
	{0, 4, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 6, 7, 7, 2, 0, 0, 0, 0, 0, 0, 0, 2, 7, 5, 0, 0, 0, 0, 0, 0, 3, 7, 3, 0, 0, 0, 0, 1, 7, 5, 0, 0, 2, 7, 5, 0, 0, 0, 0, 0, 3, 7, 7, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 4, 7, 4, 0, 0, 0, 0, 0, 1, 0, 0, 0, 3, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 5, 5, 2, 0, 0, 0, 0, 0, 0, 0, 2, 7, 7, 0, 0, 0, 0, 0, 0, 2, 7, 2, 0, 0, 0, 0, 1, 7, 4, 0, 0, 2, 7, 7, 0, 0, 0, 0, 0, 2, 7, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 1, 0, 0, 0, 5, 7, 7, 7, 3, 0, 0, 7, 7, 7, 7, 3, 0, 0, 2, 7, 7, 7, 7, 2, 0, 2, 7, 7, 7, 7, 0, 0, 3, 7, 7, 7, 3, 0, 0, 4, 7, 7, 7, 4, 0, 0, 3, 7, 7, 7, 7, 3, 0, 7, 7, 7, 7, 3, 0, 0, 3, 7, 7, 3, 0, 0, 1, 7, 7, 7, 7, 1, 0, 0, 7, 7, 3, 7, 7, 1, 0, 0, 3, 7, 3, 0, 1, 7, 7, 7, 7, 7, 7, 1, 3, 7, 7, 7, 7, 3, 0, 0, 3, 7, 7, 7, 3, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 4, 7, 7, 0, 0, 7, 7, 7, 7, 7, 2, 1, 7, 7, 5, 7, 7, 2, 1, 7, 7, 7, 7, 7, 0, 2, 7, 7, 4, 7, 7, 2, 0, 5, 7, 7, 7, 5, 0, 2, 7, 7, 5, 7, 7, 3, 0, 7, 7, 6, 7, 7, 0, 0, 2, 7, 7, 5, 0, 0, 0, 5, 6, 7, 7, 1, 0, 0, 7, 7, 7, 7, 5, 0, 0, 0, 3, 7, 3, 0, 0, 7, 7, 6, 7, 7, 7, 5, 2, 7, 7, 6, 7, 7, 0, 2, 7, 7, 5, 7, 7, 2},
	{0, 0, 0, 0, 0, 0, 0, 1, 6, 7, 7, 7, 7, 0, 0, 7, 7, 0, 2, 7, 5, 3, 7, 4, 0, 1, 4, 0, 4, 7, 4, 0, 7, 7, 0, 4, 7, 7, 7, 7, 7, 4, 0, 0, 7, 7, 0, 0, 0, 5, 7, 3, 0, 7, 7, 0, 0, 7, 7, 0, 7, 7, 0, 0, 0, 1, 7, 5, 0, 0, 0, 0, 0, 7, 7, 1, 0, 0, 7, 7, 7, 7, 0, 0, 0, 0, 3, 7, 3, 0, 0, 5, 7, 2, 7, 4, 7, 5, 0, 7, 7, 0, 7, 7, 0, 5, 7, 3, 0, 3, 7, 5},
	{0, 0, 0, 0, 0, 0, 0, 3, 7, 6, 0, 7, 7, 0, 1, 7, 7, 0, 4, 7, 5, 2, 7, 6, 0, 2, 5, 1, 3, 7, 5, 0, 7, 7, 0, 3, 7, 6, 2, 3, 5, 2, 0, 0, 7, 7, 1, 1, 0, 3, 7, 6, 2, 7, 7, 0, 0, 7, 7, 0, 7, 7, 1, 0, 1, 2, 7, 5, 0, 0, 0, 0, 0, 7, 7, 1, 0, 0, 7, 7, 7, 7, 4, 0, 0, 1, 3, 7, 4, 1, 0, 5, 7, 2, 7, 4, 7, 6, 0, 7, 7, 0, 7, 7, 0, 3, 7, 5, 0, 5, 7, 4},
	{0, 0, 0, 0, 0, 0, 0, 2, 7, 7, 7, 7, 7, 3, 4, 7, 7, 7, 7, 7, 1, 0, 6, 7, 7, 7, 7, 1, 0, 7, 7, 7, 7, 7, 5, 0, 7, 7, 7, 7, 7, 2, 0, 7, 7, 7, 7, 6, 0, 0, 6, 7, 7, 7, 7, 0, 3, 7, 7, 6, 7, 7, 4, 0, 7, 7, 7, 7, 7, 2, 0, 0, 0, 7, 7, 1, 0, 3, 7, 7, 2, 7, 7, 4, 0, 7, 7, 7, 7, 7, 1, 7, 7, 6, 7, 7, 7, 7, 4, 7, 7, 6, 7, 7, 5, 0, 7, 7, 7, 7, 7, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 4, 2, 3, 1, 1, 3, 2, 4, 4, 1, 0, 0, 0, 3, 5, 4, 1, 0, 0, 1, 4, 4, 2, 3, 2, 0, 0, 3, 5, 4, 1, 0, 0, 2, 3, 3, 3, 2, 0, 0, 1, 2, 2, 7, 7, 0, 1, 3, 3, 2, 3, 3, 1, 0, 3, 3, 3, 3, 3, 1, 0, 1, 0, 7, 7, 1, 0, 1, 3, 2, 1, 3, 3, 1, 0, 3, 3, 3, 3, 3, 0, 3, 3, 2, 3, 2, 2, 3, 1, 3, 3, 2, 3, 3, 2, 0, 0, 3, 5, 3, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 7, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 7, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 7, 2, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 7},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 5, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 4, 0, 0, 0, 1, 7, 2, 0, 0, 0, 5, 7, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0},
	{0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 3, 7, 3, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 7, 6, 1, 0, 0, 0, 1, 7, 2, 0, 0, 0, 1, 6, 7, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 7},
	{4, 7, 7, 7, 7, 5, 0, 0, 5, 7, 7, 7, 7, 4, 0, 7, 7, 5, 7, 7, 5, 0, 5, 7, 7, 7, 6, 0, 2, 7, 7, 7, 7, 3, 0, 4, 7, 6, 3, 7, 6, 0, 4, 7, 7, 4, 7, 7, 5, 7, 7, 5, 0, 5, 7, 7, 2, 7, 7, 5, 7, 7, 1, 5, 7, 7, 4, 7, 7, 4, 0, 7, 7, 7, 7, 6, 0, 0, 0, 1, 7, 4, 0, 0, 0, 0, 1, 7, 2, 0, 0, 0, 0, 3, 7, 2, 0, 0, 0, 2, 5, 1, 0, 1, 1, 0, 7, 0, 7, 0, 7, 0},
	{2, 7, 7, 4, 7, 7, 3, 3, 7, 7, 4, 7, 7, 2, 0, 5, 7, 7, 5, 7, 3, 0, 7, 7, 3, 5, 4, 0, 2, 7, 7, 7, 7, 3, 0, 2, 7, 7, 1, 7, 7, 0, 2, 7, 7, 1, 7, 7, 2, 6, 7, 4, 6, 4, 7, 6, 0, 5, 7, 7, 7, 5, 0, 2, 7, 7, 2, 7, 7, 2, 0, 7, 6, 7, 7, 4, 0, 0, 0, 3, 7, 3, 0, 0, 0, 0, 1, 7, 2, 0, 0, 0, 0, 2, 7, 4, 0, 0, 2, 7, 7, 7, 7, 7, 3, 7, 0, 7, 0, 7, 0, 7},
	{0, 7, 7, 0, 3, 7, 4, 5, 7, 2, 0, 7, 7, 0, 0, 2, 7, 4, 0, 0, 0, 0, 5, 7, 7, 7, 5, 0, 0, 3, 7, 3, 0, 0, 0, 0, 7, 7, 0, 7, 7, 0, 0, 4, 7, 4, 7, 4, 0, 3, 7, 6, 7, 6, 7, 2, 0, 0, 5, 7, 6, 0, 0, 0, 5, 7, 4, 7, 4, 0, 0, 1, 5, 7, 4, 0, 0, 0, 4, 7, 7, 1, 0, 0, 0, 0, 1, 7, 2, 0, 0, 0, 0, 0, 7, 7, 5, 0, 2, 4, 2, 4, 7, 5, 0, 0, 7, 0, 7, 0, 7, 0},
	{0, 7, 7, 3, 7, 7, 3, 3, 7, 7, 3, 7, 7, 0, 0, 4, 7, 5, 2, 1, 0, 0, 7, 5, 3, 7, 7, 1, 0, 3, 7, 5, 3, 6, 2, 0, 7, 7, 2, 7, 7, 1, 0, 1, 7, 7, 7, 0, 0, 1, 7, 7, 7, 7, 7, 1, 0, 4, 7, 7, 7, 5, 0, 0, 1, 7, 7, 7, 0, 0, 0, 4, 7, 5, 6, 7, 0, 0, 1, 5, 7, 3, 0, 0, 0, 0, 1, 7, 2, 0, 0, 0, 0, 2, 7, 6, 1, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 7},
	{0, 7, 7, 7, 7, 5, 0, 0, 5, 7, 7, 7, 7, 0, 2, 7, 7, 7, 7, 3, 0, 1, 7, 7, 7, 7, 6, 0, 0, 1, 7, 7, 7, 7, 2, 0, 5, 7, 7, 7, 7, 4, 0, 0, 5, 7, 3, 0, 0, 0, 7, 7, 2, 7, 7, 0, 1, 7, 7, 5, 7, 7, 3, 0, 0, 4, 7, 5, 0, 0, 0, 7, 7, 7, 7, 7, 0, 0, 0, 1, 7, 4, 0, 0, 0, 0, 1, 7, 2, 0, 0, 0, 0, 3, 7, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0},
	{1, 7, 7, 1, 1, 0, 0, 0, 0, 1, 1, 7, 7, 1, 0, 1, 1, 2, 2, 1, 0, 0, 2, 2, 3, 2, 0, 0, 0, 0, 1, 3, 2, 1, 0, 0, 0, 2, 2, 1, 1, 1, 0, 0, 1, 2, 0, 0, 0, 0, 2, 2, 0, 2, 2, 0, 0, 1, 1, 1, 1, 1, 0, 1, 2, 6, 7, 2, 0, 0, 0, 1, 1, 2, 2, 1, 0, 0, 0, 1, 7, 5, 0, 0, 0, 0, 1, 7, 2, 0, 0, 0, 0, 4, 7, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 7},
	{7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 7, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 4, 0, 0, 0, 1, 7, 2, 0, 0, 0, 5, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0},
	{2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 1, 7, 2, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 7}
};

INTERN IMAGE characters = {
	GIF87A,
	0, 0,
	CHARACTER_X * 16, CHARACTER_Y * 6,
	NO,
	0,
	0,
	CHARACTER_CODE_SIZE - 1,
	NO,
	YES,
	CHARACTER_CODE_SIZE - 1,
	NO, 0,
	0,
	0,
	(unsigned char *)character_color_table,
	(unsigned char *)character_pixel
};

INTERN unsigned char error_pixel[MAX_CHAR * CHARACTER_X * CHARACTER_Y];

INTERN void str2image(char **pstr, int width, int line);
INTERN void set_letter(int c, int column, int row);

void error_out(char *format, ...) {
	char buf[LINE_SIZE];
	char *error_str;
	int len, width, line;
	va_list ap;

	error_str = buf;
	va_start(ap, format);
	vsprintf(error_str, format, ap);
	va_end(ap);
	if (*error_str == EOS)
		error_str = "(NULL string)( specified )";
	if (strlen(error_str) > MAX_CHAR)
		error_str[MAX_CHAR] = EOS;
	len = strlen(error_str);
	if ((line = (len + WIDTHLIMITS - 1) / WIDTHLIMITS) <= 2) {
		width = (len + 1) / 2;
		line = 2;
	} else {
		width = WIDTHLIMITS;
	}
	memcpy(&image, &characters, sizeof(IMAGE));
	image.pixel = error_pixel;
	str2image(&error_str, width, line);
	save_main();
	exit(0);
}


void env_out(char *environment) {
	char *value, **q;
	int len, line, width;

	if ((*environment != EOS) && ((value = getenv(environment)) == NULL))
		error_out("ENV: \"%s\" Is Not Defined", environment);
	if (*environment != EOS)
		error_out("%s=%s", environment, value);
	width = 0;
	line = 0;
	for (q = environ; *q != NULL; q++) {
		if ((len = strlen(*q)) > width)
			width = len;
		line += (len + WIDTHLIMITS - 1) / WIDTHLIMITS;
	}
	if (width > WIDTHLIMITS)
		width = WIDTHLIMITS;
	if (line == 0)
		error_out("ENV: No Environment");
	memcpy(&image, &characters, sizeof(IMAGE));
	if ((image.pixel = (unsigned char *)malloc(CHARACTER_X * CHARACTER_Y * width * line)) == NULL)
		error_out("env_out: Cannot Allocate Memory");
	str2image(environ, width, line);
	save_main();
	free(image.pixel);
	exit(0);
}


INTERN void str2image(char **pstr, int width, int line) {
	int i, n, len;

	image.width = CHARACTER_X * width;
	image.height = CHARACTER_Y * line;
	memset(image.pixel, image.background, image.width * image.height);
	n = 0;
	while (n < line) {
		len = strlen(*pstr);
		for (i = 0; i < len; i++) {
			set_letter((*pstr)[i], i % width, n + i / width);
		}
		n += (len + width - 1) / width;
		pstr++;
	}
}


INTERN void set_letter(int c, int column, int row) {
	int y, top;

	if ((c < 0x20) || (c >= 0x80))
		c = 0x7F;
	c -= 0x20;
	for (y = 0; y < CHARACTER_Y; y++) {
		top = (0x10 * ((c / 16) * CHARACTER_Y + y) + (c % 0x10)) * CHARACTER_X;
		memcpy(image.pixel
			+ CHARACTER_X * column
			+ image.width * (CHARACTER_Y * row + y),
			characters.pixel + top, CHARACTER_X);
	}
}

