/*
 * digits.c -- default digits pixel
 *
 * Copyright (c) 1995-1997 by nir@mxa.meshnet.or.jp
 *
 * This file is part of npc.cgi source tree.
 * npc.cgi is free software; you can redistribute it and/or modify it
 * for any purpose.
 *
 * @(#)$Id: digits.c,v 2.3 1997/12/11 14:02:23 nir Rel $
 */

/*
 * $Log: digits.c,v $
 * Revision 2.3  1997/12/11 14:02:23  nir
 * Add left, top and disposal_method elements to struct IMAGE.
 *
 * Revision 2.2  1997/11/05 11:48:08  nir
 * Add Copyright, Id and Log.
 *
 */

#include "npc.h"

#define MIN_CODE_SIZE_0 3
#define MAX_COLOR_0     8
#define MAX_X_0        16
#define MAX_Y_0       160

INTERN unsigned char color_table_0[MAX_COLOR_0][3] = {
	{  0,   0,   0},
	{ 51,  51,  51},
	{ 85,  85,  85},
	{119, 119, 119},
	{153, 153, 153},
	{187, 187, 187},
	{221, 221, 221},
	{255, 255, 255}
};

INTERN unsigned char pixel_0[MAX_Y_0][MAX_X_0] = {
	{0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 2, 7, 7, 7, 7, 6, 2, 0, 0, 0, 0, 2},
	{0, 0, 0, 1, 7, 7, 6, 5, 6, 7, 7, 2, 0, 0, 0, 2},
	{0, 0, 0, 5, 7, 6, 0, 0, 0, 5, 7, 6, 0, 0, 0, 2},
	{0, 0, 2, 7, 7, 4, 0, 0, 0, 2, 7, 7, 2, 0, 0, 2},
	{0, 0, 2, 7, 7, 2, 0, 0, 0, 1, 7, 7, 4, 0, 0, 2},
	{0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 3, 7, 7, 1, 0, 0, 0, 1, 7, 7, 5, 0, 0, 2},
	{0, 0, 2, 7, 7, 4, 0, 0, 0, 2, 7, 7, 3, 0, 0, 2},
	{0, 0, 0, 6, 7, 5, 0, 0, 0, 5, 7, 7, 0, 0, 0, 2},
	{0, 0, 0, 2, 7, 7, 6, 4, 5, 7, 7, 3, 0, 0, 0, 2},
	{0, 0, 0, 0, 2, 6, 7, 7, 7, 6, 3, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 2, 4, 3, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 1, 7, 6, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 1, 5, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 2, 7, 7, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 1, 5, 7, 7, 6, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 1, 7, 7, 7, 3, 3, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 4, 5, 2, 0, 4, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 3, 7, 6, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 1, 2, 1, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 2, 5, 7, 7, 7, 7, 5, 1, 0, 0, 0, 2},
	{0, 0, 0, 2, 7, 7, 7, 5, 6, 7, 7, 6, 0, 0, 0, 2},
	{0, 0, 0, 7, 7, 6, 2, 0, 0, 3, 7, 7, 4, 0, 0, 2},
	{0, 0, 2, 7, 7, 3, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 1, 6, 6, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 7, 4, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 7, 6, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 3, 7, 7, 7, 2, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 4, 7, 7, 5, 2, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 5, 7, 7, 4, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 5, 7, 7, 3, 0, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 4, 7, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 0, 0, 2},
	{0, 0, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0, 0, 2},
	{0, 0, 0, 2, 4, 3, 3, 3, 3, 3, 4, 4, 2, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 3, 7, 7, 7, 7, 7, 3, 0, 0, 0, 0, 2},
	{0, 0, 0, 4, 7, 7, 6, 5, 6, 7, 7, 4, 0, 0, 0, 2},
	{0, 0, 0, 7, 7, 5, 0, 0, 1, 6, 7, 6, 0, 0, 0, 2},
	{0, 0, 0, 6, 6, 0, 0, 0, 0, 3, 7, 7, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 5, 7, 5, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 1, 4, 4, 7, 7, 6, 2, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 4, 7, 7, 7, 7, 5, 1, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 1, 4, 4, 4, 6, 7, 6, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 7, 4, 0, 0, 2},
	{0, 0, 1, 4, 3, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 4, 7, 7, 1, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 1, 7, 7, 5, 0, 0, 0, 4, 7, 7, 3, 0, 0, 2},
	{0, 0, 0, 5, 7, 7, 5, 4, 5, 7, 7, 5, 0, 0, 0, 2},
	{0, 0, 0, 0, 4, 7, 7, 7, 7, 7, 4, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 3, 4, 3, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 2, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 1, 7, 7, 6, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 5, 7, 7, 7, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 4, 7, 7, 7, 7, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 2, 7, 6, 5, 7, 7, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 1, 7, 7, 2, 3, 7, 7, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 5, 7, 5, 0, 4, 7, 7, 0, 0, 0, 0, 2},
	{0, 0, 0, 4, 7, 6, 0, 0, 4, 7, 7, 0, 0, 0, 0, 2},
	{0, 0, 2, 7, 7, 2, 0, 0, 4, 7, 7, 0, 0, 0, 0, 2},
	{0, 1, 7, 7, 4, 0, 0, 0, 4, 7, 7, 1, 0, 0, 0, 2},
	{0, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 0, 0, 2},
	{0, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0, 0, 2},
	{0, 0, 2, 4, 4, 4, 4, 4, 5, 7, 7, 4, 3, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 7, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 6, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 1, 2, 2, 2, 2, 1, 1, 1, 0, 0, 0, 2},
	{0, 0, 0, 1, 7, 7, 7, 7, 7, 7, 7, 7, 2, 0, 0, 2},
	{0, 0, 0, 2, 7, 7, 7, 7, 7, 7, 7, 6, 2, 0, 0, 2},
	{0, 0, 0, 3, 7, 7, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 3, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 5, 7, 5, 0, 2, 2, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 7, 7, 6, 7, 7, 7, 7, 5, 1, 0, 0, 0, 2},
	{0, 0, 1, 7, 7, 7, 6, 5, 6, 7, 7, 5, 0, 0, 0, 2},
	{0, 0, 1, 6, 7, 4, 0, 0, 0, 5, 7, 7, 4, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 7, 7, 5, 0, 0, 2},
	{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 3, 7, 5, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 3, 7, 7, 3, 0, 0, 0, 4, 7, 7, 3, 0, 0, 2},
	{0, 0, 1, 6, 7, 7, 5, 4, 5, 7, 7, 5, 0, 0, 0, 2},
	{0, 0, 0, 1, 5, 7, 7, 7, 7, 6, 4, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 1, 3, 3, 3, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 4, 7, 7, 7, 7, 5, 1, 0, 0, 0, 2},
	{0, 0, 0, 0, 5, 7, 7, 6, 5, 7, 7, 6, 1, 0, 0, 2},
	{0, 0, 0, 4, 7, 7, 4, 0, 0, 2, 7, 7, 4, 0, 0, 2},
	{0, 0, 1, 7, 7, 5, 0, 0, 0, 0, 2, 5, 2, 0, 0, 2},
	{0, 0, 2, 7, 7, 4, 0, 1, 2, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 4, 7, 7, 2, 5, 7, 7, 7, 6, 1, 0, 0, 0, 2},
	{0, 0, 4, 7, 7, 5, 7, 5, 6, 7, 7, 6, 1, 0, 0, 2},
	{0, 0, 4, 7, 7, 7, 2, 0, 0, 2, 7, 7, 4, 0, 0, 2},
	{0, 0, 4, 7, 7, 4, 0, 0, 0, 0, 5, 7, 7, 0, 0, 2},
	{0, 0, 3, 7, 7, 3, 0, 0, 0, 0, 3, 7, 7, 0, 0, 2},
	{0, 0, 1, 7, 7, 4, 0, 0, 0, 0, 4, 7, 6, 0, 0, 2},
	{0, 0, 0, 6, 7, 7, 1, 0, 0, 2, 7, 7, 5, 0, 0, 2},
	{0, 0, 0, 1, 7, 7, 7, 4, 4, 7, 7, 7, 2, 0, 0, 2},
	{0, 0, 0, 0, 2, 6, 7, 7, 7, 7, 5, 2, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 1, 3, 3, 1, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 1, 2, 2, 1, 1, 1, 1, 2, 2, 1, 0, 0, 2},
	{0, 0, 0, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 0, 0, 2},
	{0, 0, 0, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 7, 3, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 7, 7, 4, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 6, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 2, 7, 7, 2, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 0, 5, 7, 5, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 2, 7, 7, 3, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 4, 7, 6, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 1, 7, 7, 5, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 2, 7, 7, 4, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 3, 7, 7, 3, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 5, 7, 7, 0, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 4, 7, 6, 0, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 1, 2, 2, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 3, 7, 7, 7, 7, 7, 3, 0, 0, 0, 0, 2},
	{0, 0, 0, 3, 7, 7, 6, 5, 6, 7, 7, 4, 0, 0, 0, 2},
	{0, 0, 0, 7, 7, 5, 0, 0, 0, 5, 7, 7, 0, 0, 0, 2},
	{0, 0, 1, 7, 7, 3, 0, 0, 0, 2, 7, 7, 0, 0, 0, 2},
	{0, 0, 0, 6, 7, 5, 0, 0, 0, 4, 7, 7, 0, 0, 0, 2},
	{0, 0, 0, 2, 6, 7, 6, 4, 5, 7, 7, 3, 0, 0, 0, 2},
	{0, 0, 0, 0, 4, 7, 7, 7, 7, 7, 5, 1, 0, 0, 0, 2},
	{0, 0, 0, 5, 7, 7, 4, 4, 4, 7, 7, 6, 0, 0, 0, 2},
	{0, 0, 2, 7, 7, 4, 0, 0, 0, 2, 7, 7, 4, 0, 0, 2},
	{0, 0, 4, 7, 7, 0, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 4, 7, 7, 1, 0, 0, 0, 0, 7, 7, 5, 0, 0, 2},
	{0, 0, 2, 7, 7, 5, 0, 0, 0, 4, 7, 7, 4, 0, 0, 2},
	{0, 0, 0, 6, 7, 7, 6, 4, 5, 7, 7, 6, 0, 0, 0, 2},
	{0, 0, 0, 1, 4, 7, 7, 7, 7, 7, 5, 2, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 4, 7, 7, 7, 7, 6, 1, 0, 0, 0, 0, 2},
	{0, 0, 0, 5, 7, 7, 6, 5, 7, 7, 7, 2, 0, 0, 0, 2},
	{0, 0, 3, 7, 7, 4, 0, 0, 1, 7, 7, 6, 0, 0, 0, 2},
	{0, 0, 5, 7, 6, 0, 0, 0, 0, 3, 7, 7, 2, 0, 0, 2},
	{0, 0, 7, 7, 5, 0, 0, 0, 0, 2, 7, 7, 4, 0, 0, 2},
	{0, 0, 7, 7, 6, 0, 0, 0, 0, 2, 7, 7, 5, 0, 0, 2},
	{0, 0, 4, 7, 7, 2, 0, 0, 1, 5, 7, 7, 5, 0, 0, 2},
	{0, 0, 1, 7, 7, 7, 5, 4, 7, 7, 7, 7, 5, 0, 0, 2},
	{0, 0, 0, 2, 6, 7, 7, 7, 6, 3, 7, 7, 5, 0, 0, 2},
	{0, 0, 0, 0, 0, 2, 4, 3, 0, 1, 7, 7, 4, 0, 0, 2},
	{0, 0, 0, 4, 2, 0, 0, 0, 0, 3, 7, 7, 2, 0, 0, 2},
	{0, 0, 2, 7, 7, 2, 0, 0, 1, 7, 7, 6, 0, 0, 0, 2},
	{0, 0, 1, 6, 7, 7, 4, 4, 7, 7, 7, 2, 0, 0, 0, 2},
	{0, 0, 0, 1, 5, 7, 7, 7, 7, 6, 2, 0, 0, 0, 0, 2},
	{0, 0, 0, 0, 0, 2, 3, 3, 1, 0, 0, 0, 0, 0, 0, 2}
};

#define MIN_CODE_SIZE_1 3
#define MAX_COLOR_1     8
#define MAX_X_1        14
#define MAX_Y_1       140

INTERN unsigned char color_table_1[MAX_COLOR_1][3] = {
	{  0,   0,   0},
	{ 51,  51,  51},
	{ 85,  85,  85},
	{119, 119, 119},
	{153, 153, 153},
	{187, 187, 187},
	{221, 221, 221},
	{255, 255, 255}
};

INTERN unsigned char pixel_1[MAX_Y_1][MAX_X_1] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 2, 5, 6, 6, 6, 5, 1, 0, 0, 0},
	{0, 0, 0, 4, 7, 7, 7, 7, 7, 7, 7, 2, 0, 0},
	{0, 0, 4, 7, 7, 4, 1, 1, 2, 5, 7, 7, 1, 0},
	{0, 0, 7, 7, 3, 0, 0, 0, 0, 0, 5, 7, 5, 0},
	{0, 3, 7, 6, 0, 0, 0, 0, 0, 0, 1, 7, 7, 1},
	{0, 5, 7, 4, 0, 0, 0, 0, 0, 0, 0, 6, 7, 1},
	{0, 6, 7, 4, 0, 0, 0, 0, 0, 0, 0, 7, 7, 1},
	{0, 5, 7, 4, 0, 0, 0, 0, 0, 0, 3, 7, 6, 0},
	{0, 4, 7, 6, 0, 0, 0, 0, 0, 0, 6, 7, 5, 0},
	{0, 0, 6, 7, 5, 1, 0, 0, 0, 5, 7, 6, 0, 0},
	{0, 0, 2, 7, 7, 7, 6, 6, 7, 7, 7, 2, 0, 0},
	{0, 0, 0, 2, 6, 7, 7, 7, 7, 5, 1, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 1, 2, 1, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 2, 6, 3, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 3, 7, 5, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 3, 7, 6, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 3, 7, 6, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 3, 7, 6, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 2, 7, 6, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 7, 6, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 7, 6, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 7, 6, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 7, 6, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 7, 7, 1, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 3, 5, 6, 6, 6, 5, 1, 0, 0, 0},
	{0, 0, 1, 5, 7, 7, 7, 6, 7, 7, 7, 2, 0, 0},
	{0, 0, 5, 7, 6, 2, 0, 0, 0, 3, 7, 6, 0, 0},
	{0, 1, 7, 7, 1, 0, 0, 0, 0, 0, 6, 7, 1, 0},
	{0, 0, 6, 3, 0, 0, 0, 0, 0, 1, 7, 7, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 4, 6, 7, 4, 0, 0},
	{0, 0, 0, 0, 0, 0, 2, 5, 7, 7, 5, 0, 0, 0},
	{0, 0, 0, 0, 0, 3, 7, 7, 6, 3, 0, 0, 0, 0},
	{0, 0, 0, 0, 5, 7, 6, 4, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 1, 7, 7, 1, 0, 0, 1, 5, 4, 0, 0},
	{0, 0, 0, 0, 7, 7, 6, 6, 6, 7, 7, 6, 0, 0},
	{0, 0, 0, 0, 3, 7, 7, 7, 7, 7, 5, 1, 0, 0},
	{0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 3, 5, 6, 6, 6, 4, 0, 0, 0, 0},
	{0, 0, 2, 6, 7, 7, 7, 7, 7, 7, 4, 0, 0, 0},
	{0, 0, 3, 7, 5, 2, 1, 1, 2, 7, 7, 1, 0, 0},
	{0, 0, 0, 1, 0, 0, 0, 0, 0, 7, 7, 1, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 4, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 4, 6, 7, 7, 3, 0, 0, 0},
	{0, 0, 0, 0, 5, 7, 7, 7, 7, 7, 7, 4, 0, 0},
	{0, 0, 0, 0, 7, 7, 5, 4, 4, 5, 7, 7, 0, 0},
	{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 6, 7, 1, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 1, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 7, 6, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 4, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 1, 5, 5, 0, 0, 5, 2, 0, 0, 0},
	{0, 0, 0, 1, 6, 7, 5, 0, 3, 7, 4, 0, 0, 0},
	{0, 0, 0, 6, 7, 4, 0, 0, 5, 7, 3, 0, 0, 0},
	{0, 0, 4, 7, 5, 0, 0, 0, 6, 7, 1, 0, 0, 0},
	{0, 0, 6, 7, 2, 0, 0, 0, 6, 7, 1, 0, 0, 0},
	{0, 3, 7, 6, 0, 0, 0, 0, 7, 7, 0, 0, 0, 0},
	{0, 5, 7, 4, 0, 0, 0, 1, 7, 6, 0, 0, 0, 0},
	{0, 4, 7, 5, 0, 0, 0, 0, 7, 6, 0, 1, 3, 0},
	{0, 2, 7, 7, 5, 3, 3, 4, 7, 7, 6, 7, 7, 1},
	{0, 0, 2, 6, 7, 7, 7, 7, 7, 7, 7, 4, 2, 0},
	{0, 0, 0, 0, 3, 4, 4, 5, 7, 6, 1, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 7, 5, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 2, 6, 4, 4, 4, 4, 4, 4, 4, 2, 0, 0},
	{0, 0, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 0},
	{0, 0, 6, 7, 4, 3, 3, 3, 3, 4, 4, 6, 4, 0},
	{0, 1, 7, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 7, 6, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0},
	{0, 4, 7, 6, 4, 6, 7, 7, 7, 6, 4, 1, 0, 0},
	{0, 1, 7, 7, 7, 7, 6, 6, 7, 7, 7, 6, 0, 0},
	{0, 0, 7, 7, 4, 1, 0, 0, 0, 2, 7, 7, 5, 0},
	{0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 3, 7, 6, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 5, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 1, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 5, 6, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 1, 6, 7, 6, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 6, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 4, 7, 5, 0, 2, 3, 3, 3, 1, 0, 0, 0},
	{0, 0, 6, 7, 4, 6, 7, 7, 7, 7, 7, 4, 0, 0},
	{0, 1, 7, 7, 7, 7, 6, 4, 4, 5, 7, 7, 4, 0},
	{0, 4, 7, 7, 6, 3, 0, 0, 0, 0, 3, 7, 7, 0},
	{0, 5, 7, 6, 0, 0, 0, 0, 0, 0, 0, 6, 7, 1},
	{0, 4, 7, 6, 0, 0, 0, 0, 0, 0, 2, 7, 6, 0},
	{0, 0, 6, 7, 5, 1, 0, 0, 0, 1, 6, 7, 5, 0},
	{0, 0, 2, 7, 7, 7, 6, 6, 6, 7, 7, 6, 1, 0},
	{0, 0, 0, 1, 5, 7, 7, 7, 7, 7, 5, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 2, 4, 6, 6, 6, 6, 6, 6, 3, 0, 0, 0},
	{0, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 2, 0},
	{0, 3, 5, 3, 1, 1, 1, 1, 1, 1, 4, 7, 7, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 5, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 7, 7, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 4, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 5, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 3, 7, 6, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 3, 7, 7, 2, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 5, 7, 2, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 4, 6, 6, 6, 6, 5, 3, 0, 0, 0},
	{0, 0, 2, 6, 7, 7, 7, 6, 7, 7, 7, 5, 0, 0},
	{0, 0, 6, 7, 4, 1, 0, 0, 0, 1, 6, 7, 4, 0},
	{0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 1, 7, 6, 0},
	{0, 0, 6, 7, 2, 0, 0, 0, 0, 0, 5, 7, 5, 0},
	{0, 0, 3, 7, 7, 6, 5, 4, 4, 6, 7, 6, 0, 0},
	{0, 0, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 3, 0},
	{0, 0, 7, 7, 1, 1, 2, 3, 3, 1, 4, 7, 6, 0},
	{0, 2, 7, 6, 0, 0, 0, 0, 0, 0, 0, 7, 7, 1},
	{0, 1, 7, 7, 3, 0, 0, 0, 0, 0, 4, 7, 6, 0},
	{0, 0, 4, 7, 7, 7, 6, 6, 6, 6, 7, 7, 3, 0},
	{0, 0, 0, 2, 6, 7, 7, 7, 7, 7, 6, 2, 0, 0},
	{0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 3, 5, 6, 6, 6, 5, 2, 0, 0, 0},
	{0, 0, 2, 5, 7, 7, 7, 7, 7, 7, 7, 4, 0, 0},
	{0, 3, 7, 7, 5, 2, 1, 1, 1, 3, 7, 7, 4, 0},
	{0, 6, 7, 5, 0, 0, 0, 0, 0, 0, 2, 7, 4, 0},
	{1, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0},
	{1, 7, 6, 0, 0, 0, 0, 0, 0, 0, 4, 7, 4, 0},
	{0, 7, 7, 4, 0, 0, 0, 0, 0, 3, 7, 7, 1, 0},
	{0, 3, 7, 7, 6, 6, 5, 6, 7, 7, 7, 7, 0, 0},
	{0, 0, 3, 6, 7, 7, 7, 7, 6, 5, 7, 6, 0, 0},
	{0, 0, 0, 0, 1, 3, 3, 1, 0, 2, 7, 6, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 5, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 4, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}
};

#define MIN_CODE_SIZE_2 3
#define MAX_COLOR_2     8
#define MAX_X_2        14
#define MAX_Y_2       140

INTERN unsigned char color_table_2[MAX_COLOR_2][3] = {
	{  0,   0,   0},
	{ 51,  51,  51},
	{ 85,  85,  85},
	{119, 119, 119},
	{153, 153, 153},
	{187, 187, 187},
	{221, 221, 221},
	{255, 255, 255}
};

INTERN unsigned char pixel_2[MAX_Y_2][MAX_X_2] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 2, 4, 6, 6, 6, 5, 0, 0, 0, 0},
	{0, 0, 1, 4, 7, 7, 7, 7, 7, 7, 4, 0, 0, 0},
	{0, 0, 5, 7, 7, 4, 1, 0, 1, 4, 7, 6, 0, 0},
	{0, 3, 7, 7, 2, 0, 0, 0, 0, 0, 5, 7, 4, 0},
	{0, 5, 7, 4, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0},
	{0, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 0},
	{0, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 0},
	{0, 6, 7, 3, 0, 0, 0, 0, 0, 0, 0, 7, 7, 0},
	{0, 3, 7, 7, 0, 0, 0, 0, 0, 0, 5, 7, 5, 0},
	{0, 0, 5, 7, 6, 0, 0, 0, 0, 5, 7, 7, 1, 0},
	{0, 0, 1, 5, 7, 7, 6, 6, 7, 7, 6, 1, 0, 0},
	{0, 0, 0, 0, 3, 6, 6, 6, 6, 4, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 1, 5, 5, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 1, 3, 7, 7, 6, 0, 0, 0, 0, 0},
	{0, 0, 1, 6, 7, 7, 7, 7, 6, 0, 0, 0, 0, 0},
	{0, 0, 1, 7, 7, 7, 5, 7, 5, 0, 0, 0, 0, 0},
	{0, 0, 0, 1, 4, 2, 1, 7, 5, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 2, 7, 5, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 2, 7, 5, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 2, 7, 5, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 2, 7, 5, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 2, 7, 6, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 2, 7, 7, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 1, 5, 3, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 4, 6, 6, 6, 6, 4, 0, 0, 0, 0},
	{0, 0, 1, 6, 7, 7, 6, 6, 7, 7, 6, 1, 0, 0},
	{0, 0, 6, 7, 7, 1, 0, 0, 0, 4, 7, 5, 0, 0},
	{0, 0, 5, 7, 1, 0, 0, 0, 0, 2, 7, 6, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 6, 7, 4, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 3, 7, 7, 5, 1, 0, 0},
	{0, 0, 0, 0, 0, 0, 5, 7, 7, 5, 0, 0, 0, 0},
	{0, 0, 0, 0, 2, 7, 7, 6, 1, 0, 0, 0, 0, 0},
	{0, 0, 0, 3, 7, 7, 4, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 4, 7, 7, 7, 5, 5, 5, 5, 5, 5, 4, 0},
	{0, 3, 7, 7, 7, 6, 6, 7, 7, 7, 7, 7, 4, 0},
	{0, 3, 5, 4, 0, 0, 0, 0, 2, 4, 5, 4, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 4, 6, 6, 6, 6, 5, 1, 0, 0, 0},
	{0, 0, 3, 6, 7, 7, 6, 6, 7, 7, 7, 1, 0, 0},
	{0, 0, 7, 7, 5, 1, 0, 0, 0, 4, 7, 4, 0, 0},
	{0, 0, 4, 5, 0, 0, 0, 0, 0, 2, 7, 4, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 5, 7, 3, 0, 0},
	{0, 0, 0, 0, 5, 7, 7, 7, 7, 7, 7, 1, 0, 0},
	{0, 0, 0, 0, 4, 6, 4, 4, 5, 6, 7, 5, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 1, 0},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 5, 7, 3, 0},
	{0, 0, 7, 6, 4, 0, 0, 0, 0, 3, 7, 7, 0, 0},
	{0, 0, 6, 7, 7, 7, 7, 6, 7, 7, 7, 3, 0, 0},
	{0, 0, 1, 4, 5, 6, 6, 6, 6, 5, 1, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 2, 5, 3, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 6, 7, 3, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 7, 7, 1, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 6, 7, 3, 3, 7, 0, 0, 0, 0},
	{0, 0, 0, 0, 3, 7, 6, 0, 4, 7, 0, 0, 0, 0},
	{0, 0, 0, 1, 7, 7, 1, 0, 4, 7, 0, 0, 0, 0},
	{0, 0, 0, 6, 7, 3, 0, 0, 4, 7, 0, 0, 0, 0},
	{0, 0, 4, 7, 7, 4, 5, 6, 7, 7, 6, 5, 5, 0},
	{0, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0},
	{0, 4, 7, 3, 1, 0, 0, 0, 5, 7, 2, 4, 1, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 5, 5, 6, 6, 6, 6, 5, 5, 5, 0, 0},
	{0, 0, 2, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0, 0},
	{0, 0, 2, 7, 4, 0, 0, 0, 0, 2, 4, 1, 0, 0},
	{0, 0, 2, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 2, 7, 4, 2, 4, 4, 4, 3, 1, 0, 0, 0},
	{0, 0, 3, 7, 7, 7, 7, 7, 7, 7, 7, 3, 0, 0},
	{0, 0, 4, 7, 7, 4, 0, 0, 0, 2, 7, 7, 0, 0},
	{0, 0, 1, 3, 1, 0, 0, 0, 0, 0, 4, 7, 4, 0},
	{0, 0, 2, 1, 0, 0, 0, 0, 0, 0, 5, 7, 4, 0},
	{0, 0, 6, 7, 5, 3, 0, 0, 0, 4, 7, 7, 0, 0},
	{0, 0, 4, 7, 7, 7, 7, 7, 7, 7, 7, 3, 0, 0},
	{0, 0, 0, 4, 5, 5, 6, 6, 6, 4, 1, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 3, 5, 6, 6, 6, 5, 2, 0, 0, 0},
	{0, 0, 0, 4, 7, 7, 6, 6, 7, 7, 7, 4, 0, 0},
	{0, 0, 3, 7, 7, 1, 0, 0, 0, 4, 7, 6, 0, 0},
	{0, 0, 6, 7, 1, 0, 1, 2, 2, 0, 3, 2, 0, 0},
	{0, 1, 7, 6, 2, 6, 7, 7, 7, 6, 2, 0, 0, 0},
	{0, 4, 7, 7, 7, 7, 4, 4, 5, 7, 7, 4, 0, 0},
	{0, 4, 7, 7, 4, 0, 0, 0, 0, 2, 7, 7, 0, 0},
	{0, 1, 7, 7, 0, 0, 0, 0, 0, 0, 6, 7, 0, 0},
	{0, 0, 6, 7, 1, 0, 0, 0, 0, 0, 6, 7, 0, 0},
	{0, 0, 4, 7, 6, 2, 0, 0, 0, 5, 7, 6, 0, 0},
	{0, 0, 0, 5, 7, 7, 6, 6, 7, 7, 6, 1, 0, 0},
	{0, 0, 0, 0, 3, 5, 6, 6, 6, 4, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5, 0},
	{0, 0, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0},
	{0, 0, 6, 7, 1, 0, 0, 0, 0, 1, 7, 7, 2, 0},
	{0, 0, 6, 7, 0, 0, 0, 0, 0, 4, 7, 4, 0, 0},
	{0, 0, 5, 5, 0, 0, 0, 0, 2, 7, 7, 1, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 2, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 3, 7, 5, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 1, 7, 7, 2, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 4, 7, 6, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 7, 7, 2, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 2, 7, 7, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 5, 4, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 4, 6, 6, 6, 6, 5, 4, 0, 0, 0},
	{0, 0, 1, 6, 7, 7, 6, 6, 7, 7, 7, 3, 0, 0},
	{0, 0, 4, 7, 3, 0, 0, 0, 0, 2, 7, 5, 0, 0},
	{0, 0, 4, 7, 0, 0, 0, 0, 0, 0, 7, 6, 0, 0},
	{0, 0, 3, 7, 6, 3, 2, 2, 3, 6, 7, 4, 0, 0},
	{0, 0, 0, 6, 7, 7, 7, 7, 7, 7, 7, 3, 0, 0},
	{0, 0, 3, 7, 7, 5, 2, 0, 4, 5, 7, 7, 1, 0},
	{0, 0, 7, 7, 2, 0, 0, 0, 0, 0, 5, 7, 5, 0},
	{0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 4, 7, 6, 0},
	{0, 0, 7, 7, 4, 0, 0, 0, 0, 2, 7, 7, 4, 0},
	{0, 0, 3, 7, 7, 7, 5, 4, 6, 7, 7, 5, 0, 0},
	{0, 0, 0, 1, 5, 6, 6, 6, 6, 5, 2, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 3, 6, 6, 6, 6, 4, 0, 0, 0, 0},
	{0, 0, 1, 5, 7, 7, 6, 6, 7, 7, 6, 1, 0, 0},
	{0, 0, 5, 7, 5, 0, 0, 0, 0, 5, 7, 6, 0, 0},
	{0, 0, 7, 7, 1, 0, 0, 0, 0, 0, 7, 7, 3, 0},
	{0, 0, 7, 7, 0, 0, 0, 0, 0, 0, 4, 7, 5, 0},
	{0, 0, 7, 7, 3, 0, 0, 0, 0, 3, 6, 7, 5, 0},
	{0, 0, 2, 7, 7, 6, 4, 5, 7, 7, 7, 7, 6, 0},
	{0, 0, 0, 1, 5, 7, 7, 7, 7, 3, 4, 7, 5, 0},
	{0, 0, 4, 1, 0, 0, 0, 0, 0, 0, 6, 7, 2, 0},
	{0, 0, 7, 7, 4, 0, 0, 0, 2, 6, 7, 5, 0, 0},
	{0, 0, 4, 7, 7, 7, 6, 6, 7, 7, 4, 0, 0, 0},
	{0, 0, 0, 4, 5, 6, 6, 6, 5, 2, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
};

#define MIN_CODE_SIZE_3 3
#define MAX_COLOR_3     8
#define MAX_X_3        14
#define MAX_Y_3       140

INTERN unsigned char color_table_3[MAX_COLOR_3][3] = {
	{  0,   0,   0},
	{ 51,  51,  51},
	{ 85,  85,  85},
	{119, 119, 119},
	{153, 153, 153},
	{187, 187, 187},
	{221, 221, 221},
	{255, 255, 255}
};

INTERN unsigned char pixel_3[MAX_Y_3][MAX_X_3] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 2, 3, 2, 1, 0, 0, 0, 0},
	{0, 0, 3, 4, 6, 7, 7, 7, 7, 7, 6, 2, 0, 0},
	{0, 0, 7, 7, 7, 6, 4, 4, 4, 6, 7, 7, 1, 0},
	{0, 2, 7, 5, 1, 0, 0, 0, 0, 0, 4, 7, 4, 0},
	{0, 4, 7, 4, 0, 0, 0, 0, 0, 0, 2, 7, 4, 0},
	{0, 4, 7, 3, 0, 0, 0, 0, 0, 0, 3, 7, 5, 0},
	{0, 4, 7, 4, 0, 0, 0, 0, 0, 0, 3, 7, 4, 0},
	{0, 2, 7, 7, 6, 4, 4, 4, 4, 5, 7, 7, 2, 0},
	{0, 0, 3, 6, 7, 7, 7, 7, 7, 7, 7, 3, 0, 0},
	{0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 1, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0},
	{0, 4, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0},
	{0, 5, 6, 6, 6, 4, 4, 4, 4, 4, 4, 4, 4, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 6, 7, 4, 4, 4, 4, 3, 3, 3, 2, 0, 0},
	{0, 2, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 4, 0},
	{0, 0, 0, 1, 1, 1, 4, 4, 4, 4, 5, 6, 3, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 1, 1, 1, 2, 3, 3, 3, 3, 3, 2, 0},
	{0, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 0},
	{0, 2, 5, 6, 5, 4, 4, 4, 4, 4, 4, 4, 1, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 2, 4, 4, 4, 4, 3, 3, 3, 2, 1, 0, 0, 0},
	{0, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 2, 0},
	{0, 1, 3, 3, 3, 3, 3, 4, 4, 5, 6, 7, 4, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0},
	{0, 0, 2, 3, 4, 4, 5, 5, 7, 7, 7, 3, 0, 0},
	{0, 0, 6, 7, 7, 7, 6, 6, 6, 6, 6, 3, 0, 0},
	{0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0},
	{0, 3, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 5, 0},
	{0, 4, 6, 6, 6, 6, 6, 6, 6, 6, 5, 4, 3, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 1, 3, 3, 3, 3, 2, 1, 0, 0, 0, 0},
	{0, 1, 4, 7, 7, 7, 7, 7, 7, 7, 4, 0, 0, 0},
	{0, 5, 7, 6, 7, 7, 3, 6, 7, 6, 7, 6, 1, 0},
	{0, 6, 7, 1, 7, 5, 0, 7, 4, 0, 5, 7, 5, 0},
	{0, 7, 4, 2, 7, 3, 3, 7, 3, 0, 0, 7, 6, 0},
	{1, 7, 4, 2, 7, 2, 4, 7, 2, 0, 0, 5, 7, 1},
	{1, 7, 3, 1, 3, 0, 2, 4, 0, 0, 0, 4, 7, 1},
	{1, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 1},
	{0, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 7, 6, 0},
	{0, 5, 7, 5, 3, 2, 1, 1, 1, 1, 4, 7, 4, 0},
	{0, 1, 5, 7, 7, 7, 7, 7, 7, 7, 7, 5, 1, 0},
	{0, 0, 0, 0, 4, 4, 5, 6, 6, 4, 4, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 0},
	{0, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0},
	{0, 3, 3, 3, 4, 7, 4, 1, 1, 1, 1, 1, 0, 0},
	{0, 0, 0, 0, 4, 7, 1, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 6, 7, 5, 6, 6, 4, 3, 0, 0, 0},
	{0, 1, 4, 7, 7, 7, 7, 6, 6, 7, 7, 4, 0, 0},
	{0, 4, 7, 6, 7, 5, 0, 0, 0, 1, 6, 7, 1, 0},
	{0, 0, 0, 2, 7, 4, 0, 0, 0, 0, 6, 7, 1, 0},
	{0, 0, 0, 4, 7, 2, 0, 0, 0, 0, 7, 5, 0, 0},
	{0, 0, 0, 4, 7, 0, 0, 0, 0, 0, 7, 4, 0, 0},
	{0, 3, 4, 7, 7, 5, 4, 4, 4, 5, 7, 5, 4, 0},
	{1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0},
	{0, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 3, 5, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 3, 7, 5, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 3, 7, 1, 0, 0, 0, 0, 0},
	{0, 2, 4, 4, 5, 5, 4, 5, 5, 5, 5, 5, 3, 0},
	{0, 4, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 5, 0},
	{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 3, 4, 0, 0, 0, 1, 3, 0, 0, 0, 0},
	{0, 0, 0, 7, 7, 0, 0, 0, 4, 7, 4, 0, 0, 0},
	{0, 0, 6, 7, 2, 0, 0, 0, 1, 5, 7, 4, 0, 0},
	{0, 2, 7, 5, 0, 0, 0, 0, 0, 0, 6, 7, 4, 0},
	{0, 5, 7, 2, 0, 0, 0, 0, 0, 0, 1, 6, 7, 0},
	{1, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0},
	{0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 2, 6, 1, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 5, 7, 1, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 1, 7, 5, 0, 0, 0, 1, 2, 4, 4, 0},
	{0, 0, 0, 3, 7, 4, 3, 3, 5, 7, 7, 7, 7, 0},
	{0, 5, 6, 7, 7, 7, 7, 7, 7, 6, 4, 3, 1, 0},
	{0, 5, 6, 7, 7, 5, 4, 1, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 1, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 7, 6, 1, 0, 0, 0, 0, 0, 2, 2, 0},
	{0, 0, 0, 4, 7, 7, 5, 4, 5, 6, 7, 7, 5, 0},
	{0, 0, 0, 0, 4, 6, 7, 7, 7, 7, 6, 5, 2, 0},
	{0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 2, 0, 0, 6, 7, 3, 0, 0, 0, 0},
	{0, 0, 0, 4, 7, 3, 0, 2, 7, 7, 1, 0, 0, 0},
	{0, 0, 0, 6, 7, 1, 0, 0, 4, 7, 5, 0, 0, 0},
	{0, 0, 3, 7, 4, 0, 0, 0, 0, 6, 7, 2, 0, 0},
	{0, 0, 6, 7, 1, 0, 0, 0, 0, 1, 7, 7, 1, 0},
	{0, 2, 7, 5, 0, 0, 0, 0, 0, 0, 5, 7, 5, 0},
	{0, 4, 7, 3, 0, 0, 0, 0, 0, 0, 2, 7, 7, 1},
	{0, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 5, 7, 3},
	{2, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0},
	{2, 7, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 5, 5, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 7, 5, 0, 1, 1, 0, 0, 0, 0},
	{0, 0, 0, 1, 4, 7, 7, 7, 7, 7, 5, 2, 0, 0},
	{0, 2, 4, 7, 7, 7, 6, 6, 4, 4, 7, 5, 0, 0},
	{1, 7, 7, 6, 7, 6, 0, 0, 0, 1, 7, 4, 0, 0},
	{1, 4, 1, 2, 7, 4, 0, 0, 0, 3, 7, 3, 0, 0},
	{0, 0, 0, 4, 7, 2, 0, 0, 0, 4, 7, 1, 0, 0},
	{0, 0, 0, 6, 7, 0, 0, 0, 1, 7, 6, 0, 0, 0},
	{0, 0, 1, 7, 4, 0, 0, 0, 1, 7, 5, 0, 0, 0},
	{0, 0, 4, 7, 2, 0, 0, 0, 1, 7, 7, 4, 4, 0},
	{0, 0, 6, 7, 0, 0, 0, 0, 0, 3, 6, 7, 5, 0},
	{0, 0, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
};

INTERN IMAGE default_digits[4] = {
	{
		GIF87A,
		0, 0,
		MAX_X_0, MAX_Y_0,
		NO,
		0,
		0,
		MIN_CODE_SIZE_0 - 1,
		NO,
		YES,
		MIN_CODE_SIZE_0 - 1,
		NO, 0,
		0,
		0,
		(unsigned char *)color_table_0,
		(unsigned char *)pixel_0
	},
	{
		GIF87A,
		0, 0,
		MAX_X_1, MAX_Y_1,
		NO,
		0,
		0,
		MIN_CODE_SIZE_1 - 1,
		NO,
		YES,
		MIN_CODE_SIZE_1 - 1,
		NO, 0,
		0,
		0,
		(unsigned char *)color_table_1,
		(unsigned char *)pixel_1
	},
	{
		GIF87A,
		0, 0,
		MAX_X_2, MAX_Y_2,
		NO,
		0,
		0,
		MIN_CODE_SIZE_2 - 1,
		NO,
		YES,
		MIN_CODE_SIZE_2 - 1,
		NO, 0,
		0,
		0,
		(unsigned char *)color_table_2,
		(unsigned char *)pixel_2
	},
	{
		GIF87A,
		0, 0,
		MAX_X_3, MAX_Y_3,
		NO,
		0,
		0,
		MIN_CODE_SIZE_3 - 1,
		NO,
		YES,
		MIN_CODE_SIZE_3 - 1,
		NO, 0,
		0,
		0,
		(unsigned char *)color_table_3,
		(unsigned char *)pixel_3
	},
};

IMAGE *get_digits(int digits_number) {
	if ((digits_number < 0) || (digits_number >= 4))
		digits_number = 0;
	return(default_digits + digits_number);
}

