/*
 * npc.h -- standard definition of npc
 *
 * Copyright (c) 1995-1997 by nir@mxa.meshnet.or.jp
 *
 * This file is part of npc.cgi source tree.
 * npc.cgi is free software; you can redistribute it and/or modify it
 * for any purpose.
 *
 * @(#)$Id: npc.h,v 1.18 1997/12/11 14:02:41 nir Rel $
 */

/*
 * $Log: npc.h,v $
 * Revision 1.18  1997/12/11 14:02:41  nir
 * Add left, top and disposal_method elements to struct IMAGE.
 * Rename compress() to convert().
 *
 * Revision 1.17  1997/11/10 16:19:05  nir
 * Append index file read_only flag.
 *
 * Revision 1.16  1997/11/08 18:24:27  nir
 * Modify set_control() declaration.
 *
 * Revision 1.15  1997/11/06 19:53:01  nir
 * Add mode element to type GCONTROL.
 *
 * Revision 1.14  1997/11/05 12:12:58  nir
 * Add Copyright, Id and Log.
 * Append new TAG id. Delete obsoleted TAG id.
 *
 */

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(_WIN32)
#include <io.h>
#include <time.h>
#include <windows.h>
#include <sys/locking.h>
#else
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#endif

#define ID_MARK   "#!npc.cgi"
#define BOUNDARY  "npc.cgi"

#define MAX_WIDTH    10
#define DEFAULT_WIDTH 5

#define WIDTHLIMITS 80
#define MAX_CHAR    (WIDTHLIMITS * 5)
#define LINE_SIZE   1024

#define GLOBAL
#define IMPORT extern
#define INTERN static
#define LOCAL  static

#define EOS '\0'

#define YES 1
#define NO  0

#define ON  1
#define OFF 0
#define BAD (-1)

#define LOOP for(;;)

#define GIF87A 0
#define GIF89A 1

#define NO_DISPOSAL_SPEC   0
#define DO_NOT_DISPOSE     1
#define RESTORE_BACKGROUND 2
#define RESTORE_PREVIOUS   3

#define CODE_IMAGE    0x2C
#define CODE_TRAILER  0x3B
#define CODE_EXT      0x21
#define CODE_TEXT_EXT 0x01
#define CODE_CTRL_EXT 0xF9
#define CODE_COMM_EXT 0xFE
#define CODE_APP_EXT  0xFF

enum tag_id {
	T_ADDRESS,
	T_ANIMATION,
	T_BROWSER,
	T_COLOR,
	T_COUNTER,
	T_DEBUG,
	T_DELAY,
	T_DIGITS,
	T_ELSE,
	T_ELSIF,
	T_ENDIF,
	T_ENVIRONMENT,
	T_FALSE,
	T_HELP,
	T_HOST,
	T_IF,
	T_INCREMENT,
	T_INDEX,
	T_INITIAL,
	T_LOCATION,
	T_MODE,
	T_NUMBER,
	T_OFFSET,
	T_OPTION,
	T_PROGRESS,
	T_RANDOM,
	T_REFERER,
	T_RESTRICTION,
	T_TRANSPARENT,
	T_TRUE,
	T_UNIT,
	T_WIDTH,
	/* invalid */
	T_BAD
};

#if defined(_WIN32)
#define SEP '\\'
typedef long off_t;
#else
#define SEP '/'
typedef int BOOLEAN;
#endif

typedef struct _IMAGE {
	int		version;
	unsigned int	left;
	unsigned int	top;
	unsigned int	width;
	unsigned int	height;
	BOOLEAN		interlace_flag;
	unsigned int	aspect;
	unsigned int	background;
	unsigned int	s_size;	/* color resolution = 2 << s_size */
	BOOLEAN		sort_flag;
	BOOLEAN		color_table_flag;
	unsigned int	p_size;	/* color table size = 2 << p_size */
	BOOLEAN		transparent_color_flag;
	unsigned int	transparent_color;
	unsigned int	disposal_method;
	unsigned int	delay;
	unsigned char	*color_table;
	unsigned char	*pixel;
} IMAGE;

typedef struct _GCONTROL {
	BOOLEAN		random;
	BOOLEAN		progress;
	BOOLEAN		gif_animation;
	int		width;
	int		unit;
	int		offset;
	int		number;
	int		increment;
	int		restriction;
	int		mode;
	int		digits;
	int		initial;
	int		transparent;
	int		delay[2];
	long		color[2];
	char		*location;
} GCONTROL;

typedef struct _QSTR {
	char		*tag;
	char		*body;
	struct _QSTR	*next;
} QSTR;

typedef struct _ENV {
	BOOLEAN		nph;
	BOOLEAN		read_only;
	char		*index_dir;
	char		*index;
	char		*browser;
	char		*referer;
	char		*host;
	int		addr[4];
	QSTR		*query;
} ENV;

typedef struct _DIGITS {
	int		number;
	int		increment;
} DIGITS;

int main(int argc, char **argv);
void save_main(void);
void get_environ(int argc, char **argv);
void get_param(void);
void debug_out(char *debug);
void env_out(char *environment);
FILE *open_index(void);
void get_config(FILE *index_file);
enum tag_id tag_search(char *tag);
void set_control(GCONTROL *pg, char *name, enum tag_id id, char *param);
void update_count(FILE *index_file);
int next_num(char **pstr);
int convert(unsigned int min_code_size,
	unsigned char *pixel,
	unsigned int len);
void gwrite(unsigned char *buf, unsigned int num);
void gputc(unsigned int c);
void gputw(unsigned int w);
void error_out(char *format, ...);
char *new_str(char *str);
BOOLEAN reg_strcmp(char *exp, char *str);
void regerror(char *msg);
IMAGE *get_digits(int digits_number);

IMPORT char **environ;

IMPORT IMAGE	image;
IMPORT IMAGE	numbers;
IMPORT GCONTROL	gcontrol;
IMPORT ENV	env;

IMPORT char version[];

