/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.StaticQueryContext;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.Serializer;
import nu.xom.converters.SAXConverter;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.io.StaxParser;
import nux.xom.io.StaxUtil;
import nux.xom.io.StreamingSerializer;
import nux.xom.io.StreamingSerializerFactory;
import nux.xom.pool.BuilderFactory;
import nux.xom.pool.BuilderPool;
import nux.xom.pool.FileUtil;
import nux.xom.pool.XOMUtil;
import nux.xom.sandbox.XMLMatrix;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class BinaryXMLBench {
    private static final int minWarmupTime = 10;
    private static final int minMeasureTime = 10;
    private NodeFactory bnuxFactory;
    private BinaryXMLCodec codec;
    private Builder builder;
    private StaticQueryContext context;
    private Transformer saxonSerializer;
    private NodeInfo saxonDoc;
    private DocumentBuilder domBuilder;
    private Transformer domSerializer;
    private org.w3c.dom.Document domDoc;
    private Object fiSerializer;
    private Builder fiBuilder;
    private Method fiMethod;
    private XMLStreamReader fistaxReader;
    private Method fistaxMethod;
    private Builder staxBuilder;
    private XMLInputFactory staxInputFactory;
    private XMLOutputFactory staxOutputFactory;
    private File file;
    private String cmd;
    private boolean isDeserCmd;
    private String mode;
    private int compressionLevel;
    private byte[] data;
    private byte[] fileData;
    private Document doc;
    private int checksum = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private BinaryXMLBench() {
    }

    private void prepare() throws Exception {
        this.data = null;
        this.doc = null;
        this.fileData = null;
        this.fileData = FileUtil.toByteArray(new FileInputStream(this.file));
        if (this.mode.startsWith("bnux")) {
            this.doc = new Builder().build((InputStream)new ByteArrayInputStream(this.fileData));
            this.data = new BinaryXMLCodec().serialize(this.doc, this.compressionLevel);
            if (!this.cmd.equals("deser")) {
                this.doc = this.codec.deserialize(this.data);
                this.data = null;
            }
            if (this.cmd.equals("deser")) {
                this.doc = null;
            }
            this.fileData = null;
        }
        if (this.mode.startsWith("xom") && !this.cmd.equals("deser")) {
            this.doc = new Builder().build((InputStream)new ByteArrayInputStream(this.fileData));
        }
        this.domDoc = null;
        if (this.mode.equals("dom") && !this.cmd.equals("deser")) {
            this.domDoc = this.domBuilder.parse(new ByteArrayInputStream(this.fileData));
        }
        this.saxonDoc = null;
        if (this.mode.equals("saxon") && !this.cmd.equals("deser")) {
            this.saxonDoc = this.context.buildDocument((Source)new StreamSource(new ByteArrayInputStream(this.fileData)));
        }
        if (this.mode.startsWith("fi")) {
            this.doc = new Builder().build((InputStream)new ByteArrayInputStream(this.fileData));
            if (this.cmd.equals("deser")) {
                this.data = this.mode.indexOf("stax") >= 0 ? BinaryXMLBench.serializeWithFastInfosetStax(this.doc, (XMLStreamWriter)this.fiSerializer, this.fiMethod, new ByteArrayOutputStream()) : BinaryXMLBench.serializeWithFastInfoset(this.doc, (ContentHandler)this.fiSerializer, this.fiMethod, new ByteArrayOutputStream());
                this.doc = null;
            }
            this.fileData = null;
        }
        if (!this.cmd.equals("deser")) {
            this.fileData = null;
        }
        System.gc();
    }

    private void run() throws Exception {
        if (!this.isDeserCmd && (this.cmd.equals("ser") || this.cmd.equals("serdeser") || this.cmd.equals("test"))) {
            this.data = null;
            ByteArrayOutputStream out = BinaryXMLBench.createOutputStream(this.cmd.equals("ser"));
            if (this.mode.startsWith("bnux")) {
                this.codec.serialize(this.doc, this.compressionLevel, out);
                this.data = out.toByteArray();
            } else if (this.mode.startsWith("xom")) {
                this.data = this.mode.indexOf("stax") >= 0 ? BinaryXMLBench.serializeWithStax(this.doc, this.staxOutputFactory, out) : BinaryXMLBench.serializeWithXOM(this.doc, out);
            } else if (this.mode.equals("saxon")) {
                this.saxonSerializer.transform((Source)this.saxonDoc, new StreamResult(out));
                this.data = out.toByteArray();
            } else if (this.mode.equals("dom")) {
                this.domSerializer.transform(new DOMSource(this.domDoc), new StreamResult(out));
                this.data = out.toByteArray();
            } else if (this.mode.startsWith("fi")) {
                this.data = this.mode.indexOf("stax") >= 0 ? BinaryXMLBench.serializeWithFastInfosetStax(this.doc, (XMLStreamWriter)this.fiSerializer, this.fiMethod, out) : BinaryXMLBench.serializeWithFastInfoset(this.doc, (ContentHandler)this.fiSerializer, this.fiMethod, out);
            } else {
                throw new IllegalArgumentException("illegal mode");
            }
            this.checksum += this.data.length;
        }
        Document doc2 = null;
        if (this.isDeserCmd || this.cmd.equals("serdeser") || this.cmd.equals("test")) {
            if (this.mode.startsWith("bnux")) {
                doc2 = this.codec.deserialize(new ByteArrayInputStream(this.data), this.bnuxFactory);
            } else if (this.mode.startsWith("xom") && this.mode.indexOf("stax") >= 0) {
                doc2 = StaxUtil.createBuilder(this.staxInputFactory, this.staxBuilder.getNodeFactory()).build((InputStream)new ByteArrayInputStream(this.fileData));
            } else if (this.mode.startsWith("xom")) {
                doc2 = this.builder.build((InputStream)new ByteArrayInputStream(this.fileData));
            } else if (this.mode.equals("saxon")) {
                this.context.buildDocument((Source)new StreamSource(new ByteArrayInputStream(this.fileData)));
            } else if (this.mode.equals("dom")) {
                this.domDoc = null;
                this.domDoc = this.domBuilder.parse(new ByteArrayInputStream(this.fileData));
            } else if (this.mode.startsWith("fi") && this.mode.indexOf("stax") >= 0) {
                this.fistaxMethod.invoke((Object)this.fistaxReader, new ByteArrayInputStream(this.data));
                doc2 = new StaxParser(this.fistaxReader, this.staxBuilder.getNodeFactory()).build();
            } else if (this.mode.startsWith("fi")) {
                doc2 = this.fiBuilder.build((InputStream)new ByteArrayInputStream(this.data));
            } else {
                throw new IllegalArgumentException("illegal mode");
            }
            if (doc2 != null) {
                this.checksum += doc2.getBaseURI().length();
            }
        }
    }

    private void init() throws Exception {
        DocumentBuilderFactory factory;
        this.codec = new BinaryXMLCodec();
        this.bnuxFactory = null;
        if (this.mode.startsWith("bnux") && this.mode.indexOf("NNF") >= 0) {
            this.bnuxFactory = XOMUtil.getNullNodeFactory();
        }
        this.builder = new Builder();
        if (this.mode.indexOf("pool") >= 0) {
            this.builder = BuilderPool.GLOBAL_POOL.getBuilder(false);
        }
        if (this.mode.equals("xom-V")) {
            this.builder = new Builder(new NodeFactory(){});
        } else if (this.mode.equals("xom-V-pool")) {
            this.builder = new BuilderFactory(){

                protected Builder newBuilder(XMLReader parser, boolean validate) {
                    return new Builder(parser, false, new NodeFactory(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }
                    });
                }
            }.createBuilder(false);
        }
        if (this.mode.equals("xom-NNF")) {
            this.builder = new Builder(XOMUtil.getNullNodeFactory());
        } else if (this.mode.equals("xom-NNF-pool")) {
            this.builder = new BuilderFactory(){

                protected Builder newBuilder(XMLReader parser, boolean validate) {
                    return new Builder(parser, false, XOMUtil.getNullNodeFactory());
                }
            }.createBuilder(false);
        }
        this.context = null;
        this.saxonSerializer = null;
        if (this.mode.equals("saxon")) {
            this.context = new StaticQueryContext(new Configuration());
            this.saxonSerializer = BinaryXMLBench.createIdentityTransform(new String[]{"net.sf.saxon.TransformerFactoryImpl"});
        }
        this.domBuilder = null;
        this.domSerializer = null;
        if (this.mode.equals("dom")) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.domBuilder = factory.newDocumentBuilder();
            this.domSerializer = BinaryXMLBench.createIdentityTransform(new String[]{"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", "org.apache.xalan.processor.TransformerFactoryImpl"});
            System.err.println(this.domSerializer.getClass().getName());
        }
        this.fiBuilder = null;
        this.fiSerializer = null;
        this.fiMethod = null;
        if (this.mode.startsWith("fi")) {
            factory = null;
            if (this.mode.indexOf("NNF") >= 0) {
                factory = XOMUtil.getNullNodeFactory();
            }
            XMLReader parser = (XMLReader)Class.forName("com.sun.xml.fastinfoset.sax.SAXDocumentParser").newInstance();
            this.fiBuilder = new Builder(parser, false, (NodeFactory)factory);
            this.fiSerializer = this.mode.indexOf("stax") >= 0 ? (XMLStreamWriter)Class.forName("com.sun.xml.fastinfoset.stax.StAXDocumentSerializer").newInstance() : (ContentHandler)Class.forName("com.sun.xml.fastinfoset.sax.SAXDocumentSerializer").newInstance();
            if (this.mode.startsWith("fi1")) {
                Method method = this.fiSerializer.getClass().getMethod("setAttributeValueSizeLimit", Integer.TYPE);
                method.invoke(this.fiSerializer, new Integer(Integer.MAX_VALUE));
                method = this.fiSerializer.getClass().getMethod("setCharacterContentChunkSizeLimit", Integer.TYPE);
                method.invoke(this.fiSerializer, new Integer(Integer.MAX_VALUE));
            }
            Class<?> clazz = this.fiSerializer.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.io.OutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            this.fiMethod = clazz.getMethod("setOutputStream", classArray);
            if (this.mode.indexOf("stax") >= 0) {
                this.fistaxReader = (XMLStreamReader)Class.forName("com.sun.xml.fastinfoset.stax.StAXDocumentParser").newInstance();
                Class<?> clazz3 = this.fistaxReader.getClass();
                Class[] classArray2 = new Class[1];
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("java.io.InputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[0] = clazz4;
                this.fistaxMethod = clazz3.getMethod("setInputStream", classArray2);
            }
        }
        this.staxBuilder = null;
        if (this.mode.indexOf("stax") >= 0) {
            factory = null;
            if (this.mode.indexOf("NNF") >= 0) {
                factory = XOMUtil.getNullNodeFactory();
            }
            this.staxBuilder = StaxUtil.createBuilder(this.staxInputFactory, (NodeFactory)factory);
        }
    }

    private float runBenchmarks(long minWarmupTime, long minMeasureTime) throws Exception {
        long end;
        this.prepare();
        System.out.println("now warming up...");
        long start = System.currentTimeMillis();
        int iters = 0;
        do {
            this.run();
            ++iters;
        } while ((end = System.currentTimeMillis()) - start < minWarmupTime);
        float secs = (float)(end - start) / 1000.0f;
        System.gc();
        System.out.println("warmup:   secs=" + secs + ", iters/sec=" + (float)iters / secs);
        int limit = Math.max(1, (int)((float)iters / secs / 10.0f));
        iters = 0;
        start = System.currentTimeMillis();
        do {
            int i = 0;
            while (i < limit) {
                this.run();
                ++iters;
                ++i;
            }
        } while ((end = System.currentTimeMillis()) - start < minMeasureTime);
        secs = (float)(end - start) / 1000.0f;
        System.out.println("measured: secs=" + secs + ", iters/sec=" + (float)iters / secs);
        return (float)iters / secs;
    }

    public static void main(String[] args) throws Exception {
        int k = 0;
        String cmd = args[k++];
        String mode = args[k++];
        int compressionLevel = 0;
        if (mode.startsWith("bnux")) {
            try {
                String s = mode.substring("bnux".length());
                int i = 0;
                while (i < s.length() && Character.isDigit(s.charAt(i))) {
                    ++i;
                }
                compressionLevel = Integer.parseInt(s.substring(0, i));
            }
            catch (NumberFormatException e) {
                compressionLevel = 0;
            }
            System.out.println("compressionLevel=" + compressionLevel);
        }
        if (mode.equals("bnux0-NV")) {
            System.setProperty("nu.xom.Verifier.checkPCDATA", "false");
            System.setProperty("nu.xom.Verifier.checkURI", "false");
            System.out.println("patchesEnabled=true");
        }
        XMLInputFactory staxInputFactory = null;
        if (mode.indexOf("stax") >= 0 && mode.indexOf("fi") < 0) {
            if (mode.indexOf("sun") >= 0) {
                staxInputFactory = (XMLInputFactory)Class.forName("com.sun.xml.stream.ZephyrParserFactory").newInstance();
            } else if (mode.indexOf("bea") >= 0) {
                staxInputFactory = (XMLInputFactory)Class.forName("com.bea.xml.stream.MXParserFactory").newInstance();
            } else if (mode.indexOf("wood") >= 0) {
                staxInputFactory = (XMLInputFactory)Class.forName("com.ctc.wstx.stax.WstxInputFactory").newInstance();
            }
        }
        XMLOutputFactory staxOutputFactory = null;
        if (mode.indexOf("stax") >= 0) {
            staxOutputFactory = BinaryXMLBench.createXMLOutputFactory(mode);
        }
        File outputDir = new File(args[k++]);
        URI[] uris = FileUtil.listFiles(args[k++], false, "*.xml *.xsl", "");
        Arrays.sort(uris, new Comparator(){

            public int compare(Object o1, Object o2) {
                URI u1 = (URI)o1;
                URI u2 = (URI)o2;
                return (int)(new File(u1).length() - new File(u2).length());
            }
        });
        BinaryXMLBench bench = new BinaryXMLBench();
        bench.cmd = cmd;
        bench.isDeserCmd = cmd.equals("deser");
        bench.mode = mode;
        bench.compressionLevel = compressionLevel;
        bench.staxInputFactory = staxInputFactory;
        bench.staxOutputFactory = staxOutputFactory;
        bench.init();
        XMLMatrix matrix = new XMLMatrix(new File(outputDir, String.valueOf(bench.cmd) + ".xml"), true);
        k = 0;
        while (k < uris.length) {
            bench.file = new File(uris[k]);
            if (!bench.file.isDirectory()) {
                System.out.println("\nnow processing " + bench.file);
                double itersPerSec = 0.0;
                try {
                    itersPerSec = bench.runBenchmarks(10000L, 10000L);
                }
                catch (Exception e) {
                    if (BinaryXMLBench.hasCause(e, "org.jvnet.fastinfoset.FastInfosetException", "ParseError at [row,col]")) {
                        e.printStackTrace(System.out);
                    }
                    e.printStackTrace(System.out);
                    return;
                }
                NumberFormat format = NumberFormat.getInstance();
                format.setGroupingUsed(false);
                format.setMaximumFractionDigits(1);
                double mbs = itersPerSec * (double)bench.file.length() / 1048576.0;
                double kb = (float)bench.file.length() / 1024.0f;
                matrix.put(bench.file.getName(), bench.mode, format.format(mbs));
                matrix.put(bench.file.getName(), "XMLsize", format.format(kb));
                if (cmd.equals("ser")) {
                    matrix.put(bench.file.getName(), String.valueOf(mode) + "-csize", format.format((double)bench.data.length / 1024.0));
                }
                System.out.println("MB/s=" + mbs);
            }
            ++k;
        }
        System.out.println("matrix=" + matrix);
        matrix.saveAsXML();
        matrix.saveAsCSV();
        System.out.println("checksum=" + bench.checksum);
    }

    private static byte[] serializeWithXOM(Document doc, ByteArrayOutputStream out) throws IOException {
        Serializer ser = new Serializer((OutputStream)out);
        ser.write(doc);
        return out.toByteArray();
    }

    private static byte[] serializeWithFastInfoset(Document doc, ContentHandler fiSerializer, Method fiMethod, ByteArrayOutputStream out) throws Exception {
        try {
            fiMethod.invoke((Object)fiSerializer, out);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        new SAXConverter(fiSerializer).convert(doc);
        return out.toByteArray();
    }

    private static byte[] serializeWithFastInfosetStax(Document doc, XMLStreamWriter fiSerializer, Method method, ByteArrayOutputStream out) throws Exception {
        try {
            method.invoke((Object)fiSerializer, out);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        new StreamingSerializerFactory().createStaxSerializer(fiSerializer).write(doc);
        return out.toByteArray();
    }

    private static byte[] serializeWithStax(Document doc, XMLOutputFactory staxOutputFactory, ByteArrayOutputStream out) throws XMLStreamException, IOException {
        XMLStreamWriter writer = staxOutputFactory.createXMLStreamWriter(out, "UTF-8");
        StreamingSerializer ser = new StreamingSerializerFactory().createStaxSerializer(writer);
        ser.write(doc);
        return out.toByteArray();
    }

    private static XMLOutputFactory createXMLOutputFactory(String mode) {
        if (mode.indexOf("sun") >= 0) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.stream.ZephyrWriterFactory");
        } else if (mode.indexOf("bea") >= 0) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.bea.xml.stream.XMLOutputFactoryBase");
        } else if (mode.indexOf("wood") >= 0) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
        } else if (mode.indexOf("fi") >= 0) {
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.fastinfoset.stax.factory.StAXOutputFactory");
        }
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        System.out.println("outFactory=" + factory.getClass().getName());
        return factory;
    }

    private static Transformer createIdentityTransform(String[] clazzes) throws Exception {
        Exception t = null;
        int i = 0;
        while (i < clazzes.length) {
            if (clazzes[i] != null) {
                System.setProperty("javax.xml.transform.TransformerFactory", clazzes[i]);
            }
            try {
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                System.out.println("idTransform = " + trans.getClass().getName());
                return trans;
            }
            catch (TransformerConfigurationException e) {
                t = e;
            }
            catch (TransformerFactoryConfigurationError e) {
                t = new RuntimeException(e);
            }
            ++i;
        }
        throw t;
    }

    private static boolean hasCause(Throwable e, String clazz, String msg) {
        while (e != null) {
            if (e.getClass().getName().equals(clazz)) {
                return true;
            }
            if (msg != null && e.getMessage() != null && e.getMessage().indexOf(msg) >= 0) {
                return true;
            }
            e = e instanceof SAXException ? ((SAXException)e).getException() : (e instanceof XMLStreamException ? ((XMLStreamException)e).getNestedException() : e.getCause());
        }
        return false;
    }

    public static ByteArrayOutputStream createOutputStream(boolean nullStream) {
        return nullStream ? new NullOutputStream() : new ByteArrayOutputStream(256);
    }

    private static final class NullOutputStream
    extends ByteArrayOutputStream {
        private NullOutputStream() {
        }

        public void write(int b) {
            ++this.count;
        }

        public void write(byte[] b, int off, int len) {
            this.count += off + len;
            if (len > 0) {
                this.count += b[len - 1];
            }
        }

        public byte[] toByteArray() {
            return new byte[]{(byte)this.count};
        }

        public void close() {
            this.count = 0;
        }
    }
}

