/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import java.io.OutputStream;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.Serializer;
import nux.xom.xquery.ResultSequenceSerializer;
import nux.xom.xquery.XQueryUtil;

public final class TreeStructureCollector
extends NodeFactory {
    private Element current;
    private final Nodes NONE = new Nodes();
    private final Element DUMMY = new Element("dummy");

    public static void main(String[] args) throws Exception {
        System.out.println("\nTree structure summary:");
        System.out.println("***********************\n");
        TreeStructureCollector factory = new TreeStructureCollector();
        Document summary = new Builder((NodeFactory)factory).build(new File(args[0]));
        Serializer ser = new Serializer((OutputStream)System.out);
        ser.setIndent(4);
        ser.write(summary);
        System.out.println("\nPaths sorted by instance counts:");
        System.out.println("********************************\n");
        String query = "for $e in //* where xs:integer($e/@instances) > 1 and (every $x in $e/../@instances satisfies $x != $e/@instances) order by xs:integer($e/@instances) descending return element {node-name($e)} {attribute percent {round-half-to-even(100.0 * $e/@instances div /*/@descendants-or-self, 1)},attribute instances {$e/@instances}, attribute xpath {$e/saxon:path()}}";
        Nodes nodes = XQueryUtil.xquery((Node)summary, query);
        ResultSequenceSerializer rser = new ResultSequenceSerializer();
        rser.setIndent(4);
        rser.write(nodes, System.out);
    }

    public Document collect(Document doc) {
        this.startMakingDocument();
        this.collect(doc.getRootElement());
        return new Document(this.current);
    }

    private void collect(Element elem) {
        this.startMakingElement(elem.getQualifiedName(), elem.getNamespaceURI());
        int i = 0;
        while (i < elem.getAttributeCount()) {
            Attribute a = elem.getAttribute(i);
            this.makeAttribute(a.getQualifiedName(), a.getNamespaceURI(), a.getValue(), a.getType());
            ++i;
        }
        i = 0;
        while (i < elem.getChildCount()) {
            Node node = elem.getChild(i);
            if (node instanceof Element) {
                this.collect((Element)node);
            }
            ++i;
        }
        this.finishMakingElement(elem);
    }

    public Document startMakingDocument() {
        this.current = new Element("root");
        return super.startMakingDocument();
    }

    public Nodes finishMakingElement(Element elem) {
        this.current = (Element)this.current.getParent();
        if (elem.getParent() instanceof Document) {
            this.current = (Element)this.current.removeChild(0);
            int total = Integer.parseInt(this.current.getAttributeValue("descendants-or-self"));
            TreeStructureCollector.addAccumulatedPercentages(this.current, total);
            return new Nodes((Node)this.current);
        }
        return this.NONE;
    }

    private static void addAccumulatedPercentages(Element elem, int total) {
        String value = elem.getAttributeValue("descendants-or-self");
        if (value == null) {
            value = elem.getAttributeValue("instances");
        }
        TreeStructureCollector.incrementValue(elem, "descendants-or-self-percent", (int)Math.round(100.0 * (double)Integer.parseInt(value) / (double)total));
        int i = 0;
        while (i < elem.getChildCount()) {
            Node node = elem.getChild(i);
            if (node instanceof Element) {
                TreeStructureCollector.addAccumulatedPercentages((Element)node, total);
            }
            ++i;
        }
    }

    public Element startMakingElement(String qname, String namespaceURI) {
        String localName = TreeStructureCollector.getLocalName(qname);
        Element first = this.current.getFirstChildElement(localName, namespaceURI);
        if (first == null) {
            first = new Element(qname, namespaceURI);
            TreeStructureCollector.incrementValue(first, "descendants-or-self", 0);
            TreeStructureCollector.incrementValue(first, "instances", 0);
            TreeStructureCollector.incrementValue(first, "children", 0);
            TreeStructureCollector.incrementValue(first, "attributes", 0);
            this.current.appendChild((Node)first);
        }
        TreeStructureCollector.incrementValue(first, "descendants-or-self", 1);
        TreeStructureCollector.incrementValue(first, "instances", 1);
        Element parent = (Element)first.getParent();
        TreeStructureCollector.incrementValue(parent, "children", 1);
        TreeStructureCollector.incrementDescendantOrSelf(parent);
        this.current = first;
        return new Element(this.DUMMY);
    }

    public Nodes makeAttribute(String qname, String namespaceURI, String value, Attribute.Type type) {
        String localName = TreeStructureCollector.makeAttributeName(TreeStructureCollector.getLocalName(qname));
        Element first = this.current.getFirstChildElement(localName, namespaceURI);
        if (first == null) {
            first = new Element(TreeStructureCollector.makeAttributeName(qname), namespaceURI);
            this.current.appendChild((Node)first);
        }
        TreeStructureCollector.incrementValue(first, "instances", 1);
        Element parent = (Element)first.getParent();
        TreeStructureCollector.incrementValue(parent, "attributes", 1);
        TreeStructureCollector.incrementDescendantOrSelf(parent);
        return this.NONE;
    }

    private static void incrementDescendantOrSelf(Element parent) {
        do {
            TreeStructureCollector.incrementValue(parent, "descendants-or-self", 1);
        } while ((parent = (Element)parent.getParent()) != null);
    }

    private static void incrementValue(Element elem, String name, int value) {
        Attribute attr = elem.getAttribute(name);
        if (attr == null) {
            attr = new Attribute(name, String.valueOf(value));
            elem.addAttribute(attr);
        } else {
            int v = Integer.parseInt(attr.getValue());
            attr.setValue(String.valueOf(v + value));
        }
    }

    private static String getLocalName(String qname) {
        int i = qname.indexOf(58);
        return i < 0 ? qname : qname.substring(i + 1);
    }

    private static String makeAttributeName(String name) {
        return String.valueOf(name) + "_";
    }

    public Nodes makeComment(String data) {
        return this.NONE;
    }

    public Nodes makeDocType(String rootElementName, String publicID, String systemID) {
        return this.NONE;
    }

    public Nodes makeProcessingInstruction(String target, String data) {
        return this.NONE;
    }

    public Nodes makeText(String text) {
        return this.NONE;
    }
}

