/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.IllegalDataException;
import nu.xom.MalformedURIException;
import nu.xom.Node;
import nu.xom.Verifier;
import nu.xom.WellformednessException;

public class DocType
extends Node {
    private String rootName;
    private String systemID;
    private String publicID;
    private String internalDTDSubset = "";

    public DocType(String rootElementName, String publicID, String systemID) {
        this._setRootElementName(rootElementName);
        this._setSystemID(systemID);
        this._setPublicID(publicID);
    }

    public DocType(String rootElementName, String systemID) {
        this(rootElementName, null, systemID);
    }

    public DocType(String rootElementName) {
        this(rootElementName, null, null);
    }

    public DocType(DocType doctype) {
        this.internalDTDSubset = doctype.internalDTDSubset;
        this.publicID = doctype.publicID;
        this.systemID = doctype.systemID;
        this.rootName = doctype.rootName;
    }

    private DocType() {
    }

    static DocType build(String rootElementName, String publicID, String systemID) {
        DocType result = new DocType();
        result.publicID = publicID;
        result.systemID = systemID;
        result.rootName = rootElementName;
        return result;
    }

    public final String getRootElementName() {
        return this.rootName;
    }

    public void setRootElementName(String name) {
        this._setRootElementName(name);
    }

    private void _setRootElementName(String name) {
        Verifier.checkXMLName(name);
        this.rootName = name;
    }

    public final String getInternalDTDSubset() {
        return this.internalDTDSubset;
    }

    public final void setInternalDTDSubset(String subset) {
        if (subset != null && subset.length() > 0) {
            Verifier.checkInternalDTDSubset(subset);
            this.fastSetInternalDTDSubset(subset);
        } else {
            this.internalDTDSubset = "";
        }
    }

    final void fastSetInternalDTDSubset(String internalSubset) {
        this.internalDTDSubset = internalSubset;
    }

    public final String getPublicID() {
        return this.publicID;
    }

    public void setPublicID(String id) {
        this._setPublicID(id);
    }

    private void _setPublicID(String id) {
        int length;
        if (this.systemID == null && id != null) {
            throw new WellformednessException("Cannot have a public ID without a system ID");
        }
        if (id != null && (length = id.length()) != 0) {
            if (Verifier.isXMLSpaceCharacter(id.charAt(0))) {
                throw new IllegalDataException("Initial white space in public IDs is not round trippable.");
            }
            if (Verifier.isXMLSpaceCharacter(id.charAt(length - 1))) {
                throw new IllegalDataException("Trailing white space in public IDs is not round trippable.");
            }
            int i = 0;
            while (i < length) {
                char c = id.charAt(i);
                if (!DocType.isXMLPublicIDCharacter(c)) {
                    throw new IllegalDataException("The character 0x" + Integer.toHexString(c) + " is not allowed in public IDs");
                }
                if (c == ' ' && id.charAt(i - 1) == ' ') {
                    throw new IllegalDataException("Multiple consecutive spaces in public IDs are not round trippable.");
                }
                ++i;
            }
        }
        this.publicID = id;
    }

    public final String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String id) {
        this._setSystemID(id);
    }

    private void _setSystemID(String id) {
        if (id == null && this.publicID != null) {
            throw new WellformednessException("Cannot remove system ID without removing public ID first");
        }
        if (id != null) {
            Verifier.checkURIReference(id);
            if (id.indexOf(35) != -1) {
                MalformedURIException ex = new MalformedURIException("System literals cannot contain fragment identifiers");
                ex.setData(id);
                throw ex;
            }
        }
        this.systemID = id;
    }

    public final String getValue() {
        return "";
    }

    public final Node getChild(int position) {
        throw new IndexOutOfBoundsException("Document type declarations do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.rootName + "]";
    }

    public Node copy() {
        return new DocType(this);
    }

    public final String toXML() {
        StringBuffer result = new StringBuffer();
        result.append("<!DOCTYPE ");
        result.append(this.rootName);
        if (this.publicID != null) {
            result.append(" PUBLIC \"");
            result.append(this.publicID);
            result.append("\" \"");
            result.append(this.systemID);
            result.append('\"');
        } else if (this.systemID != null) {
            result.append(" SYSTEM \"");
            result.append(this.systemID);
            result.append('\"');
        }
        if (this.internalDTDSubset.length() != 0) {
            result.append(" [\n");
            result.append(this.internalDTDSubset);
            result.append(']');
        }
        result.append(">");
        return result.toString();
    }

    boolean isDocType() {
        return true;
    }

    private static boolean isXMLPublicIDCharacter(char c) {
        switch (c) {
            case ' ': {
                return true;
            }
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return true;
            }
            case '$': {
                return true;
            }
            case '%': {
                return true;
            }
            case '&': {
                return false;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return true;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return true;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return true;
            }
            case '@': {
                return true;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
        }
        return false;
    }
}

