/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.IOException;
import java.io.InputStream;

class EncodingHeuristics {
    private EncodingHeuristics() {
    }

    public static String readEncodingFromStream(InputStream in) throws IOException {
        int byte4;
        int byte3;
        int byte2;
        int byte1;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            in.mark(1024);
                                            byte1 = in.read();
                                            byte2 = in.read();
                                            if (byte1 != 254 || byte2 != 255) break block15;
                                            return "UnicodeBig";
                                        }
                                        if (byte1 != 255 || byte2 != 254) break block16;
                                        return "UnicodeLittle";
                                    }
                                    byte3 = in.read();
                                    if (byte1 != 239 || byte2 != 187 || byte3 != 191) break block17;
                                    return "UTF-8";
                                }
                                byte4 = in.read();
                                if (byte1 != 0 || byte2 != 0 || byte3 != 254 || byte4 != 255) break block18;
                                return "UTF32BE";
                            }
                            if (byte1 != 0 || byte2 != 0 || byte3 != 255 || byte4 != 254) break block19;
                            return "UTF32LE";
                        }
                        if (byte1 != 0 || byte2 != 0 || byte3 != 0 || byte4 != 60) break block20;
                        in.reset();
                        return "UTF32BE";
                    }
                    if (byte1 != 60 || byte2 != 0 || byte3 != 0 || byte4 != 0) break block21;
                    in.reset();
                    return "UTF32LE";
                }
                if (byte1 != 0 || byte2 != 60 || byte3 != 0 || byte4 != 63) break block22;
                in.reset();
                return "UnicodeBigUnmarked";
            }
            if (byte1 != 60 || byte2 != 0 || byte3 != 63 || byte4 != 0) break block23;
            in.reset();
            return "UnicodeLittleUnmarked";
        }
        try {
            if (byte1 == 60 && byte2 == 63 && byte3 == 120 && byte4 == 109) {
                byte[] data = new byte[1024];
                data[0] = (byte)byte1;
                data[1] = (byte)byte2;
                data[2] = (byte)byte3;
                data[3] = (byte)byte4;
                int length = in.read(data, 4, 1020) + 4;
                String declaration = new String(data, 0, length, "8859_1");
                String encoding = EncodingHeuristics.findEncodingDeclaration(declaration);
                in.reset();
                return encoding;
            }
            if (byte1 == 76 && byte2 == 111 && byte3 == 167 && byte4 == 148) {
                byte[] buffer = new byte[1016];
                int i = 0;
                while (i < buffer.length) {
                    int c = in.read();
                    if (c == -1) break;
                    buffer[i] = (byte)c;
                    ++i;
                }
                in.reset();
                return EncodingHeuristics.findEncodingDeclaration(new String(buffer, "Cp037"));
            }
        }
        catch (IOException ex) {
            in.reset();
            return "UTF-8";
        }
        catch (RuntimeException ex) {
            in.reset();
            return "UTF-8";
        }
        in.reset();
        return "UTF-8";
    }

    private static String findEncodingDeclaration(String declaration) throws IOException {
        char c;
        int position = declaration.indexOf("encoding") + 8;
        while ((c = declaration.charAt(position++)) == ' ' || c == '\t' || c == '\r' || c == '\n') {
        }
        if (c != '=') {
            throw new IOException("Couldn't determine encoding");
        }
        while ((c = declaration.charAt(position++)) == ' ' || c == '\t' || c == '\r' || c == '\n') {
        }
        char delimiter = c;
        if (delimiter != '\'' && delimiter != '\"') {
            return "UTF-8";
        }
        StringBuffer encodingName = new StringBuffer();
        while ((c = declaration.charAt(position++)) != delimiter) {
            encodingName.append(c);
        }
        return encodingName.toString();
    }
}

