/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

class XSLTHandler
implements ContentHandler,
LexicalHandler {
    private final Nodes result;
    private final ArrayList parents;
    private final NodeFactory factory;
    private StringBuffer buffer;
    private Element current;
    private AttributesImpl namespaceDeclarations = new AttributesImpl();

    XSLTHandler(NodeFactory factory) {
        this.factory = factory;
        this.result = new Nodes();
        this.parents = new ArrayList();
        this.buffer = new StringBuffer();
    }

    Nodes getResult() {
        this.flushText();
        return this.result;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        this.flushText();
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            this.namespaceDeclarations.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
            ++i;
        }
        attributes = this.namespaceDeclarations;
        Element element = this.factory.startMakingElement(qualifiedName, namespaceURI);
        if (this.parents.isEmpty()) {
            this.current = element;
        } else {
            ParentNode parent = (ParentNode)this.parents.get(this.parents.size() - 1);
            parent.appendChild(element);
        }
        this.parents.add(element);
        length = attributes.getLength();
        int i2 = 0;
        while (i2 < length) {
            String attributeName = attributes.getQName(i2);
            if (!attributeName.equals("xmlns") && !attributeName.startsWith("xmlns:")) {
                String namespace = attributes.getURI(i2);
                String value = attributes.getValue(i2);
                Nodes nodes = this.factory.makeAttribute(attributeName, namespace, value, Attribute.Type.UNDECLARED);
                int size = nodes.size();
                int j = 0;
                while (j < size) {
                    block21: {
                        Node node = nodes.get(j);
                        if (node instanceof Attribute) {
                            Attribute attribute = (Attribute)node;
                            while (true) {
                                try {
                                    element.addAttribute(attribute);
                                    break block21;
                                }
                                catch (NamespaceConflictException ex) {
                                    attribute.setNamespace("p" + attribute.getNamespacePrefix(), attribute.getNamespaceURI());
                                    continue;
                                }
                                break;
                            }
                        }
                        element.appendChild(node);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < length) {
            block22: {
                String namespacePrefix;
                String currentValue;
                String namespaceName;
                String qName = attributes.getQName(i2);
                if (qName.startsWith("xmlns:")) {
                    namespaceName = attributes.getValue(i2);
                    if (!namespaceName.equals(currentValue = element.getNamespaceURI(namespacePrefix = qName.substring(6)))) {
                        try {
                            element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                        }
                        catch (NamespaceConflictException size) {}
                    }
                } else if (qName.equals("xmlns")) {
                    namespaceName = attributes.getValue(i2);
                    if (namespaceName == null) {
                        namespaceName = "";
                    }
                    if (!namespaceName.equals(currentValue = element.getNamespaceURI(namespacePrefix = ""))) {
                        try {
                            element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                        }
                        catch (NamespaceConflictException ex) {
                            if (!"http://www.w3.org/XML/1998/namespace".equals(namespaceName) || !"".equals(namespacePrefix)) break block22;
                            element.addNamespaceDeclaration("", "");
                        }
                    }
                }
            }
            ++i2;
        }
        this.namespaceDeclarations = new AttributesImpl();
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        this.flushText();
        Element element = (Element)this.parents.remove(this.parents.size() - 1);
        if (this.parents.isEmpty()) {
            Nodes nodes = this.factory.finishMakingElement(this.current);
            int i = 0;
            while (i < nodes.size()) {
                this.result.append(nodes.get(i));
                ++i;
            }
            this.current = null;
        } else {
            Nodes nodes = this.factory.finishMakingElement(element);
            ParentNode parent = element.getParent();
            element.detach();
            int i = 0;
            while (i < nodes.size()) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    ((Element)parent).addAttribute((Attribute)node);
                } else {
                    parent.appendChild(node);
                }
                ++i;
            }
        }
    }

    public void characters(char[] text, int start, int length) {
        this.buffer.append(text, start, length);
    }

    private void flushText() {
        if (this.buffer.length() > 0) {
            Nodes text = this.factory.makeText(this.buffer.toString());
            this.addToResultTree(text);
            this.buffer = new StringBuffer();
        }
    }

    public void ignorableWhitespace(char[] text, int start, int length) {
        this.characters(text, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if ("saxon:warning".equals(target)) {
            throw new SAXException("continue");
        }
        if ("javax.xml.transform.disable-output-escaping".equals(target) || "javax.xml.transform.enable-output-escaping".equals(target)) {
            return;
        }
        this.flushText();
        int position = data.indexOf("?>");
        while (position != -1) {
            data = String.valueOf(data.substring(0, position)) + "? >" + data.substring(position + 2);
            position = data.indexOf("?>");
        }
        Nodes nodes = this.factory.makeProcessingInstruction(target, data);
        this.addToResultTree(nodes);
    }

    private void addToResultTree(Nodes nodes) {
        if (this.parents.isEmpty()) {
            int i = 0;
            while (i < nodes.size()) {
                this.result.append(nodes.get(i));
                ++i;
            }
        } else {
            ParentNode parent = (ParentNode)this.parents.get(this.parents.size() - 1);
            int i = 0;
            while (i < nodes.size()) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    ((Element)parent).addAttribute((Attribute)node);
                } else {
                    parent.appendChild(node);
                }
                ++i;
            }
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void startPrefixMapping(String prefix, String uri) {
        if ("".equals(prefix)) {
            this.namespaceDeclarations.addAttribute("", "xmlns", "xmlns", "CDATA", uri);
        } else {
            this.namespaceDeclarations.addAttribute("", "xmlns:" + prefix, "xmlns:" + prefix, "CDATA", uri);
        }
    }

    public void skippedEntity(String name) {
        this.flushText();
        throw new XMLException("Could not resolve entity " + name);
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startDTD(String name, String publicID, String systemID) {
    }

    public void endDTD() {
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void comment(char[] text, int start, int length) {
        this.flushText();
        String data = new String(text, start, length);
        int position = data.indexOf("--");
        while (position != -1) {
            data = String.valueOf(data.substring(0, position)) + "- -" + data.substring(position + 2);
            position = data.indexOf("--");
        }
        if (data.endsWith("-")) {
            data = String.valueOf(data) + ' ';
        }
        this.addToResultTree(this.factory.makeComment(data));
    }
}

