/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

class ArithmeticExpression
extends BinaryExpression {
    private static final int NUMERIC_ARITHMETIC = 0;
    private static final int DATE_AND_DURATION = 1;
    private static final int DATE_DIFFERENCE = 2;
    private static final int DURATION_ADDITION = 3;
    private static final int DURATION_MULTIPLICATION = 4;
    private static final int DURATION_DIVISION = 5;
    private static final int UNKNOWN = -1;
    private static final int UNKNOWN_10 = -2;
    private static final Signature[] plusTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DATE_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TYPE), new Signature(Type.DURATION_TYPE, Type.DATE_TYPE, 1, Type.DATE_TYPE), new Signature(Type.TIME_TYPE, Type.DURATION_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.TIME_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.DATE_TIME_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.DURATION_TYPE, 3, Type.DURATION_TYPE)};
    private static final Signature[] minusTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DATE_TYPE, Type.DATE_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.DATE_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TYPE), new Signature(Type.TIME_TYPE, Type.TIME_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.TIME_TYPE, Type.DURATION_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DATE_TIME_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.DURATION_TYPE, 3, Type.DURATION_TYPE)};
    private static final Signature[] multiplyTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.DURATION_TYPE, 4, Type.DURATION_TYPE), new Signature(Type.DURATION_TYPE, Type.NUMBER_TYPE, 4, Type.DURATION_TYPE)};
    private static final Signature[] divideTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DURATION_TYPE, Type.NUMBER_TYPE, 4, Type.DURATION_TYPE), new Signature(Type.DURATION_TYPE, Type.DURATION_TYPE, 5, Type.NUMBER_TYPE)};
    private static final Signature[] idivTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.INTEGER_TYPE)};
    private static final Signature[] modTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE)};
    private boolean backwardsCompatible = false;

    public ArithmeticExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.backwardsCompatible = staticContext.isInBackwardsCompatibleMode();
        Expression expression = this.operand0;
        Expression expression2 = this.operand1;
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, this.backwardsCompatible, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, this.backwardsCompatible, roleLocator2, staticContext);
        if (this.operand0 != expression) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != expression2) {
            this.adoptChildExpression(this.operand1);
        }
        if (this.operand0.getCardinality() == 8192) {
            return this.backwardsCompatible ? DoubleValue.NaN : EmptySequence.getInstance();
        }
        if (this.operand1.getCardinality() == 8192) {
            return this.backwardsCompatible ? DoubleValue.NaN : EmptySequence.getInstance();
        }
        if (this.backwardsCompatible) {
            Arithmetic10 arithmetic10 = new Arithmetic10(this.operand0, this.operator, this.operand1);
            ExpressionTool.copyLocationInfo(this, arithmetic10);
            return arithmetic10.simplify(staticContext).typeCheck(staticContext, itemType);
        }
        Expression expression3 = super.typeCheck(staticContext, itemType);
        if (expression3 instanceof ArithmeticExpression) {
            AtomicType atomicType = (AtomicType)this.operand0.getItemType(typeHierarchy).getPrimitiveItemType();
            AtomicType atomicType2 = (AtomicType)this.operand1.getItemType(typeHierarchy).getPrimitiveItemType();
            int n = ArithmeticExpression.getAction(atomicType, this.operator, atomicType2, this.backwardsCompatible);
            switch (n) {
                case 0: {
                    expression3 = new NumericArithmetic(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 3: {
                    expression3 = new DurationAddition(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 4: {
                    expression3 = new DurationMultiplication(this.operand0, this.operator, this.operand1, staticContext.getConfiguration());
                    break;
                }
                case 5: {
                    expression3 = new DurationDivision(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 1: {
                    expression3 = new DateAndDuration(this.operand0, this.operator, this.operand1, staticContext.getConfiguration());
                    break;
                }
                case 2: {
                    expression3 = new DateDifference(this.operand0, this.operator, this.operand1);
                    break;
                }
                case -2: {
                    expression3 = new Arithmetic10(this.operand0, this.operator, this.operand1);
                    break;
                }
                case -1: {
                    if (atomicType.isAtomicType() && atomicType != Type.UNTYPED_ATOMIC_TYPE && atomicType != Type.ANY_ATOMIC_TYPE && atomicType2.isAtomicType() && atomicType2 != Type.UNTYPED_ATOMIC_TYPE && atomicType2 != Type.ANY_ATOMIC_TYPE) {
                        StaticError staticError = new StaticError("Unsuitable operands for arithmetic operation (" + atomicType.toString(staticContext.getNamePool()) + ", " + atomicType2.toString(staticContext.getNamePool()) + ')');
                        staticError.setErrorCode("XPTY0004");
                        staticError.setIsTypeError(true);
                        staticError.setLocator(ExpressionTool.getLocator(this));
                        throw staticError;
                    }
                    return expression3;
                }
            }
            ExpressionTool.copyLocationInfo(this, expression3);
            if (expression3 instanceof ComputedExpression) {
                ((ComputedExpression)expression3).setParentExpression(this.getParentExpression());
            }
            try {
                if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
                    return ExpressionTool.eagerEvaluate(expression3, staticContext.makeEarlyEvaluationContext());
                }
            }
            catch (DynamicError dynamicError) {
                // empty catch block
            }
        }
        return expression3;
    }

    private static int getAction(AtomicType atomicType, int n, AtomicType atomicType2, boolean bl) {
        if (atomicType.getFingerprint() == 645) {
            atomicType = Type.DURATION_TYPE;
        } else if (atomicType.getFingerprint() == 644) {
            atomicType = Type.DURATION_TYPE;
        }
        if (atomicType2.getFingerprint() == 645) {
            atomicType2 = Type.DURATION_TYPE;
        } else if (atomicType2.getFingerprint() == 644) {
            atomicType2 = Type.DURATION_TYPE;
        }
        Signature[] signatureArray = ArithmeticExpression.getOperatorTable(n);
        int n2 = ArithmeticExpression.getEntry(signatureArray, atomicType, atomicType2);
        if (n2 < 0) {
            return bl ? -2 : -1;
        }
        return signatureArray[n2].operation;
    }

    private static Signature[] getOperatorTable(int n) {
        switch (n) {
            case 15: {
                return plusTable;
            }
            case 16: 
            case 199: {
                return minusTable;
            }
            case 17: {
                return multiplyTable;
            }
            case 18: {
                return divideTable;
            }
            case 50: {
                return idivTable;
            }
            case 19: {
                return modTable;
            }
        }
        throw new IllegalArgumentException("Unknown arithmetic operator");
    }

    private static int getEntry(Signature[] signatureArray, ItemType itemType, ItemType itemType2) {
        if (Type.isNumericPrimitiveType(itemType)) {
            itemType = Type.NUMBER_TYPE;
        }
        if (Type.isNumericPrimitiveType(itemType2)) {
            itemType2 = Type.NUMBER_TYPE;
        }
        for (int i = 0; i < signatureArray.length; ++i) {
            if (!itemType.equals(signatureArray[i].operand0) || !itemType2.equals(signatureArray[i].operand1)) continue;
            return i;
        }
        return -1;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType = this.operand0.getItemType(typeHierarchy);
        ItemType itemType2 = itemType.getPrimitiveItemType();
        ItemType itemType3 = this.operand1.getItemType(typeHierarchy);
        ItemType itemType4 = itemType3.getPrimitiveItemType();
        Signature[] signatureArray = ArithmeticExpression.getOperatorTable(this.operator);
        int n = ArithmeticExpression.getEntry(signatureArray, itemType2, itemType4);
        if (n < 0) {
            return Type.ANY_ATOMIC_TYPE;
        }
        ItemType itemType5 = signatureArray[n].resultType;
        if (itemType5 == Type.NUMBER_TYPE) {
            itemType5 = NumericValue.promote(itemType2, itemType4, typeHierarchy);
            itemType5 = this.operator == 18 && itemType5 == Type.INTEGER_TYPE ? Type.DECIMAL_TYPE : NumericValue.promote(itemType2, itemType4, typeHierarchy);
        } else if (itemType5 == Type.DURATION_TYPE) {
            if (typeHierarchy.isSubType(itemType, Type.DAY_TIME_DURATION_TYPE)) {
                itemType5 = Type.DAY_TIME_DURATION_TYPE;
            } else if (typeHierarchy.isSubType(itemType3, Type.DAY_TIME_DURATION_TYPE)) {
                itemType5 = Type.DAY_TIME_DURATION_TYPE;
            } else if (typeHierarchy.isSubType(itemType, Type.YEAR_MONTH_DURATION_TYPE)) {
                itemType5 = Type.YEAR_MONTH_DURATION_TYPE;
            } else if (typeHierarchy.isSubType(itemType3, Type.YEAR_MONTH_DURATION_TYPE)) {
                itemType5 = Type.YEAR_MONTH_DURATION_TYPE;
            }
        }
        return itemType5;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        ArithmeticExpression arithmeticExpression;
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        atomicValue = atomicValue.getPrimitiveValue();
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return null;
        }
        atomicValue2 = atomicValue2.getPrimitiveValue();
        Configuration configuration = xPathContext.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        int n = ArithmeticExpression.getAction((AtomicType)atomicValue.getItemType(typeHierarchy).getPrimitiveItemType(), this.operator, (AtomicType)atomicValue2.getItemType(typeHierarchy).getPrimitiveItemType(), this.backwardsCompatible);
        switch (n) {
            case 0: {
                arithmeticExpression = new NumericArithmetic(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 3: {
                arithmeticExpression = new DurationAddition(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 4: {
                arithmeticExpression = new DurationMultiplication(atomicValue, this.operator, atomicValue2, configuration);
                break;
            }
            case 5: {
                arithmeticExpression = new DurationDivision(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 1: {
                arithmeticExpression = new DateAndDuration(atomicValue, this.operator, atomicValue2, configuration);
                break;
            }
            case 2: {
                arithmeticExpression = new DateDifference(atomicValue, this.operator, atomicValue2);
                break;
            }
            default: {
                if (this.backwardsCompatible) {
                    NumericValue numericValue;
                    NumericValue numericValue2;
                    try {
                        numericValue2 = (NumericValue)atomicValue.convert(517, xPathContext);
                        numericValue = (NumericValue)atomicValue2.convert(517, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue.getItemType(typeHierarchy) + ", " + atomicValue2.getItemType(typeHierarchy) + ')', "XPTY0004", xPathContext);
                        return null;
                    }
                    arithmeticExpression = new NumericArithmetic(numericValue2, this.operator, numericValue);
                    break;
                }
                this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue.getItemType(typeHierarchy) + ", " + atomicValue2.getItemType(typeHierarchy) + ')', "XPTY0004", xPathContext);
                return null;
            }
        }
        ExpressionTool.copyLocationInfo(this, arithmeticExpression);
        if (arithmeticExpression instanceof ComputedExpression) {
            ((ComputedExpression)arithmeticExpression).setParentExpression(this.getParentExpression());
        }
        return arithmeticExpression.evaluateItem(xPathContext);
    }

    public static class DateDifference
    extends ArithmeticExpression {
        public DateDifference(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DateDifference.doArithmetic(this.operand0, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            CalendarValue calendarValue2 = (CalendarValue)atomicValue2.getPrimitiveValue();
            return calendarValue.subtract(calendarValue2, xPathContext);
        }
    }

    public static class DateAndDuration
    extends ArithmeticExpression {
        public DateAndDuration(Expression expression, int n, Expression expression2, Configuration configuration) {
            super(expression, n, expression2);
            TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
            if (typeHierarchy.isSubType(expression.getItemType(typeHierarchy), Type.DURATION_TYPE)) {
                this.operand0 = expression2;
                this.operand1 = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DateAndDuration.doArithmetic(this.operand0, this.operator, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, int n, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue2.getPrimitiveValue();
            if (n == 16) {
                durationValue = durationValue.multiply(-1.0, xPathContext);
            }
            return calendarValue.add(durationValue);
        }
    }

    public static class DurationDivision
    extends ArithmeticExpression {
        public DurationDivision(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DurationDivision.doArithmetic(this.operand0, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue2 = (DurationValue)atomicValue2.getPrimitiveValue();
            return durationValue.divide(durationValue2, xPathContext);
        }
    }

    public static class DurationMultiplication
    extends ArithmeticExpression {
        public DurationMultiplication(Expression expression, int n, Expression expression2, Configuration configuration) {
            super(expression, n, expression2);
            TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
            if (typeHierarchy.isSubType(expression2.getItemType(typeHierarchy), Type.DURATION_TYPE)) {
                this.operand0 = expression2;
                this.operand1 = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DurationMultiplication.doArithmetic(this.operand0, this.operator, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, int n, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            NumericValue numericValue = (NumericValue)atomicValue2.getPrimitiveValue();
            double d = numericValue.getDoubleValue();
            if (n == 18) {
                d = 1.0 / d;
            }
            return durationValue.multiply(d, xPathContext);
        }
    }

    public static class DurationAddition
    extends ArithmeticExpression {
        public DurationAddition(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DurationAddition.doArithmetic(this.operand0, this.operator, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, int n, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue2 = (DurationValue)atomicValue2.getPrimitiveValue();
            if (n == 15) {
                return durationValue.add(durationValue2, xPathContext);
            }
            if (n == 16) {
                return durationValue.subtract(durationValue2, xPathContext);
            }
            throw new AssertionError((Object)"Unknown operation on durations");
        }
    }

    public static class NumericArithmetic
    extends ArithmeticExpression {
        boolean backwardsCompatible = false;

        public NumericArithmetic(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public void setBackwardsCompatible(boolean bl) {
            this.backwardsCompatible = bl;
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return NumericArithmetic.doArithmetic(this.operand0, this.operator, this.operand1, xPathContext, this.backwardsCompatible);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, int n, Expression expression2, XPathContext xPathContext, boolean bl) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return bl ? DoubleValue.NaN : null;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                try {
                    atomicValue = new DoubleValue(Value.stringToNumber(atomicValue.getStringValueCS()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (bl) {
                        atomicValue = DoubleValue.NaN;
                    }
                    DynamicError dynamicError = new DynamicError("Failure converting untyped value " + Err.wrap(atomicValue.getStringValueCS(), 4) + " to a number");
                    dynamicError.setErrorCode("FORG0001");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            } else {
                atomicValue = atomicValue.getPrimitiveValue();
            }
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return bl ? DoubleValue.NaN : null;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                try {
                    atomicValue2 = new DoubleValue(Value.stringToNumber(atomicValue2.getStringValueCS()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (bl) {
                        atomicValue2 = DoubleValue.NaN;
                    }
                    DynamicError dynamicError = new DynamicError("Failure converting untyped value " + Err.wrap(atomicValue2.getStringValueCS(), 4) + " to a number");
                    dynamicError.setErrorCode("FORG0001");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            } else {
                atomicValue2 = atomicValue2.getPrimitiveValue();
            }
            if (n == 199) {
                return ((NumericValue)atomicValue2).negate();
            }
            try {
                return ((NumericValue)atomicValue).arithmetic(n, (NumericValue)atomicValue2, xPathContext);
            }
            catch (DynamicError dynamicError) {
                if (dynamicError.getXPathContext() == null) {
                    dynamicError.setXPathContext(xPathContext);
                }
                throw dynamicError;
            }
            catch (ArithmeticException arithmeticException) {
                DynamicError dynamicError = new DynamicError("Arithmetic exception: " + arithmeticException.getMessage());
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
        }
    }

    private static class Arithmetic10
    extends BinaryExpression {
        public Arithmetic10(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
            RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
            roleLocator.setSourceLocator(this);
            this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, true, roleLocator, staticContext);
            RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
            roleLocator2.setSourceLocator(this);
            this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, true, roleLocator2, staticContext);
            Expression expression = super.typeCheck(staticContext, itemType);
            if (expression instanceof ArithmeticExpression) {
                AtomicType atomicType = (AtomicType)this.operand0.getItemType(typeHierarchy).getPrimitiveItemType();
                AtomicType atomicType2 = (AtomicType)this.operand1.getItemType(typeHierarchy).getPrimitiveItemType();
                if (atomicType == Type.BOOLEAN_TYPE) {
                    atomicType = Type.NUMBER_TYPE;
                } else if (atomicType == Type.STRING_TYPE) {
                    atomicType = Type.NUMBER_TYPE;
                }
                if (atomicType2 == Type.BOOLEAN_TYPE) {
                    atomicType2 = Type.NUMBER_TYPE;
                } else if (atomicType2 == Type.STRING_TYPE) {
                    atomicType2 = Type.NUMBER_TYPE;
                }
                int n = ArithmeticExpression.getAction(atomicType, this.operator, atomicType2, true);
                switch (n) {
                    case 0: {
                        expression = new NumericArithmetic(this.operand0, this.operator, this.operand1);
                        ((NumericArithmetic)expression).setBackwardsCompatible(true);
                        break;
                    }
                    case 3: {
                        expression = new DurationAddition(this.operand0, this.operator, this.operand1);
                        break;
                    }
                    case 4: {
                        expression = new DurationMultiplication(this.operand0, this.operator, this.operand1, staticContext.getConfiguration());
                        break;
                    }
                    case 5: {
                        expression = new DurationDivision(this.operand0, this.operator, this.operand1);
                        break;
                    }
                    case 1: {
                        expression = new DateAndDuration(this.operand0, this.operator, this.operand1, staticContext.getConfiguration());
                        break;
                    }
                    case 2: {
                        expression = new DateDifference(this.operand0, this.operator, this.operand1);
                        break;
                    }
                    case -2: {
                        expression = new Arithmetic10(this.operand0, this.operator, this.operand1);
                        break;
                    }
                    case -1: {
                        if (atomicType.isAtomicType() && atomicType != Type.UNTYPED_ATOMIC_TYPE && atomicType != Type.ANY_ATOMIC_TYPE && atomicType2.isAtomicType() && atomicType2 != Type.UNTYPED_ATOMIC_TYPE && atomicType2 != Type.ANY_ATOMIC_TYPE) {
                            StaticError staticError = new StaticError("Unsuitable operands for arithmetic operation (" + atomicType.toString(staticContext.getNamePool()) + ", " + atomicType2.toString(staticContext.getNamePool()) + ')');
                            staticError.setErrorCode("XPTY0004");
                            staticError.setIsTypeError(true);
                            throw staticError;
                        }
                        return expression;
                    }
                }
                ExpressionTool.copyLocationInfo(this, expression);
                if (expression instanceof ComputedExpression) {
                    ((ComputedExpression)expression).setParentExpression(this.getParentExpression());
                }
                try {
                    if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
                        return ExpressionTool.eagerEvaluate(expression, staticContext.makeEarlyEvaluationContext());
                    }
                }
                catch (DynamicError dynamicError) {
                    // empty catch block
                }
            }
            return expression;
        }

        public ItemType getItemType(TypeHierarchy typeHierarchy) {
            return Type.ANY_ATOMIC_TYPE;
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return DoubleValue.NaN;
            }
            if ((atomicValue2 = atomicValue2.getPrimitiveValue()) instanceof BooleanValue || atomicValue2 instanceof StringValue || atomicValue2 instanceof NumericValue) {
                try {
                    atomicValue2 = atomicValue2.convert(517, xPathContext);
                }
                catch (XPathException xPathException) {
                    return DoubleValue.NaN;
                }
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return DoubleValue.NaN;
            }
            if ((atomicValue = atomicValue.getPrimitiveValue()) instanceof BooleanValue || atomicValue instanceof StringValue || atomicValue instanceof NumericValue) {
                try {
                    atomicValue = atomicValue.convert(517, xPathContext);
                }
                catch (XPathException xPathException) {
                    return DoubleValue.NaN;
                }
            }
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            int n = ArithmeticExpression.getAction((AtomicType)atomicValue2.getItemType(typeHierarchy).getPrimitiveItemType(), this.operator, (AtomicType)atomicValue.getItemType(typeHierarchy).getPrimitiveItemType(), true);
            switch (n) {
                case 0: {
                    try {
                        return NumericArithmetic.doArithmetic(atomicValue2, this.operator, atomicValue, xPathContext, true);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 3: {
                    try {
                        return DurationAddition.doArithmetic(atomicValue2, this.operator, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 4: {
                    try {
                        return DurationMultiplication.doArithmetic(atomicValue2, this.operator, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 5: {
                    try {
                        return DurationDivision.doArithmetic(atomicValue2, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 1: {
                    try {
                        return DateAndDuration.doArithmetic(atomicValue2, this.operator, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 2: {
                    try {
                        return DateDifference.doArithmetic(atomicValue2, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
            }
            this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue2.getItemType(typeHierarchy) + ", " + atomicValue.getItemType(typeHierarchy) + ')', "XPTY0004", xPathContext);
            return null;
        }
    }

    private static final class Signature {
        ItemType operand0;
        ItemType operand1;
        int operation;
        ItemType resultType;

        Signature(ItemType itemType, ItemType itemType2, int n, ItemType itemType3) {
            this.operand0 = itemType;
            this.operand1 = itemType2;
            this.operation = n;
            this.resultType = itemType3;
        }
    }
}

