/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class NumericPromoter
extends UnaryExpression {
    private int requiredType;

    public NumericPromoter(Expression expression, int n) {
        super(expression);
        this.requiredType = n;
        ExpressionTool.copyLocationInfo(expression, this);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof AtomicValue) {
            return this.promote((AtomicValue)this.operand, null);
        }
        if (this.operand instanceof Value) {
            return SequenceExtent.makeSequenceExtent(this.iterate(staticContext.makeEarlyEvaluationContext())).reduce();
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public SequenceIterator iterate(final XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                return NumericPromoter.this.promote((AtomicValue)item, xPathContext);
            }
        };
        return new ItemMappingIterator(sequenceIterator, itemMappingFunction);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        return this.promote((AtomicValue)item, xPathContext);
    }

    private AtomicValue promote(AtomicValue atomicValue, XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue2 = atomicValue.getPrimitiveValue();
        if (!(atomicValue2 instanceof NumericValue) && !(atomicValue2 instanceof UntypedAtomicValue)) {
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            DynamicError dynamicError = new DynamicError("Cannot promote non-numeric value to " + this.getItemType(typeHierarchy).toString());
            dynamicError.setLocator(this);
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        return atomicValue2.convert(this.requiredType, xPathContext);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.requiredType == 517) {
            return Type.DOUBLE_TYPE;
        }
        return Type.FLOAT_TYPE;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredType == ((NumericPromoter)object).requiredType;
    }

    protected String displayOperator(Configuration configuration) {
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        return "promote items to " + this.getItemType(typeHierarchy).toString(configuration.getNamePool());
    }
}

