/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class Message
extends Instruction {
    private Expression terminate;
    private Expression select;

    public Message(Expression expression, Expression expression2) {
        this.terminate = expression2;
        this.select = expression;
        this.adoptChildExpression(expression2);
        this.adoptChildExpression(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        if (this.terminate != null) {
            this.terminate = this.terminate.simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.select);
        if (this.terminate != null) {
            this.terminate = this.terminate.typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.terminate);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.select);
        if (this.terminate != null) {
            this.terminate = this.terminate.optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(this.terminate);
        }
        return this;
    }

    public int getInstructionNameCode() {
        return 158;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NoNodeTest.getInstance();
    }

    public int getCardinality() {
        return 8192;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.doPromotion(this.select, promotionOffer);
        }
        if (this.terminate != null) {
            this.terminate = this.doPromotion(this.terminate, promotionOffer);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
        if (this.select != null) {
            arrayList.add(this.select);
        }
        if (this.terminate != null) {
            arrayList.add(this.terminate);
        }
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        Controller controller = xPathContext.getController();
        Emitter emitter = controller.getMessageEmitter();
        if (emitter == null) {
            emitter = controller.makeMessageEmitter();
        }
        if (emitter.getWriter() == null) {
            emitter.setWriter(new OutputStreamWriter(System.err));
        }
        TreeReceiver treeReceiver = new TreeReceiver(emitter);
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        emitter.setOutputProperties(properties);
        xPathContextMinor.changeOutputDestination(properties, treeReceiver, false, 50, 3, null);
        if (this.select != null) {
            object2 = this.select.iterate(xPathContextMinor);
            while ((object = object2.next()) != null) {
                treeReceiver.append((Item)object, this.locationId, 2);
            }
        }
        treeReceiver.close();
        if (this.terminate != null && !((String)(object2 = this.terminate.evaluateAsString(xPathContext))).equals("no")) {
            if (((String)object2).equals("yes")) {
                throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber() + " in " + ExpressionLocation.truncateURI(this.getSystemId()));
            }
            object = new DynamicError("The terminate attribute of xsl:message must be 'yes' or 'no'");
            ((DynamicError)object).setXPathContext(xPathContext);
            ((XPathException)object).setErrorCode("XTDE0030");
            throw object;
        }
        return null;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "message");
    }
}

