/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public class BuiltInAtomicType
implements AtomicType,
Serializable {
    int fingerprint;
    int baseFingerprint = -1;

    public BuiltInAtomicType() {
    }

    public BuiltInAtomicType(int n) {
        this.fingerprint = n;
    }

    public AtomicType getCommonAtomicType() {
        return this;
    }

    public final int getValidationStatus() {
        return 3;
    }

    public final int getBlock() {
        return 0;
    }

    public final int getDerivationMethod() {
        return 1;
    }

    public final boolean allowsDerivation(int n) {
        return true;
    }

    public final void setBaseTypeFingerprint(int n) {
        this.baseFingerprint = n;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getNameCode() {
        return this.fingerprint;
    }

    public String getDisplayName() {
        return StandardNames.getDisplayName(this.fingerprint);
    }

    public final boolean isComplexType() {
        return false;
    }

    public final SchemaType getBaseType() {
        if (this.baseFingerprint == -1) {
            return null;
        }
        return BuiltInSchemaFactory.getSchemaType(this.baseFingerprint);
    }

    public boolean matchesItem(Item item, XPathContext xPathContext, boolean bl) {
        if (item instanceof AtomicValue) {
            AtomicValue atomicValue = (AtomicValue)item;
            AtomicType atomicType = (AtomicType)atomicValue.getItemType(null);
            if (atomicType.getFingerprint() == this.getFingerprint()) {
                return true;
            }
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            boolean bl2 = typeHierarchy.isSubType(atomicType, this);
            if (bl2) {
                return true;
            }
            if (bl && this.getFingerprint() == 513 && typeHierarchy.isSubType(atomicType, Type.ANY_URI_TYPE)) {
                return true;
            }
        }
        return false;
    }

    public ItemType getSuperType(TypeHierarchy typeHierarchy) {
        SchemaType schemaType = this.getBaseType();
        if (schemaType instanceof AnySimpleType) {
            return AnyItemType.getInstance();
        }
        return (ItemType)((Object)schemaType);
    }

    public ItemType getPrimitiveItemType() {
        if (Type.isPrimitiveType(this.getFingerprint())) {
            return this;
        }
        ItemType itemType = (ItemType)((Object)this.getBaseType());
        if (itemType instanceof AtomicType) {
            return itemType.getPrimitiveItemType();
        }
        return this;
    }

    public int getPrimitiveType() {
        int n = this.getFingerprint();
        if (Type.isPrimitiveType(n)) {
            return n;
        }
        SchemaType schemaType = this.getBaseType();
        if (schemaType instanceof AtomicType) {
            return ((AtomicType)schemaType).getPrimitiveType();
        }
        return this.getFingerprint();
    }

    public boolean isAllowedInBasicXSLT() {
        int n = this.getFingerprint();
        return Type.isPrimitiveType(n) && n != 531;
    }

    public String toString(NamePool namePool) {
        return this.getDisplayName();
    }

    public AtomicType getAtomizedItemType() {
        return this;
    }

    public SchemaType getKnownBaseType() {
        return this.getBaseType();
    }

    public boolean isSameType(SchemaType schemaType) {
        return schemaType.getFingerprint() == this.getFingerprint();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void isTypeDerivationOK(SchemaType schemaType, int n) throws SchemaException, ValidationException {
    }

    public final boolean isSimpleType() {
        return true;
    }

    public boolean isAtomicType() {
        return true;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isUnionType() {
        return false;
    }

    public int getWhitespaceAction(TypeHierarchy typeHierarchy) {
        if (this.getPrimitiveType() == 513) {
            if (typeHierarchy.isSubType(this, (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(554)))) {
                return 2;
            }
            if (typeHierarchy.isSubType(this, (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(553)))) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public SchemaType getBuiltInBaseType() {
        BuiltInAtomicType builtInAtomicType;
        for (builtInAtomicType = this; builtInAtomicType != null && builtInAtomicType.getFingerprint() > 1023; builtInAtomicType = (BuiltInAtomicType)builtInAtomicType.getBaseType()) {
        }
        return builtInAtomicType;
    }

    public boolean isNamespaceSensitive() {
        BuiltInAtomicType builtInAtomicType = this;
        int n = builtInAtomicType.getFingerprint();
        while (n > 1023) {
            builtInAtomicType = (BuiltInAtomicType)builtInAtomicType.getBaseType();
            n = builtInAtomicType.getFingerprint();
        }
        return n == 530 || n == 531;
    }

    public ValidationException validateContent(CharSequence charSequence, NamespaceResolver namespaceResolver, NameChecker nameChecker) {
        int n = this.getFingerprint();
        if (n == 513 || n == 573 || n == 642 || n == 643) {
            return null;
        }
        ValidationException validationException = null;
        if (this.isNamespaceSensitive()) {
            if (namespaceResolver == null) {
                throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
            }
            try {
                String[] stringArray = nameChecker.getQNameParts(((Object)charSequence).toString());
                String string = namespaceResolver.getURIForPrefix(stringArray[0], true);
                if (string == null) {
                    validationException = new ValidationException("Namespace prefix " + Err.wrap(stringArray[0]) + " has not been declared");
                }
                new QNameValue(stringArray[0], string, stringArray[1], nameChecker);
            }
            catch (QNameException qNameException) {
                validationException = new ValidationException("Invalid lexical QName " + Err.wrap(charSequence));
            }
            catch (XPathException xPathException) {
                validationException = new ValidationException(xPathException.getMessage());
            }
        } else {
            AtomicValue atomicValue = StringValue.convertStringToBuiltInType(charSequence, this, nameChecker);
            if (atomicValue instanceof ValidationErrorValue) {
                validationException = new ValidationException("Value " + Err.wrap(charSequence, 4) + " is invalid for type " + this.getDisplayName() + ". " + ((ValidationErrorValue)atomicValue).getException().getMessage());
            }
        }
        return validationException;
    }

    public final SequenceIterator getTypedValue(NodeInfo nodeInfo) throws XPathException {
        try {
            return this.getTypedValue(nodeInfo.getStringValue(), new InscopeNamespaceResolver(nodeInfo), nodeInfo.getConfiguration().getNameChecker());
        }
        catch (ValidationException validationException) {
            throw new DynamicError("Internal error: value doesn't match its type annotation. " + validationException.getMessage());
        }
    }

    public Value atomize(NodeInfo nodeInfo) throws XPathException {
        if (this.fingerprint == 513) {
            return StringValue.makeStringValue(nodeInfo.getStringValueCS());
        }
        if (this.fingerprint == 642) {
            return new UntypedAtomicValue(nodeInfo.getStringValueCS());
        }
        NameChecker nameChecker = nodeInfo.getConfiguration().getNameChecker();
        if (this.isNamespaceSensitive()) {
            try {
                InscopeNamespaceResolver inscopeNamespaceResolver = new InscopeNamespaceResolver(nodeInfo);
                String[] stringArray = nameChecker.getQNameParts(nodeInfo.getStringValueCS());
                String string = inscopeNamespaceResolver.getURIForPrefix(stringArray[0], true);
                if (string == null) {
                    throw new ValidationException("Namespace prefix " + Err.wrap(stringArray[0]) + " has not been declared");
                }
                return new QNameValue(stringArray[0], string, stringArray[1], nameChecker);
            }
            catch (QNameException qNameException) {
                throw new ValidationException("Invalid lexical QName " + Err.wrap(nodeInfo.getStringValueCS()));
            }
            catch (XPathException xPathException) {
                throw new ValidationException(xPathException.getMessage());
            }
        }
        AtomicValue atomicValue = StringValue.convertStringToBuiltInType(nodeInfo.getStringValueCS(), this, nameChecker);
        if (atomicValue instanceof ValidationErrorValue) {
            throw ((ValidationErrorValue)atomicValue).getException();
        }
        return atomicValue;
    }

    public SequenceIterator getTypedValue(CharSequence charSequence, NamespaceResolver namespaceResolver, NameChecker nameChecker) throws ValidationException {
        if (this.fingerprint == 513) {
            return SingletonIterator.makeIterator(StringValue.makeStringValue(charSequence));
        }
        if (this.fingerprint == 642) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(charSequence));
        }
        if (this.isNamespaceSensitive()) {
            try {
                String[] stringArray = nameChecker.getQNameParts(((Object)charSequence).toString());
                String string = namespaceResolver.getURIForPrefix(stringArray[0], true);
                if (string == null) {
                    throw new ValidationException("Namespace prefix " + Err.wrap(stringArray[0]) + " has not been declared");
                }
                return SingletonIterator.makeIterator(new QNameValue(stringArray[0], string, stringArray[1], nameChecker));
            }
            catch (QNameException qNameException) {
                throw new ValidationException("Invalid lexical QName " + Err.wrap(charSequence));
            }
            catch (XPathException xPathException) {
                throw new ValidationException(xPathException.getMessage());
            }
        }
        AtomicValue atomicValue = StringValue.convertStringToBuiltInType(charSequence, this, nameChecker);
        if (atomicValue instanceof ValidationErrorValue) {
            throw ((ValidationErrorValue)atomicValue).getException();
        }
        return SingletonIterator.makeIterator(atomicValue);
    }

    public AtomicValue makeDerivedValue(AtomicValue atomicValue, CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("makeDerivedValue is not supported for built-in types");
    }

    public void analyzeContentExpression(Expression expression, int n, StaticContext staticContext) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, staticContext, n);
    }

    public static void analyzeContentExpression(SimpleType simpleType, Expression expression, StaticContext staticContext, int n) throws XPathException {
        if (n == 1) {
            expression.checkPermittedContents(simpleType, staticContext, true);
        } else if (n == 2 && (expression instanceof ValueOf || expression instanceof Value)) {
            expression.checkPermittedContents(simpleType, staticContext, true);
        }
    }
}

