#
# Makefile for building callback shared library
#
#    To link user callback DLL:
#
#    make -f ociucb.mk user_callback SHARED_LIBNAME=libname 
#                                             OBJS="user.o ..."
#    e.g. make -f ociucb.mk user_callback SHARED_LIBNAME=ociucb.so.1.0 \
#                                                   OBJS=ociucb.o
#
#
#
#
# NOTE: 1. ORACLE_HOME must be either:
#		   . set in the user's environment
#		   . passed in on the command line
#		   . defined in a modified version of this makefile
#
#       2. Look in the platform specific documentation for information
#          about environment variables that need to be properly
#          defined (e.g. LD_LIBRARY_PATH in Solaris).
#


include $(ORACLE_HOME)/rdbms/lib/env_rdbms.mk


RDBMSLIB=$(ORACLE_HOME)/rdbms/lib/

USERLIB=$(ORACLE_HOME)/lib/

LDFLAGS=-L$(LIBHOME) -L$(ORACLE_HOME)/rdbms/lib
LLIBPSO=`cat $(ORACLE_HOME)/rdbms/lib/psoliblist`

#CC=/opt/SUNWspro4.2/SUNWspro/bin/cc

# directory that contain oratypes.h and other oci program header files
INCLUDE= -I$(ORACLE_HOME)/rdbms/demo -I$(ORACLE_HOME)/rdbms/public -I$(ORACLE_HOME)/plsql/public -I$(ORACLE_HOME)/network/public

#
CONFIG = $(ORACLE_HOME)/rdbms/lib/config.o

# module to be used for linking with non-deferred option

# flag for linking with non-deferred option (default is deferred mode)
NONDEFER=false

# libraries for linking oci programs
OCISHAREDLIBS=$(TTLIBS) $(LLIBTHREAD)
OCISTATICLIBS=$(STATICTTLIBS) $(LLIBTHREAD)
#OCICALLBACK=$(RDBMSLIB)kpucb.o

PSOLIBLIST=$(ORACLE_HOME)/rdbms/lib/psoliblist
CLEANPSO=rm -f $(PSOLIBLIST); $(GENPSOLIB)

DOLIB=$(ORACLE_HOME)/lib/liborcaccel.a
DUMSDOLIB=$(ORACLE_HOME)/lib/liborcaccel_stub.a
REALSDOLIB=/usr/lpp/orcaccel/liborcaccel.a


LLIBSQL= -lsql8
PROLDLIBS= $(LLIBSQL) $(TTLIBS)

.SUFFIXES: .o


user_callback: $(OBJS)
	$(LD) $(SHARED_LDFLAG) $(USERLIB)$(SHARED_LIBNAME) $(OBJS) $(OCICALLBACK)

clean:
	$(RM) -f $(DEMOS) *.o *.so

