/*
 * misc.c - Misc funcitons.
 *
    Copyright (C) 2001  Yao Zhang

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * yaoz@users.sourceforge.net
 */
#include <iconv.h>
#include <stdio.h>

#include "ot.h"

void read_table(uint8_t *p, uint32_t length, char *file, uint32_t offset)
{
    FILE *fp;

    fp = fopen(file, "r");

    fseek(fp, offset, SEEK_SET);
    fread(p, 1, length, fp);

    fclose(fp);
}

uint32_t calc_table_checksum(uint8_t *p, uint32_t length)
{
    int i;
    uint32_t sum;

    sum = 0;
    for (i = 0; i < length; i += 4) {
        sum += p[i]  <<24;
        sum += p[i+1]<<16;
        sum += p[i+2]<<8;
        sum += p[i+3];
    }
    if (i     < length) {
        sum += p[i]  <<24;
    }
    if ((i+1) < length) {
        sum += p[i+1]<<16;
    }
    if ((i+2) < length) {
        sum += p[i+2]<<8;
    }
    if ((i+3) < length) {
        sum += p[i+3];
    }

    return sum;
}

int to_utf8_string(char *from, char *buffer, int length,
                               char *utf8, int utf8bytes)
{
    iconv_t cd;
    int count;
    char *s;
    size_t inbytesleft, outbytesleft;
    char *inbuf, *outbuf;

    cd = iconv_open("UTF-8", from);
    if (cd == (iconv_t)-1) {
        return -1;
    }

    count = length;
    s = (char *)calloc(count, 1);
    if ((strcmp(from, "GBK") == 0)
     || (strcmp(from, "BIG5") == 0)) {
        int i;

        /* We need to remove those 0x00s in name string. */
        count = 0;
        for (i = 0; i < length; i++) {
            if (buffer[i] != 0x00) {
                s[count] = buffer[i];
                count++;
            }
        }
    } else {
        memcpy(s, buffer, count);
    }

    inbytesleft = count;
    inbuf = s;
    outbytesleft = utf8bytes;
    outbuf = utf8;

    iconv(cd, &inbuf, &inbytesleft, &outbuf, &outbytesleft);
    if (outbytesleft > 0) {
        *outbuf = '\0';
    }

    free(s);

    iconv_close(cd);

    return 0;
}

int from_utf8_string(char *to, char *utf8, int utf8bytes,
                               char *buffer, int length)
{
    iconv_t cd;
    int count;
    uint8_t *s;
    size_t inbytesleft, outbytesleft;
    char *inbuf, *outbuf;
    int outbytes;

    cd = iconv_open(to, "UTF-8");
    if (cd == (iconv_t)-1) {
        return -1;
    }

    count = utf8bytes*2;
    s = (uint8_t *)calloc(count, 1);

    inbytesleft = utf8bytes;
    inbuf = utf8;
    outbytesleft = count;
    outbuf = s;

    iconv(cd, &inbuf, &inbytesleft, &outbuf, &outbytesleft);
    outbytes = count-outbytesleft;

    if ((strcmp(to, "GBK") == 0)
     || (strcmp(to, "BIG5") == 0)) {
        int i;

        /* We need to add those 0x00s for ASCII part in name string. */
        count = 0;
        i = 0;
        while (1) {
            if ((s[i]&0x80) == 0) {
                buffer[count++] = 0x00;
                if (count >= length) {
                    break;
                }
                buffer[count++] = s[i++];
                if ((i >= outbytes) || (count >= length)) {
                    break;
                }
            } else {
                buffer[count++] = s[i++];
                if ((i >= outbytes) || (count >= length)) {
                    break;
                }
                buffer[count++] = s[i++];
                if ((i >= outbytes) || (count >= length)) {
                    break;
                }
            }
        }
        count = count/2 * 2;
    } else {
        count = outbytes;
        if (count > length) {
            count = length;
        }
        memcpy(buffer, s, count);
    }

    free(s);

    iconv_close(cd);

    return count;
}

char *platform_string(int platformID)
{
    char *s;

    s = "(unknown platform)";
    switch (platformID) {
    case 0:
        s = "Unicode";
        break;
    case 1:
        s = "Macintosh";
        break;
    case 2:
        s = "ISO [deprecated]";
        break;
    case 3:
        s = "Microsoft";
        break;
    case 4:
        s = "Custom";
        break;
    default:
        break;
    }

    return s;
}

char *platform_specific_string(int platformID, int platformSpecificID)
{
    char *s;

    s = "(unknown platform specific)";
    if (platformID == 0) {		/* Unicode */
        switch (platformSpecificID) {
        case 0:
            s = "Default semantics";
            break;
        case 1:
            s = "Version 1.1 semantics";
            break;
        case 2:
            s = "ISO 10646 1993 semantics (deprecated)";
            break;
        case 3:
            s = "Unicode 2.0 or later semantics";
            break;
        default:
            break;
        }
    } else if (platformID == 1) {	/* Macintosh */
        switch (platformSpecificID) {
        case 0:
            s = "Roman";
            break;
        case 1:
            s = "Japanese";
            break;
        case 2:
            s = "Traditianal Chinese";
            break;
        case 3:
            s = "Korean";
            break;
        case 4:
            s = "Arabic";
            break;
        case 5:
            s = "Hebrew";
            break;
        case 6:
            s = "Greek";
            break;
        case 7:
            s = "Russian";
            break;
        case 8:
            s = "RSymbol";
            break;
        case 9:
            s = "Devanagari";
            break;
        case 10:
            s = "Gurmukhi";
            break;
        case 11:
            s = "Gujarati";
            break;
        case 12:
            s = "Oriya";
            break;
        case 13:
            s = "Bengali";
            break;
        case 14:
            s = "Tamil";
            break;
        case 15:
            s = "Telugu";
            break;
        case 16:
            s = "Kannada";
            break;
        case 17:
            s = "Malayalam";
            break;
        case 18:
            s = "Sinhalese";
            break;
        case 19:
            s = "Burmese";
            break;
        case 20:
            s = "Khmer";
            break;
        case 21:
            s = "Thai";
            break;
        case 22:
            s = "Laotian";
            break;
        case 23:
            s = "Georgian";
            break;
        case 24:
            s = "Armenian";
            break;
        case 25:
            s = "Simplified Chinese";
            break;
        case 26:
            s = "Tibetan";
            break;
        case 27:
            s = "Mongolian";
            break;
        case 28:
            s = "Geez";
            break;
        case 29:
            s = "Slavic";
            break;
        case 30:
            s = "Vietnamese";
            break;
        case 31:
            s = "Sindhi";
            break;
        case 32:
            s = "(Uninterpreted)";
            break;
        default:
            break;
        }
    } else if (platformID == 2) {	/* ISO [deprecated] */
        switch (platformSpecificID) {
        case 0:
            s = "7-bit ASCII";
            break;
        case 1:
            s = "ISO 10646";
            break;
        case 2:
            s = "ISO 8859-1";
            break;
        default:
            break;
        }
    } else if (platformID == 3) {	/* Microsoft */
        switch (platformSpecificID) {
        case 0:
            s = "Symbol";
            break;
        case 1:
            s = "Unicode";
            break;
        case 2:
            s = "ShiftJIS";
            break;
        case 3:
            s = "PRC";
            break;
        case 4:
            s = "Big5";
            break;
        case 5:
            s = "Wansung";
            break;
        case 6:
            s = "Johab";
            break;
        case 7:
            s = "Reserved 7";
            break;
        case 8:
            s = "Reserved 8";
            break;
        case 9:
            s = "Reserved 9";
            break;
        case 10:
            s = "UCS-4";
            break;
        default:
            break;
        }
    } else if (platformID == 4) {	/* Custom */
        if ((platformSpecificID >= 0)
         && (platformSpecificID <= 255)) {
            s = "OTF Windows NT compatibility mapping";
        }
    }

    return s;
}

char *language_string(int platformID, int languageID)
{
    char *s;

    s = "(unknown language)";
    if (platformID == 1) {		/* Macintosh */
        switch (languageID) {
        case 0:
            s = "English";
            break;
        case 1:
            s = "French";
            break;
        case 2:
            s = "German";
            break;
        case 3:
            s = "Italian";
            break;
        case 4:
            s = "Dutch";
            break;
        case 5:
            s = "Swedish";
            break;
        case 6:
            s = "Spanish";
            break;
        case 7:
            s = "Danish";
            break;
        case 8:
            s = "Portuguese";
            break;
        case 9:
            s = "Norwegian";
            break;
        case 10:
            s = "Hebrew";
            break;
        case 11:
            s = "Japanese";
            break;
        case 12:
            s = "Arabic";
            break;
        case 13:
            s = "Finnish";
            break;
        case 14:
            s = "Greek";
            break;
        case 15:
            s = "Icelandic";
            break;
        case 16:
            s = "Maltese";
            break;
        case 17:
            s = "Turkish";
            break;
        case 18:
            s = "Croatian";
            break;
        case 19:
            s = "Chinese (Traditional)";
            break;
        case 20:
            s = "Urdu";
            break;
        case 21:
            s = "Hindi";
            break;
        case 22:
            s = "Thai";
            break;
        case 23:
            s = "Korean";
            break;
        case 24:
            s = "Lithuanian";
            break;
        case 25:
            s = "Polish";
            break;
        case 26:
            s = "Hungarian";
            break;
        case 27:
            s = "Estonian";
            break;
        case 28:
            s = "Latvian";
            break;
        case 29:
            s = "Sami";
            break;
        case 30:
            s = "Faroese";
            break;
        case 31:
            s = "Farsi/Persian";
            break;
        case 32:
            s = "Russian";
            break;
        case 33:
            s = "Chinese (Simplified)";
            break;
        case 34:
            s = "Flemish";
            break;
        case 35:
            s = "Irish Gaelic";
            break;
        case 36:
            s = "Albanian";
            break;
        case 37:
            s = "Romanian";
            break;
        case 38:
            s = "Czech";
            break;
        case 39:
            s = "Slovak";
            break;
/*
 TBD
 */
        default:
            break;
        }
    } else if (platformID == 3) {	/* Microsoft */
        switch (languageID) {
        case 0x0401:
            s = "Arabic - Saudi Arabia";
            break;
        case 0x0801:
            s = "Arabic - Iraq";
            break;
        case 0x0c01:
            s = "Arabic - Egypt";
            break;
        case 0x1001:
            s = "Arabic - Libya";
            break;
        case 0x1401:
            s = "Arabic - Algeria";
            break;
        case 0x1801:
            s = "Arabic - Morocco";
            break;
        case 0x1c01:
            s = "Arabic - Tunisia";
            break;
        case 0x2001:
            s = "Arabic - Oman";
            break;
        case 0x2401:
            s = "Arabic - Yemen";
            break;
        case 0x2801:
            s = "Arabic - Syria";
            break;
        case 0x2c01:
            s = "Arabic - Jordan";
            break;
        case 0x3001:
            s = "Arabic - Lebanon";
            break;
        case 0x3401:
            s = "Arabic - Kuwait";
            break;
        case 0x3801:
            s = "Arabic - U.A.E.";
            break;
        case 0x3c01:
            s = "Arabic - Bahrain";
            break;
        case 0x4001:
            s = "Arabic - Qatar";
            break;
        case 0x0402:
            s = "Bulgarian - Bulgaria";
            break;
        case 0x0403:
            s = "Catalan - Spain";
            break;
        case 0x0404:
            s = "Chinese - Taiwan";
            break;
        case 0x0804:
            s = "Chinese - PRC";
            break;
        case 0x0c04:
            s = "Chinese - Hong Kong";
            break;
        case 0x1004:
            s = "Chinese - Singapore";
            break;
        case 0x1404:
            s = "Chinese - Macau";
            break;
        case 0x0405:
            s = "Czech - Czech Republic";
            break;
        case 0x0406:
            s = "Danish - Denmark";
            break;
        case 0x0407:
            s = "German - Germany";
            break;
        case 0x0807:
            s = "German - Switzerland";
            break;
        case 0x0c07:
            s = "German - Austria";
            break;
        case 0x1007:
            s = "German - Luxembourg";
            break;
        case 0x1407:
            s = "German - Liechtenstein";
            break;
        case 0x0408:
            s = "Greek - Greece";
            break;
        case 0x0409:
            s = "English - United States";
            break;
        case 0x0809:
            s = "English - United Kingdom";
            break;
        case 0x0c09:
            s = "English - Australia";
            break;
        case 0x1009:
            s = "English - Canada";
            break;
        case 0x1409:
            s = "English - New Zealand";
            break;
        case 0x1809:
            s = "English - Ireland";
            break;
        case 0x1c09:
            s = "English - South Africa";
            break;
        case 0x2009:
            s = "English - Jamaica";
            break;
        case 0x2409:
            s = "English - Caribbean";
            break;
        case 0x2809:
            s = "English - Belize";
            break;
        case 0x2c09:
            s = "English - Trinidad";
            break;
        case 0x3009:
            s = "English - Zimbabwe";
            break;
        case 0x3409:
            s = "English - Philippines";
            break;
/*
 * TBD
 */
        default:
            break;
        }
    }

    return s;
}

char *name_string(int nameID)
{
    char *s;

    s = "(unknown name)";
    switch(nameID) {
    case 0:
        s = "Copyright notice";
        break;
    case 1:
        s = "Font Family";
        break;
    case 2:
        s = "Font Subfamily";
        break;
    case 3:
        s = "Unique subfamily identification";
        break;
    case 4:
        s = "Full name of the font";
        break;
    case 5:
        s = "Version of the name table";
        break;
    case 6:
        s = "PostScript name for the font";
        break;
    case 7:
        s = "Trademark notice";
        break;
    case 8:
        s = "Manufacturer Name";
        break;
    case 9:
        s = "Designer";
        break;
    case 10:
        s = "Description";
        break;
    case 11:
        s = "URL of the font vendor";
        break;
    case 12:
        s = "URL of the font designer";
        break;
    case 13:
        s = "License description";
        break;
    case 14:
        s = "License information URL";
        break;
    case 15:
        s = "Reserved";
        break;
    case 16:
        s = "Preferred Family";
        break;
    case 17:
        s = "Preferred Subfamily";
        break;
    case 18:
        s = "Compatible Full";
        break;
    case 19:
        s = "Sample text";
        break;
    default:
        break;
    }

    return s;
}
