#include <iostream>

#include "paman.hh"
#include "ClientWindow.hh"

#define GLADE_NAME "clientWindow"

ClientWindow::ClientWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade) :
    Gtk::Window(cobject),
    nameLabel(NULL),
    protocolLabel(NULL),
    indexLabel(NULL),
    ownerModuleLabel(NULL),
    closeButton(NULL),
    toOwnerModuleButton(NULL),
    killButton(NULL) {

    refGlade->get_widget("nameLabel", nameLabel);
    refGlade->get_widget("protocolLabel", protocolLabel);
    refGlade->get_widget("indexLabel", indexLabel);
    refGlade->get_widget("ownerModuleLabel", ownerModuleLabel);
    refGlade->get_widget("closeButton", closeButton);
    refGlade->get_widget("toOwnerModuleButton", toOwnerModuleButton);
    refGlade->get_widget("killButton", killButton);

    closeButton->signal_clicked().connect(sigc::mem_fun(*this, &ClientWindow::onCloseButton));
    toOwnerModuleButton->signal_clicked().connect(sigc::mem_fun(*this, &ClientWindow::onToOwnerModuleButton));
    killButton->signal_clicked().connect(sigc::mem_fun(*this, &ClientWindow::onKillButton));
}

ClientWindow* ClientWindow::create() {
    ClientWindow *w = NULL;
    Glib::RefPtr<Gnome::Glade::Xml> refXml = Gnome::Glade::Xml::create(GLADE_FILE, GLADE_NAME);
    refXml->get_widget_derived(GLADE_NAME, w);
    return w;
}

void ClientWindow::updateInfo(const ClientInfo &i) {
    char t[20];

    nameLabel->set_text(i.name);
    protocolLabel->set_text(i.protocol_name);
    snprintf(t, sizeof(t), "#%u", i.index);
    indexLabel->set_text(t);

    snprintf(t, sizeof(t), "#%u", i.owner_module);
    ownerModuleLabel->set_text(t);

    set_title("Client: "+i.name);
    
    owner_module = i.owner_module;
    toOwnerModuleButton->set_sensitive(owner_module != (uint32_t) -1);

    index = i.index;
}

void ClientWindow::onCloseButton() {
    hide();
}

void ClientWindow::onToOwnerModuleButton() {
    if (owner_module != (uint32_t) -1)
        serverInfoManager->showModuleWindow(owner_module);
}

bool ClientWindow::on_delete_event(GdkEventAny*) {
    hide();
    return false;
}

void ClientWindow::onKillButton() {
    serverInfoManager->killClient(index);
}
