#ifndef fooclientwindowhhfoo
#define fooclientwindowhhfoo

#include <gtkmm.h>
#include <libglademm.h>

class ClientWindow;

#include "ServerInfoManager.hh"

class ClientWindow : public Gtk::Window {
public:
    ClientWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
    static ClientWindow* create();

    Gtk::Label *nameLabel,
        *protocolLabel,
        *indexLabel,
        *ownerModuleLabel;

    Gtk::Button *closeButton,
        *toOwnerModuleButton,
        *killButton;

    uint32_t owner_module;
    uint32_t index;
    
    void updateInfo(const ClientInfo &i);

    virtual void onCloseButton();
    virtual void onToOwnerModuleButton();
    virtual bool on_delete_event(GdkEventAny* e);
    virtual void onKillButton();
};

#endif
