#include <iostream>

#include "paman.hh"
#include "ModuleWindow.hh"

#define GLADE_NAME "moduleWindow"

ModuleWindow::ModuleWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade) :
    Gtk::Window(cobject),
    nameLabel(NULL),
    argumentLabel(NULL),
    indexLabel(NULL),
    autoloadedLabel(NULL),
    usageLabel(NULL),
    closeButton(NULL) {

    refGlade->get_widget("nameLabel", nameLabel);
    refGlade->get_widget("argumentLabel", argumentLabel);
    refGlade->get_widget("indexLabel", indexLabel);
    refGlade->get_widget("autoloadedLabel", autoloadedLabel);
    refGlade->get_widget("usageLabel", usageLabel);
    refGlade->get_widget("closeButton", closeButton);

    closeButton->signal_clicked().connect(sigc::mem_fun(*this, &ModuleWindow::onCloseButton));
}

ModuleWindow* ModuleWindow::create() {
    ModuleWindow *w = NULL;
    Glib::RefPtr<Gnome::Glade::Xml> refXml = Gnome::Glade::Xml::create(GLADE_FILE, GLADE_NAME);
    refXml->get_widget_derived(GLADE_NAME, w);
    return w;
}

void ModuleWindow::updateInfo(const ModuleInfo &i) {
    char t[20];

    nameLabel->set_text(i.name);
    if (!i.argument.empty())
        argumentLabel->set_text(i.argument);
    else
        argumentLabel->set_markup("<i>None specified</i>");
    
    snprintf(t, sizeof(t), "#%u", i.index);
    indexLabel->set_text(t);
    autoloadedLabel->set_text(i.autoloaded ? "Yes" : "No");

    if (i.used != (uint32_t) -1) {
        snprintf(t, sizeof(t), "%u", i.used);
        usageLabel->set_text(t);
    } else
        usageLabel->set_markup("<i>n/a</i>");

    set_title("Module: "+i.name);
}

void ModuleWindow::onCloseButton() {
    hide();
}

bool ModuleWindow::on_delete_event(GdkEventAny*) {
    hide();
    return false;
}
