#include <iostream>

#include "paman.hh"
#include "SampleWindow.hh"

#define GLADE_NAME "sampleWindow"

SampleWindow::SampleWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade) :
    Gtk::Window(cobject),
    nameLabel(NULL),
    indexLabel(NULL),
    volumeLabel(NULL),
    sampleTypeLabel(NULL),
    durationLabel(NULL),
    sizeLabel(NULL),
    lazyLabel(NULL),
    filenameLabel(NULL),
    closeButton(NULL) {

    refGlade->get_widget("nameLabel", nameLabel);
    refGlade->get_widget("indexLabel", indexLabel);
    refGlade->get_widget("volumeLabel", volumeLabel);
    refGlade->get_widget("sampleTypeLabel", sampleTypeLabel);
    refGlade->get_widget("durationLabel", durationLabel);
    refGlade->get_widget("sizeLabel", sizeLabel);
    refGlade->get_widget("lazyLabel", lazyLabel);
    refGlade->get_widget("filenameLabel", filenameLabel);
    refGlade->get_widget("closeButton", closeButton);

    closeButton->signal_clicked().connect(sigc::mem_fun(*this, &SampleWindow::onCloseButton));
}

SampleWindow* SampleWindow::create() {
    SampleWindow *w = NULL;
    Glib::RefPtr<Gnome::Glade::Xml> refXml = Gnome::Glade::Xml::create(GLADE_FILE, GLADE_NAME);
    refXml->get_widget_derived(GLADE_NAME, w);
    return w;
}

void SampleWindow::updateInfo(const SampleInfo &i) {
    char t[60], ss[PA_SAMPLE_SPEC_SNPRINT_MAX];

    nameLabel->set_text(i.name);
    snprintf(t, sizeof(t), "#%u", i.index);
    indexLabel->set_text(t);

    snprintf(t, sizeof(t), "%0.0f%%", (double) i.volume / 0x100 * 100);
    volumeLabel->set_text(t);

    if (pa_sample_spec_valid(&i.sample_spec)) {
        pa_sample_spec_snprint(ss, sizeof(ss), &i.sample_spec);
        sampleTypeLabel->set_text(ss);
    } else
        sampleTypeLabel->set_markup("<i>n/a</i>");

    if (i.duration > 0) {
        snprintf(t, sizeof(t), "%0.1fs", (double) i.duration/1000000);
        durationLabel->set_text(t);
    } else
        durationLabel->set_markup("<i>n/a</i>");

    if (i.bytes > 0) {
        pa_bytes_snprint(t, sizeof(t), i.bytes);
        sizeLabel->set_text(t);
    } else
        sizeLabel->set_markup("<i>n/a</i>");

    lazyLabel->set_text(i.lazy ? "yes" : "no");

    if (i.filename_valid)
        filenameLabel->set_text(i.filename);
    else
        filenameLabel->set_markup("<i>n/a</i>");
    
    set_title("Sample: "+i.name);
}

void SampleWindow::onCloseButton() {
    hide();
}

bool SampleWindow::on_delete_event(GdkEventAny*) {
    hide();
    return false;
}
