#ifndef foosinkinputwindowhhfoo
#define foosinkinputwindowhhfoo

#include <gtkmm.h>
#include <libglademm.h>

class SinkInputWindow;

#include "ServerInfoManager.hh"

class SinkInputWindow : public Gtk::Window {
public:
    SinkInputWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
    static SinkInputWindow* create();

    Gtk::Label *nameLabel,
        *indexLabel,
        *sampleTypeLabel,
        *latencyLabel,
        *sinkLabel,
        *clientLabel,
        *ownerModuleLabel,
        *volumeLabel,
        *resampleMethodLabel;

    Gtk::Button *closeButton,
        *toOwnerModuleButton,
        *toClientButton,
        *toSinkButton,
        *volumeResetButton,
        *volumeMuteButton,
        *killButton;

    Gtk::HScale *volumeScale;

    uint32_t index, owner_module, sink, client;
    
    void updateInfo(const SinkInputInfo &i);

    virtual void onCloseButton();
    virtual void onToOwnerModuleButton();
    virtual void onToClientButton();
    virtual void onToSinkButton();
    virtual void onVolumeScaleValueChanged();
    virtual void onVolumeResetButton();
    virtual void onVolumeMuteButton();
    virtual bool on_delete_event(GdkEventAny* e);
    virtual void onKillButton();
};

#endif
