#ifndef foosinkwindowhhfoo
#define foosinkwindowhhfoo

#include <gtkmm.h>
#include <libglademm.h>

class SinkWindow;

#include "ServerInfoManager.hh"

class SinkWindow : public Gtk::Window {
public:
    SinkWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
    static SinkWindow* create();

    Gtk::Label *nameLabel,
        *descriptionLabel,
        *indexLabel,
        *sampleTypeLabel,
        *latencyLabel,
        *ownerModuleLabel,
        *monitorSourceLabel,
        *volumeLabel;

    Gtk::Button *closeButton,
        *toMonitorSourceButton,
        *toOwnerModuleButton,
        *volumeResetButton,
        *volumeMuteButton,
        *volumeMeterButton;

    Gtk::HScale *volumeScale;

    uint32_t index, owner_module, monitor_source;
    Glib::ustring monitor_source_name;
    
    void updateInfo(const SinkInfo &i);

    virtual void onCloseButton();
    virtual void onToMonitorSourceButton();
    virtual void onToOwnerModuleButton();
    virtual void onVolumeScaleValueChanged();
    virtual void onVolumeResetButton();
    virtual void onVolumeMuteButton();
    virtual bool on_delete_event(GdkEventAny* e);
    virtual void onVolumeMeterButton();
};

#endif
