#ifndef foosourceoutputwindowhhfoo
#define foosourceoutputwindowhhfoo

#include <gtkmm.h>
#include <libglademm.h>

class SourceOutputWindow;

#include "ServerInfoManager.hh"

class SourceOutputWindow : public Gtk::Window {
public:
    SourceOutputWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
    static SourceOutputWindow* create();

    Gtk::Label *nameLabel,
        *indexLabel,
        *sampleTypeLabel,
        *sourceLabel,
        *clientLabel,
        *ownerModuleLabel,
        *latencyLabel,
        *resampleMethodLabel;

    Gtk::Button *closeButton,
        *toOwnerModuleButton,
        *toClientButton,
        *toSourceButton,
        *killButton;

    uint32_t owner_module, source, client, index;
    
    void updateInfo(const SourceOutputInfo &i);

    virtual void onCloseButton();
    virtual void onToOwnerModuleButton();
    virtual void onToClientButton();
    virtual void onToSourceButton();
    virtual bool on_delete_event(GdkEventAny* e);
    virtual void onKillButton();
};

#endif
