#include "paman.hh"
#include "SourceWindow.hh"

#define GLADE_NAME "sourceWindow"

SourceWindow::SourceWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade) :
    Gtk::Window(cobject),
    nameLabel(NULL),
    descriptionLabel(NULL),
    indexLabel(NULL),
    sampleTypeLabel(NULL),
    ownerModuleLabel(NULL),
    monitorOfSinkLabel(NULL),
    latencyLabel(NULL),
    closeButton(NULL),
    toParentSinkButton(NULL),
    toOwnerModuleButton(NULL),
    volumeMeterButton(NULL) {

    refGlade->get_widget("nameLabel", nameLabel);
    refGlade->get_widget("descriptionLabel", descriptionLabel);
    refGlade->get_widget("indexLabel", indexLabel);
    refGlade->get_widget("sampleTypeLabel", sampleTypeLabel);
    refGlade->get_widget("ownerModuleLabel", ownerModuleLabel);
    refGlade->get_widget("monitorOfSinkLabel", monitorOfSinkLabel);
    refGlade->get_widget("latencyLabel", latencyLabel);
    refGlade->get_widget("closeButton", closeButton);
    refGlade->get_widget("toParentSinkButton", toParentSinkButton);
    refGlade->get_widget("toOwnerModuleButton", toOwnerModuleButton);
    refGlade->get_widget("volumeMeterButton", volumeMeterButton);
    
    closeButton->signal_clicked().connect(sigc::mem_fun(*this, &SourceWindow::onCloseButton));
    toParentSinkButton->signal_clicked().connect(sigc::mem_fun(*this, &SourceWindow::onParentSinkButton));
    toOwnerModuleButton->signal_clicked().connect(sigc::mem_fun(*this, &SourceWindow::onToOwnerModuleButton));
    volumeMeterButton->signal_clicked().connect(sigc::mem_fun(*this, &SourceWindow::onVolumeMeterButton));
}

SourceWindow* SourceWindow::create() {
    SourceWindow *w = NULL;
    Glib::RefPtr<Gnome::Glade::Xml> refXml = Gnome::Glade::Xml::create(GLADE_FILE, GLADE_NAME);
    refXml->get_widget_derived(GLADE_NAME, w);
    return w;
}

void SourceWindow::updateInfo(const SourceInfo &i) {
    char t[20], ss[PA_SAMPLE_SPEC_SNPRINT_MAX];

    nameLabel->set_text(i.name);
    descriptionLabel->set_text(i.description);
    snprintf(t, sizeof(t), "#%u", i.index);
    indexLabel->set_text(t);
    pa_sample_spec_snprint(ss, sizeof(ss), &i.sample_spec);
    sampleTypeLabel->set_text(ss);
    snprintf(t, sizeof(t), "#%u", i.owner_module);
    ownerModuleLabel->set_text(t);

    snprintf(t, sizeof(t), "%0.0f usec", (double) i.latency);
    latencyLabel->set_text(t);
    
    monitorOfSinkLabel->set_markup("<i>n/a</i>");
    toParentSinkButton->set_sensitive(false);
    if (i.monitor_of_sink != (uint32_t) -1) {
        SinkInfo *sink = serverInfoManager->getSinkInfo(i.monitor_of_sink);
        if (sink) {
            monitorOfSinkLabel->set_text(sink->name);
            toParentSinkButton->set_sensitive(true);
        }
    }

    monitor_of_sink = i.monitor_of_sink;
    source_name = i.name;
    
    set_title("Source: "+i.name);

    owner_module = i.owner_module;
    toOwnerModuleButton->set_sensitive(owner_module != (uint32_t) -1);
}

void SourceWindow::onCloseButton() {
    hide();
}

void SourceWindow::onParentSinkButton() {
    if (monitor_of_sink != (uint32_t) -1)
        serverInfoManager->showSinkWindow(monitor_of_sink);
}

void SourceWindow::onToOwnerModuleButton() {
    if (owner_module != (uint32_t) -1)
        serverInfoManager->showModuleWindow(owner_module);
}

bool SourceWindow::on_delete_event(GdkEventAny*) {
    hide();
    return false;
}

void SourceWindow::onVolumeMeterButton() {
    serverInfoManager->runVolumeMeter(source_name);
}
