#ifndef foosourcewindowhhfoo
#define foosourcewindowhhfoo

#include <gtkmm.h>
#include <libglademm.h>

class SourceWindow : public Gtk::Window {
public:
    SourceWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
    static SourceWindow* create();

    Gtk::Label *nameLabel,
        *descriptionLabel,
        *indexLabel,
        *sampleTypeLabel,
        *ownerModuleLabel,
        *monitorOfSinkLabel,
        *latencyLabel;

    Gtk::Button *closeButton,
        *toParentSinkButton,
        *toOwnerModuleButton,
        *volumeMeterButton;

    uint32_t monitor_of_sink, owner_module;
    Glib::ustring source_name;
    
    void updateInfo(const SourceInfo &i);

    virtual void onCloseButton();
    virtual void onParentSinkButton();
    virtual void onToOwnerModuleButton();
    virtual bool on_delete_event(GdkEventAny* e);
    virtual void onVolumeMeterButton();
};

#endif
