#ifndef VERSION
#define VERSION "0.99?"
#endif
static char c1[] = "     display-sutras-patanjali V" VERSION " \n";
static char c2[] = " (C) y2k by Stuart Trusty <stuart@linuxlabs.com>. \n";
static char c3[] = " Copying policy: Public Domain, text used with permission\n";
static char c4[] = " Modified from Ricardas Cepas (C) 1997 \n";

#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#define max_string_length 278
#define mark_length 4
#ifndef DPPATHNAME
#define DPPATHNAME "/usr/local/lib/display-sutras-patanjali/patanjali-sutras-english.txt"
#endif
#ifndef DPPATHNAME2
#define DPPATHNAME2 "/usr/lib/display-sutras-patanjali/patanjali-sutras-english.txt"
#endif

static const char dp_pathname1[] = DPPATHNAME;
static const char c6[] = "                                                                                  ";
static const char dp_pathname2[] = DPPATHNAME2;
static const char c7[] = "                                                                                  ";
static const char dp_pathname3[] = "patanjali-sutras-english.txt";
static const char c8[] = "                                                                                  ";
const char IO_err[] = "I/O error";
const char cannot_open[] = "    -- cannot open any of the files.";
const char too_long_verse[] = " file format error ?";
const char unexp_EOF[] = "unexpected end of file.";


const max_strings_in_verse = 20;

/*const long min_all_verses_size=50; */
static struct
  {
       char begin[mark_length], end[mark_length];
  }
marks[] =
  {
       {"1","3"},{"3","4"},{"4","6"},{"6","7"},{"7","8"},
       {"8","9"},{"9","10"},{"10","11"},{"11","13"},{"13","14"},
       {"14","16"},{"16","17"},{"17","18"},{"18","19"},{"19","22"},
       {"22","24"},{"24","25"},{"25","26"},{"26","27"},{"27","28"},
       {"28","29"},{"29","30"},{"30","31"},{"31","32"},{"32","33"},
       {"33","34"},{"34","35"},{"35","36"},{"36","37"},{"37","38"},{"38","39"},
       {"39","40"},{"40","41"},{"41","42"},{"42","44"},{"44","47"},
       {"46","51"},{"51","53"},{"53","54"},{"54","55"},{"55","56"},
       {"56","57"},{"57","58"},{"58","59"},{"59","60"},{"60","62"},{"62","65"},
       {"65","66"},{"66","67"},{"67","68"},{"68","69"},{"69","70"},
       {"70","71"},{"71","72"},{"72","73"},{"73","75"},{"75","76"},
       {"76","77"},{"77","78"},{"78","79"},{"79","80"},
       {"80","81"},{"81","82"},{"82","83"},
       {"83","84"},{"84","85"},{"85","86"},{"86","87"},{"87","88"},{"88","89"},
	{"89","90"},
       {"90","91"},{"91","93"},{"93","94"},{"94","95"},
       {"95","96"},{"96","99"},{"99","100"},{"100","101"},{"101","104"},{"104","106"},
       {"106","107"},{"107","108"},{"108","109"},{"109","110"},{"110","112"},
	{"112","114"},{"114","115"},{"115","116"},{"116","117"},{"117","118"},
	{"118","119"},{"119","120"},{"120","122"},{"122","123"},{"123","124"},{"124","125"},
       {"125","126"},{"126","127"},{"127","128"},{"128","130"},{"130","131"},{"131","132"},{"132","133"},
       {"133","134"},{"134","135"},{"135","136"},{"136","137"},{"137","138"},{"138","139"},{"139","140"},{"140","141"},{"141","142"},
       {"142","143"},{"143","144"},{"144","145"},{"145","146"},{"146","147"},
       {"147","148"},{"148","149"},{"149","150"},{"150","151"},{"151","152"},
       {"152","154"},{"154","155"},{"155","156"},{"156","157"},{"157","158"},
       {"158","159"},{"159","160"},{"160","161"},{"161","162"},{"162","163"},
       {"163","164"},{"164","165"},{"165","166"},{"166","167"},{"167","168"},
       {"168","169"},{"169","170"},{"170","171"},{"171","172"},{"172","173"},
       {"173","174"},{"174","175"},{"175","176"},{"176","177"},{"177","178"},{"178","179"},
       {"179","180"},{"180","181"},{"181","182"},{"182","183"},{"183","184"},{"184","185"},
       {"185","187"},{"187","192"},{"192","193"},{"193","194"}
  };

void
Error (const char *message)
{
     fprintf (stderr, "dp: %s \n", message);
     exit (1);
}

void
Find_begin_of_verses (FILE * dp)
{
     char s[max_string_length];

     rewind (dp);
     do
          if (fgets (s, max_string_length, dp) == NULL)
               if (feof (dp))
                    Error (unexp_EOF);
               else
                    Error (IO_err);
     while (strstr (s, "---------------------------------------------") == NULL);
     do
          if (fgets (s, max_string_length, dp) == NULL)
               if (feof (dp))
                    Error (unexp_EOF);
               else
                    Error (IO_err);
     while (strstr (s, "---------------------------------------------") == NULL);
}
void
Find_verse (FILE * dp, char *begin_mark)
{
     char s[max_string_length];

     do
          if (fgets (s, max_string_length, dp) == NULL)
               if (feof (dp))
                    Error (unexp_EOF);
               else
                    Error (IO_err);
     while (strstr (s, begin_mark) == NULL);
}

void
Help ()
{
     printf ("%s Displays a random verse \n", c1);
     printf ("from %s \nor from %s \nor from %s file. \n", dp_pathname1, dp_pathname2, dp_pathname3);
     printf (" Arguments: \n           <number>         specify number of verse(s) to display \n           all              display all file at once \n");
     printf (" Arguments for debugging only: \n           0x<hex_number>   specify internal index of verse(s) to display \n           0xall            display all file at once \n");
     printf ("%s%s%s", c2, c3, c4);
}

void
Print_verse (FILE * dp, char *end_mark)
{
     char s[max_string_length];
     int printed_strings_counter = 0;

     do
       {
            if (fgets (s, max_string_length, dp) == NULL)
                 if (feof (dp))
                      Error (unexp_EOF);
                 else
                      Error (IO_err);
            printf (" %s ", s);
            printed_strings_counter++;
            if (printed_strings_counter > max_strings_in_verse)
                 Error (too_long_verse);
       }
     while (strstr (s, end_mark) == NULL);
     printf ("\n");
}

void
Get_and_print_verse (FILE * dp, int index)
{
     Find_begin_of_verses (dp);
     if (index >= sizeof marks / sizeof marks[0])
          index = sizeof marks / sizeof marks[0] - 1;
     Find_verse (dp, marks[index].begin);
     Print_verse (dp, marks[index].end);
}

void
Get_and_print_verse_number_n (FILE * dp, int number)
{
  int index;

  for (index = 0; index < sizeof marks / sizeof marks[0] - 1; index++)
    if (number <= atoi (marks[index].end))
      break;
  Get_and_print_verse (dp, index);
}

int
Random_index ()
{
     int i, random_index;

     srand ((unsigned int) time (NULL));
/*      min=0, max=numb.of elem.-1+.999 */
     random_index = (int) ((double) (sizeof marks / sizeof marks[0]) * (i = rand ()) / (RAND_MAX + 1.0));
     return (random_index);
}

int
main (int argc, char *argv[], char *env[])
{
     FILE *dp;
     int index;
     char *stop_char_ptr;

     if ((dp = fopen (dp_pathname1, "rt")) == NULL)
        if ((dp = fopen (dp_pathname2, "rt")) == NULL)
          if ((dp = fopen (dp_pathname3, "rt")) == NULL)
            {
                 fprintf (stderr, " %s \n %s \n %s \n", dp_pathname1, dp_pathname2, dp_pathname3);
                 Error (cannot_open);
            }

     if (argc > 1)
       {
            if (strcmp (argv[1], "0xall") == 0)
                 for (index = 0; index < sizeof marks / sizeof marks[0]; index++)
                   {
                        printf ("0x%X \n", index);
                        Get_and_print_verse (dp, index);
                   }
	    else if (strcmp (argv[1], "all") == 0)
                 for (index = 0; index < sizeof marks / sizeof marks[0]; index++)
		      Get_and_print_verse (dp, index);
            else
	    {
	      errno = 0;
	      index = strtol (argv[1], &stop_char_ptr, 0);
	      if (errno != ERANGE && *stop_char_ptr == '\0' && argv[1][0] != '\0')
		if (argv[1][0] == '0' && (argv[1][1] == 'x' || argv[1][1] == 'X'))
		{
		    printf ("0x%X \n", index);
		    Get_and_print_verse (dp, index);
		}
		else
		{
		    Get_and_print_verse_number_n (dp, index);
		}
            else
                 Help ();
	    }
       }
     else
          Get_and_print_verse (dp, Random_index ());
     fclose (dp);
     exit (0);
}
